/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.common;

import com.google.common.base.Preconditions;
import com.google.common.collect.Comparators;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Ordering;
import com.google.errorprone.annotations.InlineMe;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.Comparator;
import java.util.Optional;
import java.util.OptionalDouble;
import java.util.OptionalInt;
import java.util.OptionalLong;
import java.util.stream.DoubleStream;
import java.util.stream.IntStream;
import java.util.stream.LongStream;
import java.util.stream.Stream;
import org.sosy_lab.common.OptionalComparators;

public final class Optionals {
    private Optionals() {
    }

    @Deprecated
    @InlineMe(replacement="com.google.common.base.Optional.fromJavaUtil(checkNotNull(optional))", staticImports={"com.google.common.base.Preconditions.checkNotNull"})
    @SuppressFBWarnings(value={"NP_NULL_ON_SOME_PATH_FROM_RETURN_VALUE"})
    public static <T> com.google.common.base.Optional<T> toGuavaOptional(Optional<T> optional) {
        return com.google.common.base.Optional.fromJavaUtil((Optional)((Optional)Preconditions.checkNotNull(optional)));
    }

    @Deprecated
    @InlineMe(replacement="optional.toJavaUtil()")
    public static <T> Optional<T> fromGuavaOptional(com.google.common.base.Optional<T> optional) {
        return optional.toJavaUtil();
    }

    public static <T> ImmutableSet<T> asSet(Optional<T> optional) {
        return optional.isPresent() ? ImmutableSet.of(optional.orElseThrow()) : ImmutableSet.of();
    }

    @Deprecated
    @InlineMe(replacement="optional.stream()")
    public static <T> Stream<T> asStream(Optional<T> optional) {
        return optional.stream();
    }

    public static <T> FluentIterable<T> presentInstances(Iterable<Optional<T>> iterable) {
        return FluentIterable.from(iterable).filter(Optional::isPresent).transform(Optional::get);
    }

    public static <T> Stream<T> presentInstances(Stream<Optional<T>> stream) {
        return stream.filter(Optional::isPresent).map(Optional::get);
    }

    public static IntStream presentInts(Stream<OptionalInt> stream) {
        return stream.filter(OptionalInt::isPresent).mapToInt(OptionalInt::getAsInt);
    }

    public static LongStream presentLongs(Stream<OptionalLong> stream) {
        return stream.filter(OptionalLong::isPresent).mapToLong(OptionalLong::getAsLong);
    }

    public static DoubleStream presentDoubles(Stream<OptionalDouble> stream) {
        return stream.filter(OptionalDouble::isPresent).mapToDouble(OptionalDouble::getAsDouble);
    }

    @Deprecated
    @InlineMe(replacement="Comparators.emptiesFirst(Comparator.<T>naturalOrder())", imports={"com.google.common.collect.Comparators", "java.util.Comparator"})
    public static <T extends Comparable<T>> Comparator<Optional<T>> comparingEmptyFirst() {
        return Comparators.emptiesFirst(Comparator.naturalOrder());
    }

    @Deprecated
    @InlineMe(replacement="Comparators.emptiesFirst(comparator)", imports={"com.google.common.collect.Comparators"})
    public static <T> Comparator<Optional<T>> comparingEmptyFirst(Comparator<T> comparator) {
        return Comparators.emptiesFirst(comparator);
    }

    @Deprecated
    @InlineMe(replacement="Comparators.emptiesLast(Comparator.<T>naturalOrder())", imports={"com.google.common.collect.Comparators", "java.util.Comparator"})
    public static <T extends Comparable<T>> Comparator<Optional<T>> comparingEmptyLast() {
        return Comparators.emptiesLast(Comparator.naturalOrder());
    }

    @Deprecated
    @InlineMe(replacement="Comparators.emptiesLast(comparator)", imports={"com.google.common.collect.Comparators"})
    public static <T> Comparator<Optional<T>> comparingEmptyLast(Comparator<T> comparator) {
        return Comparators.emptiesLast(comparator);
    }

    public static Ordering<OptionalInt> comparingIntEmptyFirst() {
        return OptionalComparators.INT_EMPTY_FIRST;
    }

    public static Ordering<OptionalInt> comparingIntEmptyLast() {
        return OptionalComparators.INT_EMPTY_LAST;
    }

    public static Ordering<OptionalLong> comparingLongEmptyFirst() {
        return OptionalComparators.LONG_EMPTY_FIRST;
    }

    public static Ordering<OptionalLong> comparingLongEmptyLast() {
        return OptionalComparators.LONG_EMPTY_LAST;
    }

    public static Ordering<OptionalDouble> comparingDoubleEmptyFirst() {
        return OptionalComparators.DOUBLE_EMPTY_FIRST;
    }

    public static Ordering<OptionalDouble> comparingDoubleEmptyLast() {
        return OptionalComparators.DOUBLE_EMPTY_LAST;
    }
}

