/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.common;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableMap;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Supplier;
import java.util.logging.Level;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.sosy_lab.common.Classes;
import org.sosy_lab.common.Concurrency;
import org.sosy_lab.common.io.IO;
import org.sosy_lab.common.log.LogManager;

public class ProcessExecutor<E extends Exception> {
    private final String name;
    private final long pid;
    private final Class<E> exceptionClass;
    private final Writer in;
    private final ListeningExecutorService executor = MoreExecutors.listeningDecorator((ExecutorService)Executors.newFixedThreadPool(3));
    private final ListenableFuture<?> outFuture;
    private final ListenableFuture<?> errFuture;
    private final ListenableFuture<Integer> processFuture;
    private final List<String> output = new ArrayList<String>();
    private final List<String> errorOutput = new ArrayList<String>();
    private boolean finished = false;
    protected final LogManager logger;

    public ProcessExecutor(LogManager logger, Class<E> exceptionClass, String ... cmd) throws IOException {
        this(logger, exceptionClass, (Map<String, String>)ImmutableMap.of(), (File)null, cmd);
    }

    public ProcessExecutor(LogManager logger, Class<E> exceptionClass, @Nullable File executionDirectory, String ... cmd) throws IOException {
        this(logger, exceptionClass, (Map<String, String>)ImmutableMap.of(), executionDirectory, cmd);
    }

    public ProcessExecutor(LogManager logger, Class<E> exceptionClass, Map<String, String> environmentOverride, String ... cmd) throws IOException {
        this(logger, exceptionClass, environmentOverride, (File)null, cmd);
    }

    public ProcessExecutor(final LogManager logger, Class<E> exceptionClass, Map<String, String> environmentOverride, @Nullable File executionDirectory, String ... cmd) throws IOException {
        Preconditions.checkNotNull((Object)cmd);
        Preconditions.checkArgument((cmd.length > 0 ? 1 : 0) != 0);
        this.logger = (LogManager)Preconditions.checkNotNull((Object)logger);
        this.exceptionClass = (Class)Preconditions.checkNotNull(exceptionClass);
        this.name = cmd[0];
        ProcessBuilder proc = new ProcessBuilder(cmd);
        proc.directory(executionDirectory);
        Map<String, String> environment = proc.environment();
        for (Map.Entry<String, String> entry : environmentOverride.entrySet()) {
            if (entry.getValue() == null) {
                environment.remove(entry.getKey());
                continue;
            }
            environment.put(entry.getKey(), entry.getValue());
        }
        Supplier<String> executingMsgSupplier = () -> String.format("Executing '%s'", Joiner.on((String)" ").join((Object[])cmd));
        logger.log(Level.FINEST, executingMsgSupplier);
        Process process = proc.start();
        this.pid = process.pid();
        Supplier<String> startedMsgSupplier = () -> String.format("Started '%s' with pid [%d]", Joiner.on((String)" ").join((Object[])cmd), this.pid);
        logger.log(Level.FINEST, startedMsgSupplier);
        this.processFuture = this.executor.submit(() -> {
            logger.logf(Level.FINEST, "Waiting for %s[%d]", this.name, this.pid);
            try {
                int exitCode1 = process.waitFor();
                logger.logf(Level.FINEST, "%s[%d] has terminated normally", this.name, this.pid);
                this.handleExitCode(exitCode1);
                return exitCode1;
            }
            catch (InterruptedException e) {
                process.destroy();
                while (true) {
                    try {
                        int exitCode2 = process.waitFor();
                        logger.logf(Level.FINEST, "%s[%d] has terminated after it was cancelled", this.name, this.pid);
                        Thread.currentThread().interrupt();
                        return exitCode2;
                    }
                    catch (InterruptedException interruptedException) {
                        continue;
                    }
                    break;
                }
            }
        });
        this.in = new OutputStreamWriter(process.getOutputStream(), IO.getNativeCharset());
        this.outFuture = this.executor.submit(() -> {
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream(), IO.getNativeCharset()));){
                String line;
                while ((line = reader.readLine()) != null) {
                    this.handleOutput(line);
                }
            }
            catch (IOException e) {
                if (this.processFuture.isCancelled()) {
                    logger.logfDebugException(e, "IOException after process[%d] was killed", this.pid);
                }
                throw e;
            }
            return null;
        });
        this.errFuture = this.executor.submit(() -> {
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(process.getErrorStream(), IO.getNativeCharset()));){
                String line;
                while ((line = reader.readLine()) != null) {
                    this.handleErrorOutput(line);
                }
            }
            catch (IOException e) {
                if (this.processFuture.isCancelled()) {
                    logger.logfDebugException(e, "IOException after process[%d] was killed", this.pid);
                }
                throw e;
            }
            return null;
        });
        FutureCallback<Object> cancelProcessOnFailure = new FutureCallback<Object>(){

            public void onFailure(Throwable e) {
                if (!ProcessExecutor.this.processFuture.isCancelled()) {
                    logger.logfUserException(Level.FINEST, e, "Killing %s[%d] due to error in output handling", ProcessExecutor.this.name, ProcessExecutor.this.pid);
                    ProcessExecutor.this.processFuture.cancel(true);
                } else {
                    logger.logfDebugException(e, "Error in output handling after %s[%d] was already killed", ProcessExecutor.this.name, ProcessExecutor.this.pid);
                }
            }

            public void onSuccess(Object pArg0) {
            }
        };
        Futures.addCallback(this.outFuture, (FutureCallback)cancelProcessOnFailure, (Executor)MoreExecutors.directExecutor());
        Futures.addCallback(this.errFuture, (FutureCallback)cancelProcessOnFailure, (Executor)MoreExecutors.directExecutor());
        this.executor.shutdown();
    }

    public void println(String s) throws IOException {
        Preconditions.checkNotNull((Object)s);
        this.print(s + "\n");
    }

    public void print(String s) throws IOException {
        Preconditions.checkNotNull((Object)s);
        Preconditions.checkState((!this.finished ? 1 : 0) != 0, (Object)"Cannot write to process that has already terminated.");
        this.in.write(s);
        this.in.flush();
    }

    public void sendEOF() throws IOException {
        Preconditions.checkState((!this.finished ? 1 : 0) != 0, (Object)"Cannot write to process that has already terminated.");
        this.in.close();
    }

    public int join(long timelimit) throws IOException, E, TimeoutException, InterruptedException {
        try {
            Integer exitCode = null;
            try {
                exitCode = timelimit > 0L ? (Integer)this.processFuture.get(timelimit, TimeUnit.MILLISECONDS) : (Integer)this.processFuture.get();
            }
            catch (CancellationException cancellationException) {
                // empty catch block
            }
            this.outFuture.get();
            this.errFuture.get();
            if (exitCode == null) {
                throw new InterruptedException();
            }
            int n = exitCode;
            return n;
        }
        catch (TimeoutException e) {
            this.logger.logf(Level.FINEST, "Killing %s[%d] due to timeout", this.name, this.pid);
            this.processFuture.cancel(true);
            throw e;
        }
        catch (InterruptedException e) {
            this.logger.logf(Level.FINEST, "Killing %s[%d] due to user interrupt", this.name, this.pid);
            this.processFuture.cancel(true);
            throw e;
        }
        catch (ExecutionException e) {
            Throwable t = e.getCause();
            Throwables.propagateIfPossible((Throwable)t, IOException.class, this.exceptionClass);
            throw new Classes.UnexpectedCheckedException(String.format("output handling of external process %s[%d]", this.name, this.pid), t);
        }
        finally {
            assert (this.processFuture.isDone());
            Concurrency.waitForTermination((ExecutorService)this.executor);
            try {
                this.in.close();
            }
            catch (IOException iOException) {}
            this.finished = true;
        }
    }

    public int join() throws IOException, E, InterruptedException {
        try {
            return this.join(0L);
        }
        catch (TimeoutException e) {
            throw new AssertionError((Object)e);
        }
    }

    protected void handleOutput(String line) throws E {
        Preconditions.checkNotNull((Object)line);
        this.logger.logf(Level.ALL, "%s[%d] output: %s", this.name, this.pid, line);
        this.output.add(line);
    }

    protected void handleErrorOutput(String line) throws E {
        Preconditions.checkNotNull((Object)line);
        this.logger.logf(Level.WARNING, "%s[%d] error output: %s", this.name, this.pid, line);
        this.errorOutput.add(line);
    }

    protected void handleExitCode(int code) throws E {
        if (code != 0) {
            this.logger.logf(Level.WARNING, "Exit code from %s[%d] was %d", this.name, this.pid, code);
        }
    }

    public boolean isFinished() {
        return this.finished;
    }

    public List<String> getOutput() {
        Preconditions.checkState((boolean)this.finished, (Object)"Cannot get output while process is not yet finished");
        return this.output;
    }

    public List<String> getErrorOutput() {
        Preconditions.checkState((boolean)this.finished, (Object)"Cannot get error output while process is not yet finished");
        return this.errorOutput;
    }
}

