/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.common.collect;

import java.util.Comparator;
import java.util.Iterator;
import java.util.Map;
import java.util.NavigableMap;
import java.util.NavigableSet;
import java.util.NoSuchElementException;
import java.util.SortedMap;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.sosy_lab.common.collect.AbstractImmutableMap;
import org.sosy_lab.common.collect.Collections3;
import org.sosy_lab.common.collect.OurSortedMap;
import org.sosy_lab.common.collect.SortedMapKeySet;

abstract class AbstractImmutableSortedMap<K, V>
extends AbstractImmutableMap<K, V>
implements OurSortedMap<K, V> {
    AbstractImmutableSortedMap() {
    }

    @Override
    public boolean equals(@Nullable Object pObj) {
        if (this == pObj) {
            return true;
        }
        if (!(pObj instanceof Map)) {
            return false;
        }
        NavigableMap other = (NavigableMap)pObj;
        if (this.size() != other.size()) {
            return false;
        }
        boolean hasSameOrder = false;
        if (other instanceof SortedMap) {
            Comparator comparator = ((SortedMap)other).comparator();
            if (Collections3.guaranteedSameOrder(this.comparator(), comparator)) {
                hasSameOrder = true;
            } else if (other instanceof NavigableMap) {
                NavigableMap descendingOther = ((NavigableMap)other).descendingMap();
                if (Collections3.guaranteedSameOrder(this.comparator(), descendingOther.comparator())) {
                    hasSameOrder = true;
                    other = descendingOther;
                }
            }
        }
        if (hasSameOrder) {
            Iterator it1 = this.entrySet().iterator();
            Iterator it2 = other.entrySet().iterator();
            try {
                while (it1.hasNext()) {
                    if (it1.next().equals(it2.next())) continue;
                    return false;
                }
                return true;
            }
            catch (NoSuchElementException e) {
                return false;
            }
        }
        return ((Object)this.entrySet()).equals(other.entrySet());
    }

    @Override
    public int hashCode() {
        return ((Object)this.entrySet()).hashCode();
    }

    private @Nullable K keyOrNull(@Nullable Map.Entry<K, V> entry) {
        return entry == null ? null : (K)entry.getKey();
    }

    private K keyOrNSE(@Nullable Map.Entry<K, V> entry) {
        if (entry == null) {
            throw new NoSuchElementException();
        }
        return entry.getKey();
    }

    @Override
    public final K firstKey() {
        return this.keyOrNSE(this.firstEntry());
    }

    @Override
    public final K lastKey() {
        return this.keyOrNSE(this.lastEntry());
    }

    @Override
    public final @Nullable K ceilingKey(K pKey) {
        return this.keyOrNull(this.ceilingEntry(pKey));
    }

    @Override
    public final @Nullable K floorKey(K pKey) {
        return this.keyOrNull(this.floorEntry(pKey));
    }

    @Override
    public final @Nullable K higherKey(K pKey) {
        return this.keyOrNull(this.higherEntry(pKey));
    }

    @Override
    public final @Nullable K lowerKey(K pKey) {
        return this.keyOrNull(this.lowerEntry(pKey));
    }

    @Override
    public final OurSortedMap<K, V> headMap(K pToKey) {
        return this.headMap((Object)pToKey, false);
    }

    @Override
    public final OurSortedMap<K, V> tailMap(K pFromKey) {
        return this.tailMap((Object)pFromKey, true);
    }

    @Override
    public final OurSortedMap<K, V> subMap(K pFromKey, K pToKey) {
        return this.subMap((Object)pFromKey, true, (Object)pToKey, false);
    }

    @Override
    public final NavigableSet<K> keySet() {
        return this.navigableKeySet();
    }

    @Override
    public NavigableSet<K> navigableKeySet() {
        return new SortedMapKeySet(this);
    }

    @Override
    public final NavigableSet<K> descendingKeySet() {
        return this.descendingMap().navigableKeySet();
    }

    @Override
    public final Map.Entry<K, V> pollFirstEntry() {
        throw new UnsupportedOperationException();
    }

    @Override
    public final Map.Entry<K, V> pollLastEntry() {
        throw new UnsupportedOperationException();
    }
}

