/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.common.collect;

import com.google.auto.value.AutoValue;
import com.google.common.base.Preconditions;
import com.google.errorprone.annotations.Immutable;
import java.util.Collection;
import java.util.Optional;
import org.sosy_lab.common.collect.AutoValue_MapsDifference_Entry;

public class MapsDifference {
    private MapsDifference() {
    }

    public static <K, V> Visitor<K, V> ignoreMapsDifference() {
        return DummyVisitor.INSTANCE;
    }

    public static <K, V> Visitor<K, V> collectMapsDifferenceTo(final Collection<Entry<K, V>> target) {
        Preconditions.checkNotNull(target);
        return new Visitor<K, V>(){

            @Override
            public void leftValueOnly(K pKey, V pLeftValue) {
                target.add(Entry.forLeftValueOnly(pKey, pLeftValue));
            }

            @Override
            public void rightValueOnly(K pKey, V pRightValue) {
                target.add(Entry.forRightValueOnly(pKey, pRightValue));
            }

            @Override
            public void differingValues(K pKey, V pLeftValue, V pRightValue) {
                target.add(Entry.forDifferingValues(pKey, pLeftValue, pRightValue));
            }
        };
    }

    @Immutable(containerOf={"K", "V"})
    @AutoValue
    public static abstract class Entry<K, V> {
        Entry() {
        }

        public static <K, V> Entry<K, V> forLeftValueOnly(K pKey, V pLeftValue) {
            return new AutoValue_MapsDifference_Entry<K, V>(pKey, Optional.of(pLeftValue), Optional.empty());
        }

        public static <K, V> Entry<K, V> forRightValueOnly(K pKey, V pRightValue) {
            return new AutoValue_MapsDifference_Entry(pKey, Optional.empty(), Optional.of(pRightValue));
        }

        public static <K, V> Entry<K, V> forDifferingValues(K pKey, V pLeftValue, V pRightValue) {
            return new AutoValue_MapsDifference_Entry<K, V>(pKey, Optional.of(pLeftValue), Optional.of(pRightValue));
        }

        public abstract K getKey();

        public abstract Optional<V> getLeftValue();

        public abstract Optional<V> getRightValue();
    }

    private static enum DummyVisitor implements Visitor<Object, Object>
    {
        INSTANCE;


        @Override
        public void leftValueOnly(Object pKey, Object pLeftValue) {
        }

        @Override
        public void rightValueOnly(Object key, Object rightValue) {
        }

        @Override
        public void differingValues(Object pKey, Object pLeftValue, Object pRightValue) {
        }
    }

    public static abstract class DefaultVisitor<K, V>
    implements Visitor<K, V> {
        @Override
        public void leftValueOnly(K pKey, V pLeftValue) {
        }

        @Override
        public void rightValueOnly(K key, V rightValue) {
        }

        @Override
        public void differingValues(K pKey, V pLeftValue, V pRightValue) {
        }
    }

    public static interface Visitor<K, V> {
        public void leftValueOnly(K var1, V var2);

        public void rightValueOnly(K var1, V var2);

        public void differingValues(K var1, V var2, V var3);
    }
}

