/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.common.collect;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.Comparator;
import java.util.NavigableSet;
import java.util.SortedSet;
import org.sosy_lab.common.collect.NaiveOrderStatisticSet;

public interface OrderStatisticSet<E>
extends NavigableSet<E> {
    public E getByRank(int var1);

    @CanIgnoreReturnValue
    public E removeByRank(int var1);

    public int rankOf(E var1);

    @Override
    public OrderStatisticSet<E> descendingSet();

    @Override
    public OrderStatisticSet<E> subSet(E var1, boolean var2, E var3, boolean var4);

    @Override
    public OrderStatisticSet<E> headSet(E var1, boolean var2);

    @Override
    public OrderStatisticSet<E> tailSet(E var1, boolean var2);

    @Override
    public OrderStatisticSet<E> subSet(E var1, E var2);

    @Override
    public OrderStatisticSet<E> headSet(E var1);

    @Override
    public OrderStatisticSet<E> tailSet(E var1);

    public static <E> OrderStatisticSet<E> create() {
        return NaiveOrderStatisticSet.createSet();
    }

    public static <E> OrderStatisticSet<E> create(Comparator<? super E> pComparator) {
        return NaiveOrderStatisticSet.createSet(pComparator);
    }

    public static <E> OrderStatisticSet<E> createWithNaturalOrder(Iterable<E> pCollection) {
        return NaiveOrderStatisticSet.createSetWithNaturalOrder(pCollection);
    }

    public static <E> OrderStatisticSet<E> createWithSameOrder(SortedSet<E> pSortedSet) {
        return NaiveOrderStatisticSet.createSetWithSameOrder(pSortedSet);
    }
}

