/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.common.collect;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.testing.TestStringSortedSetGenerator;
import com.google.common.testing.EqualsTester;
import com.google.common.testing.SerializableTester;
import com.google.common.truth.Truth;
import java.util.Collection;
import java.util.Collections;
import java.util.NavigableSet;
import org.junit.Assert;
import org.junit.Test;
import org.sosy_lab.common.collect.OrderStatisticSet;

public abstract class OrderStatisticSetTestSuite {
    private static final String[] ELEMS = new String[]{"aaa", "hha", "ppa", "zza"};
    private static final String[] ELEMS_ABOVE = new String[]{"aab", "hhb", "ppb", "zzb"};
    private static final String[] ELEMS_BELOW = new String[]{"aa", "hh", "pp", "zz"};
    private final OrderStatisticSetFactory factory;

    OrderStatisticSetTestSuite(OrderStatisticSetFactory pFactory) {
        this.factory = pFactory;
    }

    private OrderStatisticSet<String> createSet() {
        return this.factory.create(new String[0]);
    }

    private OrderStatisticSet<String> createSet(String[] pElems) {
        return this.factory.create(pElems);
    }

    @Test
    public void testEquals() {
        EqualsTester setEqualsTester = new EqualsTester();
        OrderStatisticSet<String> l1 = this.createSet();
        OrderStatisticSet<String> l2 = this.createSet();
        setEqualsTester.addEqualityGroup(new Object[]{l1, l2});
        l1 = this.createSet();
        l2 = this.createSet();
        Collections.addAll(l1, "a", "b", "c", "d");
        Collections.addAll(l2, "d", "c", "a", "b");
        OrderStatisticSet<String> l3 = this.createSet();
        Collections.addAll(l3, "d", "c", "a", "b", "a", "b", "a");
        setEqualsTester.addEqualityGroup(new Object[]{l1, l2, l3});
        setEqualsTester.testEquals();
    }

    @Test
    public void testSerialize() {
        OrderStatisticSet<String> l = this.createSet();
        SerializableTester.reserializeAndAssert(l);
        for (int i = 100000; i >= 0; --i) {
            l.add(String.valueOf(i));
        }
        SerializableTester.reserializeAndAssert(l);
    }

    @Test
    public void testSubsetView_mutation() {
        OrderStatisticSet<String> set = this.createSet(ELEMS);
        NavigableSet<String> subSet = set.subSet(ELEMS[1], true, ELEMS[2], true);
        String toAdd = ELEMS_BELOW[2];
        subSet.add(toAdd);
        Truth.assertThat(subSet).contains((Object)toAdd);
        Truth.assertThat(set).contains((Object)toAdd);
        subSet.remove(toAdd);
        Truth.assertThat(subSet).doesNotContain((Object)toAdd);
        Truth.assertThat(set).doesNotContain((Object)toAdd);
        set.add(toAdd);
        Truth.assertThat(subSet).contains((Object)toAdd);
        set.remove(toAdd);
        Truth.assertThat(subSet).doesNotContain((Object)toAdd);
    }

    @Test
    public void testSubsetView_outOfBounds_add() {
        OrderStatisticSet<String> set = this.createSet(ELEMS);
        NavigableSet<String> subSet = set.subSet(ELEMS_ABOVE[0], true, ELEMS_ABOVE[2], true);
        ImmutableList toAdd = ImmutableList.of((Object)ELEMS[1], (Object)ELEMS_BELOW[2], (Object)ELEMS[2], (Object)ELEMS_ABOVE[3]);
        Assert.assertThrows(IllegalArgumentException.class, () -> subSet.add(ELEMS[0]));
        Assert.assertThrows(IllegalArgumentException.class, () -> subSet.add(ELEMS[3]));
        Assert.assertThrows(IllegalArgumentException.class, () -> subSet.addAll((Collection<String>)toAdd));
    }

    @Test
    public void testSubsetView_outOfBounds_remove() {
        OrderStatisticSet<String> set = this.createSet(ELEMS);
        NavigableSet<String> subSet = set.subSet(ELEMS_ABOVE[1], true, ELEMS_ABOVE[2], true);
        subSet.remove(ELEMS[1]);
        subSet.remove(ELEMS[3]);
        Truth.assertThat(set).contains((Object)ELEMS[1]);
        Truth.assertThat(set).contains((Object)ELEMS[3]);
        ImmutableList toRemove = ImmutableList.of((Object)ELEMS_BELOW[2], (Object)ELEMS[2], (Object)ELEMS[1]);
        subSet.removeAll((Collection<?>)toRemove);
        Truth.assertThat(set).contains((Object)ELEMS[1]);
        Truth.assertThat(set).doesNotContain((Object)ELEMS_BELOW[2]);
        Truth.assertThat(set).doesNotContain((Object)ELEMS[2]);
    }

    @Test
    public void testSubsetView_outOfBounds_contains() {
        OrderStatisticSet<String> set = this.createSet(ELEMS);
        NavigableSet<String> subSet = set.subSet(ELEMS_ABOVE[1], true, ELEMS_ABOVE[2], true);
        Truth.assertThat(subSet).doesNotContain((Object)ELEMS[1]);
        Truth.assertThat(subSet).doesNotContain((Object)ELEMS[3]);
        subSet = set.subSet(ELEMS_ABOVE[1], false, ELEMS_ABOVE[2], false);
        Truth.assertThat(subSet).doesNotContain((Object)ELEMS_ABOVE[1]);
        Truth.assertThat(subSet).doesNotContain((Object)ELEMS_ABOVE[2]);
        subSet = set.subSet(ELEMS_ABOVE[0], true, ELEMS_ABOVE[2], true);
        Truth.assertThat(subSet).contains((Object)ELEMS[1]);
        Truth.assertThat(subSet).contains((Object)ELEMS[2]);
    }

    @Test
    public void testSubsetView_descending() {
        OrderStatisticSet<String> set = this.createSet(ELEMS);
        NavigableSet subSet = set.subSet((Object)ELEMS[1], true, (Object)ELEMS[2], true).descendingSet();
        Truth.assertThat((String)ELEMS[2]).isEqualTo(subSet.first());
        Truth.assertThat((String)ELEMS[1]).isEqualTo(subSet.last());
        subSet = subSet.descendingSet();
        Truth.assertThat((String)ELEMS[1]).isEqualTo(subSet.first());
        Truth.assertThat((String)ELEMS[2]).isEqualTo(subSet.last());
    }

    @Test
    public void testSubsetView_subsetOfSubset() {
        OrderStatisticSet<String> set = this.createSet(ELEMS);
        NavigableSet subSet = set.subSet((Object)ELEMS[1], true, (Object)ELEMS[3], true);
        NavigableSet<String> subSubSet = subSet.subSet(ELEMS[1], true, ELEMS_BELOW[3], true);
        Truth.assertThat(subSubSet).doesNotContain((Object)ELEMS[0]);
        Truth.assertThat(subSubSet).contains((Object)ELEMS[1]);
        Truth.assertThat(subSubSet).contains((Object)ELEMS[2]);
        Truth.assertThat(subSubSet).doesNotContain((Object)ELEMS[3]);
        subSubSet = subSet.subSet(ELEMS[1], true, ELEMS[3], true);
        Truth.assertThat(subSubSet).contains((Object)ELEMS[1]);
        Truth.assertThat(subSubSet).contains((Object)ELEMS[2]);
        Truth.assertThat(subSubSet).contains((Object)ELEMS[3]);
        subSubSet = subSubSet.subSet(ELEMS[1], false, ELEMS[3], false);
        Truth.assertThat(subSubSet).doesNotContain((Object)ELEMS[1]);
        Truth.assertThat(subSubSet).contains((Object)ELEMS[2]);
        Truth.assertThat(subSubSet).doesNotContain((Object)ELEMS[3]);
    }

    @Test
    public void testGetByRank_valid() {
        OrderStatisticSet<String> set = this.createSet(ELEMS);
        for (int i = 0; i < ELEMS.length; ++i) {
            Truth.assertThat((String)ELEMS[i]).isEqualTo((Object)set.getByRank(i));
        }
    }

    @Test
    public void testGetByRank_outOfBounds() {
        OrderStatisticSet<String> set = this.createSet(ELEMS);
        try {
            set.getByRank(-1);
            Truth.assertWithMessage((String)("Expected " + IndexOutOfBoundsException.class.getSimpleName())).fail();
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        try {
            set.getByRank(ELEMS.length);
            Truth.assertWithMessage((String)("Expected " + IndexOutOfBoundsException.class.getSimpleName())).fail();
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
    }

    @Test
    public void testGetByRank_subsetFirst() {
        OrderStatisticSet<String> set = this.createSet(ELEMS);
        NavigableSet subSet = set.subSet((Object)ELEMS[1], true, (Object)ELEMS[2], true);
        String firstSubSetElement = (String)subSet.getByRank(0);
        Truth.assertThat((String)firstSubSetElement).isEqualTo((Object)ELEMS[1]);
    }

    @Test
    public void testGetByRank_subsetLast() {
        OrderStatisticSet<String> set = this.createSet(ELEMS);
        NavigableSet subSet = set.subSet((Object)ELEMS[1], true, (Object)ELEMS[2], true);
        String lastSubSetElement = (String)subSet.getByRank(subSet.size() - 1);
        Truth.assertThat((String)lastSubSetElement).isEqualTo((Object)ELEMS[2]);
    }

    @Test
    public void testGetByRank_descendingSetFirstElement() {
        OrderStatisticSet<String> set = this.createSet(ELEMS);
        NavigableSet descendingSet = set.descendingSet();
        String firstElementDescending = (String)descendingSet.getByRank(0);
        Truth.assertThat((String)firstElementDescending).isEqualTo((Object)ELEMS[ELEMS.length - 1]);
    }

    @Test
    public void testGetByRank_descendingSetSecondElement() {
        OrderStatisticSet<String> set = this.createSet(ELEMS);
        NavigableSet descendingSet = set.descendingSet();
        String firstElementDescending = (String)descendingSet.getByRank(1);
        Truth.assertThat((String)firstElementDescending).isEqualTo((Object)ELEMS[ELEMS.length - 2]);
    }

    @Test
    public void testGetByRank_descendingSetLastElement() {
        OrderStatisticSet<String> set = this.createSet(ELEMS);
        NavigableSet descendingSet = set.descendingSet();
        String lastElementDescending = (String)descendingSet.getByRank(descendingSet.size() - 1);
        Truth.assertThat((String)lastElementDescending).isEqualTo((Object)ELEMS[0]);
    }

    @Test
    public void testRemoveByRank_valid() {
        OrderStatisticSet<String> set = this.createSet(ELEMS);
        set.removeByRank(2);
        Truth.assertThat(set).doesNotContain((Object)ELEMS[2]);
        Truth.assertThat(set).contains((Object)ELEMS[0]);
        Truth.assertThat(set).contains((Object)ELEMS[1]);
        Truth.assertThat(set).contains((Object)ELEMS[3]);
        set.removeByRank(0);
        Truth.assertThat(set).doesNotContain((Object)ELEMS[0]);
        Truth.assertThat(set).contains((Object)ELEMS[1]);
        Truth.assertThat(set).contains((Object)ELEMS[3]);
        set.removeByRank(set.size() - 1);
        Truth.assertThat(set).doesNotContain((Object)ELEMS[3]);
        Truth.assertThat(set).contains((Object)ELEMS[1]);
        set.removeByRank(0);
        Truth.assertThat(set).isEmpty();
    }

    @Test
    public void testRemoveByRank_invalid() {
        OrderStatisticSet<String> set = this.createSet(ELEMS);
        OrderStatisticSet<String> emptySet = this.createSet();
        Assert.assertThrows(IndexOutOfBoundsException.class, () -> set.removeByRank(-1));
        Assert.assertThrows(IndexOutOfBoundsException.class, () -> set.removeByRank(set.size()));
        Assert.assertThrows(IndexOutOfBoundsException.class, () -> emptySet.removeByRank(0));
    }

    @Test
    public void testRemoveByRank_subsetFirst() {
        OrderStatisticSet<String> set = this.createSet(ELEMS);
        NavigableSet subSet = set.subSet((Object)ELEMS[1], true, (Object)ELEMS[2], true);
        String firstSubSetElement = (String)subSet.removeByRank(0);
        Truth.assertThat((String)firstSubSetElement).isEqualTo((Object)ELEMS[1]);
        Truth.assertThat((Iterable)subSet).doesNotContain((Object)ELEMS[1]);
        Truth.assertThat(set).doesNotContain((Object)ELEMS[1]);
    }

    @Test
    public void testRemoveByRank_subsetLast() {
        OrderStatisticSet<String> set = this.createSet(ELEMS);
        NavigableSet subSet = set.subSet((Object)ELEMS[1], true, (Object)ELEMS[2], true);
        String lastSubSetElement = (String)subSet.removeByRank(subSet.size() - 1);
        Truth.assertThat((String)lastSubSetElement).isEqualTo((Object)ELEMS[2]);
        Truth.assertThat((Iterable)subSet).doesNotContain((Object)ELEMS[2]);
        Truth.assertThat(set).doesNotContain((Object)ELEMS[2]);
    }

    @Test
    public void testRemoveByRank_descendingSetFirstElement() {
        OrderStatisticSet<String> set = this.createSet(ELEMS);
        NavigableSet descendingSet = set.descendingSet();
        String expectedRemove = ELEMS[ELEMS.length - 1];
        String firstElementDescending = (String)descendingSet.removeByRank(0);
        Truth.assertThat((String)firstElementDescending).isEqualTo((Object)expectedRemove);
        Truth.assertThat((Iterable)descendingSet).doesNotContain((Object)expectedRemove);
        Truth.assertThat(set).doesNotContain((Object)expectedRemove);
    }

    @Test
    public void testRemoveByRank_descendingSetLastElement() {
        OrderStatisticSet<String> set = this.createSet(ELEMS);
        NavigableSet descendingSet = set.descendingSet();
        String expectedRemove = ELEMS[0];
        String lastElementDescending = (String)descendingSet.removeByRank(descendingSet.size() - 1);
        Truth.assertThat((String)lastElementDescending).isEqualTo((Object)expectedRemove);
        Truth.assertThat((Iterable)descendingSet).doesNotContain((Object)expectedRemove);
        Truth.assertThat(set).doesNotContain((Object)expectedRemove);
    }

    private static <E> void assertRankOf(E pElement, int pExpectedRank, OrderStatisticSet<E> pSet) {
        int actualRank = pSet.rankOf(pElement);
        Truth.assertThat((Integer)actualRank).isEqualTo((Object)pExpectedRank);
    }

    @Test
    public void testRankOf_firstElement() {
        OrderStatisticSet<String> set = this.createSet(ELEMS);
        OrderStatisticSetTestSuite.assertRankOf(ELEMS[0], 0, set);
    }

    @Test
    public void testRankOf_secondElement() {
        OrderStatisticSet<String> set = this.createSet(ELEMS);
        OrderStatisticSetTestSuite.assertRankOf(ELEMS[1], 1, set);
    }

    @Test
    public void testRankOf_lastElement() {
        OrderStatisticSet<String> set = this.createSet(ELEMS);
        String element = ELEMS[ELEMS.length - 1];
        int expectedRank = ELEMS.length - 1;
        OrderStatisticSetTestSuite.assertRankOf(element, expectedRank, set);
    }

    @Test
    public void testRankOf_descendingSetFirstElement() {
        NavigableSet descendingSet = this.createSet(ELEMS).descendingSet();
        String element = ELEMS[ELEMS.length - 1];
        int expectedRank = 0;
        OrderStatisticSetTestSuite.assertRankOf(element, expectedRank, descendingSet);
    }

    @Test
    public void testRankOf_descendingSetSecondElement() {
        NavigableSet descendingSet = this.createSet(ELEMS).descendingSet();
        String element = ELEMS[ELEMS.length - 2];
        int expectedRank = 1;
        OrderStatisticSetTestSuite.assertRankOf(element, expectedRank, descendingSet);
    }

    @Test
    public void testRankOf_descendingSetLastElement() {
        NavigableSet descendingSet = this.createSet(ELEMS).descendingSet();
        String element = ELEMS[0];
        int expectedRank = ELEMS.length - 1;
        OrderStatisticSetTestSuite.assertRankOf(element, expectedRank, descendingSet);
    }

    @Test
    public void testRankOf_subSetFirstElement() {
        String firstSubsetElement = ELEMS[1];
        String lastSubsetElement = ELEMS[3];
        NavigableSet subSet = this.createSet(ELEMS).subSet((Object)firstSubsetElement, true, (Object)lastSubsetElement, true);
        String element = firstSubsetElement;
        int expectedRank = 0;
        OrderStatisticSetTestSuite.assertRankOf(element, expectedRank, subSet);
    }

    @Test
    public void testRankOf_subSetLastElement() {
        String firstSubsetElement = ELEMS[1];
        String lastSubsetElement = ELEMS[3];
        NavigableSet subSet = this.createSet(ELEMS).subSet((Object)firstSubsetElement, true, (Object)lastSubsetElement, true);
        String element = lastSubsetElement;
        int expectedRank = subSet.size() - 1;
        OrderStatisticSetTestSuite.assertRankOf(element, expectedRank, subSet);
    }

    @Test
    public void testRankOf_subSetSecondElement() {
        String firstSubsetElement = ELEMS[1];
        String lastSubsetElement = ELEMS[3];
        NavigableSet subSet = this.createSet(ELEMS).subSet((Object)firstSubsetElement, true, (Object)lastSubsetElement, true);
        String element = ELEMS[2];
        int expectedRank = 1;
        OrderStatisticSetTestSuite.assertRankOf(element, expectedRank, subSet);
    }

    protected static abstract class OrderStatisticSetFactory
    extends TestStringSortedSetGenerator {
        protected OrderStatisticSetFactory() {
        }

        protected abstract OrderStatisticSet<String> create(String[] var1);
    }
}

