/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.common.collect;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Verify;
import com.google.common.collect.Iterators;
import com.google.common.collect.UnmodifiableIterator;
import com.google.errorprone.annotations.Immutable;
import com.google.errorprone.annotations.Var;
import com.google.errorprone.annotations.concurrent.LazyInit;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.Serializable;
import java.util.AbstractMap;
import java.util.ArrayDeque;
import java.util.Collections;
import java.util.Comparator;
import java.util.Deque;
import java.util.Iterator;
import java.util.Map;
import java.util.NavigableSet;
import java.util.Objects;
import java.util.function.BinaryOperator;
import java.util.function.Function;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.sosy_lab.common.collect.AbstractImmutableSortedMap;
import org.sosy_lab.common.collect.CopyOnWriteSortedMap;
import org.sosy_lab.common.collect.DescendingSortedMap;
import org.sosy_lab.common.collect.OurSortedMap;
import org.sosy_lab.common.collect.PersistentMap;
import org.sosy_lab.common.collect.PersistentSortedMap;
import org.sosy_lab.common.collect.SortedMapEntrySet;

@Immutable(containerOf={"K", "V"})
public final class PathCopyingPersistentTreeMap<K extends Comparable<? super K>, V>
extends AbstractImmutableSortedMap<K, V>
implements PersistentSortedMap<K, V>,
Serializable {
    private static final long serialVersionUID = 1041711151457528188L;
    private static final PathCopyingPersistentTreeMap<?, ?> EMPTY_MAP = new PathCopyingPersistentTreeMap(null);
    private final @Nullable Node<K, V> root;
    @LazyInit
    private transient @Nullable NavigableSet<Map.Entry<K, V>> entrySet;
    @LazyInit
    private transient int size;

    public static <K extends Comparable<? super K>, V> PersistentSortedMap<K, V> of() {
        return EMPTY_MAP;
    }

    public static <K extends Comparable<? super K>, V> PersistentSortedMap<K, V> copyOf(Map<K, V> map) {
        Preconditions.checkNotNull(map);
        if (map instanceof PathCopyingPersistentTreeMap) {
            return (PathCopyingPersistentTreeMap)map;
        }
        PersistentMap<K, V> result = PathCopyingPersistentTreeMap.of();
        for (Map.Entry<K, V> entry : map.entrySet()) {
            result = result.putAndCopy((Comparable)entry.getKey(), (Object)entry.getValue());
        }
        return result;
    }

    public static <T, K extends Comparable<? super K>, V> Collector<T, ?, PersistentSortedMap<K, V>> toPathCopyingPersistentTreeMap(Function<? super T, ? extends K> keyFunction, Function<? super T, ? extends V> valueFunction) {
        return PathCopyingPersistentTreeMap.toPathCopyingPersistentTreeMap(keyFunction, valueFunction, (k, v) -> {
            throw new IllegalArgumentException("Duplicate key " + k);
        });
    }

    public static <T, K extends Comparable<? super K>, V> Collector<T, ?, PersistentSortedMap<K, V>> toPathCopyingPersistentTreeMap(Function<? super T, ? extends K> keyFunction, Function<? super T, ? extends V> valueFunction, BinaryOperator<V> mergeFunction) {
        Preconditions.checkNotNull(keyFunction);
        Preconditions.checkNotNull(valueFunction);
        Preconditions.checkNotNull(mergeFunction);
        return Collectors.collectingAndThen(Collectors.toMap(keyFunction, valueFunction, mergeFunction, () -> CopyOnWriteSortedMap.copyOf(PathCopyingPersistentTreeMap.of())), CopyOnWriteSortedMap::getSnapshot);
    }

    private PathCopyingPersistentTreeMap(@Nullable Node<K, V> pRoot) {
        this.root = pRoot;
    }

    private static <K extends Comparable<? super K>, V> @Nullable Node<K, V> findNode(Object key, Node<K, V> root) {
        Preconditions.checkNotNull((Object)key);
        return PathCopyingPersistentTreeMap.findNode((Comparable)key, root);
    }

    private static <K extends Comparable<? super K>, V> @Nullable Node<K, V> findNode(K key, Node<K, V> root) {
        Preconditions.checkNotNull(key);
        Node<K, V> current = root;
        while (current != null) {
            int comp = key.compareTo(current.getKey());
            if (comp < 0) {
                current = current.left;
                continue;
            }
            if (comp > 0) {
                current = current.right;
                continue;
            }
            return current;
        }
        return null;
    }

    private static <K extends Comparable<? super K>, V> Node<K, V> findSmallestNode(Node<K, V> root) {
        Node<K, V> current = root;
        while (current.left != null) {
            current = current.left;
        }
        return current;
    }

    private static <K extends Comparable<? super K>, V> Node<K, V> findLargestNode(Node<K, V> root) {
        Node<K, V> current = root;
        while (current.right != null) {
            current = current.right;
        }
        return current;
    }

    private static <K extends Comparable<? super K>, V> @Nullable Node<K, V> findNextGreaterNode(K key, Node<K, V> root, boolean inclusive) {
        Preconditions.checkNotNull(key);
        Node<K, V> result = null;
        Node<K, V> current = root;
        while (current != null) {
            int comp = key.compareTo(current.getKey());
            if (comp < 0) {
                result = current;
                current = current.left;
            } else if (comp > 0) {
                current = current.right;
            } else {
                if (inclusive) {
                    return current;
                }
                if (current.right == null) {
                    return result;
                }
                return PathCopyingPersistentTreeMap.findSmallestNode(current.right);
            }
            if (current != null) continue;
            return result;
        }
        return null;
    }

    private static <K extends Comparable<? super K>, V> @Nullable Node<K, V> findNextSmallerNode(K key, Node<K, V> root, boolean inclusive) {
        Preconditions.checkNotNull(key);
        Node<K, V> result = null;
        Node<K, V> current = root;
        while (current != null) {
            int comp = key.compareTo(current.getKey());
            if (comp < 0) {
                current = current.left;
            } else if (comp > 0) {
                result = current;
                current = current.right;
            } else {
                if (inclusive) {
                    return current;
                }
                if (current.left == null) {
                    return result;
                }
                return PathCopyingPersistentTreeMap.findLargestNode(current.left);
            }
            if (current != null) continue;
            return result;
        }
        return null;
    }

    private static <K extends Comparable<? super K>> boolean exceedsLowerBound(K pKey, K pLowerBound, boolean pLowerInclusive) {
        if (pLowerInclusive) {
            return pKey.compareTo(pLowerBound) < 0;
        }
        return pKey.compareTo(pLowerBound) <= 0;
    }

    private static <K extends Comparable<? super K>> boolean exceedsUpperBound(K pKey, K pUpperBound, boolean pUpperInclusive) {
        if (pUpperInclusive) {
            return pKey.compareTo(pUpperBound) > 0;
        }
        return pKey.compareTo(pUpperBound) >= 0;
    }

    private static <K extends Comparable<? super K>, V> int checkAssertions(@Nullable Node<K, V> current) {
        if (current == null) {
            return 0;
        }
        if (current.left != null) {
            Preconditions.checkState((((Comparable)current.getKey()).compareTo(current.left.getKey()) > 0 ? 1 : 0) != 0, (Object)"Tree has left child that is not smaller.");
        }
        if (current.right != null) {
            Preconditions.checkState((((Comparable)current.getKey()).compareTo(current.right.getKey()) < 0 ? 1 : 0) != 0, (Object)"Tree has right child that is not bigger.");
        }
        Preconditions.checkState((!Node.isRed(current.right) ? 1 : 0) != 0, (Object)"LLRB has red right child");
        Preconditions.checkState((!Node.isRed(current) || !Node.isRed(current.left) || !Node.isRed(current.left.left) ? 1 : 0) != 0, (Object)"LLRB has three red nodes in a row.");
        int leftBlackHeight = PathCopyingPersistentTreeMap.checkAssertions(current.left);
        int rightBlackHeight = PathCopyingPersistentTreeMap.checkAssertions(current.right);
        Preconditions.checkState((leftBlackHeight == rightBlackHeight ? 1 : 0) != 0, (String)"Black path length on left is %s and on right is %s", (int)leftBlackHeight, (int)rightBlackHeight);
        int blackHeight = leftBlackHeight;
        if (!current.isRed) {
            ++blackHeight;
        }
        return blackHeight;
    }

    @VisibleForTesting
    void checkAssertions() {
        PathCopyingPersistentTreeMap.checkAssertions(this.root);
    }

    private PersistentSortedMap<K, V> mapFromTree(@Var @Nullable Node<K, V> newRoot) {
        if (newRoot == this.root) {
            return this;
        }
        if (newRoot == null) {
            return PathCopyingPersistentTreeMap.of();
        }
        newRoot = newRoot.withColor(false);
        return new PathCopyingPersistentTreeMap<K, V>(newRoot);
    }

    @Override
    public PersistentSortedMap<K, V> putAndCopy(K key, V value) {
        return this.mapFromTree(PathCopyingPersistentTreeMap.putAndCopy0((Comparable)Preconditions.checkNotNull(key), value, this.root));
    }

    private static <K extends Comparable<? super K>, V> Node<K, V> putAndCopy0(K key, V value, @Var @Nullable Node<K, V> current) {
        if (current == null) {
            return new Node<K, V>(key, value);
        }
        int comp = key.compareTo(current.getKey());
        if (comp < 0) {
            Node<K, V> newLeft = PathCopyingPersistentTreeMap.putAndCopy0(key, value, current.left);
            current = current.withLeftChild(newLeft);
        } else if (comp > 0) {
            Node<K, V> newRight = PathCopyingPersistentTreeMap.putAndCopy0(key, value, current.right);
            current = current.withRightChild(newRight);
        } else {
            current = new Node<K, V>(key, value, current.left, current.right, current.getColor());
        }
        return PathCopyingPersistentTreeMap.restoreInvariants(current);
    }

    @Override
    public PersistentSortedMap<K, V> removeAndCopy(Object key) {
        if (this.isEmpty()) {
            return this;
        }
        return this.mapFromTree(PathCopyingPersistentTreeMap.removeAndCopy0((Comparable)Preconditions.checkNotNull((Object)key), this.root));
    }

    private static <K extends Comparable<? super K>, V> @Nullable Node<K, V> removeAndCopy0(K key, @Var Node<K, V> current) {
        int comp = key.compareTo(current.getKey());
        if (comp < 0) {
            if (current.left == null) {
                return current;
            }
            if (!Node.isRed(current.left) && !Node.isRed(current.left.left)) {
                current = PathCopyingPersistentTreeMap.makeLeftRed(current);
            }
            Node newLeft = PathCopyingPersistentTreeMap.removeAndCopy0(key, current.left);
            current = current.withLeftChild(newLeft);
        } else {
            if (comp > 0 && current.right == null) {
                return current;
            }
            if (Node.isRed(current.left)) {
                current = PathCopyingPersistentTreeMap.rotateClockwise(current);
                comp = key.compareTo(current.getKey());
                assert (comp >= 0);
            }
            if (comp == 0 && current.right == null) {
                assert (current.left == null);
                return null;
            }
            if (!Node.isRed(current.right) && !Node.isRed(current.right.left)) {
                current = PathCopyingPersistentTreeMap.makeRightRed(current);
                comp = key.compareTo(current.getKey());
                assert (comp >= 0);
            }
            if (comp == 0) {
                Node successor = current.right;
                while (successor.left != null) {
                    successor = successor.left;
                }
                Node newRight = PathCopyingPersistentTreeMap.removeMininumNodeInTree(current.right);
                current = new Node((Comparable)successor.getKey(), successor.getValue(), current.left, newRight, current.getColor());
            } else {
                Node newRight = PathCopyingPersistentTreeMap.removeAndCopy0(key, current.right);
                current = current.withRightChild(newRight);
            }
        }
        return PathCopyingPersistentTreeMap.restoreInvariants(current);
    }

    private static <K, V> @Nullable Node<K, V> removeMininumNodeInTree(@Var Node<K, V> current) {
        if (current.left == null) {
            return null;
        }
        if (!Node.isRed(current.left) && !Node.isRed(current.left.left)) {
            current = PathCopyingPersistentTreeMap.makeLeftRed(current);
        }
        Node newLeft = PathCopyingPersistentTreeMap.removeMininumNodeInTree(current.left);
        current = current.withLeftChild(newLeft);
        return PathCopyingPersistentTreeMap.restoreInvariants(current);
    }

    private static <K, V> Node<K, V> restoreInvariants(@Var Node<K, V> current) {
        if (Node.isRed(current.right)) {
            current = PathCopyingPersistentTreeMap.rotateCounterclockwise(current);
        }
        if (Node.isRed(current.left) && Node.isRed(current.left.left)) {
            current = PathCopyingPersistentTreeMap.rotateClockwise(current);
        }
        if (Node.isRed(current.left) && Node.isRed(current.right)) {
            current = PathCopyingPersistentTreeMap.colorFlip(current);
        }
        return current;
    }

    private static <K, V> Node<K, V> colorFlip(Node<K, V> current) {
        Node newLeft = current.left.withColor(!current.left.getColor());
        Node newRight = current.right.withColor(!current.right.getColor());
        return new Node(current.getKey(), current.getValue(), newLeft, newRight, !current.getColor());
    }

    private static <K, V> Node<K, V> rotateCounterclockwise(Node<K, V> current) {
        Node crossoverNode = current.right.left;
        Node newLeft = new Node(current.getKey(), current.getValue(), current.left, crossoverNode, true);
        return new Node(current.right.getKey(), current.right.getValue(), newLeft, current.right.right, current.getColor());
    }

    private static <K, V> Node<K, V> rotateClockwise(Node<K, V> current) {
        Node crossOverNode = current.left.right;
        Node newRight = new Node(current.getKey(), current.getValue(), crossOverNode, current.right, true);
        return new Node(current.left.getKey(), current.left.getValue(), current.left.left, newRight, current.getColor());
    }

    private static <K, V> Node<K, V> makeLeftRed(@Var Node<K, V> current) {
        current = PathCopyingPersistentTreeMap.colorFlip(current);
        if (Node.isRed(current.right.left)) {
            Node newRight = PathCopyingPersistentTreeMap.rotateClockwise(current.right);
            current = new Node(current.getKey(), current.getValue(), current.left, newRight, current.getColor());
            current = PathCopyingPersistentTreeMap.rotateCounterclockwise(current);
            current = PathCopyingPersistentTreeMap.colorFlip(current);
        }
        return current;
    }

    private static <K, V> Node<K, V> makeRightRed(@Var Node<K, V> current) {
        current = PathCopyingPersistentTreeMap.colorFlip(current);
        if (Node.isRed(current.left.left)) {
            current = PathCopyingPersistentTreeMap.rotateClockwise(current);
            current = PathCopyingPersistentTreeMap.colorFlip(current);
        }
        return current;
    }

    @Override
    public boolean equals(@Nullable Object pObj) {
        if (pObj instanceof PathCopyingPersistentTreeMap && ((PathCopyingPersistentTreeMap)pObj).root == this.root) {
            return true;
        }
        return super.equals(pObj);
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    @Override
    public @Nullable Map.Entry<K, V> getEntry(Object pKey) {
        return PathCopyingPersistentTreeMap.findNode(pKey, this.root);
    }

    @Override
    public Iterator<Map.Entry<K, V>> entryIterator() {
        return EntryInOrderIterator.create(this.root);
    }

    @Override
    public Iterator<Map.Entry<K, V>> descendingEntryIterator() {
        return DescendingEntryInOrderIterator.create(this.root);
    }

    @Override
    public PersistentSortedMap<K, V> empty() {
        return PathCopyingPersistentTreeMap.of();
    }

    @Override
    public boolean containsKey(Object pObj) {
        return PathCopyingPersistentTreeMap.findNode(pObj, this.root) != null;
    }

    @Override
    public @Nullable V get(Object pObj) {
        Node<Object, V> node = PathCopyingPersistentTreeMap.findNode(pObj, this.root);
        return node == null ? null : (V)node.getValue();
    }

    @Override
    public V getOrDefault(Object pKey, V pDefaultValue) {
        Node<Object, V> node = PathCopyingPersistentTreeMap.findNode(pKey, this.root);
        return node == null ? pDefaultValue : node.getValue();
    }

    @Override
    public boolean isEmpty() {
        return this.root == null;
    }

    @Override
    public int size() {
        if (this.size <= 0) {
            this.size = Node.countNodes(this.root);
        }
        return this.size;
    }

    @Override
    public @Nullable Map.Entry<K, V> firstEntry() {
        if (this.isEmpty()) {
            return null;
        }
        return PathCopyingPersistentTreeMap.findSmallestNode(this.root);
    }

    @Override
    public @Nullable Map.Entry<K, V> lastEntry() {
        if (this.isEmpty()) {
            return null;
        }
        return PathCopyingPersistentTreeMap.findLargestNode(this.root);
    }

    @Override
    public @Nullable Map.Entry<K, V> ceilingEntry(K pKey) {
        return PathCopyingPersistentTreeMap.findNextGreaterNode(pKey, this.root, true);
    }

    @Override
    public @Nullable Map.Entry<K, V> floorEntry(K pKey) {
        return PathCopyingPersistentTreeMap.findNextSmallerNode(pKey, this.root, true);
    }

    @Override
    public @Nullable Map.Entry<K, V> higherEntry(K pKey) {
        return PathCopyingPersistentTreeMap.findNextGreaterNode(pKey, this.root, false);
    }

    @Override
    public @Nullable Map.Entry<K, V> lowerEntry(K pKey) {
        return PathCopyingPersistentTreeMap.findNextSmallerNode(pKey, this.root, false);
    }

    @Override
    public @Nullable Comparator<? super K> comparator() {
        return null;
    }

    @Override
    public OurSortedMap<K, V> descendingMap() {
        return new DescendingSortedMap(this);
    }

    @Override
    public NavigableSet<Map.Entry<K, V>> entrySet() {
        if (this.entrySet == null) {
            this.entrySet = new SortedMapEntrySet(this);
        }
        return this.entrySet;
    }

    @Override
    public OurSortedMap<K, V> subMap(K pFromKey, boolean pFromInclusive, K pToKey, boolean pToInclusive) {
        Preconditions.checkNotNull(pFromKey);
        Preconditions.checkNotNull(pToKey);
        return PartialSortedMap.create(this.root, pFromKey, pFromInclusive, pToKey, pToInclusive);
    }

    @Override
    public OurSortedMap<K, V> headMap(K pToKey, boolean pToInclusive) {
        Preconditions.checkNotNull(pToKey);
        return PartialSortedMap.create(this.root, null, true, pToKey, pToInclusive);
    }

    @Override
    public OurSortedMap<K, V> tailMap(K pFromKey, boolean pFromInclusive) {
        Preconditions.checkNotNull(pFromKey);
        return PartialSortedMap.create(this.root, pFromKey, pFromInclusive, null, false);
    }

    @Immutable(containerOf={"K", "V"})
    private static final class PartialSortedMap<K extends Comparable<? super K>, V>
    extends AbstractImmutableSortedMap<K, V>
    implements OurSortedMap<K, V>,
    Serializable {
        private static final long serialVersionUID = 5354023186935889223L;
        private final Node<K, V> root;
        private final @Nullable K fromKey;
        private final boolean fromInclusive;
        private final @Nullable K toKey;
        private final boolean toInclusive;
        @LazyInit
        private transient int size;
        @LazyInit
        private transient @Nullable NavigableSet<Map.Entry<K, V>> entrySet;

        static <K extends Comparable<? super K>, V> OurSortedMap<K, V> create(Node<K, V> pRoot, @Nullable K pFromKey, boolean pFromInclusive, @Nullable K pToKey, boolean pToInclusive) {
            Node<K, V> root;
            Preconditions.checkArgument((pFromKey != null || pToKey != null ? 1 : 0) != 0);
            if (pFromKey != null && pToKey != null) {
                int comp = pFromKey.compareTo(pToKey);
                if (!(comp != 0 || pFromInclusive && pToInclusive)) {
                    return OurSortedMap.EmptyImmutableOurSortedMap.of();
                }
                Preconditions.checkArgument((comp <= 0 ? 1 : 0) != 0, (Object)"fromKey > toKey");
            }
            if ((root = PartialSortedMap.findBestRoot(pRoot, pFromKey, pFromInclusive, pToKey, pToInclusive)) == null) {
                return OurSortedMap.EmptyImmutableOurSortedMap.of();
            }
            Node<K, V> lowestNode = null;
            if (pFromKey != null && (lowestNode = PathCopyingPersistentTreeMap.findNextGreaterNode(pFromKey, root, pFromInclusive)) == null) {
                return OurSortedMap.EmptyImmutableOurSortedMap.of();
            }
            Node<K, V> highestNode = null;
            if (pToKey != null && (highestNode = PathCopyingPersistentTreeMap.findNextSmallerNode(pToKey, root, pToInclusive)) == null) {
                return OurSortedMap.EmptyImmutableOurSortedMap.of();
            }
            if (pFromKey != null && pToKey != null) {
                assert (lowestNode != null && highestNode != null);
                if (PathCopyingPersistentTreeMap.exceedsUpperBound((Comparable)lowestNode.getKey(), pToKey, pToInclusive)) {
                    Verify.verify((boolean)PathCopyingPersistentTreeMap.exceedsLowerBound((Comparable)highestNode.getKey(), pFromKey, pFromInclusive));
                    return OurSortedMap.EmptyImmutableOurSortedMap.of();
                }
            }
            return new PartialSortedMap<K, V>(root, pFromKey, pFromInclusive, pToKey, pToInclusive);
        }

        private static <K extends Comparable<? super K>, V> @Nullable Node<K, V> findBestRoot(@Nullable Node<K, V> pRoot, @Nullable K pFromKey, boolean pFromInclusive, @Nullable K pToKey, boolean pToInclusive) {
            Node<K, V> current = pRoot;
            while (current != null) {
                if (pFromKey != null && PathCopyingPersistentTreeMap.exceedsLowerBound((Comparable)current.getKey(), pFromKey, pFromInclusive)) {
                    current = current.right;
                    continue;
                }
                if (pToKey != null && PathCopyingPersistentTreeMap.exceedsUpperBound((Comparable)current.getKey(), pToKey, pToInclusive)) {
                    current = current.left;
                    continue;
                }
                return current;
            }
            return null;
        }

        private PartialSortedMap(Node<K, V> pRoot, @Nullable K pFromKey, boolean pFromInclusive, @Nullable K pToKey, boolean pToInclusive) {
            this.root = (Node)Preconditions.checkNotNull(pRoot);
            this.fromKey = pFromKey;
            this.fromInclusive = pFromInclusive;
            this.toKey = pToKey;
            this.toInclusive = pToInclusive;
            assert (pFromKey == null || this.containsKey(PathCopyingPersistentTreeMap.findNextGreaterNode(pFromKey, pRoot, this.fromInclusive).getKey()));
            assert (pToKey == null || this.containsKey(PathCopyingPersistentTreeMap.findNextSmallerNode(pToKey, pRoot, this.toInclusive).getKey()));
        }

        private boolean inRange(K key, boolean treatBoundsAsInclusive) {
            return !this.tooLow(key, treatBoundsAsInclusive) && !this.tooHigh(key, treatBoundsAsInclusive);
        }

        private boolean tooLow(K key, boolean treatBoundAsInclusive) {
            return this.fromKey != null && PathCopyingPersistentTreeMap.exceedsLowerBound(key, this.fromKey, treatBoundAsInclusive || this.fromInclusive);
        }

        private boolean tooHigh(K key, boolean treatBoundAsInclusive) {
            return this.toKey != null && PathCopyingPersistentTreeMap.exceedsUpperBound(key, this.toKey, treatBoundAsInclusive || this.toInclusive);
        }

        @Override
        public Iterator<Map.Entry<K, V>> entryIterator() {
            return EntryInOrderIterator.createWithBounds(this.root, this.fromKey, this.fromInclusive, this.toKey, this.toInclusive);
        }

        @Override
        public Iterator<Map.Entry<K, V>> descendingEntryIterator() {
            return DescendingEntryInOrderIterator.createWithBounds(this.root, this.fromKey, this.fromInclusive, this.toKey, this.toInclusive);
        }

        @Override
        public boolean equals(@Nullable Object pObj) {
            if (pObj instanceof PartialSortedMap) {
                PartialSortedMap other = (PartialSortedMap)pObj;
                if (this.root == other.root && Objects.equals(this.fromKey, other.fromKey) && this.fromInclusive == other.fromInclusive && Objects.equals(this.toKey, other.toKey) && this.toInclusive == other.toInclusive) {
                    return true;
                }
            }
            return super.equals(pObj);
        }

        @Override
        public int hashCode() {
            return super.hashCode();
        }

        @Override
        public boolean containsKey(Object pKey) {
            Comparable key = (Comparable)Preconditions.checkNotNull((Object)pKey);
            return this.inRange(key, false) && PathCopyingPersistentTreeMap.findNode(key, this.root) != null;
        }

        @Override
        public @Nullable Node<K, V> getEntry(Object pKey) {
            Comparable key = (Comparable)Preconditions.checkNotNull((Object)pKey);
            if (!this.inRange(key, false)) {
                return null;
            }
            Node<Comparable, V> node = PathCopyingPersistentTreeMap.findNode(key, this.root);
            return node;
        }

        @Override
        public @Nullable V get(Object pKey) {
            Map.Entry node = this.getEntry(pKey);
            return node == null ? null : (V)((AbstractMap.SimpleImmutableEntry)node).getValue();
        }

        @Override
        public boolean isEmpty() {
            return false;
        }

        @Override
        public int size() {
            if (this.size == 0) {
                this.size = Iterators.size(this.entryIterator());
            }
            return this.size;
        }

        @Override
        public @Nullable Map.Entry<K, V> firstEntry() {
            if (this.fromKey == null) {
                return PathCopyingPersistentTreeMap.findSmallestNode(this.root);
            }
            return PathCopyingPersistentTreeMap.findNextGreaterNode(this.fromKey, this.root, this.fromInclusive);
        }

        @Override
        public @Nullable Map.Entry<K, V> lastEntry() {
            if (this.toKey == null) {
                return PathCopyingPersistentTreeMap.findLargestNode(this.root);
            }
            return PathCopyingPersistentTreeMap.findNextSmallerNode(this.toKey, this.root, this.toInclusive);
        }

        @Override
        public @Nullable Map.Entry<K, V> ceilingEntry(K pKey) {
            Node<K, V> result = PathCopyingPersistentTreeMap.findNextGreaterNode(pKey, this.root, true);
            if (result != null && !this.inRange((Comparable)result.getKey(), false)) {
                return null;
            }
            return result;
        }

        @Override
        public @Nullable Map.Entry<K, V> floorEntry(K pKey) {
            Node<K, V> result = PathCopyingPersistentTreeMap.findNextSmallerNode(pKey, this.root, true);
            if (result != null && !this.inRange((Comparable)result.getKey(), false)) {
                return null;
            }
            return result;
        }

        @Override
        public @Nullable Map.Entry<K, V> higherEntry(K pKey) {
            Node<K, V> result = PathCopyingPersistentTreeMap.findNextGreaterNode(pKey, this.root, false);
            if (result != null && !this.inRange((Comparable)result.getKey(), false)) {
                return null;
            }
            return result;
        }

        @Override
        public @Nullable Map.Entry<K, V> lowerEntry(K pKey) {
            Node<K, V> result = PathCopyingPersistentTreeMap.findNextSmallerNode(pKey, this.root, false);
            if (result != null && !this.inRange((Comparable)result.getKey(), false)) {
                return null;
            }
            return result;
        }

        @Override
        public @Nullable Comparator<? super K> comparator() {
            return null;
        }

        @Override
        public OurSortedMap<K, V> descendingMap() {
            return new DescendingSortedMap(this);
        }

        @Override
        public NavigableSet<Map.Entry<K, V>> entrySet() {
            if (this.entrySet == null) {
                this.entrySet = new SortedMapEntrySet(this);
            }
            return this.entrySet;
        }

        @Override
        public OurSortedMap<K, V> subMap(K pFromKey, boolean pFromInclusive, K pToKey, boolean pToInclusive) {
            Preconditions.checkNotNull(pFromKey);
            Preconditions.checkNotNull(pToKey);
            Preconditions.checkArgument((boolean)this.inRange(pFromKey, !pFromInclusive));
            Preconditions.checkArgument((boolean)this.inRange(pToKey, !pToInclusive));
            return PartialSortedMap.create(this.root, pFromKey, pFromInclusive, pToKey, pToInclusive);
        }

        @Override
        public OurSortedMap<K, V> headMap(K pToKey, boolean pInclusive) {
            Preconditions.checkNotNull(pToKey);
            Preconditions.checkArgument((boolean)this.inRange(pToKey, !pInclusive));
            return PartialSortedMap.create(this.root, this.fromKey, this.fromInclusive, pToKey, pInclusive);
        }

        @Override
        public OurSortedMap<K, V> tailMap(K pFromKey, boolean pInclusive) {
            Preconditions.checkNotNull(pFromKey);
            Preconditions.checkArgument((boolean)this.inRange(pFromKey, !pInclusive));
            return PartialSortedMap.create(this.root, pFromKey, pInclusive, this.toKey, this.toInclusive);
        }
    }

    private static class DescendingEntryInOrderIterator<K extends Comparable<? super K>, V>
    extends UnmodifiableIterator<Map.Entry<K, V>> {
        private final Deque<Node<K, V>> stack = new ArrayDeque<Node<K, V>>();
        private final @Nullable K lowKey;
        private final boolean lowInclusive;

        static <K extends Comparable<? super K>, V> Iterator<Map.Entry<K, V>> create(@Nullable Node<K, V> root) {
            if (root == null) {
                return Collections.emptyIterator();
            }
            return new DescendingEntryInOrderIterator<Object, V>(root, null, false, null, false);
        }

        static <K extends Comparable<? super K>, V> Iterator<Map.Entry<K, V>> createWithBounds(@Nullable Node<K, V> root, @Nullable K pFromKey, boolean pFromInclusive, @Nullable K pToKey, boolean pToInclusive) {
            if (root == null) {
                return Collections.emptyIterator();
            }
            return new DescendingEntryInOrderIterator<K, V>(root, pFromKey, pFromInclusive, pToKey, pToInclusive);
        }

        private DescendingEntryInOrderIterator(Node<K, V> root, @Nullable K pLowKey, boolean pLowInclusive, @Nullable K pHighKey, boolean pHighInclusive) {
            this.lowKey = pLowKey;
            this.lowInclusive = pLowInclusive;
            if (pHighKey == null) {
                this.pushRightMostNodesOnStack(root);
            } else {
                this.pushNodesToKeyOnStack(root, (Comparable)PathCopyingPersistentTreeMap.findNextSmallerNode(pHighKey, root, pHighInclusive).getKey());
            }
            this.stopFurtherIterationIfOutOfRange();
        }

        public boolean hasNext() {
            return !this.stack.isEmpty();
        }

        private void pushRightMostNodesOnStack(@Var Node<K, V> current) {
            while (current.right != null) {
                this.stack.push(current);
                current = current.right;
            }
            this.stack.push(current);
        }

        private void pushNodesToKeyOnStack(@Var Node<K, V> current, K key) {
            while (current != null) {
                int comp = key.compareTo(current.getKey());
                if (comp > 0) {
                    this.stack.push(current);
                    current = current.right;
                    continue;
                }
                if (comp < 0) {
                    current = current.left;
                    continue;
                }
                this.stack.push(current);
                return;
            }
            throw new AssertionError((Object)"PartialEntryInOrderIterator created with upper bound that is not in map");
        }

        private void stopFurtherIterationIfOutOfRange() {
            if (this.lowKey != null && !this.stack.isEmpty() && PathCopyingPersistentTreeMap.exceedsLowerBound((Comparable)this.stack.peek().getKey(), this.lowKey, this.lowInclusive)) {
                this.stack.clear();
            }
        }

        public Map.Entry<K, V> next() {
            Node<K, V> current = this.stack.pop();
            if (current.left != null) {
                this.pushRightMostNodesOnStack(current.left);
            }
            this.stopFurtherIterationIfOutOfRange();
            return current;
        }
    }

    private static class EntryInOrderIterator<K extends Comparable<? super K>, V>
    extends UnmodifiableIterator<Map.Entry<K, V>> {
        private final Deque<Node<K, V>> stack = new ArrayDeque<Node<K, V>>();
        private final @Nullable K highKey;
        private final boolean highInclusive;

        static <K extends Comparable<? super K>, V> Iterator<Map.Entry<K, V>> create(@Nullable Node<K, V> root) {
            if (root == null) {
                return Collections.emptyIterator();
            }
            return new EntryInOrderIterator<Object, V>(root, null, false, null, false);
        }

        static <K extends Comparable<? super K>, V> Iterator<Map.Entry<K, V>> createWithBounds(@Nullable Node<K, V> root, @Nullable K pFromKey, boolean pFromInclusive, @Nullable K pToKey, boolean pToInclusive) {
            if (root == null) {
                return Collections.emptyIterator();
            }
            return new EntryInOrderIterator<K, V>(root, pFromKey, pFromInclusive, pToKey, pToInclusive);
        }

        private EntryInOrderIterator(Node<K, V> root, @Nullable K pLowKey, boolean pLowInclusive, @Nullable K pHighKey, boolean pHighInclusive) {
            this.highKey = pHighKey;
            this.highInclusive = pHighInclusive;
            if (pLowKey == null) {
                this.pushLeftMostNodesOnStack(root);
            } else {
                this.pushNodesToKeyOnStack(root, (Comparable)PathCopyingPersistentTreeMap.findNextGreaterNode(pLowKey, root, pLowInclusive).getKey());
            }
            this.stopFurtherIterationIfOutOfRange();
        }

        public boolean hasNext() {
            return !this.stack.isEmpty();
        }

        private void pushLeftMostNodesOnStack(@Var Node<K, V> current) {
            while (current.left != null) {
                this.stack.push(current);
                current = current.left;
            }
            this.stack.push(current);
        }

        private void pushNodesToKeyOnStack(@Var Node<K, V> current, K key) {
            while (current != null) {
                int comp = key.compareTo(current.getKey());
                if (comp < 0) {
                    this.stack.push(current);
                    current = current.left;
                    continue;
                }
                if (comp > 0) {
                    current = current.right;
                    continue;
                }
                this.stack.push(current);
                return;
            }
            throw new AssertionError((Object)"PartialEntryInOrderIterator created with lower bound that is not in map");
        }

        private void stopFurtherIterationIfOutOfRange() {
            if (this.highKey != null && !this.stack.isEmpty() && PathCopyingPersistentTreeMap.exceedsUpperBound((Comparable)this.stack.peek().getKey(), this.highKey, this.highInclusive)) {
                this.stack.clear();
            }
        }

        public Map.Entry<K, V> next() {
            Node<K, V> current = this.stack.pop();
            if (current.right != null) {
                this.pushLeftMostNodesOnStack(current.right);
            }
            this.stopFurtherIterationIfOutOfRange();
            return current;
        }
    }

    @Immutable(containerOf={"K", "V"})
    @SuppressFBWarnings(value={"EQ_DOESNT_OVERRIDE_EQUALS"}, justification="Inherits equals() according to specification.")
    private static final class Node<K, V>
    extends AbstractMap.SimpleImmutableEntry<K, V> {
        private static final boolean RED = true;
        private static final boolean BLACK = false;
        private static final long serialVersionUID = -7393505826652634501L;
        private final @Nullable Node<K, V> left;
        private final @Nullable Node<K, V> right;
        private final boolean isRed;

        Node(K pKey, V pValue) {
            super(pKey, pValue);
            this.left = null;
            this.right = null;
            this.isRed = true;
        }

        Node(K pKey, V pValue, Node<K, V> pLeft, Node<K, V> pRight, boolean pRed) {
            super(pKey, pValue);
            this.left = pLeft;
            this.right = pRight;
            this.isRed = pRed;
        }

        boolean isLeaf() {
            return this.left == null && this.right == null;
        }

        boolean getColor() {
            return this.isRed;
        }

        static boolean isRed(@Nullable Node<?, ?> n) {
            return n != null && n.isRed;
        }

        static boolean isBlack(@Nullable Node<?, ?> n) {
            return n != null && !n.isRed;
        }

        Node<K, V> withColor(boolean color) {
            if (this.isRed == color) {
                return this;
            }
            return new Node(this.getKey(), this.getValue(), this.left, this.right, color);
        }

        Node<K, V> withLeftChild(Node<K, V> newLeft) {
            if (newLeft == this.left) {
                return this;
            }
            return new Node(this.getKey(), this.getValue(), newLeft, this.right, this.isRed);
        }

        Node<K, V> withRightChild(Node<K, V> newRight) {
            if (newRight == this.right) {
                return this;
            }
            return new Node(this.getKey(), this.getValue(), this.left, newRight, this.isRed);
        }

        static int countNodes(@Nullable Node<?, ?> n) {
            if (n == null) {
                return 0;
            }
            return Node.countNodes(n.left) + 1 + Node.countNodes(n.right);
        }
    }
}

