/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.common.collect;

import com.google.common.base.Preconditions;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.UnmodifiableListIterator;
import com.google.errorprone.annotations.Immutable;
import com.google.errorprone.annotations.InlineMe;
import com.google.errorprone.annotations.Var;
import java.util.AbstractSequentialList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.BinaryOperator;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import java.util.stream.Collector;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.sosy_lab.common.collect.PersistentList;

@Immutable(containerOf={"T"})
public final class PersistentLinkedList<T>
extends AbstractSequentialList<T>
implements PersistentList<T> {
    private final @Nullable T head;
    private final @Nullable PersistentLinkedList<T> tail;
    private static final PersistentLinkedList EMPTY = PersistentLinkedList.makeEmpty();

    private PersistentLinkedList(@Nullable T head, @Nullable PersistentLinkedList<T> tail) {
        this.head = head;
        this.tail = tail;
    }

    private static PersistentLinkedList makeEmpty() {
        return new PersistentLinkedList<Object>(null, null);
    }

    public static <T> PersistentLinkedList<T> of() {
        return EMPTY;
    }

    public static <T> PersistentLinkedList<T> of(T value) {
        Preconditions.checkNotNull(value);
        return new PersistentLinkedList<T>(value, PersistentLinkedList.of());
    }

    public static <T> PersistentLinkedList<T> of(T v1, T v2) {
        return PersistentLinkedList.of(v2).with((Object)v1);
    }

    public static <T> PersistentLinkedList<T> of(T v1, T v2, T v3) {
        return ((PersistentLinkedList)PersistentLinkedList.of(v3).with((Object)v2)).with((Object)v1);
    }

    public static <T> PersistentLinkedList<T> of(T v1, T ... values) {
        return PersistentLinkedList.copyOf(values).with((Object)v1);
    }

    public static <T> PersistentLinkedList<T> copyOf(T ... values) {
        return PersistentLinkedList.copyOf(Arrays.asList(values));
    }

    public static <T> PersistentLinkedList<T> copyOf(List<T> values) {
        if (values instanceof PersistentLinkedList) {
            return (PersistentLinkedList)values;
        }
        PersistentList<T> result = PersistentLinkedList.of();
        for (Object value : Lists.reverse(values)) {
            result = result.with(value);
        }
        return result;
    }

    public T head() {
        Preconditions.checkState((!this.isEmpty() ? 1 : 0) != 0);
        return this.head;
    }

    public PersistentLinkedList<T> tail() {
        Preconditions.checkState((!this.isEmpty() ? 1 : 0) != 0);
        return this.tail;
    }

    @Override
    public PersistentLinkedList<T> with(T value) {
        Preconditions.checkNotNull(value);
        return new PersistentLinkedList<T>(value, this);
    }

    @Override
    public PersistentLinkedList<T> withAll(@Var List<T> values) {
        PersistentList<T> result = this;
        if (values instanceof PersistentLinkedList) {
            values = ImmutableList.copyOf(values);
        }
        for (Object value : Lists.reverse(values)) {
            result = result.with(value);
        }
        return result;
    }

    @Override
    public PersistentLinkedList<T> without(@Nullable T value) {
        PersistentLinkedList<T> suffix = PersistentLinkedList.of();
        int pos = 0;
        PersistentLinkedList<T> list = this;
        while (!list.isEmpty()) {
            if (Objects.equals(value, list.head)) {
                suffix = list.tail;
                break;
            }
            ++pos;
            list = list.tail;
        }
        ImmutableList prefix = FluentIterable.from((Iterable)this).limit(pos).toList();
        PersistentList<T> result = suffix;
        for (Object v : prefix.reverse()) {
            result = result.with(v);
        }
        return result;
    }

    @Override
    public PersistentLinkedList<T> empty() {
        return PersistentLinkedList.of();
    }

    @Override
    public int size() {
        int size = 0;
        PersistentLinkedList<T> list = this;
        while (!list.isEmpty()) {
            ++size;
            list = list.tail;
        }
        return size;
    }

    @Override
    public boolean isEmpty() {
        return this == EMPTY;
    }

    @Override
    public PersistentLinkedList<T> reversed() {
        PersistentList result = this.empty();
        PersistentLinkedList<T> p = this;
        while (!p.isEmpty()) {
            result = ((PersistentLinkedList)result).with((Object)p.head);
            p = p.tail;
        }
        return result;
    }

    @Override
    public Iterator<T> iterator() {
        return new Iter(this);
    }

    @Override
    public ListIterator<T> listIterator(int index) {
        if (index < 0) {
            throw new IndexOutOfBoundsException();
        }
        Iter it = new Iter(this);
        for (int i = 0; i < index; ++i) {
            if (!it.hasNext()) {
                throw new IndexOutOfBoundsException();
            }
            it.next();
        }
        return it;
    }

    public static <T> Collector<T, ?, PersistentLinkedList<T>> toPersistentLinkedList() {
        return new Collector<T, PersistentLinkedListBuilder<T>, PersistentLinkedList<T>>(){

            @Override
            public Supplier<PersistentLinkedListBuilder<T>> supplier() {
                return () -> new PersistentLinkedListBuilder();
            }

            @Override
            public BiConsumer<PersistentLinkedListBuilder<T>, T> accumulator() {
                return PersistentLinkedListBuilder::add;
            }

            @Override
            public BinaryOperator<PersistentLinkedListBuilder<T>> combiner() {
                return (a, b) -> {
                    throw new UnsupportedOperationException("Should be used sequentially");
                };
            }

            @Override
            public Function<PersistentLinkedListBuilder<T>, PersistentLinkedList<T>> finisher() {
                return PersistentLinkedListBuilder::build;
            }

            @Override
            public Set<Collector.Characteristics> characteristics() {
                return EnumSet.noneOf(Collector.Characteristics.class);
            }
        };
    }

    @Deprecated
    @InlineMe(replacement="PersistentLinkedList.toPersistentLinkedList()", imports={"org.sosy_lab.common.collect.PersistentLinkedList"})
    public static <T> Collector<T, ?, PersistentLinkedList<T>> collector() {
        return PersistentLinkedList.toPersistentLinkedList();
    }

    @Override
    @Deprecated
    public void replaceAll(UnaryOperator<T> pOperator) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public void sort(Comparator<? super T> pC) {
        throw new UnsupportedOperationException();
    }

    private static class PersistentLinkedListBuilder<T> {
        private PersistentLinkedList<T> list = PersistentLinkedList.of();

        private PersistentLinkedListBuilder() {
        }

        void add(T e) {
            this.list = this.list.with((Object)e);
        }

        PersistentLinkedList<T> build() {
            return this.list;
        }
    }

    private static class Iter<T>
    extends UnmodifiableListIterator<T> {
        private PersistentLinkedList<T> list;
        private int nextIndex = 0;

        private Iter(PersistentLinkedList<T> list) {
            this.list = list;
        }

        public boolean hasNext() {
            return !this.list.isEmpty();
        }

        public T next() {
            if (this.list.isEmpty()) {
                throw new NoSuchElementException();
            }
            ++this.nextIndex;
            Object result = this.list.head;
            this.list = this.list.tail;
            return result;
        }

        public int nextIndex() {
            return this.nextIndex;
        }

        public int previousIndex() {
            return this.nextIndex - 1;
        }

        public boolean hasPrevious() {
            throw new UnsupportedOperationException();
        }

        public T previous() {
            throw new UnsupportedOperationException();
        }
    }
}

