/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.common.collect;

import com.google.common.base.Equivalence;
import com.google.common.base.Preconditions;
import com.google.common.collect.Iterators;
import com.google.common.collect.Ordering;
import java.util.Iterator;
import java.util.Map;
import org.sosy_lab.common.collect.MapsDifference;
import org.sosy_lab.common.collect.PersistentMap;
import org.sosy_lab.common.collect.PersistentSortedMap;

public class PersistentSortedMaps {
    private PersistentSortedMaps() {
    }

    public static <K, V> MergeConflictHandler<K, V> getExceptionMergeConflictHandler() {
        return (key, value1, value2) -> {
            throw new IllegalArgumentException(String.format("Conflicting value when merging maps for key %s: %s and %s", key, value1, value2));
        };
    }

    public static <K, V extends Comparable<? super V>> MergeConflictHandler<K, V> getMaximumMergeConflictHandler() {
        return (key, value1, value2) -> (Comparable)Ordering.natural().max(value1, value2);
    }

    public static <K, V extends Comparable<? super V>> MergeConflictHandler<K, V> getMinimumMergeConflictHandler() {
        return (key, value1, value2) -> (Comparable)Ordering.natural().min(value1, value2);
    }

    private static <K, V> MergeConflictHandler<K, V> inverseMergeConflictHandler(MergeConflictHandler<K, V> delegate) {
        return (pKey, pValue1, pValue2) -> delegate.resolveConflict(pKey, pValue2, pValue1);
    }

    public static <K extends Comparable<? super K>, V> PersistentSortedMap<K, V> merge(PersistentSortedMap<K, V> map1, PersistentSortedMap<K, V> map2, MergeConflictHandler<K, V> conflictHandler) {
        if (map1.size() >= map2.size()) {
            return PersistentSortedMaps.merge(map1, map2, Equivalence.equals(), conflictHandler, MapsDifference.ignoreMapsDifference());
        }
        return PersistentSortedMaps.merge(map2, map1, Equivalence.equals(), PersistentSortedMaps.inverseMergeConflictHandler(conflictHandler), MapsDifference.ignoreMapsDifference());
    }

    public static <K extends Comparable<? super K>, V> PersistentSortedMap<K, V> merge(PersistentSortedMap<K, V> map1, PersistentSortedMap<K, V> map2, Equivalence<? super V> valueEquals, MergeConflictHandler<? super K, V> conflictHandler, MapsDifference.Visitor<? super K, ? super V> collectDifferences) {
        Iterator rest;
        Object value2;
        Comparable key;
        Preconditions.checkNotNull(map1);
        Preconditions.checkNotNull(map2);
        Preconditions.checkNotNull(valueEquals);
        Preconditions.checkNotNull(conflictHandler);
        Preconditions.checkNotNull(collectDifferences);
        if (map1 == map2) {
            return map1;
        }
        PersistentMap<K, V> result = map1;
        Iterator it1 = map1.entrySet().iterator();
        Iterator it2 = map2.entrySet().iterator();
        Map.Entry e1 = null;
        Map.Entry e2 = null;
        while ((e1 != null || it1.hasNext()) && (e2 != null || it2.hasNext())) {
            Object value22;
            Object value1;
            int comp;
            if (e1 == null) {
                e1 = (Map.Entry)it1.next();
            }
            if (e2 == null) {
                e2 = (Map.Entry)it2.next();
            }
            if ((comp = ((Comparable)e1.getKey()).compareTo(e2.getKey())) < 0) {
                key = (Comparable)e1.getKey();
                value1 = e1.getValue();
                collectDifferences.leftValueOnly(key, value1);
                e1 = null;
                continue;
            }
            if (comp > 0) {
                key = (Comparable)e2.getKey();
                value2 = e2.getValue();
                assert (!result.containsKey(key));
                result = result.putAndCopy(key, value2);
                collectDifferences.rightValueOnly(key, value2);
                e2 = null;
                continue;
            }
            key = (Comparable)e1.getKey();
            value1 = e1.getValue();
            if (!valueEquals.equivalent(value1, value22 = e2.getValue())) {
                V newValue = conflictHandler.resolveConflict(key, value1, value22);
                result = result.putAndCopy(key, (Object)newValue);
                collectDifferences.differingValues(key, value1, value22);
            }
            e1 = null;
            e2 = null;
        }
        if (collectDifferences != MapsDifference.ignoreMapsDifference()) {
            Iterator rest2;
            Iterator iterator = rest2 = e1 != null ? Iterators.concat((Iterator)Iterators.singletonIterator((Object)e1), it1) : it1;
            while (rest2.hasNext()) {
                e1 = (Map.Entry)rest2.next();
                collectDifferences.leftValueOnly((Comparable)e1.getKey(), e1.getValue());
            }
        }
        Iterator iterator = rest = e2 != null ? Iterators.concat((Iterator)Iterators.singletonIterator(e2), it2) : it2;
        while (rest.hasNext()) {
            e2 = (Map.Entry)rest.next();
            key = (Comparable)e2.getKey();
            value2 = e2.getValue();
            result = result.putAndCopy(key, value2);
            collectDifferences.rightValueOnly(key, value2);
        }
        assert (result.size() >= Math.max(map1.size(), map2.size()));
        return result;
    }

    @FunctionalInterface
    public static interface MergeConflictHandler<K, V> {
        public V resolveConflict(K var1, V var2, V var3);
    }
}

