/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.common.configuration;

import com.google.auto.service.AutoService;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.errorprone.annotations.Var;
import java.lang.annotation.Annotation;
import java.lang.invoke.CallSite;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.Completion;
import javax.annotation.processing.Completions;
import javax.annotation.processing.Processor;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.PrimitiveType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;
import javax.tools.Diagnostic;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.sosy_lab.common.configuration.AnnotatedValue;
import org.sosy_lab.common.configuration.ClassOption;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.FileOption;
import org.sosy_lab.common.configuration.IntegerOption;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.configuration.Option;
import org.sosy_lab.common.configuration.OptionDetailAnnotation;
import org.sosy_lab.common.configuration.Options;
import org.sosy_lab.common.configuration.TimeSpanOption;

@SupportedAnnotationTypes(value={"org.sosy_lab.common.configuration.*"})
@AutoService(value={Processor.class})
public class OptionAnnotationProcessor
extends AbstractProcessor {
    private static final ImmutableSet<Class<? extends Annotation>> KNOWN_OPTION_DETAIL_ANNOTATIONS = ImmutableSet.of(ClassOption.class, FileOption.class, IntegerOption.class, TimeSpanOption.class);

    @Override
    public SourceVersion getSupportedSourceVersion() {
        return SourceVersion.latestSupported();
    }

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        Preconditions.checkNotNull(annotations);
        Preconditions.checkNotNull((Object)roundEnv);
        for (Class annotation : KNOWN_OPTION_DETAIL_ANNOTATIONS) {
            for (Element elem : roundEnv.getElementsAnnotatedWith(annotation)) {
                if (elem.getAnnotation(annotation) == null) continue;
                this.processOptionDetailAnnotation(elem, annotation);
            }
        }
        for (Element elem : roundEnv.getElementsAnnotatedWith(Options.class)) {
            if (elem.getAnnotation(Options.class) == null) continue;
            this.processOptions(elem);
        }
        for (Element elem : roundEnv.getElementsAnnotatedWith(Option.class)) {
            if (elem.getAnnotation(Option.class) == null) continue;
            this.processOption(elem);
            this.checkOptionDetailAnnotations(elem);
        }
        return false;
    }

    private void processOptionDetailAnnotation(Element elem, Class<? extends Annotation> annotation) {
        if (elem.getAnnotation(Option.class) == null) {
            this.message(Diagnostic.Kind.ERROR, elem, annotation, "Option-detail annotation @" + annotation.getSimpleName() + " is not valid without an @Option annotation at the same element.");
        }
    }

    private void processOptions(Element elem) {
        if (elem.getKind() != ElementKind.CLASS) {
            this.message(Diagnostic.Kind.ERROR, elem, Options.class, "@Options annotation can only be used on classes.");
            return;
        }
        TypeElement element = (TypeElement)elem;
        if (!element.getModifiers().contains((Object)Modifier.PRIVATE)) {
            List<ExecutableElement> constructors = ElementFilter.constructorsIn(element.getEnclosedElements());
            for (ExecutableElement constructor : constructors) {
                boolean foundConfigurationParameter;
                if (constructor.getModifiers().contains((Object)Modifier.PRIVATE) || constructor.getParameters().isEmpty() && constructors.size() == 1 || (foundConfigurationParameter = constructor.getParameters().stream().anyMatch(param -> OptionAnnotationProcessor.typeToString(param.asType()).equals(Configuration.class.getName()))) || !OptionAnnotationProcessor.warningsEnabled(constructor)) continue;
                this.message(Diagnostic.Kind.WARNING, constructor, "Constructor does not receive Configuration instance and may not be able to inject configuration options of this class.");
            }
        }
        boolean foundOption = false;
        TypeElement currentClass = element;
        do {
            if (!this.hasChildWithAnnotation(currentClass, Option.class)) continue;
            foundOption = true;
            break;
        } while ((currentClass = (TypeElement)((DeclaredType)currentClass.getSuperclass()).asElement()).getSuperclass().getKind() != TypeKind.NONE);
        if (!foundOption && OptionAnnotationProcessor.warningsEnabled(element)) {
            this.message(Diagnostic.Kind.WARNING, (Element)element, Options.class, "@Options annotation on class without @Option fields or methods is useless.");
        }
    }

    private void processOption(Element elem) {
        Option option = elem.getAnnotation(Option.class);
        Element cls = elem.getEnclosingElement();
        if (cls.getAnnotation(Options.class) == null) {
            this.message(Diagnostic.Kind.ERROR, elem, Option.class, "Annotation @Option is meaningless in class that does not use configuration-option injection. Add @Options to surrounding class and call Configuration.inject(Object) in constructor.");
        }
        switch (elem.getKind()) {
            case FIELD: {
                if (!elem.getModifiers().contains((Object)Modifier.FINAL)) break;
                this.message(Diagnostic.Kind.ERROR, elem, "Modifier final on field annotated with @Option is illegal, as it will be written via reflection.");
                break;
            }
            case METHOD: {
                ExecutableElement method = (ExecutableElement)elem;
                if (method.getParameters().size() != 1) {
                    this.message(Diagnostic.Kind.ERROR, method, "Methods annotated with @Option need to have exactly one parameter.");
                }
                for (TypeMirror typeMirror : method.getThrownTypes()) {
                    boolean allowedException = OptionAnnotationProcessor.isSubtypeOf(typeMirror, RuntimeException.class.getName()) || OptionAnnotationProcessor.isSubtypeOf(typeMirror, Error.class.getName()) || OptionAnnotationProcessor.isSubtypeOf(typeMirror, InvalidConfigurationException.class.getName());
                    if (allowedException) continue;
                    this.message(Diagnostic.Kind.ERROR, method, "Methods annotated with @Option may not throw " + typeMirror + ".");
                }
                break;
            }
            default: {
                this.message(Diagnostic.Kind.ERROR, elem, Option.class, "Annotation @Option is only allowed for fields and methods.");
            }
        }
        if (elem.getModifiers().contains((Object)Modifier.STATIC)) {
            this.message(Diagnostic.Kind.ERROR, elem, "Annotation @Option is not allowed for static members.");
        }
        if (option.description().isEmpty() && OptionAnnotationProcessor.warningsEnabled(elem)) {
            AnnotationMirror optionAnnotation = this.findAnnotationMirror(Option.class, elem).get();
            AnnotationValue value = OptionAnnotationProcessor.findAnnotationValue(Option.class, "description", optionAnnotation).orElse(null);
            this.message(Diagnostic.Kind.WARNING, elem, optionAnnotation, value, "@Option annotation should not have empty description.");
        }
    }

    private void checkOptionDetailAnnotations(Element elem) {
        ArrayList<CallSite> usedDetailAnnotations = new ArrayList<CallSite>(2);
        block4: for (AnnotationMirror annotationMirror : elem.getAnnotationMirrors()) {
            List<? extends TypeMirror> params;
            TypeMirror optionType;
            Element annotation = annotationMirror.getAnnotationType().asElement();
            Optional<? extends AnnotationMirror> optionDetailAnnotation = this.findAnnotationMirror(OptionDetailAnnotation.class, annotation);
            if (!optionDetailAnnotation.isPresent()) continue;
            String annotationName = "@" + annotation.getSimpleName();
            usedDetailAnnotations.add((CallSite)((Object)annotationName));
            switch (elem.getKind()) {
                case FIELD: {
                    optionType = elem.asType();
                    break;
                }
                case METHOD: {
                    ExecutableElement method = (ExecutableElement)elem;
                    if (method.getParameters().size() != 1) continue block4;
                    optionType = method.getParameters().get(0).asType();
                    break;
                }
                default: {
                    continue block4;
                }
            }
            boolean isArray = false;
            boolean isCollection = false;
            if (optionType.getKind() == TypeKind.ARRAY) {
                isArray = true;
                optionType = ((ArrayType)optionType).getComponentType();
            } else {
                String rawTypeName = this.getRawTypeName(optionType);
                for (Class collectionClass : Configuration.COLLECTIONS.keySet()) {
                    List<? extends TypeMirror> params2;
                    if (!rawTypeName.equals(collectionClass.getName()) || (params2 = ((DeclaredType)optionType).getTypeArguments()).size() != 1) continue;
                    isCollection = true;
                    optionType = params2.get(0);
                    break;
                }
            }
            String optionTypeName = this.getRawTypeName(optionType);
            if (optionTypeName.equals(AnnotatedValue.class.getName()) && (params = ((DeclaredType)optionType).getTypeArguments()).size() == 1) {
                optionType = params.get(0);
                optionTypeName = this.getRawTypeName(optionType);
            }
            Iterable acceptedClasses = (Iterable)OptionAnnotationProcessor.findAnnotationValue(OptionDetailAnnotation.class, "applicableTo", optionDetailAnnotation.get()).get().getValue();
            boolean foundMatchingType = false;
            HashSet<String> acceptedTypeNames = new HashSet<String>();
            for (Object listEntry : acceptedClasses) {
                String acceptedType = OptionAnnotationProcessor.typeToString((DeclaredType)((AnnotationValue)listEntry).getValue());
                acceptedTypeNames.add(acceptedType);
                if (!optionTypeName.equals(acceptedType)) continue;
                foundMatchingType = true;
                break;
            }
            if (Iterables.isEmpty((Iterable)acceptedClasses) || foundMatchingType) continue;
            String msgPrefix = isArray ? "Array option with incompatible element type" : (isCollection ? "Option of collection type with incompatible element type" : "Option with incompatible type");
            this.message(Diagnostic.Kind.ERROR, elem, annotationMirror, String.format("%s %s for annotation %s, this annotation is only for types %s.", msgPrefix, optionType, annotationName, Joiner.on((String)", ").join(acceptedTypeNames)));
        }
        if (usedDetailAnnotations.size() > 1) {
            this.message(Diagnostic.Kind.ERROR, elem, "Elements annotated with @Option might have at most one additional option-detail annotation, but this element has the following annotations: " + Joiner.on((String)", ").join(usedDetailAnnotations) + ".");
        }
    }

    private static boolean isSubtypeOf(@Var TypeMirror type, String superType) {
        Preconditions.checkArgument((boolean)(type instanceof DeclaredType));
        Preconditions.checkNotNull((Object)superType);
        do {
            if (!OptionAnnotationProcessor.typeToString(type).equals(superType)) continue;
            return true;
        } while ((type = ((TypeElement)((DeclaredType)type).asElement()).getSuperclass()).getKind() != TypeKind.NONE);
        return false;
    }

    private static String typeToString(TypeMirror type) {
        if (type.getKind() == TypeKind.DECLARED) {
            return ((TypeElement)((DeclaredType)type).asElement()).getQualifiedName().toString();
        }
        return type.toString();
    }

    private static boolean warningsEnabled(@Var Element element) {
        do {
            List<String> values;
            SuppressWarnings suppress;
            if ((suppress = element.getAnnotation(SuppressWarnings.class)) == null || !(values = Arrays.asList(suppress.value())).contains("all") && !values.contains("options")) continue;
            return false;
        } while ((element = element.getEnclosingElement()) != null);
        return true;
    }

    private boolean hasChildWithAnnotation(Element element, Class<? extends Annotation> annotation) {
        return element.getEnclosedElements().stream().anyMatch(child -> child.getAnnotation(annotation) != null);
    }

    private Optional<? extends AnnotationMirror> findAnnotationMirror(Class<? extends Annotation> annotation, Element elem) {
        String annotationName = annotation.getName();
        return elem.getAnnotationMirrors().stream().filter(am -> am.getAnnotationType().toString().equals(annotationName)).findFirst();
    }

    private static Optional<? extends AnnotationValue> findAnnotationValue(Class<? extends Annotation> annotationClass, String fieldName, AnnotationMirror annotation) {
        Preconditions.checkArgument((boolean)annotation.getAnnotationType().toString().equals(annotationClass.getName()));
        try {
            Method method = annotationClass.getDeclaredMethod((String)Preconditions.checkNotNull((Object)fieldName), new Class[0]);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalArgumentException(e);
        }
        return annotation.getElementValues().entrySet().stream().filter(entry -> ((ExecutableElement)entry.getKey()).getSimpleName().contentEquals(fieldName)).map(Map.Entry::getValue).findFirst();
    }

    private String getRawTypeName(TypeMirror t) {
        String typeName;
        int i;
        TypeMirror type = this.typeUtils().erasure(t);
        if (type.getKind().isPrimitive()) {
            type = this.typeUtils().boxedClass((PrimitiveType)type).asType();
        }
        if ((i = (typeName = OptionAnnotationProcessor.typeToString(type)).indexOf(60)) > 0) {
            typeName = typeName.substring(0, i);
        }
        return typeName;
    }

    @Override
    public Iterable<? extends Completion> getCompletions(@Nullable Element element, @Nullable AnnotationMirror annotation, @Nullable ExecutableElement field, @Nullable String userText) {
        if (element == null || annotation == null || field == null) {
            return super.getCompletions(element, annotation, field, userText);
        }
        if (annotation.getAnnotationType().toString().equals(ClassOption.class.getName()) && field.getSimpleName().contentEquals("packagePrefix")) {
            return this.returnPackagePrefixCompletions(element, Strings.nullToEmpty((String)userText));
        }
        return super.getCompletions(element, annotation, field, userText);
    }

    private List<? extends Completion> returnPackagePrefixCompletions(Element element, String userText) {
        ArrayList<Completion> packages = new ArrayList<Completion>();
        PackageElement pkg = this.elementUtils().getPackageOf(element);
        if (!pkg.isUnnamed()) {
            String name = pkg.getQualifiedName().toString();
            while (name.startsWith(userText)) {
                packages.add(Completions.of(name));
                int pos = name.lastIndexOf(46);
                if (!(name = name.substring(0, Math.max(pos, 0))).isEmpty()) continue;
            }
        }
        return packages;
    }

    private Elements elementUtils() {
        return this.processingEnv.getElementUtils();
    }

    private Types typeUtils() {
        return this.processingEnv.getTypeUtils();
    }

    private void message(Diagnostic.Kind level, Element elem, String message) {
        this.processingEnv.getMessager().printMessage(level, message, elem);
    }

    private void message(Diagnostic.Kind level, Element elem, Class<? extends Annotation> annotation, String message) {
        this.message(level, elem, (AnnotationMirror)this.findAnnotationMirror(annotation, elem).orElse(null), message);
    }

    private void message(Diagnostic.Kind level, Element elem, AnnotationMirror annotationMirror, String message) {
        this.processingEnv.getMessager().printMessage(level, message, elem, annotationMirror);
    }

    private void message(Diagnostic.Kind level, Element elem, AnnotationMirror annotation, AnnotationValue value, String message) {
        this.processingEnv.getMessager().printMessage(level, message, elem, annotation, value);
    }
}

