/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.common.configuration.converters;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.CharMatcher;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.base.StandardSystemProperty;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableSet;
import com.google.common.reflect.TypeToken;
import com.google.errorprone.annotations.Var;
import java.io.File;
import java.io.FileNotFoundException;
import java.lang.annotation.Annotation;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Iterator;
import java.util.Objects;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.FileOption;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.configuration.Option;
import org.sosy_lab.common.configuration.Options;
import org.sosy_lab.common.configuration.converters.TypeConverter;
import org.sosy_lab.common.io.IO;
import org.sosy_lab.common.io.PathCounterTemplate;
import org.sosy_lab.common.io.PathTemplate;
import org.sosy_lab.common.log.LogManager;

@Options
public final class FileTypeConverter
implements TypeConverter {
    private static final ImmutableSet<Class<?>> SUPPORTED_TYPES = ImmutableSet.of(File.class, Path.class, PathTemplate.class, PathCounterTemplate.class);
    private static final String TEMP_DIR = FileTypeConverter.stripTrailingSeparator((String)Preconditions.checkNotNull((Object)StandardSystemProperty.JAVA_IO_TMPDIR.value())) + File.separator;
    @Option(secure=true, name="output.path", description="directory to put all output files in")
    private String outputDirectory = "output/";
    @VisibleForTesting
    final Path outputPath;
    @Option(secure=true, name="output.disable", description="disable all default output files\n(any explicitly given file will still be written)")
    private boolean disableOutput = false;
    @Option(description="base directory for all paths in default values")
    private String rootDirectory = ".";
    @VisibleForTesting
    final Path rootPath;
    @VisibleForTesting
    final boolean safePathsOnly;

    private FileTypeConverter(Configuration config, boolean pSafePathsOnly) throws InvalidConfigurationException {
        this.safePathsOnly = pSafePathsOnly;
        config.inject(this, FileTypeConverter.class);
        this.rootPath = this.checkSafePath(Path.of(this.rootDirectory, new String[0]), "rootDirectory");
        this.outputPath = this.checkSafePath(this.rootPath.resolve(this.outputDirectory), "output.path");
    }

    private FileTypeConverter(Configuration config, FileTypeConverter defaultsInstance) throws InvalidConfigurationException {
        this.safePathsOnly = defaultsInstance.safePathsOnly;
        config.injectWithDefaults(this, FileTypeConverter.class, defaultsInstance);
        this.rootPath = this.checkSafePath(Path.of(this.rootDirectory, new String[0]), "rootDirectory");
        this.outputPath = this.checkSafePath(this.rootPath.resolve(this.outputDirectory), "output.path");
    }

    public static FileTypeConverter create(Configuration config) throws InvalidConfigurationException {
        return new FileTypeConverter(config, false);
    }

    public static FileTypeConverter createWithSafePathsOnly(Configuration config) throws InvalidConfigurationException {
        return new FileTypeConverter(config, true);
    }

    @Override
    public FileTypeConverter getInstanceForNewConfiguration(Configuration pNewConfiguration) throws InvalidConfigurationException {
        return new FileTypeConverter(pNewConfiguration, this);
    }

    @VisibleForTesting
    Path checkSafePath(Path pPath, String optionName) throws InvalidConfigurationException {
        if (!this.safePathsOnly) {
            return pPath;
        }
        String path = pPath.toString();
        if (pPath.isAbsolute()) {
            if (pPath.startsWith(TEMP_DIR)) {
                path = path.substring(TEMP_DIR.length());
            } else {
                throw FileTypeConverter.forbidden("because it is absolute", optionName, pPath, new Object[0]);
            }
        }
        if (path.contains(File.pathSeparator)) {
            throw FileTypeConverter.forbidden("because it contains the character '%s'", optionName, pPath, File.pathSeparator);
        }
        int depth = 0;
        Iterator iterator = Splitter.on((String)File.separator).split((CharSequence)path).iterator();
        while (iterator.hasNext()) {
            String component;
            switch (component = (String)iterator.next()) {
                case "": 
                case ".": {
                    break;
                }
                case "..": {
                    --depth;
                    break;
                }
                default: {
                    ++depth;
                }
            }
            if (depth >= 0) continue;
            throw FileTypeConverter.forbidden("because it is not below the current directory", optionName, pPath, new Object[0]);
        }
        return pPath;
    }

    private static InvalidConfigurationException forbidden(String reason, String optionName, Path path, Object ... args) throws InvalidConfigurationException {
        throw new InvalidConfigurationException(String.format("The option %s specifies the path '%s' that is forbidden in safe mode " + reason + ".", FluentIterable.of((Object)optionName, (Object[])new Object[]{path}).append(args).toArray(Object.class)));
    }

    public String getOutputDirectory() {
        return this.outputPath.toString();
    }

    public Path getOutputPath() {
        return this.outputPath;
    }

    private static void checkApplicability(Class<?> type, @Nullable Annotation secondaryOption, String optionName) {
        if (!SUPPORTED_TYPES.contains(type) || !(secondaryOption instanceof FileOption)) {
            throw new UnsupportedOperationException("A FileTypeConverter can handle only options of type File and with a @FileOption annotation, but " + optionName + " does not fit.");
        }
    }

    @Override
    public @Nullable Object convert(String optionName, String pValue, TypeToken<?> pType, Annotation secondaryOption, Path pSource, LogManager logger) throws InvalidConfigurationException {
        Path path;
        Class type = pType.getRawType();
        FileTypeConverter.checkApplicability(type, secondaryOption, optionName);
        assert (secondaryOption != null) : "checkApplicability should ensure this";
        try {
            path = Path.of(pValue, new String[0]);
        }
        catch (InvalidPathException e) {
            throw new InvalidConfigurationException(String.format("Invalid file name in option %s: %s", optionName, e.getMessage()), e);
        }
        return this.handleFileOption(optionName, path, ((FileOption)secondaryOption).value(), type, Objects.requireNonNullElse(pSource, Path.of("", new String[0])), true);
    }

    @Override
    public <T> @Nullable T convertDefaultValue(String optionName, T pDefaultValue, TypeToken<T> pType, Annotation secondaryOption) throws InvalidConfigurationException {
        return this.convertDefaultValue(optionName, pDefaultValue, pType, secondaryOption, true);
    }

    private <T> @Nullable T convertDefaultValue(String optionName, T pDefaultValue, TypeToken<T> pType, Annotation secondaryOption, boolean doResolve) throws InvalidConfigurationException {
        Class type = pType.getRawType();
        FileTypeConverter.checkApplicability(type, secondaryOption, optionName);
        assert (secondaryOption != null) : "checkApplicability should ensure this";
        FileOption.Type typeInfo = ((FileOption)secondaryOption).value();
        if (pDefaultValue == null) {
            if (typeInfo == FileOption.Type.REQUIRED_INPUT_FILE) {
                throw new UnsupportedOperationException("The option " + optionName + " specifies a required input file, but the option is neither required nor has a default value.");
            }
            return null;
        }
        if (this.disableOutput && FileTypeConverter.isOutputOption(typeInfo)) {
            return null;
        }
        Path defaultValue = type.equals(File.class) ? ((File)pDefaultValue).toPath() : (type.equals(PathTemplate.class) ? Path.of(((PathTemplate)pDefaultValue).getTemplate(), new String[0]) : (type.equals(PathCounterTemplate.class) ? Path.of(((PathCounterTemplate)pDefaultValue).getTemplate(), new String[0]) : (Path)pDefaultValue));
        Object value = this.handleFileOption(optionName, defaultValue, typeInfo, type, null, doResolve);
        return (T)value;
    }

    @Override
    public <T> @Nullable T convertDefaultValueFromOtherInstance(String optionName, @Nullable T pDefaultValue, TypeToken<T> pType, @Nullable Annotation secondaryOption) throws InvalidConfigurationException {
        return this.convertDefaultValue(optionName, pDefaultValue, pType, secondaryOption, false);
    }

    private Object handleFileOption(String optionName, @Var Path file, FileOption.Type typeInfo, Class<?> targetType, @Nullable Path source, boolean doResolve) throws InvalidConfigurationException {
        if (doResolve) {
            file = FileTypeConverter.isOutputOption(typeInfo) ? this.outputPath.resolve(file) : (source != null ? source.resolveSibling(file) : this.rootPath.resolve(file));
        }
        this.checkSafePath(file, optionName);
        if (typeInfo == FileOption.Type.OUTPUT_DIRECTORY) {
            if (Files.isRegularFile(file, new LinkOption[0])) {
                throw new InvalidConfigurationException("Option " + optionName + " specifies a file instead of a directory: " + file);
            }
        } else if (Files.isDirectory(file, new LinkOption[0])) {
            throw new InvalidConfigurationException("Option " + optionName + " specifies a directory instead of a file: " + file);
        }
        if (typeInfo == FileOption.Type.REQUIRED_INPUT_FILE) {
            try {
                IO.checkReadableFile(file);
            }
            catch (FileNotFoundException e) {
                throw new InvalidConfigurationException("Option " + optionName + " specifies an invalid input file: " + e.getMessage(), e);
            }
        }
        if (targetType.equals(File.class)) {
            return file.toFile();
        }
        if (targetType.equals(PathTemplate.class)) {
            return PathTemplate.ofFormatString(file.toString());
        }
        if (targetType.equals(PathCounterTemplate.class)) {
            return PathCounterTemplate.ofFormatString(file.toString());
        }
        assert (targetType.equals(Path.class));
        return file;
    }

    private static boolean isOutputOption(FileOption.Type typeInfo) {
        return typeInfo == FileOption.Type.OUTPUT_FILE || typeInfo == FileOption.Type.OUTPUT_DIRECTORY;
    }

    static String stripTrailingSeparator(String input) {
        Preconditions.checkArgument((!input.equals(File.separator) ? 1 : 0) != 0, (Object)"result would be empty");
        return CharMatcher.is((char)File.separatorChar).trimTrailingFrom((CharSequence)input);
    }
}

