/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.common.log;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicates;
import com.google.common.base.Strings;
import com.google.common.io.CharStreams;
import com.google.common.io.MoreFiles;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.file.AccessDeniedException;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.FileSystemException;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Formatter;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.function.Supplier;
import java.util.logging.ConsoleHandler;
import java.util.logging.FileHandler;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.sosy_lab.common.AbstractMBean;
import org.sosy_lab.common.Appender;
import org.sosy_lab.common.Appenders;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.log.ConsoleLogFormatter;
import org.sosy_lab.common.log.ExtendedLogRecord;
import org.sosy_lab.common.log.LogLevelFilter;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.common.log.LoggingOptions;
import org.sosy_lab.common.log.TimestampedLogFormatter;

public class BasicLogManager
implements LogManager,
AutoCloseable {
    @VisibleForTesting
    static final int TRUNCATE_REMAINING_SIZE = 100;
    private static final Level EXCEPTION_DEBUG_LEVEL = Level.ALL;
    private static final Joiner MESSAGE_FORMAT = Joiner.on((char)' ').useForNull("null");
    private final Logger logger;
    private final int truncateSize;
    private @Nullable LogManagerBean mxBean = null;
    private final String componentName;
    private static final String CONFIGURATION_PACKAGE_NAME = Configuration.class.getPackage().getName();

    private static void appendTruncationMessage(StringBuilder sb, String len) {
        sb.append("... <REMAINING ARGUMENT OMITTED BECAUSE ").append(len).append(" CHARACTERS LONG>");
    }

    public BasicLogManager(Logger pLogger) {
        this(pLogger, 0);
    }

    public BasicLogManager(Logger pLogger, int pTruncateSize) {
        this.logger = (Logger)Preconditions.checkNotNull((Object)pLogger);
        this.componentName = "";
        if (pTruncateSize >= 100) {
            this.truncateSize = pTruncateSize;
        } else if (pTruncateSize > 0) {
            this.truncateSize = 100;
        } else if (pTruncateSize == 0) {
            this.truncateSize = 0;
        } else {
            throw new IllegalArgumentException("Negative truncateSize not allowed.");
        }
    }

    public static LogManager createWithHandler(Handler handler) {
        return BasicLogManager.createWithHandler(handler, 0);
    }

    @VisibleForTesting
    static LogManager createWithHandler(Handler handler, int truncateSize) {
        Logger logger = Logger.getAnonymousLogger();
        logger.setLevel(handler.getLevel());
        logger.setUseParentHandlers(false);
        logger.addHandler(handler);
        return new BasicLogManager(logger, truncateSize);
    }

    public static LogManager create(Configuration config) throws InvalidConfigurationException {
        return BasicLogManager.create(new LoggingOptions(config));
    }

    public static LogManager create(LoggingOptions options) {
        Level fileLevel = options.getFileLevel();
        Level consoleLevel = options.getConsoleLevel();
        Logger logger = Logger.getAnonymousLogger();
        logger.setLevel(BasicLogManager.getMinimumLevel(fileLevel, consoleLevel));
        logger.setUseParentHandlers(false);
        ConsoleHandler consoleOutputHandler = new ConsoleHandler();
        BasicLogManager.setupHandler(logger, consoleOutputHandler, new ConsoleLogFormatter(options), consoleLevel, options.getConsoleExclude());
        Path outputFile = options.getOutputFile();
        if (!fileLevel.equals(Level.OFF) && outputFile != null) {
            try {
                MoreFiles.createParentDirectories((Path)outputFile, (FileAttribute[])new FileAttribute[0]);
                FileHandler outfileHandler = new FileHandler(outputFile.toAbsolutePath().toString(), false);
                BasicLogManager.setupHandler(logger, outfileHandler, TimestampedLogFormatter.withoutColors(), fileLevel, options.getFileExclude());
            }
            catch (IOException e) {
                if (consoleLevel.intValue() > fileLevel.intValue()) {
                    consoleOutputHandler.setLevel(fileLevel);
                }
                logger.log(Level.WARNING, "Could not open log file (" + e.getMessage() + "), redirecting log output to console");
            }
        }
        BasicLogManager logManager = new BasicLogManager(logger, options.getTruncateSize());
        logManager.addMxBean(consoleOutputHandler, fileLevel);
        return logManager;
    }

    private static void setupHandler(Logger logger, Handler handler, java.util.logging.Formatter formatter, Level level, List<Level> excludeLevels) {
        if (!excludeLevels.isEmpty()) {
            handler.setFilter(new LogLevelFilter(excludeLevels));
        } else {
            handler.setFilter(null);
        }
        handler.setFormatter(formatter);
        handler.setLevel(level);
        logger.addHandler(handler);
    }

    private void addMxBean(Handler pConsoleHandler, Level pFileLevel) {
        Preconditions.checkState((this.mxBean == null ? 1 : 0) != 0);
        try {
            this.mxBean = new LogManagerBean(pConsoleHandler, pFileLevel);
            this.mxBean.register();
        }
        catch (NoClassDefFoundError e) {
            this.logUserException(Level.WARNING, e, "Error during registration of management interface for logger");
        }
    }

    private BasicLogManager(BasicLogManager originalLogger, String pComponentName) {
        this.logger = originalLogger.logger;
        this.truncateSize = originalLogger.truncateSize;
        this.componentName = pComponentName;
    }

    @Override
    public LogManager withComponentName(String pName) {
        Preconditions.checkArgument((!pName.isEmpty() ? 1 : 0) != 0);
        String name = this.componentName.isEmpty() ? pName : this.componentName + ":" + pName;
        return new BasicLogManager(this, name);
    }

    @Override
    public boolean wouldBeLogged(Level priority) {
        return this.logger.isLoggable(priority);
    }

    @Override
    public void log(Level priority, Object ... args) {
        BasicLogManager.checkBuildAdditionalMessageParams(args);
        if (this.wouldBeLogged(priority)) {
            this.log0(priority, BasicLogManager.findCallingMethod(), this.buildAdditionalMessageText(args));
        }
    }

    @Override
    public void log(Level priority, Supplier<String> msgSupplier) {
        Preconditions.checkNotNull(msgSupplier);
        if (this.wouldBeLogged(priority)) {
            this.log0(priority, BasicLogManager.findCallingMethod(), msgSupplier.get());
        }
    }

    @Override
    public void logf(Level priority, String format, Object ... args) {
        BasicLogManager.checkFormatStringParameters(format, args);
        if (this.wouldBeLogged(priority)) {
            this.log0(priority, BasicLogManager.findCallingMethod(), this.formatAdditionalMessage(format, args));
        }
    }

    private String formatAdditionalMessage(String format, Object ... args) {
        BasicLogManager.checkFormatStringParameters(format, args);
        Formatter formatter = new Formatter(this.truncateSize > 0 ? new LimitingStringBuilderAppendable(this.truncateSize) : new StringBuilder());
        return formatter.format(format, args).toString();
    }

    private static void checkFormatStringParameters(String format, Object ... args) {
        Preconditions.checkNotNull((Object)format);
        Preconditions.checkNotNull((Object)args);
    }

    private String buildAdditionalMessageText(Object ... args) {
        BasicLogManager.checkBuildAdditionalMessageParams(args);
        Object[] argsStr = new String[args.length];
        for (int i = 0; i < args.length; ++i) {
            String o = Objects.requireNonNullElse(args[i], "null");
            String arg = o instanceof Appender && this.truncateSize > 0 ? Appenders.toStringWithTruncation((Appender)((Object)o), this.truncateSize + 1) : o.toString();
            arg = Objects.requireNonNullElse(arg, "null");
            if (this.truncateSize > 0 && arg.length() > this.truncateSize) {
                Object length = o instanceof Appender ? ">= " + this.truncateSize : Integer.toString(arg.length());
                StringBuilder sb = new StringBuilder(170);
                sb.append(arg.substring(0, 100));
                BasicLogManager.appendTruncationMessage(sb, (String)length);
                argsStr[i] = sb.toString();
                continue;
            }
            argsStr[i] = arg;
        }
        String messageText = MESSAGE_FORMAT.join(argsStr);
        return messageText;
    }

    private static void checkBuildAdditionalMessageParams(Object ... args) {
        Preconditions.checkNotNull((Object)args);
    }

    private static @Nullable StackTraceElement findCallingMethod() {
        return StackWalker.getInstance().walk(stack -> stack.skip(2L).filter(BasicLogManager::isRelevantMethod).findFirst()).map(StackWalker.StackFrame::toStackTraceElement).orElse(null);
    }

    private static boolean isRelevantMethod(StackWalker.StackFrame frame) {
        String methodname = frame.getMethodName();
        return !methodname.startsWith("log") && !methodname.startsWith("access$") && !methodname.startsWith("lambda$log");
    }

    @VisibleForTesting
    void log0(Level priority, @Nullable StackTraceElement stackElement, @Nullable String msg) {
        ExtendedLogRecord record = new ExtendedLogRecord(priority, msg);
        if (stackElement != null) {
            record.setSourceClassName(stackElement.getClassName());
            record.setSourceMethodName(stackElement.getMethodName());
        } else {
            record.setSourceClassName(null);
            record.setSourceMethodName(null);
        }
        record.setSourceComponentName(this.componentName);
        this.logger.log(record);
    }

    @Override
    public void logUserException(Level priority, Throwable e, @Nullable String pAdditionalMessage) {
        Preconditions.checkNotNull((Object)e);
        Supplier<String> additinalMessageSupplier = () -> Strings.nullToEmpty((String)pAdditionalMessage);
        this.log0UserException(priority, e, additinalMessageSupplier);
    }

    @Override
    public void logfUserException(Level priority, Throwable e, String format, Object ... args) {
        Preconditions.checkNotNull((Object)e);
        BasicLogManager.checkFormatStringParameters(format, args);
        Supplier<String> additionalMessageSupplier = () -> this.formatAdditionalMessage(format, args);
        this.log0UserException(priority, e, additionalMessageSupplier);
    }

    private void log0UserException(Level priority, Throwable e, Supplier<String> additionalMessageSupplier) {
        if (this.wouldBeLogged(priority) || this.wouldBeLogged(EXCEPTION_DEBUG_LEVEL)) {
            String additionalMessage = additionalMessageSupplier.get();
            if (this.wouldBeLogged(priority)) {
                StringBuilder logMessage = BasicLogManager.buildUserExceptionLogMessage(priority, e, Strings.nullToEmpty((String)additionalMessage));
                @Nullable StackTraceElement frame = BasicLogManager.locateStackTraceElement(e);
                this.log0(priority, frame, logMessage.toString());
            }
            this.logDebugException(e, additionalMessage);
        }
    }

    private static StringBuilder buildUserExceptionLogMessage(Level priority, Throwable e, String additionalMessage) {
        String exceptionMessage;
        StringBuilder logMessage = new StringBuilder();
        if (priority.equals(Level.SEVERE)) {
            logMessage.append("Error: ");
        } else if (priority.equals(Level.WARNING)) {
            logMessage.append("Warning: ");
        }
        CharSequence charSequence = exceptionMessage = e instanceof FileSystemException ? BasicLogManager.createFileSystemExceptionMessage((FileSystemException)e, additionalMessage.endsWith("file")) : Strings.nullToEmpty((String)e.getMessage());
        if (additionalMessage.isEmpty()) {
            if (exceptionMessage.length() > 0) {
                logMessage.append((CharSequence)exceptionMessage);
            } else {
                logMessage.append(e.getClass().getSimpleName()).append(" in ").append(e.getStackTrace()[0]);
            }
        } else {
            logMessage.append(additionalMessage);
            if (exceptionMessage.length() > 0) {
                if (e instanceof IOException && additionalMessage.endsWith("file") && exceptionMessage.charAt(exceptionMessage.length() - 1) == ')') {
                    logMessage.append(' ').append((CharSequence)exceptionMessage);
                } else {
                    logMessage.append(" (").append((CharSequence)exceptionMessage).append(')');
                }
            }
        }
        return logMessage;
    }

    private static CharSequence createFileSystemExceptionMessage(FileSystemException fse, boolean asSuffix) {
        @Nullable String file = Strings.emptyToNull((String)fse.getFile());
        @Nullable String otherFile = Strings.emptyToNull((String)fse.getOtherFile());
        if (file == null && otherFile != null) {
            file = otherFile;
            otherFile = null;
        } else if (file != null && file.equals(otherFile)) {
            otherFile = null;
        }
        StringBuilder msg = new StringBuilder();
        if (asSuffix) {
            if (file != null) {
                msg.append(file);
            }
            msg.append(" (").append(BasicLogManager.getReasonForFileSystemException(fse));
            if (otherFile != null) {
                msg.append(": ").append(otherFile);
            }
            msg.append(")");
        } else {
            msg.append(BasicLogManager.getReasonForFileSystemException(fse));
            if (file != null) {
                msg.append(": ").append(file);
                if (otherFile != null) {
                    msg.append(" -> ").append(otherFile);
                }
            }
        }
        return msg;
    }

    private static String getReasonForFileSystemException(FileSystemException fse) {
        @Nullable String reason = fse.getReason();
        if (!Strings.isNullOrEmpty((String)reason)) {
            return reason;
        }
        if (fse instanceof AccessDeniedException) {
            return "Permission denied";
        }
        if (fse instanceof NoSuchFileException) {
            return "No such file or directory";
        }
        if (fse instanceof FileAlreadyExistsException) {
            return "File already exists";
        }
        if (fse.getClass() != FileSystemException.class) {
            return fse.getClass().getSimpleName();
        }
        return "Unknown file-system error";
    }

    private static @Nullable StackTraceElement locateStackTraceElement(Throwable e) {
        Object isRelevant = e instanceof InvalidConfigurationException ? f -> !f.getClassName().startsWith(CONFIGURATION_PACKAGE_NAME) : (e instanceof IOException ? f -> !f.getClassName().equals("sun.nio.fs.UnixException") : Predicates.alwaysTrue());
        for (StackTraceElement frame : e.getStackTrace()) {
            if (!isRelevant.test(frame)) continue;
            return frame;
        }
        return null;
    }

    @Override
    public void logDebugException(Throwable pE, @Nullable String pAdditionalMessage) {
        this.logException(EXCEPTION_DEBUG_LEVEL, pE, pAdditionalMessage);
    }

    @Override
    public void logDebugException(Throwable e) {
        this.logException(EXCEPTION_DEBUG_LEVEL, e, null);
    }

    @Override
    public void logfDebugException(Throwable e, String format, Object ... args) {
        this.logfException(EXCEPTION_DEBUG_LEVEL, e, format, args);
    }

    @Override
    public void logException(Level pPriority, Throwable pE, @Nullable String pAdditionalMessage) {
        Preconditions.checkNotNull((Object)pE);
        Supplier<String> additionalMessageSupplier = () -> Strings.emptyToNull((String)pAdditionalMessage);
        this.log0Exception(pPriority, pE, additionalMessageSupplier);
    }

    @Override
    public void logfException(Level priority, Throwable e, String format, Object ... args) {
        Preconditions.checkNotNull((Object)e);
        BasicLogManager.checkFormatStringParameters(format, args);
        Supplier<String> additionalMessageSupplier = () -> this.formatAdditionalMessage(format, args);
        this.log0Exception(priority, e, additionalMessageSupplier);
    }

    private void log0Exception(Level priority, Throwable e, Supplier<String> additionalMessageSupplier) {
        if (this.wouldBeLogged(priority)) {
            String additionalMessage = additionalMessageSupplier.get();
            StringBuilder logMessage = BasicLogManager.buildExceptionLogMessage(e, additionalMessage);
            this.log0(priority, BasicLogManager.findCallingMethod(), logMessage.toString());
        }
    }

    private static StringBuilder buildExceptionLogMessage(Throwable e, String additionalMessage) {
        StringBuilder logMessage = new StringBuilder();
        if (!Strings.isNullOrEmpty((String)additionalMessage)) {
            logMessage.append(additionalMessage).append('\n');
        }
        logMessage.append("Exception in thread \"").append(Thread.currentThread().getName()).append("\" ");
        PrintWriter printWriterToLogMessage = new PrintWriter(CharStreams.asWriter((Appendable)logMessage));
        e.printStackTrace(printWriterToLogMessage);
        return logMessage;
    }

    @Override
    public void flush() {
        for (Handler handler : this.logger.getHandlers()) {
            handler.flush();
        }
    }

    @Override
    public void close() {
        if (this.mxBean != null) {
            this.mxBean.unregister();
        }
        for (Handler handler : this.logger.getHandlers()) {
            handler.close();
        }
    }

    private static Level getMinimumLevel(Level level1, Level level2) {
        if (level1.intValue() > level2.intValue()) {
            return level2;
        }
        return level1;
    }

    private static class LimitingStringBuilderAppendable
    implements Appendable {
        private final int truncateSize;
        private final StringBuilder sb = new StringBuilder();

        LimitingStringBuilderAppendable(int pTruncateSize) {
            this.truncateSize = pTruncateSize;
        }

        @Override
        public Appendable append(CharSequence pCsq, int pStart, int pEnd) throws IOException {
            int length = pEnd - pStart;
            if (length - this.truncateSize > 0) {
                this.sb.append(pCsq, pStart, pStart + 100);
                BasicLogManager.appendTruncationMessage(this.sb, Integer.toString(length));
            } else {
                this.sb.append(pCsq, pStart, pEnd);
            }
            return this;
        }

        @Override
        public Appendable append(char pC) throws IOException {
            this.sb.append(pC);
            return this;
        }

        @Override
        public Appendable append(CharSequence pCsq) throws IOException {
            int length = pCsq.length();
            if (length > this.truncateSize) {
                this.sb.append(pCsq, 0, 100);
                BasicLogManager.appendTruncationMessage(this.sb, Integer.toString(length));
            } else {
                this.sb.append(pCsq);
            }
            return this;
        }

        public String toString() {
            return this.sb.toString();
        }
    }

    private class LogManagerBean
    extends AbstractMBean
    implements LogManagerMXBean {
        private final Level fileLevel;
        private final Handler consoleHandler;

        private LogManagerBean(Handler pConsoleHandler, Level pFileLevel) {
            super("org.sosy_lab.common.log:type=LogManager", BasicLogManager.this);
            this.consoleHandler = (Handler)Preconditions.checkNotNull((Object)pConsoleHandler);
            this.fileLevel = (Level)Preconditions.checkNotNull((Object)pFileLevel);
        }

        @Override
        public String getConsoleLevel() {
            return this.consoleHandler.getLevel().toString();
        }

        @Override
        public void setConsoleLevel(String pNewLevel) {
            Level newLevel = Level.parse(pNewLevel.toUpperCase(Locale.US));
            this.consoleHandler.setLevel(newLevel);
            BasicLogManager.this.logger.setLevel(BasicLogManager.getMinimumLevel(this.fileLevel, newLevel));
        }
    }

    public static interface LogManagerMXBean {
        public String getConsoleLevel();

        public void setConsoleLevel(String var1);
    }
}

