/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.common.rationals;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.google.errorprone.annotations.Immutable;
import com.google.errorprone.annotations.InlineMe;
import com.google.errorprone.annotations.concurrent.LazyInit;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.sosy_lab.common.rationals.Rational;

@Immutable(containerOf={"T"})
public final class LinearExpression<T>
implements Iterable<Map.Entry<T, Rational>> {
    private final ImmutableMap<T, Rational> data;
    @LazyInit
    private transient int hashCache = 0;

    private LinearExpression(Map<T, Rational> data) {
        this.data = ImmutableMap.copyOf(data);
    }

    public static <T> LinearExpression<T> empty() {
        return new LinearExpression<T>(ImmutableMap.of());
    }

    @Deprecated
    @InlineMe(replacement="LinearExpression.monomial(var, coeff)", imports={"org.sosy_lab.common.rationals.LinearExpression"})
    public static <T> LinearExpression<T> pair(T var, Rational coeff) {
        return LinearExpression.monomial(var, coeff);
    }

    public static <T> LinearExpression<T> monomial(T var, Rational coeff) {
        if (coeff.equals(Rational.ZERO)) {
            return LinearExpression.empty();
        }
        return new LinearExpression<T>(ImmutableMap.of(var, (Object)coeff));
    }

    public static <T> LinearExpression<T> ofVariable(T var) {
        return LinearExpression.monomial(var, Rational.ONE);
    }

    public LinearExpression<T> add(LinearExpression<T> other) {
        Object var;
        ImmutableMap.Builder resultData = ImmutableMap.builder();
        for (Map.Entry e : this.data.entrySet()) {
            var = e.getKey();
            Rational value = (Rational)e.getValue();
            Rational otherValue = (Rational)other.data.get(var);
            if (otherValue != null) {
                value = value.plus(otherValue);
            }
            if (value.equals(Rational.ZERO)) continue;
            resultData.put(var, (Object)value);
        }
        for (Map.Entry e : other.data.entrySet()) {
            var = e.getKey();
            if (this.data.containsKey(var)) continue;
            resultData.put(e.getKey(), (Object)((Rational)e.getValue()));
        }
        return new LinearExpression<T>(resultData.build());
    }

    public LinearExpression<T> sub(LinearExpression<T> other) {
        return this.add(other.negate());
    }

    public LinearExpression<T> multByConst(Rational constant) {
        if (constant.equals(Rational.ZERO)) {
            return LinearExpression.empty();
        }
        return new LinearExpression<T>(Maps.transformValues(this.data, value -> value.times(constant)));
    }

    public LinearExpression<T> negate() {
        return this.multByConst(Rational.NEG_ONE);
    }

    public Rational getCoeff(T variable) {
        Preconditions.checkNotNull(variable);
        Rational out = (Rational)this.data.get(variable);
        if (out == null) {
            return Rational.ZERO;
        }
        return out;
    }

    public int size() {
        return this.data.size();
    }

    public boolean isEmpty() {
        return this.data.isEmpty();
    }

    public boolean isIntegral() {
        return this.data.values().stream().allMatch(Rational::isIntegral);
    }

    public Optional<Rational> divide(LinearExpression<T> other) {
        if (other.size() != this.data.size()) {
            return Optional.empty();
        }
        Rational multiplier = null;
        for (Object key : this.data.keySet()) {
            Rational div = other.getCoeff(key).divides((Rational)this.data.get(key)).reciprocal();
            if (multiplier == null) {
                multiplier = div;
                continue;
            }
            if (multiplier.equals(div)) continue;
            return Optional.empty();
        }
        assert (multiplier != null);
        return Optional.of(multiplier);
    }

    @Override
    public Iterator<Map.Entry<T, Rational>> iterator() {
        return this.data.entrySet().iterator();
    }

    public ImmutableMap<T, Rational> getMap() {
        return this.data;
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        this.data.forEach((var, coeff) -> LinearExpression.writeMonomial(var.toString(), coeff, b));
        return b.toString();
    }

    public static void writeMonomial(String varSerialized, Rational coeff, StringBuilder b) {
        Preconditions.checkNotNull((Object)varSerialized);
        if (b.length() != 0 && coeff.signum() >= 0) {
            b.append(" + ");
        }
        if (coeff == Rational.ONE) {
            b.append(varSerialized);
        } else if (coeff == Rational.NEG_ONE) {
            b.append(" - ").append(varSerialized);
        } else {
            b.append(coeff.toString()).append(varSerialized);
        }
    }

    public boolean equals(@Nullable Object object) {
        if (object == this) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (object.getClass() != this.getClass()) {
            return false;
        }
        LinearExpression other = (LinearExpression)object;
        return this.data.equals(other.data);
    }

    public int hashCode() {
        if (this.hashCache == 0) {
            this.hashCache = this.data.hashCode();
        }
        return this.hashCache;
    }
}

