/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.common.time;

import com.google.common.base.Ticker;
import java.lang.management.ManagementFactory;
import java.lang.management.ThreadMXBean;
import java.util.concurrent.TimeUnit;
import javax.management.JMException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.RuntimeErrorException;

public class Tickers {
    private Tickers() {
    }

    public static TickerWithUnit getNullTicker() {
        return NullTicker.INSTANCE;
    }

    public static TickerWithUnit getWalltimeMillis() {
        return WalltimeMillis.INSTANCE;
    }

    public static TickerWithUnit getWalltimeNanos() {
        return WalltimeNanos.INSTANCE;
    }

    public static TickerWithUnit getCurrentThreadCputime() {
        return CurrentThreadCputime.INSTANCE;
    }

    public static TickerWithUnit getProcessCputime() {
        return ProcessCputime.INSTANCE;
    }

    private static final class ProcessCputime
    extends TickerWithUnit {
        static final TickerWithUnit INSTANCE = new ProcessCputime();
        private final MBeanServer mbeanServer = ManagementFactory.getPlatformMBeanServer();
        private final ObjectName osMbean;
        private static final String PROCESS_CPU_TIME = "ProcessCpuTime";

        private ProcessCputime() {
            try {
                this.osMbean = new ObjectName("java.lang:type=OperatingSystem");
            }
            catch (MalformedObjectNameException e) {
                throw new UnsupportedOperationException(e);
            }
            this.read();
        }

        public long read() {
            try {
                return (Long)this.mbeanServer.getAttribute(this.osMbean, PROCESS_CPU_TIME);
            }
            catch (RuntimeErrorException e) {
                if (e.getTargetError() != null) {
                    throw e.getTargetError();
                }
                throw e;
            }
            catch (JMException e) {
                throw new UnsupportedOperationException(e);
            }
        }

        @Override
        public TimeUnit unit() {
            return TimeUnit.NANOSECONDS;
        }
    }

    private static final class CurrentThreadCputime
    extends TickerWithUnit {
        static final TickerWithUnit INSTANCE = new CurrentThreadCputime();
        private final ThreadMXBean threadMxBean = ManagementFactory.getThreadMXBean();

        private CurrentThreadCputime() {
            if (!this.threadMxBean.isThreadCpuTimeSupported()) {
                throw new UnsupportedOperationException("JVM does not support measuring per-thread cputime");
            }
            this.threadMxBean.setThreadCpuTimeEnabled(true);
            this.read();
        }

        public long read() {
            return this.threadMxBean.getCurrentThreadCpuTime();
        }

        @Override
        public TimeUnit unit() {
            return TimeUnit.NANOSECONDS;
        }
    }

    private static final class WalltimeNanos
    extends TickerWithUnit {
        static final TickerWithUnit INSTANCE = new WalltimeNanos();

        private WalltimeNanos() {
        }

        public long read() {
            return System.nanoTime();
        }

        @Override
        public TimeUnit unit() {
            return TimeUnit.NANOSECONDS;
        }
    }

    private static final class WalltimeMillis
    extends TickerWithUnit {
        static final TickerWithUnit INSTANCE = new WalltimeMillis();

        private WalltimeMillis() {
        }

        public long read() {
            return System.currentTimeMillis();
        }

        @Override
        public TimeUnit unit() {
            return TimeUnit.MILLISECONDS;
        }
    }

    private static final class NullTicker
    extends TickerWithUnit {
        static final TickerWithUnit INSTANCE = new NullTicker();

        private NullTicker() {
        }

        public long read() {
            return 0L;
        }

        @Override
        public TimeUnit unit() {
            return TimeUnit.NANOSECONDS;
        }
    }

    public static abstract class TickerWithUnit
    extends Ticker {
        public abstract TimeUnit unit();
    }
}

