/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.common.time;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Ascii;
import com.google.common.base.Preconditions;
import com.google.common.collect.EnumHashBiMap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSortedSet;
import com.google.common.collect.Ordering;
import com.google.common.primitives.Longs;
import com.google.errorprone.annotations.CheckReturnValue;
import com.google.errorprone.annotations.Immutable;
import com.google.errorprone.annotations.Var;
import java.io.Serializable;
import java.time.Duration;
import java.time.temporal.Temporal;
import java.time.temporal.TemporalAmount;
import java.time.temporal.TemporalUnit;
import java.time.temporal.UnsupportedTemporalTypeException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.checkerframework.checker.nullness.qual.Nullable;

@Immutable
public final class TimeSpan
implements Comparable<TimeSpan>,
Serializable,
TemporalAmount {
    private static final long serialVersionUID = -4013592312989551009L;
    private static final ImmutableSortedSet<TimeUnit> ALL_UNITS;
    private static final EnumHashBiMap<TimeUnit, String> TIME_UNITS;
    private static final Pattern ONLY_DIGITS;
    private final long span;
    private final TimeUnit unit;
    private static final String DEFAULT_FORMAT_PROPERTY_NAME;
    private static final Function<TimeSpan, String> DEFAULT_FORMAT;

    private TimeSpan(long pSpan, TimeUnit pUnit) {
        this.span = pSpan;
        this.unit = (TimeUnit)((Object)Preconditions.checkNotNull((Object)((Object)pUnit)));
    }

    public static TimeSpan of(long pSpan, TimeUnit pUnit) {
        return new TimeSpan(pSpan, pUnit);
    }

    public static TimeSpan ofSeconds(long pSeconds) {
        return new TimeSpan(pSeconds, TimeUnit.SECONDS);
    }

    public static TimeSpan ofMillis(long pMillis) {
        return new TimeSpan(pMillis, TimeUnit.MILLISECONDS);
    }

    public static TimeSpan ofNanos(long pNanos) {
        return new TimeSpan(pNanos, TimeUnit.NANOSECONDS);
    }

    public static TimeSpan empty() {
        return new TimeSpan(0L, TimeUnit.DAYS);
    }

    public static TimeSpan valueOf(String input) {
        Matcher secondMatcher = ONLY_DIGITS.matcher(input);
        if (secondMatcher.matches()) {
            return TimeSpan.ofSeconds(Long.parseLong(secondMatcher.group(1)));
        }
        List<String> tokens = TimeSpan.splitIntoTokens(input);
        long days = 0L;
        long hours = 0L;
        long minutes = 0L;
        long seconds = 0L;
        Iterator<String> it = tokens.iterator();
        block17: while (it.hasNext()) {
            String unit;
            String nextString = it.next();
            long value = Long.parseLong(nextString);
            if (!it.hasNext()) {
                throw new IllegalArgumentException("Value " + nextString + " has no unit.");
            }
            switch (unit = it.next()) {
                case "day": 
                case "days": 
                case "d": {
                    if (days != 0L) {
                        throw new IllegalArgumentException("Days set twice: " + unit);
                    }
                    days = value;
                    continue block17;
                }
                case "h": 
                case "hour": 
                case "hours": {
                    if (hours != 0L) {
                        throw new IllegalArgumentException("Hours set twice: " + unit);
                    }
                    hours = value;
                    continue block17;
                }
                case "min": 
                case "m": {
                    if (minutes != 0L) {
                        throw new IllegalArgumentException("Minutes set twice: " + unit);
                    }
                    minutes = value;
                    continue block17;
                }
                case "s": {
                    if (seconds != 0L) {
                        throw new IllegalArgumentException("Seconds set twice: " + unit);
                    }
                    seconds = value;
                    continue block17;
                }
            }
            throw new IllegalArgumentException("Unknown unit: " + unit);
        }
        return TimeSpan.sum(TimeSpan.of(seconds, TimeUnit.SECONDS), TimeSpan.of(minutes, TimeUnit.MINUTES), TimeSpan.of(hours, TimeUnit.HOURS), TimeSpan.of(days, TimeUnit.DAYS));
    }

    private static List<String> splitIntoTokens(String input) {
        ArrayList<String> tokens = new ArrayList<String>();
        CharType previous = CharType.BEGIN;
        int pos = 0;
        for (int i = 0; i <= input.length(); ++i) {
            CharType current;
            if (i == input.length()) {
                current = CharType.END;
            } else {
                char currentChar = input.charAt(i);
                if (Character.isLetter(currentChar)) {
                    current = CharType.LETTER;
                } else if (Character.isDigit(currentChar)) {
                    current = CharType.DIGIT;
                } else if (Character.isWhitespace(currentChar)) {
                    current = CharType.WHITESPACE;
                } else {
                    throw new IllegalArgumentException("Unreconized character '" + currentChar + "' when parsing " + input);
                }
            }
            if (current == previous) continue;
            if (previous == CharType.LETTER || previous == CharType.DIGIT) {
                tokens.add(input.substring(pos, i));
            }
            if (current == CharType.LETTER || current == CharType.DIGIT) {
                pos = i;
            }
            previous = current;
        }
        return tokens;
    }

    public long getChecked(TimeUnit dest) {
        if (dest.compareTo(this.unit) < 0) {
            long factor = dest.convert(1L, this.unit);
            assert (factor > 1L);
            return Math.multiplyExact(this.span, factor);
        }
        return dest.convert(this.span, this.unit);
    }

    public long getSaturated(TimeUnit dest) {
        return dest.convert(this.span, this.unit);
    }

    public TimeSpan toChecked(TimeUnit dest) {
        if (dest.equals((Object)this.unit)) {
            return this;
        }
        return new TimeSpan(this.getChecked(dest), dest);
    }

    public TimeSpan toSaturated(TimeUnit dest) {
        if (dest.equals((Object)this.unit)) {
            return this;
        }
        return new TimeSpan(this.getSaturated(dest), dest);
    }

    @VisibleForTesting
    TimeSpan toIfPossible(@Var TimeUnit dest) {
        if (dest.equals((Object)this.unit)) {
            return this;
        }
        if (dest.compareTo(this.unit) < 0) {
            while (true) {
                try {
                    return this.toChecked(dest);
                }
                catch (ArithmeticException e) {
                    dest = (TimeUnit)((Object)Preconditions.checkNotNull((Object)((Object)((TimeUnit)((Object)ALL_UNITS.higher((Object)dest))))));
                    continue;
                }
                break;
            }
        }
        return new TimeSpan(this.getSaturated(dest), dest);
    }

    public long asSeconds() {
        return this.getChecked(TimeUnit.SECONDS);
    }

    public long asMillis() {
        return this.getChecked(TimeUnit.MILLISECONDS);
    }

    public long asNanos() {
        return this.getChecked(TimeUnit.NANOSECONDS);
    }

    public TimeUnit getUnit() {
        return this.unit;
    }

    public Duration asDuration() {
        return Duration.of(this.span, this.unit.toChronoUnit());
    }

    public String formatAs(TimeUnit dest) {
        if (dest.compareTo(this.unit) <= 0) {
            return this.toIfPossible(dest).toString();
        }
        long scaleFactor = this.unit.convert(1L, dest);
        assert (scaleFactor > 0L);
        return String.format(Locale.US, "%9.3f%s", (double)this.span / (double)scaleFactor, TIME_UNITS.get((Object)dest));
    }

    public boolean isEmpty() {
        return this.span == 0L;
    }

    public boolean equals(@Nullable Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof TimeSpan)) {
            return false;
        }
        TimeSpan other = (TimeSpan)obj;
        if (this.unit == other.unit) {
            return this.span == other.span;
        }
        TimeUnit leastCommonUnit = TimeSpan.leastCommonUnit(this, other);
        try {
            return this.getChecked(leastCommonUnit) == other.getChecked(leastCommonUnit);
        }
        catch (ArithmeticException e) {
            return false;
        }
    }

    public int hashCode() {
        return Longs.hashCode((long)this.getSaturated(TimeUnit.NANOSECONDS));
    }

    @Override
    public int compareTo(TimeSpan other) {
        if (this.unit == other.unit) {
            return Long.compare(this.span, other.span);
        }
        TimeUnit leastCommonUnit = TimeSpan.leastCommonUnit(this, other);
        try {
            return Long.compare(this.getChecked(leastCommonUnit), other.getChecked(leastCommonUnit));
        }
        catch (ArithmeticException e) {
            return this.unit.compareTo(other.unit);
        }
    }

    private static TimeUnit leastCommonUnit(TimeSpan a, TimeSpan b) {
        return (TimeUnit)((Object)Ordering.natural().min((Object)a.unit, (Object)b.unit));
    }

    public String toString() {
        return DEFAULT_FORMAT.apply(this);
    }

    public static TimeSpan sum(TimeSpan a, TimeSpan b) {
        TimeUnit leastCommonUnit = TimeSpan.leastCommonUnit(a, b);
        while (true) {
            try {
                return new TimeSpan(Math.addExact(a.getChecked(leastCommonUnit), b.getChecked(leastCommonUnit)), leastCommonUnit);
            }
            catch (ArithmeticException e) {
                if ((leastCommonUnit = (TimeUnit)((Object)ALL_UNITS.higher((Object)leastCommonUnit))) != null) continue;
                throw e;
            }
            break;
        }
    }

    public static TimeSpan sum(Iterable<TimeSpan> timeSpans) {
        Iterator<TimeSpan> it = timeSpans.iterator();
        Preconditions.checkArgument((boolean)it.hasNext());
        TimeSpan result = it.next();
        while (it.hasNext()) {
            result = TimeSpan.sum(result, it.next());
        }
        return result;
    }

    public static TimeSpan sum(TimeSpan ... t) {
        return TimeSpan.sum(Arrays.asList(t));
    }

    public static TimeSpan difference(TimeSpan a, TimeSpan b) {
        TimeUnit leastCommonUnit = TimeSpan.leastCommonUnit(a, b);
        while (true) {
            try {
                return new TimeSpan(Math.subtractExact(a.getChecked(leastCommonUnit), b.getChecked(leastCommonUnit)), leastCommonUnit);
            }
            catch (ArithmeticException e) {
                if ((leastCommonUnit = (TimeUnit)((Object)ALL_UNITS.higher((Object)leastCommonUnit))) != null) continue;
                throw e;
            }
            break;
        }
    }

    @CheckReturnValue
    public TimeSpan multiply(int factor) {
        Preconditions.checkArgument((factor >= 0 ? 1 : 0) != 0, (String)"Cannot multiply TimeSpan with negative value %s", (int)factor);
        TimeUnit dest = this.unit;
        while (true) {
            try {
                return new TimeSpan(Math.multiplyExact(this.getChecked(dest), factor), dest);
            }
            catch (ArithmeticException e) {
                if ((dest = (TimeUnit)((Object)ALL_UNITS.higher((Object)dest))) != null) continue;
                throw e;
            }
            break;
        }
    }

    @CheckReturnValue
    public TimeSpan divide(int divisor) {
        Preconditions.checkArgument((divisor >= 0 ? 1 : 0) != 0, (String)"Cannot divide TimeSpan by negative value %s", (int)divisor);
        return new TimeSpan(this.span / (long)divisor, this.unit);
    }

    @Deprecated
    public ImmutableList<TemporalUnit> getUnits() {
        return ImmutableList.of((Object)this.unit.toChronoUnit());
    }

    @Override
    @Deprecated
    public long get(TemporalUnit pUnit) {
        Preconditions.checkNotNull((Object)pUnit);
        if (pUnit != this.unit.toChronoUnit()) {
            throw new UnsupportedTemporalTypeException("Unsupported unit: " + pUnit);
        }
        return this.span;
    }

    @Override
    public Temporal addTo(Temporal pTemporal) {
        return pTemporal.plus(this.span, this.unit.toChronoUnit());
    }

    @Override
    public Temporal subtractFrom(Temporal pTemporal) {
        return pTemporal.minus(this.span, this.unit.toChronoUnit());
    }

    private String formatSimple() {
        return this.span + (String)TIME_UNITS.get((Object)this.unit);
    }

    @VisibleForTesting
    String formatHumanReadableLarge() {
        StringBuilder result = new StringBuilder();
        boolean started = false;
        long years = this.getChecked(TimeUnit.DAYS) / 365L;
        if (years > 0L) {
            started = true;
            result.append(years).append("a ");
        }
        long days = this.getChecked(TimeUnit.DAYS) - years * 365L;
        if (started || days > 0L) {
            started = true;
            result.append(days).append("d ");
        }
        if (this.unit.equals((Object)TimeUnit.DAYS)) {
            return result.toString().trim();
        }
        long hours = this.getChecked(TimeUnit.HOURS) - years * 365L * 24L - days * 24L;
        if (started || hours > 0L) {
            started = true;
            result.append(String.format("%02dh ", hours));
        }
        if (this.unit.equals((Object)TimeUnit.HOURS)) {
            return result.toString().trim();
        }
        long minutes = this.getChecked(TimeUnit.MINUTES) - years * 365L * 24L * 60L - days * 24L * 60L - hours * 60L;
        if (started || minutes > 0L) {
            result.append(String.format("%02dmin ", minutes));
        }
        if (this.unit.equals((Object)TimeUnit.MINUTES)) {
            started = true;
            return result.toString().trim();
        }
        long seconds = this.getChecked(TimeUnit.SECONDS) - years * 365L * 24L * 60L * 60L - days * 24L * 60L * 60L - hours * 60L * 60L - minutes * 60L;
        result.append(String.format("%02ds", seconds));
        return result.toString();
    }

    static {
        String format;
        ALL_UNITS = ImmutableSortedSet.copyOf(EnumSet.allOf(TimeUnit.class));
        assert (((TimeUnit)((Object)ALL_UNITS.higher((Object)TimeUnit.SECONDS))).equals((Object)TimeUnit.MINUTES));
        TIME_UNITS = EnumHashBiMap.create(TimeUnit.class);
        TIME_UNITS.put((Enum)TimeUnit.NANOSECONDS, (Object)"ns");
        TIME_UNITS.put((Enum)TimeUnit.MICROSECONDS, (Object)"\u00b5s");
        TIME_UNITS.put((Enum)TimeUnit.MILLISECONDS, (Object)"ms");
        TIME_UNITS.put((Enum)TimeUnit.SECONDS, (Object)"s");
        TIME_UNITS.put((Enum)TimeUnit.MINUTES, (Object)"min");
        TIME_UNITS.put((Enum)TimeUnit.HOURS, (Object)"h");
        TIME_UNITS.put((Enum)TimeUnit.DAYS, (Object)"d");
        ONLY_DIGITS = Pattern.compile(" *([0-9]+) *");
        DEFAULT_FORMAT_PROPERTY_NAME = TimeSpan.class.getCanonicalName() + ".defaultFormat";
        switch (format = Ascii.toUpperCase((String)System.getProperty(DEFAULT_FORMAT_PROPERTY_NAME, "SIMPLE").trim())) {
            case "HUMAN_READABLE_LARGE": {
                DEFAULT_FORMAT = TimeSpan::formatHumanReadableLarge;
                break;
            }
            case "SIMPLE": {
                DEFAULT_FORMAT = TimeSpan::formatSimple;
                break;
            }
            default: {
                DEFAULT_FORMAT = TimeSpan::formatSimple;
            }
        }
    }

    private static enum CharType {
        BEGIN,
        END,
        LETTER,
        DIGIT,
        WHITESPACE;

    }
}

