/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.java_smt.basicimpl;

import com.google.common.base.Preconditions;
import java.util.Set;
import org.sosy_lab.java_smt.api.BasicProverEnvironment;
import org.sosy_lab.java_smt.api.SolverContext;

public abstract class AbstractProver<T>
implements BasicProverEnvironment<T> {
    private final boolean generateModels;
    private final boolean generateAllSat;
    protected final boolean generateUnsatCores;
    private final boolean generateUnsatCoresOverAssumptions;
    protected final boolean enableSL;
    private static final String TEMPLATE = "Please set the prover option %s.";

    protected AbstractProver(Set<SolverContext.ProverOptions> pOptions) {
        this.generateModels = pOptions.contains((Object)SolverContext.ProverOptions.GENERATE_MODELS);
        this.generateAllSat = pOptions.contains((Object)SolverContext.ProverOptions.GENERATE_ALL_SAT);
        this.generateUnsatCores = pOptions.contains((Object)SolverContext.ProverOptions.GENERATE_UNSAT_CORE);
        this.generateUnsatCoresOverAssumptions = pOptions.contains((Object)SolverContext.ProverOptions.GENERATE_UNSAT_CORE_OVER_ASSUMPTIONS);
        this.enableSL = pOptions.contains((Object)SolverContext.ProverOptions.ENABLE_SEPARATION_LOGIC);
    }

    protected final void checkGenerateModels() {
        Preconditions.checkState((boolean)this.generateModels, (String)TEMPLATE, (Object)((Object)SolverContext.ProverOptions.GENERATE_MODELS));
    }

    protected final void checkGenerateAllSat() {
        Preconditions.checkState((boolean)this.generateAllSat, (String)TEMPLATE, (Object)((Object)SolverContext.ProverOptions.GENERATE_ALL_SAT));
    }

    protected final void checkGenerateUnsatCores() {
        Preconditions.checkState((boolean)this.generateUnsatCores, (String)TEMPLATE, (Object)((Object)SolverContext.ProverOptions.GENERATE_UNSAT_CORE));
    }

    protected final void checkGenerateUnsatCoresOverAssumptions() {
        Preconditions.checkState((boolean)this.generateUnsatCoresOverAssumptions, (String)TEMPLATE, (Object)((Object)SolverContext.ProverOptions.GENERATE_UNSAT_CORE_OVER_ASSUMPTIONS));
    }

    protected final void checkEnableSeparationLogic() {
        Preconditions.checkState((boolean)this.enableSL, (String)TEMPLATE, (Object)((Object)SolverContext.ProverOptions.ENABLE_SEPARATION_LOGIC));
    }
}

