/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.java_smt.basicimpl;

import com.google.common.collect.Lists;
import java.util.List;
import org.sosy_lab.java_smt.api.BooleanFormula;
import org.sosy_lab.java_smt.api.Formula;
import org.sosy_lab.java_smt.api.QuantifiedFormulaManager;
import org.sosy_lab.java_smt.api.SolverException;
import org.sosy_lab.java_smt.basicimpl.AbstractBaseFormulaManager;
import org.sosy_lab.java_smt.basicimpl.FormulaCreator;

public abstract class AbstractQuantifiedFormulaManager<TFormulaInfo, TType, TEnv, TFuncDecl>
extends AbstractBaseFormulaManager<TFormulaInfo, TType, TEnv, TFuncDecl>
implements QuantifiedFormulaManager {
    protected AbstractQuantifiedFormulaManager(FormulaCreator<TFormulaInfo, TType, TEnv, TFuncDecl> pCreator) {
        super(pCreator);
    }

    private BooleanFormula wrap(TFormulaInfo formulaInfo) {
        return this.getFormulaCreator().encapsulateBoolean(formulaInfo);
    }

    @Override
    public BooleanFormula eliminateQuantifiers(BooleanFormula pF) throws InterruptedException, SolverException {
        return this.wrap(this.eliminateQuantifiers(this.extractInfo(pF)));
    }

    protected abstract TFormulaInfo eliminateQuantifiers(TFormulaInfo var1) throws SolverException, InterruptedException;

    @Override
    public BooleanFormula mkQuantifier(QuantifiedFormulaManager.Quantifier q, List<? extends Formula> pVariables, BooleanFormula pBody) {
        return this.wrap(this.mkQuantifier(q, Lists.transform(pVariables, this::extractInfo), this.extractInfo(pBody)));
    }

    public abstract TFormulaInfo mkQuantifier(QuantifiedFormulaManager.Quantifier var1, List<TFormulaInfo> var2, TFormulaInfo var3);
}

