/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.java_smt.basicimpl;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.sosy_lab.java_smt.api.BooleanFormula;
import org.sosy_lab.java_smt.api.Formula;
import org.sosy_lab.java_smt.api.FunctionDeclaration;
import org.sosy_lab.java_smt.api.QuantifiedFormulaManager;
import org.sosy_lab.java_smt.api.visitors.FormulaVisitor;
import org.sosy_lab.java_smt.api.visitors.TraversalProcess;

final class RecursiveFormulaVisitorImpl
implements FormulaVisitor<TraversalProcess> {
    private final Set<Formula> seen = new HashSet<Formula>();
    private final Deque<Formula> toVisit = new ArrayDeque<Formula>();
    private final FormulaVisitor<TraversalProcess> delegate;

    RecursiveFormulaVisitorImpl(FormulaVisitor<TraversalProcess> pDelegate) {
        this.delegate = (FormulaVisitor)Preconditions.checkNotNull(pDelegate);
    }

    void addToQueue(Formula f) {
        if (this.seen.add(f)) {
            this.toVisit.push(f);
        }
    }

    boolean isQueueEmpty() {
        return this.toVisit.isEmpty();
    }

    private void addToQueueIfNecessary(TraversalProcess result, List<? extends Formula> pOperands) {
        if (result == TraversalProcess.CONTINUE) {
            for (Formula formula : pOperands) {
                this.addToQueue(formula);
            }
        } else if (result.getType() == TraversalProcess.TraversalType.CUSTOM_TYPE) {
            pOperands.stream().filter(result::contains).forEach(this::addToQueue);
        }
    }

    Formula pop() {
        return this.toVisit.pop();
    }

    @Override
    public TraversalProcess visitFreeVariable(Formula pF, String pName) {
        return this.delegate.visitFreeVariable(pF, pName);
    }

    @Override
    public TraversalProcess visitBoundVariable(Formula pF, int pDeBruijnIdx) {
        return this.delegate.visitBoundVariable(pF, pDeBruijnIdx);
    }

    @Override
    public TraversalProcess visitConstant(Formula pF, Object pValue) {
        return this.delegate.visitConstant(pF, pValue);
    }

    @Override
    public TraversalProcess visitFunction(Formula pF, List<Formula> pArgs, FunctionDeclaration<?> pFunctionDeclaration) {
        TraversalProcess result = this.delegate.visitFunction(pF, pArgs, pFunctionDeclaration);
        this.addToQueueIfNecessary(result, pArgs);
        return result;
    }

    @Override
    public TraversalProcess visitQuantifier(BooleanFormula pF, QuantifiedFormulaManager.Quantifier pQuantifier, List<Formula> boundVars, BooleanFormula pBody) {
        TraversalProcess result = this.delegate.visitQuantifier(pF, pQuantifier, boundVars, pBody);
        this.addToQueueIfNecessary(result, (List<? extends Formula>)ImmutableList.of((Object)pBody));
        return result;
    }
}

