/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.java_smt.delegate.statistics;

import com.google.common.base.Preconditions;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.sosy_lab.java_smt.api.BasicProverEnvironment;
import org.sosy_lab.java_smt.api.BooleanFormula;
import org.sosy_lab.java_smt.api.Model;
import org.sosy_lab.java_smt.api.SolverException;
import org.sosy_lab.java_smt.delegate.statistics.SolverStatistics;
import org.sosy_lab.java_smt.delegate.statistics.StatisticsModel;
import org.sosy_lab.java_smt.delegate.statistics.TimerPool;

class StatisticsBasicProverEnvironment<T>
implements BasicProverEnvironment<T> {
    private final BasicProverEnvironment<T> delegate;
    final SolverStatistics stats;
    final TimerPool.TimerWrapper unsatTimer;
    private final TimerPool.TimerWrapper allSatTimer;

    StatisticsBasicProverEnvironment(BasicProverEnvironment<T> pDelegate, SolverStatistics pStats) {
        this.delegate = (BasicProverEnvironment)Preconditions.checkNotNull(pDelegate);
        this.stats = (SolverStatistics)Preconditions.checkNotNull((Object)pStats);
        this.unsatTimer = this.stats.unsat.getNewTimer();
        this.allSatTimer = this.stats.allSat.getNewTimer();
        this.stats.provers.getAndIncrement();
    }

    @Override
    public void pop() {
        this.stats.pop.getAndIncrement();
        this.delegate.pop();
    }

    @Override
    public @Nullable T addConstraint(BooleanFormula pConstraint) throws InterruptedException {
        this.stats.constraint.getAndIncrement();
        return this.delegate.addConstraint(pConstraint);
    }

    @Override
    public void push() {
        this.stats.push.getAndIncrement();
        this.delegate.push();
    }

    @Override
    public int size() {
        return this.delegate.size();
    }

    @Override
    public boolean isUnsat() throws SolverException, InterruptedException {
        this.unsatTimer.start();
        try {
            boolean bl = this.delegate.isUnsat();
            return bl;
        }
        finally {
            this.unsatTimer.stop();
        }
    }

    @Override
    public boolean isUnsatWithAssumptions(Collection<BooleanFormula> pAssumptions) throws SolverException, InterruptedException {
        this.unsatTimer.start();
        try {
            boolean bl = this.delegate.isUnsatWithAssumptions(pAssumptions);
            return bl;
        }
        finally {
            this.unsatTimer.stop();
        }
    }

    @Override
    public Model getModel() throws SolverException {
        this.stats.model.getAndIncrement();
        return new StatisticsModel(this.delegate.getModel(), this.stats);
    }

    @Override
    public List<BooleanFormula> getUnsatCore() {
        this.stats.unsatCore.getAndIncrement();
        return this.delegate.getUnsatCore();
    }

    @Override
    public Optional<List<BooleanFormula>> unsatCoreOverAssumptions(Collection<BooleanFormula> pAssumptions) throws SolverException, InterruptedException {
        this.stats.unsatCore.getAndIncrement();
        return this.delegate.unsatCoreOverAssumptions(pAssumptions);
    }

    @Override
    public void close() {
        this.delegate.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <R> R allSat(BasicProverEnvironment.AllSatCallback<R> pCallback, List<BooleanFormula> pImportant) throws InterruptedException, SolverException {
        this.allSatTimer.start();
        try {
            R r = this.delegate.allSat(pCallback, pImportant);
            return r;
        }
        finally {
            this.allSatTimer.stop();
        }
    }
}

