/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.java_smt.delegate.synchronize;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.sosy_lab.common.Appender;
import org.sosy_lab.common.Appenders;
import org.sosy_lab.java_smt.api.ArrayFormulaManager;
import org.sosy_lab.java_smt.api.BitvectorFormulaManager;
import org.sosy_lab.java_smt.api.BooleanFormula;
import org.sosy_lab.java_smt.api.BooleanFormulaManager;
import org.sosy_lab.java_smt.api.FloatingPointFormulaManager;
import org.sosy_lab.java_smt.api.Formula;
import org.sosy_lab.java_smt.api.FormulaManager;
import org.sosy_lab.java_smt.api.FormulaType;
import org.sosy_lab.java_smt.api.FunctionDeclaration;
import org.sosy_lab.java_smt.api.IntegerFormulaManager;
import org.sosy_lab.java_smt.api.QuantifiedFormulaManager;
import org.sosy_lab.java_smt.api.RationalFormulaManager;
import org.sosy_lab.java_smt.api.SLFormulaManager;
import org.sosy_lab.java_smt.api.SolverContext;
import org.sosy_lab.java_smt.api.StringFormulaManager;
import org.sosy_lab.java_smt.api.Tactic;
import org.sosy_lab.java_smt.api.UFManager;
import org.sosy_lab.java_smt.api.visitors.FormulaTransformationVisitor;
import org.sosy_lab.java_smt.api.visitors.FormulaVisitor;
import org.sosy_lab.java_smt.api.visitors.TraversalProcess;
import org.sosy_lab.java_smt.delegate.synchronize.SynchronizedArrayFormulaManager;
import org.sosy_lab.java_smt.delegate.synchronize.SynchronizedBitvectorFormulaManager;
import org.sosy_lab.java_smt.delegate.synchronize.SynchronizedBooleanFormulaManager;
import org.sosy_lab.java_smt.delegate.synchronize.SynchronizedFloatingPointFormulaManager;
import org.sosy_lab.java_smt.delegate.synchronize.SynchronizedIntegerFormulaManager;
import org.sosy_lab.java_smt.delegate.synchronize.SynchronizedQuantifiedFormulaManager;
import org.sosy_lab.java_smt.delegate.synchronize.SynchronizedRationalFormulaManager;
import org.sosy_lab.java_smt.delegate.synchronize.SynchronizedSLFormulaManager;
import org.sosy_lab.java_smt.delegate.synchronize.SynchronizedStringFormulaManager;
import org.sosy_lab.java_smt.delegate.synchronize.SynchronizedUFManager;

class SynchronizedFormulaManager
implements FormulaManager {
    private final FormulaManager delegate;
    private final SolverContext sync;

    protected SynchronizedFormulaManager(FormulaManager pDelegate, SolverContext pSync) {
        this.delegate = (FormulaManager)Preconditions.checkNotNull((Object)pDelegate);
        this.sync = (SolverContext)Preconditions.checkNotNull((Object)pSync);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IntegerFormulaManager getIntegerFormulaManager() {
        SolverContext solverContext = this.sync;
        synchronized (solverContext) {
            return new SynchronizedIntegerFormulaManager(this.delegate.getIntegerFormulaManager(), this.sync);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RationalFormulaManager getRationalFormulaManager() {
        SolverContext solverContext = this.sync;
        synchronized (solverContext) {
            return new SynchronizedRationalFormulaManager(this.delegate.getRationalFormulaManager(), this.sync);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BooleanFormulaManager getBooleanFormulaManager() {
        SolverContext solverContext = this.sync;
        synchronized (solverContext) {
            return new SynchronizedBooleanFormulaManager(this.delegate.getBooleanFormulaManager(), this.sync);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ArrayFormulaManager getArrayFormulaManager() {
        SolverContext solverContext = this.sync;
        synchronized (solverContext) {
            return new SynchronizedArrayFormulaManager(this.delegate.getArrayFormulaManager(), this.sync);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BitvectorFormulaManager getBitvectorFormulaManager() {
        SolverContext solverContext = this.sync;
        synchronized (solverContext) {
            return new SynchronizedBitvectorFormulaManager(this.delegate.getBitvectorFormulaManager(), this.sync);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public FloatingPointFormulaManager getFloatingPointFormulaManager() {
        SolverContext solverContext = this.sync;
        synchronized (solverContext) {
            return new SynchronizedFloatingPointFormulaManager(this.delegate.getFloatingPointFormulaManager(), this.sync);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UFManager getUFManager() {
        SolverContext solverContext = this.sync;
        synchronized (solverContext) {
            return new SynchronizedUFManager(this.delegate.getUFManager(), this.sync);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SLFormulaManager getSLFormulaManager() {
        SolverContext solverContext = this.sync;
        synchronized (solverContext) {
            return new SynchronizedSLFormulaManager(this.delegate.getSLFormulaManager(), this.sync);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public QuantifiedFormulaManager getQuantifiedFormulaManager() {
        SolverContext solverContext = this.sync;
        synchronized (solverContext) {
            return new SynchronizedQuantifiedFormulaManager(this.delegate.getQuantifiedFormulaManager(), this.sync);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public StringFormulaManager getStringFormulaManager() {
        SolverContext solverContext = this.sync;
        synchronized (solverContext) {
            return new SynchronizedStringFormulaManager(this.delegate.getStringFormulaManager(), this.sync);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T extends Formula> T makeVariable(FormulaType<T> pFormulaType, String pName) {
        SolverContext solverContext = this.sync;
        synchronized (solverContext) {
            return this.delegate.makeVariable(pFormulaType, pName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T extends Formula> T makeApplication(FunctionDeclaration<T> pDeclaration, List<? extends Formula> pArgs) {
        SolverContext solverContext = this.sync;
        synchronized (solverContext) {
            return this.delegate.makeApplication(pDeclaration, pArgs);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T extends Formula> T makeApplication(FunctionDeclaration<T> pDeclaration, Formula ... pArgs) {
        SolverContext solverContext = this.sync;
        synchronized (solverContext) {
            return this.delegate.makeApplication(pDeclaration, pArgs);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T extends Formula> FormulaType<T> getFormulaType(T pFormula) {
        SolverContext solverContext = this.sync;
        synchronized (solverContext) {
            return this.delegate.getFormulaType(pFormula);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BooleanFormula parse(String pS) throws IllegalArgumentException {
        SolverContext solverContext = this.sync;
        synchronized (solverContext) {
            return this.delegate.parse(pS);
        }
    }

    @Override
    public Appender dumpFormula(final BooleanFormula pT) {
        return new Appenders.AbstractAppender(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void appendTo(Appendable out) throws IOException {
                String dump;
                SolverContext solverContext = SynchronizedFormulaManager.this.sync;
                synchronized (solverContext) {
                    dump = SynchronizedFormulaManager.this.delegate.dumpFormula(pT).toString();
                }
                out.append(dump);
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BooleanFormula applyTactic(BooleanFormula pInput, Tactic pTactic) throws InterruptedException {
        SolverContext solverContext = this.sync;
        synchronized (solverContext) {
            return this.delegate.applyTactic(pInput, pTactic);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T extends Formula> T simplify(T pInput) throws InterruptedException {
        SolverContext solverContext = this.sync;
        synchronized (solverContext) {
            return this.delegate.simplify(pInput);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <R> R visit(Formula pF, FormulaVisitor<R> pFormulaVisitor) {
        SolverContext solverContext = this.sync;
        synchronized (solverContext) {
            return this.delegate.visit(pF, pFormulaVisitor);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void visitRecursively(Formula pF, FormulaVisitor<TraversalProcess> pFormulaVisitor) {
        SolverContext solverContext = this.sync;
        synchronized (solverContext) {
            this.delegate.visitRecursively(pF, pFormulaVisitor);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T extends Formula> T transformRecursively(T pF, FormulaTransformationVisitor pFormulaVisitor) {
        SolverContext solverContext = this.sync;
        synchronized (solverContext) {
            return this.delegate.transformRecursively(pF, pFormulaVisitor);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, Formula> extractVariables(Formula pF) {
        SolverContext solverContext = this.sync;
        synchronized (solverContext) {
            return this.delegate.extractVariables(pF);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, Formula> extractVariablesAndUFs(Formula pF) {
        SolverContext solverContext = this.sync;
        synchronized (solverContext) {
            return this.delegate.extractVariablesAndUFs(pF);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T extends Formula> T substitute(T pF, Map<? extends Formula, ? extends Formula> pFromToMapping) {
        SolverContext solverContext = this.sync;
        synchronized (solverContext) {
            return this.delegate.substitute(pF, pFromToMapping);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BooleanFormula translateFrom(BooleanFormula pFormula, FormulaManager pOtherContext) {
        SolverContext solverContext = this.sync;
        synchronized (solverContext) {
            return this.delegate.translateFrom(pFormula, pOtherContext);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isValidName(String pVariableName) {
        SolverContext solverContext = this.sync;
        synchronized (solverContext) {
            return this.delegate.isValidName(pVariableName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String escape(String pVariableName) {
        SolverContext solverContext = this.sync;
        synchronized (solverContext) {
            return this.delegate.escape(pVariableName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String unescape(String pVariableName) {
        SolverContext solverContext = this.sync;
        synchronized (solverContext) {
            return this.delegate.unescape(pVariableName);
        }
    }
}

