/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.java_smt.delegate.synchronize;

import com.google.common.base.Preconditions;
import java.util.Collection;
import java.util.List;
import org.sosy_lab.java_smt.api.BooleanFormula;
import org.sosy_lab.java_smt.api.FormulaManager;
import org.sosy_lab.java_smt.api.InterpolatingProverEnvironment;
import org.sosy_lab.java_smt.api.SolverContext;
import org.sosy_lab.java_smt.api.SolverException;
import org.sosy_lab.java_smt.delegate.synchronize.SynchronizedBasicProverEnvironmentWithContext;

class SynchronizedInterpolatingProverEnvironmentWithContext<T>
extends SynchronizedBasicProverEnvironmentWithContext<T>
implements InterpolatingProverEnvironment<T> {
    private final InterpolatingProverEnvironment<T> delegate;

    SynchronizedInterpolatingProverEnvironmentWithContext(InterpolatingProverEnvironment<T> pDelegate, SolverContext pSync, FormulaManager pManager, FormulaManager pOtherManager) {
        super(pDelegate, pSync, pManager, pOtherManager);
        this.delegate = (InterpolatingProverEnvironment)Preconditions.checkNotNull(pDelegate);
    }

    @Override
    public BooleanFormula getInterpolant(Collection<T> pFormulasOfA) throws SolverException, InterruptedException {
        return this.manager.translateFrom(this.delegate.getInterpolant(pFormulasOfA), this.otherManager);
    }

    @Override
    public List<BooleanFormula> getSeqInterpolants(List<? extends Collection<T>> pPartitionedFormulas) throws SolverException, InterruptedException {
        return this.translate(this.delegate.getSeqInterpolants(pPartitionedFormulas), this.otherManager, this.manager);
    }

    @Override
    public List<BooleanFormula> getTreeInterpolants(List<? extends Collection<T>> pPartitionedFormulas, int[] pStartOfSubTree) throws SolverException, InterruptedException {
        return this.translate(this.delegate.getTreeInterpolants(pPartitionedFormulas, pStartOfSubTree), this.otherManager, this.manager);
    }
}

