/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.java_smt.example;

import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.logging.Level;
import org.sosy_lab.common.ShutdownNotifier;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.log.BasicLogManager;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.java_smt.SolverContextFactory;
import org.sosy_lab.java_smt.api.BooleanFormula;
import org.sosy_lab.java_smt.api.SolverContext;
import org.sosy_lab.java_smt.api.SolverException;
import org.sosy_lab.java_smt.utils.PrettyPrinter;
import org.sosy_lab.java_smt.utils.SolverUtils;

public class PrettyPrinter {
    private PrettyPrinter() {
    }

    public static void main(String ... args) throws InvalidConfigurationException, SolverException, InterruptedException, IOException {
        if (args.length == 0) {
            PrettyPrinter.help();
        }
        SolverContextFactory.Solvers solver = SolverContextFactory.Solvers.MATHSAT5;
        Type type = Type.TEXT;
        Path path = null;
        for (String arg : args) {
            if (arg.startsWith("-solver=")) {
                solver = SolverContextFactory.Solvers.valueOf(arg.substring(8));
                continue;
            }
            if (arg.startsWith("-type=")) {
                type = Type.valueOf(arg.substring(6).toUpperCase());
                continue;
            }
            if (path == null) {
                path = Path.of(arg, new String[0]);
                continue;
            }
            PrettyPrinter.help();
        }
        if (path == null) {
            PrettyPrinter.help();
        }
        Configuration config = Configuration.defaultConfiguration();
        LogManager logger = BasicLogManager.create(config);
        ShutdownNotifier notifier = ShutdownNotifier.createDummy();
        try (SolverContext context = SolverContextFactory.createSolverContext(config, logger, notifier, solver);){
            ArrayList<BooleanFormula> formulas = new ArrayList<BooleanFormula>();
            ArrayList<String> definitions = new ArrayList<String>();
            for (String line : Files.readAllLines(path)) {
                if (Iterables.any((Iterable)ImmutableList.of((Object)";", (Object)"(push ", (Object)"(pop ", (Object)"(reset", (Object)"(set-logic"), line::startsWith)) continue;
                if (line.startsWith("(assert ")) {
                    BooleanFormula bf = context.getFormulaManager().parse(Joiner.on((String)"").join(definitions) + line);
                    formulas.add(bf);
                    continue;
                }
                definitions.add(line);
            }
            org.sosy_lab.java_smt.utils.PrettyPrinter pp = SolverUtils.prettyPrinter(context.getFormulaManager());
            for (BooleanFormula formula : formulas) {
                System.out.println(PrettyPrinter.formulaToString(formula, pp, type));
            }
        }
        catch (UnsatisfiedLinkError | InvalidConfigurationException e) {
            logger.logUserException(Level.INFO, e, "Solver " + solver + " is not available.");
        }
        catch (UnsupportedOperationException e) {
            logger.logUserException(Level.INFO, e, e.getMessage());
        }
    }

    private static String formulaToString(BooleanFormula formula, org.sosy_lab.java_smt.utils.PrettyPrinter pp, Type type) {
        switch (type) {
            case DETAILED_TEXT: {
                return pp.formulaToString(formula, new PrettyPrinter.PrinterOption[0]);
            }
            case DOT: {
                return pp.formulaToDot(formula, PrettyPrinter.PrinterOption.SPLIT_ONLY_BOOLEAN_OPERATIONS);
            }
            case DETAILED_DOT: {
                return pp.formulaToDot(formula, new PrettyPrinter.PrinterOption[0]);
            }
        }
        return pp.formulaToString(formula, PrettyPrinter.PrinterOption.SPLIT_ONLY_BOOLEAN_OPERATIONS);
    }

    private static void help() {
        throw new AssertionError((Object)"run $> TOOL [-solver=SOLVER] [-type=TYPE] PATH");
    }

    private static enum Type {
        DOT,
        DETAILED_DOT,
        TEXT,
        DETAILED_TEXT;

    }
}

