/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.java_smt.solvers.boolector;

import com.google.errorprone.annotations.Immutable;
import org.sosy_lab.java_smt.api.ArrayFormula;
import org.sosy_lab.java_smt.api.BitvectorFormula;
import org.sosy_lab.java_smt.api.BooleanFormula;
import org.sosy_lab.java_smt.api.Formula;
import org.sosy_lab.java_smt.api.FormulaType;
import org.sosy_lab.java_smt.solvers.boolector.BtorJNI;

@Immutable
abstract class BoolectorFormula
implements Formula {
    private final long btorTerm;
    private final long btor;

    BoolectorFormula(long term, long btor) {
        this.btorTerm = term;
        this.btor = btor;
    }

    final long getTerm() {
        return this.btorTerm;
    }

    @Override
    public final boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BoolectorFormula)) {
            return false;
        }
        BoolectorFormula other = (BoolectorFormula)o;
        return this.btor == other.btor && this.btorTerm == other.btorTerm;
    }

    @Override
    public final int hashCode() {
        return BtorJNI.boolector_get_node_id(this.btor, this.btorTerm);
    }

    static final class BoolectorArrayFormula<TI extends Formula, TE extends Formula>
    extends BoolectorFormula
    implements ArrayFormula<TI, TE> {
        private final FormulaType<TI> indexType;
        private final FormulaType<TE> elementType;

        BoolectorArrayFormula(long pTerm, FormulaType<TI> pIndexType, FormulaType<TE> pElementType, long btor) {
            super(pTerm, btor);
            this.indexType = pIndexType;
            this.elementType = pElementType;
        }

        public FormulaType<TI> getIndexType() {
            return this.indexType;
        }

        public FormulaType<TE> getElementType() {
            return this.elementType;
        }
    }

    @Immutable
    static final class BoolectorBooleanFormula
    extends BoolectorFormula
    implements BooleanFormula {
        BoolectorBooleanFormula(long pTerm, long btor) {
            super(pTerm, btor);
        }
    }

    @Immutable
    static final class BoolectorBitvectorFormula
    extends BoolectorFormula
    implements BitvectorFormula {
        BoolectorBitvectorFormula(long pTerm, long btor) {
            super(pTerm, btor);
        }
    }
}

