/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.java_smt.solvers.boolector;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.primitives.Longs;
import java.util.List;
import org.sosy_lab.java_smt.api.QuantifiedFormulaManager;
import org.sosy_lab.java_smt.api.SolverException;
import org.sosy_lab.java_smt.basicimpl.AbstractQuantifiedFormulaManager;
import org.sosy_lab.java_smt.basicimpl.FormulaCreator;
import org.sosy_lab.java_smt.solvers.boolector.BtorJNI;

public class BoolectorQuantifiedFormulaManager
extends AbstractQuantifiedFormulaManager<Long, Long, Long, Long> {
    private final long btor = (Long)this.getFormulaCreator().getEnv();

    BoolectorQuantifiedFormulaManager(FormulaCreator<Long, Long, Long, Long> pCreator) {
        super(pCreator);
    }

    @Override
    protected Long eliminateQuantifiers(Long pExtractInfo) throws SolverException, InterruptedException {
        throw new UnsupportedOperationException("Boolector can not eliminate quantifier.");
    }

    @Override
    public Long mkQuantifier(QuantifiedFormulaManager.Quantifier pQ, List<Long> pVars, Long pBody) {
        Preconditions.checkArgument((!pVars.isEmpty() ? 1 : 0) != 0, (Object)"List of quantified variables can not be empty");
        for (long param : pVars) {
            Preconditions.checkArgument((boolean)BtorJNI.boolector_is_param(this.btor, param), (Object)"pVariables need to be parameter nodes in boolector.");
        }
        long[] varsArray = Longs.toArray(pVars);
        long newQuantifier = pQ == QuantifiedFormulaManager.Quantifier.FORALL ? BtorJNI.boolector_forall(this.btor, varsArray, varsArray.length, pBody) : BtorJNI.boolector_exists(this.btor, varsArray, varsArray.length, pBody);
        return newQuantifier;
    }

    static class QuantifiedFormula {
        private final boolean isForall;
        private final long body;
        private final ImmutableList<Long> boundVariables;

        QuantifiedFormula(boolean pIsForall, long pBody, List<Long> pVars) {
            this.isForall = pIsForall;
            this.body = pBody;
            this.boundVariables = ImmutableList.copyOf(pVars);
        }

        public boolean isForall() {
            return this.isForall;
        }

        public long getBody() {
            return this.body;
        }

        public ImmutableList<Long> getBoundVariables() {
            return this.boundVariables;
        }
    }
}

