/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.java_smt.solvers.cvc4;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import edu.stanford.CVC4.Expr;
import edu.stanford.CVC4.ExprManager;
import edu.stanford.CVC4.Kind;
import edu.stanford.CVC4.SmtEngine;
import edu.stanford.CVC4.Type;
import java.util.ArrayList;
import java.util.Collection;
import org.sosy_lab.java_smt.api.BooleanFormula;
import org.sosy_lab.java_smt.api.Formula;
import org.sosy_lab.java_smt.api.Model;
import org.sosy_lab.java_smt.basicimpl.AbstractModel;
import org.sosy_lab.java_smt.solvers.cvc4.CVC4FormulaCreator;
import org.sosy_lab.java_smt.solvers.cvc4.CVC4TheoremProver;

public class CVC4Model
extends AbstractModel.CachingAbstractModel<Expr, Type, ExprManager> {
    private final ImmutableList<Model.ValueAssignment> model;
    private final SmtEngine smtEngine;
    private final ImmutableList<Expr> assertedExpressions;
    private final CVC4TheoremProver prover;
    protected boolean closed = false;

    CVC4Model(CVC4TheoremProver pProver, CVC4FormulaCreator pCreator, SmtEngine pSmtEngine, Collection<Expr> pAssertedExpressions) {
        super(pCreator);
        this.smtEngine = pSmtEngine;
        this.prover = pProver;
        this.assertedExpressions = ImmutableList.copyOf(pAssertedExpressions);
        this.model = this.generateModel();
    }

    @Override
    public Expr evalImpl(Expr f) {
        Preconditions.checkState((!this.closed ? 1 : 0) != 0);
        return this.getValue(f);
    }

    private Expr getValue(Expr f) {
        return this.prover.exportExpr(this.smtEngine.getValue(this.prover.importExpr(f)));
    }

    private ImmutableList<Model.ValueAssignment> generateModel() {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        for (Expr expr : this.assertedExpressions) {
            this.recursiveAssignmentFinder((ImmutableSet.Builder<Model.ValueAssignment>)builder, expr);
        }
        return builder.build().asList();
    }

    private void recursiveAssignmentFinder(ImmutableSet.Builder<Model.ValueAssignment> builder, Expr expr) {
        if (expr.isConst() || expr.isNull()) {
            return;
        }
        if (expr.isVariable() && expr.getKind() == Kind.BOUND_VARIABLE) {
            return;
        }
        if (expr.isVariable() || expr.getOperator().getType().isFunction()) {
            builder.add((Object)this.getAssignment(expr));
        } else if (expr.getKind() == Kind.FORALL || expr.getKind() == Kind.EXISTS) {
            Expr body = expr.getChildren().get(1);
            this.recursiveAssignmentFinder(builder, body);
        } else {
            for (Expr child : expr) {
                this.recursiveAssignmentFinder(builder, child);
            }
        }
    }

    private Model.ValueAssignment getAssignment(Expr pKeyTerm) {
        ArrayList<Object> argumentInterpretation = new ArrayList<Object>();
        for (Expr param : pKeyTerm) {
            argumentInterpretation.add(this.evaluateImpl(param));
        }
        Expr name = pKeyTerm.hasOperator() ? pKeyTerm.getOperator() : pKeyTerm;
        String nameStr = name.toString();
        if (nameStr.startsWith("|") && nameStr.endsWith("|")) {
            nameStr = nameStr.substring(1, nameStr.length() - 1);
        }
        Expr valueTerm = this.getValue(pKeyTerm);
        Formula keyFormula = this.creator.encapsulateWithTypeOf(pKeyTerm);
        Formula valueFormula = this.creator.encapsulateWithTypeOf(valueTerm);
        BooleanFormula equation = this.creator.encapsulateBoolean(((ExprManager)this.creator.getEnv()).mkExpr(Kind.EQUAL, pKeyTerm, valueTerm));
        Object value = this.creator.convertValue(pKeyTerm, valueTerm);
        return new Model.ValueAssignment(keyFormula, valueFormula, equation, nameStr, value, argumentInterpretation);
    }

    @Override
    public void close() {
        this.prover.unregisterModel(this);
        this.closed = true;
    }

    @Override
    protected ImmutableList<Model.ValueAssignment> toList() {
        return this.model;
    }
}

