/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.java_smt.solvers.cvc4;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import edu.stanford.CVC4.Expr;
import edu.stanford.CVC4.ExprManager;
import edu.stanford.CVC4.Kind;
import edu.stanford.CVC4.Rational;
import edu.stanford.CVC4.Type;
import edu.stanford.CVC4.vectorExpr;
import java.math.BigInteger;
import java.util.ArrayDeque;
import java.util.HashSet;
import java.util.List;
import java.util.regex.Pattern;
import org.sosy_lab.java_smt.api.NumeralFormula;
import org.sosy_lab.java_smt.basicimpl.AbstractNumeralFormulaManager;
import org.sosy_lab.java_smt.solvers.cvc4.CVC4FormulaCreator;

abstract class CVC4NumeralFormulaManager<ParamFormulaType extends NumeralFormula, ResultFormulaType extends NumeralFormula>
extends AbstractNumeralFormulaManager<Expr, Type, ExprManager, ParamFormulaType, ResultFormulaType, Expr> {
    public static final Pattern INTEGER_NUMBER = Pattern.compile("(-)?(\\d)+");
    public static final Pattern RATIONAL_NUMBER = Pattern.compile("(-)?(\\d)+(.)?(\\d)*");
    private static final ImmutableSet<Kind> NUMERIC_FUNCTIONS = ImmutableSet.of((Object)Kind.PLUS, (Object)Kind.MINUS, (Object)Kind.MULT, (Object)Kind.DIVISION, (Object)Kind.INTS_DIVISION, (Object)Kind.INTS_MODULUS, (Object[])new Kind[0]);
    protected final ExprManager exprManager;

    CVC4NumeralFormulaManager(CVC4FormulaCreator pCreator, AbstractNumeralFormulaManager.NonLinearArithmetic pNonLinearArithmetic) {
        super(pCreator, pNonLinearArithmetic);
        this.exprManager = (ExprManager)pCreator.getEnv();
    }

    protected abstract Type getNumeralType();

    @Override
    protected boolean isNumeral(Expr pVal) {
        return (pVal.getType().isInteger() || pVal.getType().isReal()) && pVal.isConst();
    }

    boolean consistsOfNumerals(Expr val) {
        HashSet<Expr> finished = new HashSet<Expr>();
        ArrayDeque<Expr> waitlist = new ArrayDeque<Expr>();
        waitlist.add(val);
        while (!waitlist.isEmpty()) {
            Expr e = (Expr)waitlist.pop();
            if (!finished.add(e) || this.isNumeral(e)) continue;
            if (NUMERIC_FUNCTIONS.contains((Object)e.getKind())) {
                Iterables.addAll(waitlist, (Iterable)e);
                continue;
            }
            if (Kind.ITE.equals(e.getKind())) {
                waitlist.add(e.getChild(1L));
                waitlist.add(e.getChild(2L));
                continue;
            }
            return false;
        }
        return true;
    }

    @Override
    protected Expr makeNumberImpl(long i) {
        return this.makeNumberImpl(Long.toString(i));
    }

    @Override
    protected Expr makeNumberImpl(BigInteger pI) {
        return this.makeNumberImpl(pI.toString());
    }

    @Override
    protected Expr makeNumberImpl(String pI) {
        if (!RATIONAL_NUMBER.matcher(pI).matches()) {
            throw new NumberFormatException("number is not an rational value: " + pI);
        }
        return this.exprManager.mkConst(Rational.fromDecimal((String)pI));
    }

    @Override
    protected Expr makeVariableImpl(String varName) {
        Type type = this.getNumeralType();
        return (Expr)this.getFormulaCreator().makeVariable(type, varName);
    }

    @Override
    protected Expr multiply(Expr pParam1, Expr pParam2) {
        if (this.consistsOfNumerals(pParam1) || this.consistsOfNumerals(pParam2)) {
            return this.exprManager.mkExpr(Kind.MULT, pParam1, pParam2);
        }
        return super.multiply(pParam1, pParam2);
    }

    @Override
    protected Expr modulo(Expr pParam1, Expr pParam2) {
        return this.exprManager.mkExpr(Kind.INTS_MODULUS, pParam1, pParam2);
    }

    @Override
    protected Expr negate(Expr pParam1) {
        return this.exprManager.mkExpr(Kind.UMINUS, pParam1);
    }

    @Override
    protected Expr add(Expr pParam1, Expr pParam2) {
        return this.exprManager.mkExpr(Kind.PLUS, pParam1, pParam2);
    }

    @Override
    protected Expr subtract(Expr pParam1, Expr pParam2) {
        return this.exprManager.mkExpr(Kind.MINUS, pParam1, pParam2);
    }

    @Override
    protected Expr equal(Expr pParam1, Expr pParam2) {
        return this.exprManager.mkExpr(Kind.EQUAL, pParam1, pParam2);
    }

    @Override
    protected Expr greaterThan(Expr pParam1, Expr pParam2) {
        return this.exprManager.mkExpr(Kind.GT, pParam1, pParam2);
    }

    @Override
    protected Expr greaterOrEquals(Expr pParam1, Expr pParam2) {
        return this.exprManager.mkExpr(Kind.GEQ, pParam1, pParam2);
    }

    @Override
    protected Expr lessThan(Expr pParam1, Expr pParam2) {
        return this.exprManager.mkExpr(Kind.LT, pParam1, pParam2);
    }

    @Override
    protected Expr lessOrEquals(Expr pParam1, Expr pParam2) {
        return this.exprManager.mkExpr(Kind.LEQ, pParam1, pParam2);
    }

    @Override
    protected Expr distinctImpl(List<Expr> pParam) {
        vectorExpr param = new vectorExpr();
        pParam.forEach(arg_0 -> ((vectorExpr)param).add(arg_0));
        return this.exprManager.mkExpr(Kind.DISTINCT, param);
    }
}

