/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.java_smt.solvers.cvc5;

import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import io.github.cvc5.CVC5ApiException;
import io.github.cvc5.Kind;
import io.github.cvc5.Op;
import io.github.cvc5.Pair;
import io.github.cvc5.Solver;
import io.github.cvc5.Sort;
import io.github.cvc5.Term;
import io.github.cvc5.Triplet;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.sosy_lab.common.rationals.Rational;
import org.sosy_lab.java_smt.api.ArrayFormula;
import org.sosy_lab.java_smt.api.BitvectorFormula;
import org.sosy_lab.java_smt.api.BooleanFormula;
import org.sosy_lab.java_smt.api.FloatingPointFormula;
import org.sosy_lab.java_smt.api.Formula;
import org.sosy_lab.java_smt.api.FormulaType;
import org.sosy_lab.java_smt.api.FunctionDeclarationKind;
import org.sosy_lab.java_smt.api.QuantifiedFormulaManager;
import org.sosy_lab.java_smt.api.RegexFormula;
import org.sosy_lab.java_smt.api.StringFormula;
import org.sosy_lab.java_smt.api.visitors.FormulaVisitor;
import org.sosy_lab.java_smt.basicimpl.FormulaCreator;
import org.sosy_lab.java_smt.basicimpl.FunctionDeclarationImpl;
import org.sosy_lab.java_smt.solvers.cvc5.CVC5Formula;
import org.sosy_lab.java_smt.solvers.cvc5.CVC5FormulaManager;

public class CVC5FormulaCreator
extends FormulaCreator<Term, Sort, Solver, Term> {
    private static final ImmutableSet<String> UNSUPPORTED_IDENTIFIERS = ImmutableSet.of((Object)"let");
    private final Map<String, Term> variablesCache = new HashMap<String, Term>();
    private final Map<String, Term> functionsCache = new HashMap<String, Term>();
    private final Solver solver;
    private static final ImmutableMap<Kind, FunctionDeclarationKind> KIND_MAPPING = ImmutableMap.builder().put((Object)Kind.EQUAL, (Object)FunctionDeclarationKind.EQ).put((Object)Kind.DISTINCT, (Object)FunctionDeclarationKind.DISTINCT).put((Object)Kind.NOT, (Object)FunctionDeclarationKind.NOT).put((Object)Kind.AND, (Object)FunctionDeclarationKind.AND).put((Object)Kind.IMPLIES, (Object)FunctionDeclarationKind.IMPLIES).put((Object)Kind.OR, (Object)FunctionDeclarationKind.OR).put((Object)Kind.XOR, (Object)FunctionDeclarationKind.XOR).put((Object)Kind.ITE, (Object)FunctionDeclarationKind.ITE).put((Object)Kind.APPLY_UF, (Object)FunctionDeclarationKind.UF).put((Object)Kind.ADD, (Object)FunctionDeclarationKind.ADD).put((Object)Kind.MULT, (Object)FunctionDeclarationKind.MUL).put((Object)Kind.SUB, (Object)FunctionDeclarationKind.SUB).put((Object)Kind.INTS_MODULUS, (Object)FunctionDeclarationKind.MODULO).put((Object)Kind.INTS_DIVISION, (Object)FunctionDeclarationKind.DIV).put((Object)Kind.DIVISION, (Object)FunctionDeclarationKind.DIV).put((Object)Kind.LT, (Object)FunctionDeclarationKind.LT).put((Object)Kind.LEQ, (Object)FunctionDeclarationKind.LTE).put((Object)Kind.GT, (Object)FunctionDeclarationKind.GT).put((Object)Kind.GEQ, (Object)FunctionDeclarationKind.GTE).put((Object)Kind.BITVECTOR_ADD, (Object)FunctionDeclarationKind.BV_ADD).put((Object)Kind.BITVECTOR_SUB, (Object)FunctionDeclarationKind.BV_SUB).put((Object)Kind.BITVECTOR_MULT, (Object)FunctionDeclarationKind.BV_MUL).put((Object)Kind.BITVECTOR_AND, (Object)FunctionDeclarationKind.BV_AND).put((Object)Kind.BITVECTOR_OR, (Object)FunctionDeclarationKind.BV_OR).put((Object)Kind.BITVECTOR_XOR, (Object)FunctionDeclarationKind.BV_XOR).put((Object)Kind.BITVECTOR_SLT, (Object)FunctionDeclarationKind.BV_SLT).put((Object)Kind.BITVECTOR_ULT, (Object)FunctionDeclarationKind.BV_ULT).put((Object)Kind.BITVECTOR_SLE, (Object)FunctionDeclarationKind.BV_SLE).put((Object)Kind.BITVECTOR_ULE, (Object)FunctionDeclarationKind.BV_ULE).put((Object)Kind.BITVECTOR_SGT, (Object)FunctionDeclarationKind.BV_SGT).put((Object)Kind.BITVECTOR_UGT, (Object)FunctionDeclarationKind.BV_UGT).put((Object)Kind.BITVECTOR_SGE, (Object)FunctionDeclarationKind.BV_SGE).put((Object)Kind.BITVECTOR_UGE, (Object)FunctionDeclarationKind.BV_UGE).put((Object)Kind.BITVECTOR_SDIV, (Object)FunctionDeclarationKind.BV_SDIV).put((Object)Kind.BITVECTOR_UDIV, (Object)FunctionDeclarationKind.BV_UDIV).put((Object)Kind.BITVECTOR_SREM, (Object)FunctionDeclarationKind.BV_SREM).put((Object)Kind.BITVECTOR_UREM, (Object)FunctionDeclarationKind.BV_UREM).put((Object)Kind.BITVECTOR_NOT, (Object)FunctionDeclarationKind.BV_NOT).put((Object)Kind.BITVECTOR_NEG, (Object)FunctionDeclarationKind.BV_NEG).put((Object)Kind.BITVECTOR_EXTRACT, (Object)FunctionDeclarationKind.BV_EXTRACT).put((Object)Kind.BITVECTOR_CONCAT, (Object)FunctionDeclarationKind.BV_CONCAT).put((Object)Kind.BITVECTOR_SIGN_EXTEND, (Object)FunctionDeclarationKind.BV_SIGN_EXTENSION).put((Object)Kind.BITVECTOR_ZERO_EXTEND, (Object)FunctionDeclarationKind.BV_ZERO_EXTENSION).put((Object)Kind.BITVECTOR_SHL, (Object)FunctionDeclarationKind.BV_SHL).put((Object)Kind.BITVECTOR_ASHR, (Object)FunctionDeclarationKind.BV_ASHR).put((Object)Kind.BITVECTOR_LSHR, (Object)FunctionDeclarationKind.BV_LSHR).put((Object)Kind.TO_INTEGER, (Object)FunctionDeclarationKind.FLOOR).put((Object)Kind.TO_REAL, (Object)FunctionDeclarationKind.TO_REAL).put((Object)Kind.FLOATINGPOINT_TO_SBV, (Object)FunctionDeclarationKind.FP_CASTTO_SBV).put((Object)Kind.FLOATINGPOINT_TO_UBV, (Object)FunctionDeclarationKind.FP_CASTTO_UBV).put((Object)Kind.FLOATINGPOINT_TO_FP_FROM_FP, (Object)FunctionDeclarationKind.FP_CASTTO_FP).put((Object)Kind.FLOATINGPOINT_TO_FP_FROM_SBV, (Object)FunctionDeclarationKind.BV_SCASTTO_FP).put((Object)Kind.FLOATINGPOINT_TO_FP_FROM_UBV, (Object)FunctionDeclarationKind.BV_UCASTTO_FP).put((Object)Kind.FLOATINGPOINT_IS_NAN, (Object)FunctionDeclarationKind.FP_IS_NAN).put((Object)Kind.FLOATINGPOINT_IS_NEG, (Object)FunctionDeclarationKind.FP_IS_NEGATIVE).put((Object)Kind.FLOATINGPOINT_IS_INF, (Object)FunctionDeclarationKind.FP_IS_INF).put((Object)Kind.FLOATINGPOINT_IS_NORMAL, (Object)FunctionDeclarationKind.FP_IS_NORMAL).put((Object)Kind.FLOATINGPOINT_IS_SUBNORMAL, (Object)FunctionDeclarationKind.FP_IS_SUBNORMAL).put((Object)Kind.FLOATINGPOINT_IS_ZERO, (Object)FunctionDeclarationKind.FP_IS_ZERO).put((Object)Kind.FLOATINGPOINT_EQ, (Object)FunctionDeclarationKind.FP_EQ).put((Object)Kind.FLOATINGPOINT_ABS, (Object)FunctionDeclarationKind.FP_ABS).put((Object)Kind.FLOATINGPOINT_MAX, (Object)FunctionDeclarationKind.FP_MAX).put((Object)Kind.FLOATINGPOINT_MIN, (Object)FunctionDeclarationKind.FP_MIN).put((Object)Kind.FLOATINGPOINT_SQRT, (Object)FunctionDeclarationKind.FP_SQRT).put((Object)Kind.FLOATINGPOINT_ADD, (Object)FunctionDeclarationKind.FP_ADD).put((Object)Kind.FLOATINGPOINT_SUB, (Object)FunctionDeclarationKind.FP_SUB).put((Object)Kind.FLOATINGPOINT_MULT, (Object)FunctionDeclarationKind.FP_MUL).put((Object)Kind.FLOATINGPOINT_DIV, (Object)FunctionDeclarationKind.FP_DIV).put((Object)Kind.FLOATINGPOINT_NEG, (Object)FunctionDeclarationKind.FP_NEG).put((Object)Kind.FLOATINGPOINT_LT, (Object)FunctionDeclarationKind.FP_LT).put((Object)Kind.FLOATINGPOINT_LEQ, (Object)FunctionDeclarationKind.FP_LE).put((Object)Kind.FLOATINGPOINT_GT, (Object)FunctionDeclarationKind.FP_GT).put((Object)Kind.FLOATINGPOINT_GEQ, (Object)FunctionDeclarationKind.FP_GE).put((Object)Kind.FLOATINGPOINT_RTI, (Object)FunctionDeclarationKind.FP_ROUND_TO_INTEGRAL).put((Object)Kind.FLOATINGPOINT_TO_FP_FROM_IEEE_BV, (Object)FunctionDeclarationKind.FP_FROM_IEEEBV).put((Object)Kind.STRING_CONCAT, (Object)FunctionDeclarationKind.STR_CONCAT).put((Object)Kind.STRING_PREFIX, (Object)FunctionDeclarationKind.STR_PREFIX).put((Object)Kind.STRING_SUFFIX, (Object)FunctionDeclarationKind.STR_SUFFIX).put((Object)Kind.STRING_CONTAINS, (Object)FunctionDeclarationKind.STR_CONTAINS).put((Object)Kind.STRING_SUBSTR, (Object)FunctionDeclarationKind.STR_SUBSTRING).put((Object)Kind.STRING_REPLACE, (Object)FunctionDeclarationKind.STR_REPLACE).put((Object)Kind.STRING_REPLACE_ALL, (Object)FunctionDeclarationKind.STR_REPLACE_ALL).put((Object)Kind.STRING_CHARAT, (Object)FunctionDeclarationKind.STR_CHAR_AT).put((Object)Kind.STRING_LENGTH, (Object)FunctionDeclarationKind.STR_LENGTH).put((Object)Kind.STRING_INDEXOF, (Object)FunctionDeclarationKind.STR_INDEX_OF).put((Object)Kind.STRING_TO_REGEXP, (Object)FunctionDeclarationKind.STR_TO_RE).put((Object)Kind.STRING_IN_REGEXP, (Object)FunctionDeclarationKind.STR_IN_RE).put((Object)Kind.STRING_FROM_INT, (Object)FunctionDeclarationKind.INT_TO_STR).put((Object)Kind.STRING_TO_INT, (Object)FunctionDeclarationKind.STR_TO_INT).put((Object)Kind.STRING_LT, (Object)FunctionDeclarationKind.STR_LT).put((Object)Kind.STRING_LEQ, (Object)FunctionDeclarationKind.STR_LE).put((Object)Kind.REGEXP_PLUS, (Object)FunctionDeclarationKind.RE_PLUS).put((Object)Kind.REGEXP_STAR, (Object)FunctionDeclarationKind.RE_STAR).put((Object)Kind.REGEXP_OPT, (Object)FunctionDeclarationKind.RE_OPTIONAL).put((Object)Kind.REGEXP_CONCAT, (Object)FunctionDeclarationKind.RE_CONCAT).put((Object)Kind.REGEXP_UNION, (Object)FunctionDeclarationKind.RE_UNION).put((Object)Kind.REGEXP_RANGE, (Object)FunctionDeclarationKind.RE_RANGE).put((Object)Kind.REGEXP_INTER, (Object)FunctionDeclarationKind.RE_INTERSECT).put((Object)Kind.REGEXP_COMPLEMENT, (Object)FunctionDeclarationKind.RE_COMPLEMENT).put((Object)Kind.REGEXP_DIFF, (Object)FunctionDeclarationKind.RE_DIFFERENCE).build();

    protected CVC5FormulaCreator(Solver pSolver) {
        super(pSolver, pSolver.getBooleanSort(), pSolver.getIntegerSort(), pSolver.getRealSort(), pSolver.getStringSort(), pSolver.getRegExpSort());
        this.solver = pSolver;
    }

    @Override
    public Term makeVariable(Sort sort, String name) {
        this.checkSymbol(name);
        Term exp = this.variablesCache.computeIfAbsent(name, n -> this.solver.mkConst(sort, name));
        Preconditions.checkArgument((boolean)sort.equals((Object)exp.getSort()), (String)"symbol name %s with sort %s already in use for different sort %s", (Object)name, (Object)sort, (Object)exp.getSort());
        return exp;
    }

    public Term makeBoundCopy(Term var) {
        Sort sort = var.getSort();
        String name = this.getName(var);
        Term boundCopy = this.solver.mkVar(sort, name);
        return boundCopy;
    }

    @Override
    public Sort getBitvectorType(int pBitwidth) {
        try {
            return this.solver.mkBitVectorSort(pBitwidth);
        }
        catch (CVC5ApiException e) {
            throw new IllegalArgumentException("Cannot create bitvector sort with size " + pBitwidth + ".", e);
        }
    }

    @Override
    public Sort getFloatingPointType(FormulaType.FloatingPointType pType) {
        try {
            return this.solver.mkFloatingPointSort(pType.getExponentSize(), pType.getMantissaSize() + 1);
        }
        catch (CVC5ApiException e) {
            throw new IllegalArgumentException("Cannot create floatingpoint sort with exponent size " + pType.getExponentSize() + " and mantissa " + pType.getMantissaSize() + " (plus sign bit).", e);
        }
    }

    @Override
    public Sort getArrayType(Sort pIndexType, Sort pElementType) {
        return this.solver.mkArraySort(pIndexType, pElementType);
    }

    @Override
    public Term extractInfo(Formula pT) {
        return CVC5FormulaManager.getCVC5Term(pT);
    }

    @Override
    protected <TD extends Formula, TR extends Formula> FormulaType<TR> getArrayFormulaElementType(ArrayFormula<TD, TR> pArray) {
        return ((CVC5Formula.CVC5ArrayFormula)pArray).getElementType();
    }

    @Override
    protected <TD extends Formula, TR extends Formula> FormulaType<TD> getArrayFormulaIndexType(ArrayFormula<TD, TR> pArray) {
        return ((CVC5Formula.CVC5ArrayFormula)pArray).getIndexType();
    }

    @Override
    public <T extends Formula> FormulaType<T> getFormulaType(T pFormula) {
        Sort cvc5sort = this.extractInfo(pFormula).getSort();
        if (pFormula instanceof BitvectorFormula) {
            Preconditions.checkArgument((boolean)cvc5sort.isBitVector(), (String)"BitvectorFormula with actual Type %s: %s", (Object)cvc5sort, pFormula);
            return this.getFormulaType(this.extractInfo(pFormula));
        }
        if (pFormula instanceof FloatingPointFormula) {
            Preconditions.checkArgument((boolean)cvc5sort.isFloatingPoint(), (String)"FloatingPointFormula with actual Type %s: %s", (Object)cvc5sort, pFormula);
            return FormulaType.getFloatingPointType(cvc5sort.getFloatingPointExponentSize(), cvc5sort.getFloatingPointSignificandSize() - 1);
        }
        if (pFormula instanceof ArrayFormula) {
            FormulaType arrayIndexType = this.getArrayFormulaIndexType((ArrayFormula)pFormula);
            FormulaType arrayElementType = this.getArrayFormulaElementType((ArrayFormula)pFormula);
            return FormulaType.getArrayType(arrayIndexType, arrayElementType);
        }
        return super.getFormulaType(pFormula);
    }

    @Override
    public FormulaType<?> getFormulaType(Term pFormula) {
        return this.getFormulaTypeFromTermType(pFormula.getSort());
    }

    private FormulaType<?> getFormulaTypeFromTermType(Sort sort) {
        if (sort.isBoolean()) {
            return FormulaType.BooleanType;
        }
        if (sort.isInteger()) {
            return FormulaType.IntegerType;
        }
        if (sort.isBitVector()) {
            return FormulaType.getBitvectorTypeWithSize(sort.getBitVectorSize());
        }
        if (sort.isFloatingPoint()) {
            return FormulaType.getFloatingPointType(sort.getFloatingPointExponentSize(), sort.getFloatingPointSignificandSize() - 1);
        }
        if (sort.isRoundingMode()) {
            return FormulaType.FloatingPointRoundingModeType;
        }
        if (sort.isReal()) {
            return FormulaType.RationalType;
        }
        if (sort.isArray()) {
            FormulaType<?> indexType = this.getFormulaTypeFromTermType(sort.getArrayIndexSort());
            FormulaType<?> elementType = this.getFormulaTypeFromTermType(sort.getArrayElementSort());
            return FormulaType.getArrayType(indexType, elementType);
        }
        if (sort.isString()) {
            return FormulaType.StringType;
        }
        if (sort.isRegExp()) {
            return FormulaType.RegexType;
        }
        if (sort.isFunction()) {
            return this.getFormulaTypeFromTermType(sort.getFunctionCodomainSort());
        }
        throw new AssertionError((Object)String.format("Encountered unhandled Type '%s'.", sort));
    }

    @Override
    public <T extends Formula> T encapsulate(FormulaType<T> pType, Term pTerm) {
        assert (pType.equals(this.getFormulaType(pTerm)) || pType.equals(FormulaType.RationalType) && this.getFormulaType(pTerm).equals(FormulaType.IntegerType)) : String.format("Cannot encapsulate formula %s of Type %s as %s", pTerm, this.getFormulaType(pTerm), pType);
        if (pType.isBooleanType()) {
            return (T)new CVC5Formula.CVC5BooleanFormula(pTerm);
        }
        if (pType.isIntegerType()) {
            return (T)new CVC5Formula.CVC5IntegerFormula(pTerm);
        }
        if (pType.isRationalType()) {
            return (T)new CVC5Formula.CVC5RationalFormula(pTerm);
        }
        if (pType.isArrayType()) {
            FormulaType.ArrayFormulaType arrFt = (FormulaType.ArrayFormulaType)pType;
            return (T)new CVC5Formula.CVC5ArrayFormula(pTerm, arrFt.getIndexType(), arrFt.getElementType());
        }
        if (pType.isBitvectorType()) {
            return (T)new CVC5Formula.CVC5BitvectorFormula(pTerm);
        }
        if (pType.isFloatingPointType()) {
            return (T)new CVC5Formula.CVC5FloatingPointFormula(pTerm);
        }
        if (pType.isFloatingPointRoundingModeType()) {
            return (T)new CVC5Formula.CVC5FloatingPointRoundingModeFormula(pTerm);
        }
        if (pType.isStringType()) {
            return (T)new CVC5Formula.CVC5StringFormula(pTerm);
        }
        if (pType.isRegexType()) {
            return (T)new CVC5Formula.CVC5RegexFormula(pTerm);
        }
        throw new IllegalArgumentException("Cannot create formulas of Type " + pType + " in CVC5");
    }

    private Formula encapsulate(Term pTerm) {
        return this.encapsulate(this.getFormulaType(pTerm), pTerm);
    }

    @Override
    public BooleanFormula encapsulateBoolean(Term pTerm) {
        assert (this.getFormulaType(pTerm).isBooleanType()) : String.format("%s is not boolean, but %s (%s)", pTerm, pTerm.getSort(), this.getFormulaType(pTerm));
        return new CVC5Formula.CVC5BooleanFormula(pTerm);
    }

    @Override
    public BitvectorFormula encapsulateBitvector(Term pTerm) {
        assert (this.getFormulaType(pTerm).isBitvectorType()) : String.format("%s is no BV, but %s (%s)", pTerm, pTerm.getSort(), this.getFormulaType(pTerm));
        return new CVC5Formula.CVC5BitvectorFormula(pTerm);
    }

    @Override
    protected FloatingPointFormula encapsulateFloatingPoint(Term pTerm) {
        assert (this.getFormulaType(pTerm).isFloatingPointType()) : String.format("%s is no FP, but %s (%s)", pTerm, pTerm.getSort(), this.getFormulaType(pTerm));
        return new CVC5Formula.CVC5FloatingPointFormula(pTerm);
    }

    @Override
    protected <TI extends Formula, TE extends Formula> ArrayFormula<TI, TE> encapsulateArray(Term pTerm, FormulaType<TI> pIndexType, FormulaType<TE> pElementType) {
        assert (this.getFormulaType(pTerm).equals(FormulaType.getArrayType(pIndexType, pElementType))) : String.format("%s is no array, but %s (%s)", pTerm, pTerm.getSort(), this.getFormulaType(pTerm));
        return new CVC5Formula.CVC5ArrayFormula<TI, TE>(pTerm, pIndexType, pElementType);
    }

    @Override
    protected StringFormula encapsulateString(Term pTerm) {
        assert (this.getFormulaType(pTerm).isStringType()) : String.format("%s is no String, but %s (%s)", pTerm, pTerm.getSort(), this.getFormulaType(pTerm));
        return new CVC5Formula.CVC5StringFormula(pTerm);
    }

    @Override
    protected RegexFormula encapsulateRegex(Term pTerm) {
        assert (this.getFormulaType(pTerm).isRegexType());
        return new CVC5Formula.CVC5RegexFormula(pTerm);
    }

    private String getName(Term e) {
        Preconditions.checkState((!e.isNull() ? 1 : 0) != 0);
        String repr = e.toString();
        try {
            if (e.getKind() == Kind.APPLY_UF) {
                e = e.getChild(0);
            }
        }
        catch (CVC5ApiException cVC5ApiException) {
            // empty catch block
        }
        if (e.hasSymbol()) {
            return e.getSymbol();
        }
        if (repr.startsWith("(")) {
            String dequoted = CVC5FormulaCreator.dequote(repr);
            return (String)Iterables.get((Iterable)Splitter.on((char)' ').split((CharSequence)dequoted.substring(1)), (int)0);
        }
        return CVC5FormulaCreator.dequote(repr);
    }

    @Override
    public <R> R visit(FormulaVisitor<R> visitor, Formula formula, Term f) {
        Preconditions.checkState((!f.isNull() ? 1 : 0) != 0);
        Sort sort = f.getSort();
        try {
            if (f.isBooleanValue()) {
                return visitor.visitConstant(formula, f.getBooleanValue());
            }
            if (f.isStringValue()) {
                return visitor.visitConstant(formula, f.getStringValue());
            }
            if (f.isRealValue()) {
                Pair realValue = f.getRealValue();
                Object number = BigInteger.ONE.equals(realValue.second) ? realValue.first : Rational.of((BigInteger)realValue.first, (BigInteger)realValue.second);
                return visitor.visitConstant(formula, number);
            }
            if (f.isIntegerValue()) {
                return visitor.visitConstant(formula, f.getIntegerValue());
            }
            if (f.isBitVectorValue()) {
                return visitor.visitConstant(formula, new BigInteger(f.getBitVectorValue(), 2));
            }
            if (f.isFloatingPointValue()) {
                return visitor.visitConstant(formula, f.toString());
            }
            if (f.getKind() == Kind.CONST_ROUNDINGMODE) {
                return visitor.visitConstant(formula, f.toString());
            }
            if (f.getKind() == Kind.VARIABLE) {
                Term originalVar = this.variablesCache.get(CVC5FormulaCreator.dequote(formula.toString()));
                return visitor.visitBoundVariable(this.encapsulate(originalVar), 0);
            }
            if (f.getKind() == Kind.FORALL || f.getKind() == Kind.EXISTS) {
                assert (f.getNumChildren() == 2);
                Term body = f.getChild(1);
                ArrayList<Formula> freeVars = new ArrayList<Formula>();
                for (Term boundVar : f.getChild(0)) {
                    String name = this.getName(boundVar);
                    Term freeVar = (Term)Preconditions.checkNotNull((Object)this.variablesCache.get(name));
                    body = body.substitute(boundVar, freeVar);
                    freeVars.add(this.encapsulate(freeVar));
                }
                BooleanFormula fBody = this.encapsulateBoolean(body);
                QuantifiedFormulaManager.Quantifier quant = f.getKind() == Kind.EXISTS ? QuantifiedFormulaManager.Quantifier.EXISTS : QuantifiedFormulaManager.Quantifier.FORALL;
                return visitor.visitQuantifier((BooleanFormula)formula, quant, freeVars, fBody);
            }
            if (f.getKind() == Kind.CONSTANT) {
                return visitor.visitFreeVariable(formula, CVC5FormulaCreator.dequote(f.toString()));
            }
            ImmutableList.Builder argsBuilder = ImmutableList.builder();
            ArrayList argsTypes = new ArrayList();
            Kind kind = f.getKind();
            if (sort.isFunction() || kind == Kind.APPLY_UF) {
                for (int i = 1; i < f.getNumChildren(); ++i) {
                    argsTypes.add(this.getFormulaTypeFromTermType(f.getChild(i).getSort()));
                    argsBuilder.add((Object)this.encapsulate(f.getChild(i)));
                }
            } else {
                for (Term arg : f) {
                    argsTypes.add(this.getFormulaType(arg));
                    argsBuilder.add((Object)this.encapsulate(arg));
                }
            }
            if (sort.isFunction()) {
                return visitor.visitFunction(formula, (List<Formula>)argsBuilder.build(), FunctionDeclarationImpl.of(this.getName(f), this.getDeclarationKind(f), argsTypes, this.getFormulaType(f), this.normalize(f)));
            }
            if (kind == Kind.APPLY_UF) {
                return visitor.visitFunction(formula, (List<Formula>)argsBuilder.build(), FunctionDeclarationImpl.of(this.getName(f), this.getDeclarationKind(f), argsTypes, this.getFormulaType(f), this.normalize(f.getChild(0))));
            }
            return visitor.visitFunction(formula, (List<Formula>)argsBuilder.build(), FunctionDeclarationImpl.of(this.getName(f), this.getDeclarationKind(f), argsTypes, this.getFormulaType(f), this.normalize(f)));
        }
        catch (CVC5ApiException e) {
            throw new IllegalArgumentException("Failure visiting the Term '" + f + "'.", e);
        }
    }

    private Term normalize(Term operator) {
        Term function = this.functionsCache.get(this.getName(operator));
        if (function != null) {
            Preconditions.checkState((function.getId() == operator.getId() ? 1 : 0) != 0, (String)"operator '%s' with ID %s differs from existing function '%s' with ID '%s'.", (Object)operator, (Object)operator.getId(), (Object)function, (Object)function.getId());
            return function;
        }
        return operator;
    }

    private FunctionDeclarationKind getDeclarationKind(Term f) {
        try {
            Kind kind = f.getKind();
            if (kind == Kind.EQUAL && Iterables.all((Iterable)f, child -> child.getSort().isBoolean())) {
                return FunctionDeclarationKind.IFF;
            }
            return (FunctionDeclarationKind)((Object)KIND_MAPPING.getOrDefault((Object)kind, (Object)FunctionDeclarationKind.OTHER));
        }
        catch (CVC5ApiException e) {
            throw new IllegalArgumentException("Failure trying to get the KIND of Term '" + f + "'.", e);
        }
    }

    @Override
    protected Term getBooleanVarDeclarationImpl(Term pTFormulaInfo) {
        try {
            Kind kind = pTFormulaInfo.getKind();
            assert (kind == Kind.APPLY_UF || kind == Kind.CONSTANT) : pTFormulaInfo.getKind();
            if (kind == Kind.APPLY_UF) {
                return pTFormulaInfo.getChild(0);
            }
            return pTFormulaInfo;
        }
        catch (CVC5ApiException e) {
            throw new IllegalArgumentException("You tried reading a bool variable potentially in a UF application that failed. Checked term: " + pTFormulaInfo + ".", e);
        }
    }

    @Override
    public Term callFunctionImpl(Term pDeclaration, List<Term> pArgs) {
        if (pArgs.isEmpty()) {
            return pDeclaration;
        }
        if (pDeclaration.hasOp()) {
            Op op = pDeclaration.getOp();
            return this.solver.mkTerm(op, pArgs.toArray(new Term[0]));
        }
        try {
            Sort[] paramSorts = pDeclaration.getSort().getFunctionDomainSorts();
            List<Term> args = this.castToParamTypeIfRequired(pArgs, paramSorts);
            Kind kind = pDeclaration.getKind();
            if (kind == Kind.CONSTANT) {
                kind = Kind.APPLY_UF;
                args.add(0, pDeclaration);
            }
            return this.solver.mkTerm(kind, args.toArray(new Term[0]));
        }
        catch (CVC5ApiException e) {
            throw new IllegalArgumentException("Failure when building the UF '" + pDeclaration + "' with arguments '" + pArgs + "'.", e);
        }
    }

    private List<Term> castToParamTypeIfRequired(List<Term> pArgs, Sort[] pParamSorts) {
        ArrayList<Term> args = new ArrayList<Term>();
        for (int i = 0; i < pArgs.size(); ++i) {
            args.add(this.castToParamTypeIfRequired(pArgs.get(i), pParamSorts.length > i ? pParamSorts[i] : null));
        }
        return args;
    }

    private Term castToParamTypeIfRequired(Term input, @Nullable Sort targetSort) {
        if (input.getSort().isInteger() && targetSort.isReal()) {
            return this.solver.mkTerm(Kind.TO_REAL, input);
        }
        return input;
    }

    private void checkSymbol(String symbol) {
        Preconditions.checkArgument((!UNSUPPORTED_IDENTIFIERS.contains((Object)symbol) ? 1 : 0) != 0, (String)"CVC5 does not support %s as identifier.", (Object)symbol);
    }

    @Override
    public Term declareUFImpl(String pName, Sort pReturnType, List<Sort> pArgTypes) {
        this.checkSymbol(pName);
        Term exp = this.functionsCache.get(pName);
        if (exp == null) {
            Sort sort = pArgTypes.isEmpty() ? pReturnType : this.solver.mkFunctionSort(pArgTypes.toArray(new Sort[0]), pReturnType);
            exp = this.solver.mkConst(sort, pName);
            this.functionsCache.put(pName, exp);
        } else {
            Preconditions.checkArgument((boolean)exp.getSort().equals((Object)exp.getSort()), (String)"Symbol %s already in use for different return type %s", (Object)exp, (Object)exp.getSort());
            for (int i = 1; i < exp.getNumChildren(); ++i) {
                try {
                    Preconditions.checkArgument((boolean)pArgTypes.get(i).equals((Object)exp.getChild(i).getSort()), (String)"Argument %s with type %s does not match expected type %s", (Object)(i - 1), (Object)pArgTypes.get(i), (Object)exp.getChild(i).getSort());
                    continue;
                }
                catch (CVC5ApiException e) {
                    throw new IllegalArgumentException("Failure visiting the Term '" + exp + "' at index " + i + ".", e);
                }
            }
        }
        return exp;
    }

    @Override
    public Object convertValue(Term expForType, Term value) {
        Sort type = expForType.getSort();
        Sort valueType = value.getSort();
        try {
            if (value.getKind() == Kind.VARIABLE) {
                return value.getSymbol();
            }
            if (value.isIntegerValue()) {
                return value.getIntegerValue();
            }
            if (value.isRealValue()) {
                Pair realValue = value.getRealValue();
                return Rational.of((BigInteger)realValue.first, (BigInteger)realValue.second);
            }
            if (value.isBitVectorValue()) {
                String bitvectorValue = value.getBitVectorValue();
                return new BigInteger(bitvectorValue, 2);
            }
            if (value.isFloatingPointNaN()) {
                return Float.valueOf(Float.NaN);
            }
            if (value.isFloatingPointNegInf()) {
                return Float.valueOf(Float.NEGATIVE_INFINITY);
            }
            if (value.isFloatingPointPosInf()) {
                return Float.valueOf(Float.POSITIVE_INFINITY);
            }
            if (value.isFloatingPointPosZero()) {
                return BigDecimal.ZERO;
            }
            if (value.isFloatingPointValue()) {
                Triplet fpValue = value.getFloatingPointValue();
                long expWidth = (Long)fpValue.first;
                long mantWidth = (Long)fpValue.second - 1L;
                Term bvValue = (Term)fpValue.third;
                Preconditions.checkState((boolean)bvValue.isBitVectorValue());
                BigInteger bits = new BigInteger(bvValue.getBitVectorValue(), 2);
                if (expWidth == 11L && mantWidth == 52L) {
                    return Double.longBitsToDouble(bits.longValue());
                }
                if (expWidth == 8L && mantWidth == 23L) {
                    return Float.valueOf(Float.intBitsToFloat(bits.intValue()));
                }
                return value.toString();
            }
            if (value.isBooleanValue()) {
                return value.getBooleanValue();
            }
            if (value.isStringValue()) {
                return value.getStringValue();
            }
            return value.toString();
        }
        catch (CVC5ApiException e) {
            throw new IllegalArgumentException(String.format("Failure trying to convert constant %s with type %s to type %s.", value, valueType, type), e);
        }
    }
}

