/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.java_smt.solvers.cvc5;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import io.github.cvc5.CVC5ApiException;
import io.github.cvc5.Kind;
import io.github.cvc5.Solver;
import io.github.cvc5.Sort;
import io.github.cvc5.Term;
import java.util.Collection;
import java.util.List;
import org.sosy_lab.java_smt.api.BooleanFormula;
import org.sosy_lab.java_smt.api.Formula;
import org.sosy_lab.java_smt.api.FormulaManager;
import org.sosy_lab.java_smt.api.Model;
import org.sosy_lab.java_smt.basicimpl.AbstractModel;
import org.sosy_lab.java_smt.solvers.cvc5.CVC5AbstractProver;
import org.sosy_lab.java_smt.solvers.cvc5.CVC5FormulaCreator;

public class CVC5Model
extends AbstractModel.CachingAbstractModel<Term, Sort, Solver> {
    private final ImmutableList<Model.ValueAssignment> model;
    private final Solver solver;
    private final ImmutableList<Term> assertedExpressions;
    private final CVC5AbstractProver<?> prover;
    private final FormulaManager mgr;
    protected boolean closed = false;

    CVC5Model(CVC5AbstractProver<?> pProver, FormulaManager pMgr, CVC5FormulaCreator pCreator, Collection<Term> pAssertedExpressions) {
        super(pCreator);
        this.solver = pProver.solver;
        this.prover = pProver;
        this.mgr = pMgr;
        this.assertedExpressions = ImmutableList.copyOf(pAssertedExpressions);
        this.model = this.generateModel();
    }

    @Override
    public Term evalImpl(Term f) {
        Preconditions.checkState((!this.closed ? 1 : 0) != 0);
        return this.solver.getValue(f);
    }

    private ImmutableList<Model.ValueAssignment> generateModel() {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        for (Term expr : this.assertedExpressions) {
            this.recursiveAssignmentFinder((ImmutableSet.Builder<Model.ValueAssignment>)builder, expr);
        }
        return builder.build().asList();
    }

    private void recursiveAssignmentFinder(ImmutableSet.Builder<Model.ValueAssignment> builder, Term expr) {
        try {
            Sort sort = expr.getSort();
            Kind kind = expr.getKind();
            if (kind == Kind.VARIABLE || sort.isFunction()) {
                return;
            }
            if (kind == Kind.CONSTANT) {
                builder.add((Object)this.getAssignment(expr));
            } else if (kind == Kind.FORALL || kind == Kind.EXISTS) {
                Term body = expr.getChild(1);
                this.recursiveAssignmentFinder(builder, body);
            } else if (kind != Kind.CONST_STRING && kind != Kind.CONST_ARRAY && kind != Kind.CONST_BITVECTOR && kind != Kind.CONST_BOOLEAN && kind != Kind.CONST_FLOATINGPOINT && kind != Kind.CONST_RATIONAL && kind != Kind.CONST_ROUNDINGMODE && kind != Kind.CONST_SEQUENCE) {
                if (kind == Kind.APPLY_UF) {
                    builder.add((Object)this.getAssignmentForUf(expr));
                } else {
                    for (Term child : expr) {
                        this.recursiveAssignmentFinder(builder, child);
                    }
                }
            }
        }
        catch (CVC5ApiException e) {
            throw new IllegalArgumentException("Failure visiting the Term '" + expr + "'.", e);
        }
    }

    private Model.ValueAssignment getAssignmentForUf(Term pKeyTerm) {
        Term valueTerm;
        String nameStr;
        ImmutableList.Builder argumentInterpretationBuilder = ImmutableList.builder();
        boolean boundFound = false;
        for (int i = 1; i < pKeyTerm.getNumChildren(); ++i) {
            try {
                Term child = pKeyTerm.getChild(i);
                if (child.getKind().equals((Object)Kind.VARIABLE)) {
                    boundFound = true;
                    argumentInterpretationBuilder.add((Object)child.toString());
                    continue;
                }
                argumentInterpretationBuilder.add(this.evaluateImpl(child));
                continue;
            }
            catch (CVC5ApiException e) {
                throw new IllegalArgumentException("Failure visiting the Term '" + pKeyTerm + "'.", e);
            }
        }
        try {
            nameStr = pKeyTerm.getChild(0).getSymbol();
        }
        catch (CVC5ApiException e) {
            nameStr = "UF";
        }
        if (nameStr.startsWith("|") && nameStr.endsWith("|")) {
            nameStr = nameStr.substring(1, nameStr.length() - 1);
        }
        if (!boundFound) {
            valueTerm = this.solver.getValue(pKeyTerm);
        } else {
            try {
                valueTerm = this.solver.getValue(pKeyTerm.getChild(0)).getChild(1);
            }
            catch (CVC5ApiException e) {
                throw new IndexOutOfBoundsException("Accessed a non existing UF value while creating a CVC5 model.");
            }
        }
        Formula keyFormula = this.creator.encapsulateWithTypeOf(pKeyTerm);
        Formula valueFormula = this.creator.encapsulateWithTypeOf(valueTerm);
        BooleanFormula equation = this.creator.encapsulateBoolean(this.solver.mkTerm(Kind.EQUAL, pKeyTerm, valueTerm));
        Object value = this.creator.convertValue(pKeyTerm, valueTerm);
        return new Model.ValueAssignment(keyFormula, valueFormula, equation, nameStr, value, (List<?>)argumentInterpretationBuilder.build());
    }

    private Model.ValueAssignment getAssignment(Term pKeyTerm) {
        ImmutableList.Builder argumentInterpretationBuilder = ImmutableList.builder();
        for (int i = 0; i < pKeyTerm.getNumChildren(); ++i) {
            try {
                argumentInterpretationBuilder.add(this.evaluateImpl(pKeyTerm.getChild(i)));
                continue;
            }
            catch (CVC5ApiException e) {
                throw new IndexOutOfBoundsException("Accessed a non existing UF value while creating a CVC5 model.");
            }
        }
        String nameStr = "";
        nameStr = pKeyTerm.hasSymbol() ? pKeyTerm.getSymbol() : "UNKNOWN_VARIABLE";
        if (nameStr.startsWith("|") && nameStr.endsWith("|")) {
            nameStr = nameStr.substring(1, nameStr.length() - 1);
        }
        Term valueTerm = this.solver.getValue(pKeyTerm);
        Formula keyFormula = this.creator.encapsulateWithTypeOf(pKeyTerm);
        Formula valueFormula = this.creator.encapsulateWithTypeOf(valueTerm);
        BooleanFormula equation = this.creator.encapsulateBoolean(this.solver.mkTerm(Kind.EQUAL, pKeyTerm, valueTerm));
        Object value = this.creator.convertValue(pKeyTerm, valueTerm);
        return new Model.ValueAssignment(keyFormula, valueFormula, equation, nameStr, value, (List<?>)argumentInterpretationBuilder.build());
    }

    @Override
    public void close() {
        this.prover.unregisterModel(this);
        this.closed = true;
    }

    @Override
    protected ImmutableList<Model.ValueAssignment> toList() {
        return this.model;
    }
}

