/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.java_smt.solvers.princess;

import ap.SimpleAPI;
import ap.parser.BooleanCompactifier;
import ap.parser.Environment;
import ap.parser.IAtom;
import ap.parser.IConstant;
import ap.parser.IExpression;
import ap.parser.IFormula;
import ap.parser.IFunApp;
import ap.parser.IFunction;
import ap.parser.IIntFormula;
import ap.parser.ITerm;
import ap.parser.Parser2InputAbsy;
import ap.parser.PartialEvaluator;
import ap.parser.SMTLineariser;
import ap.parser.SMTParser2InputAbsy;
import ap.terfor.ConstantTerm;
import ap.terfor.preds.Predicate;
import ap.theories.ExtArray;
import ap.theories.bitvectors.ModuloArithmetic;
import ap.theories.rationals.Fractions;
import ap.types.Sort;
import ap.types.Sort$;
import ap.util.Debug;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.common.io.Files;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.nio.file.Path;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeMap;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.sosy_lab.common.Appender;
import org.sosy_lab.common.Appenders;
import org.sosy_lab.common.ShutdownNotifier;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.FileOption;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.configuration.Options;
import org.sosy_lab.common.io.PathCounterTemplate;
import org.sosy_lab.java_smt.api.FormulaType;
import org.sosy_lab.java_smt.api.SolverContext;
import org.sosy_lab.java_smt.solvers.princess.PrincessAbstractProver;
import org.sosy_lab.java_smt.solvers.princess.PrincessFormulaCreator;
import org.sosy_lab.java_smt.solvers.princess.PrincessFormulaManager;
import org.sosy_lab.java_smt.solvers.princess.PrincessInterpolatingProver;
import org.sosy_lab.java_smt.solvers.princess.PrincessTheoremProver;
import scala.MatchError;
import scala.Option;
import scala.Some;
import scala.Tuple2;
import scala.Tuple4;
import scala.collection.Iterable;
import scala.collection.JavaConverters;
import scala.collection.Map;
import scala.collection.Seq;

@Options(prefix="solver.princess")
class PrincessEnvironment {
    @org.sosy_lab.common.configuration.Option(secure=true, description="The number of atoms a term has to have before it gets abbreviated if there are more identical terms.")
    private int minAtomsForAbbreviation = 100;
    @org.sosy_lab.common.configuration.Option(secure=true, description="Enable additional assertion checks within Princess. The main usage is debugging. This option can cause a performance overhead.")
    private boolean enableAssertions = false;
    public static final Sort BOOL_SORT = Sort$.MODULE$.Bool();
    public static final Sort INTEGER_SORT = Sort.Integer$.MODULE$;
    @org.sosy_lab.common.configuration.Option(secure=true, description="log all queries as Princess-specific Scala code")
    private boolean logAllQueriesAsScala = false;
    @org.sosy_lab.common.configuration.Option(secure=true, description="file for Princess-specific dump of queries as Scala code")
    @FileOption(value=FileOption.Type.OUTPUT_FILE)
    private PathCounterTemplate logAllQueriesAsScalaFile = PathCounterTemplate.ofFormatString("princess-query-%03d-");
    private final java.util.Map<String, IFormula> boolVariablesCache = new HashMap<String, IFormula>();
    private final java.util.Map<String, ITerm> sortedVariablesCache = new HashMap<String, ITerm>();
    private final java.util.Map<String, IFunction> functionsCache = new HashMap<String, IFunction>();
    private final int randomSeed;
    private final @Nullable PathCounterTemplate basicLogfile;
    private final ShutdownNotifier shutdownNotifier;
    private final SimpleAPI api;
    private final List<PrincessAbstractProver<?, ?>> registeredProvers = new ArrayList();

    PrincessEnvironment(Configuration config, @Nullable PathCounterTemplate pBasicLogfile, ShutdownNotifier pShutdownNotifier, int pRandomSeed) throws InvalidConfigurationException {
        config.inject(this);
        this.basicLogfile = pBasicLogfile;
        this.shutdownNotifier = pShutdownNotifier;
        this.randomSeed = pRandomSeed;
        this.api = this.getNewApi(false);
    }

    PrincessAbstractProver<?, ?> getNewProver(boolean useForInterpolation, PrincessFormulaManager mgr, PrincessFormulaCreator creator, Set<SolverContext.ProverOptions> pOptions) {
        SimpleAPI newApi = this.getNewApi(useForInterpolation || pOptions.contains((Object)SolverContext.ProverOptions.GENERATE_UNSAT_CORE));
        this.boolVariablesCache.values().forEach(arg_0 -> ((SimpleAPI)newApi).addBooleanVariable(arg_0));
        this.sortedVariablesCache.values().forEach(arg_0 -> ((SimpleAPI)newApi).addConstant(arg_0));
        this.functionsCache.values().forEach(arg_0 -> ((SimpleAPI)newApi).addFunction(arg_0));
        PrincessAbstractProver prover = useForInterpolation ? new PrincessInterpolatingProver(mgr, creator, newApi, this.shutdownNotifier, pOptions) : new PrincessTheoremProver(mgr, creator, newApi, this.shutdownNotifier, pOptions);
        this.registeredProvers.add(prover);
        return prover;
    }

    @SuppressFBWarnings(value={"NP_NULL_ON_SOME_PATH_FROM_RETURN_VALUE"})
    private SimpleAPI getNewApi(boolean constructProofs) {
        Path logPath;
        File directory = null;
        Object smtDumpBasename = null;
        String scalaDumpBasename = null;
        if (this.basicLogfile != null) {
            logPath = this.basicLogfile.getFreshPath();
            directory = this.getAbsoluteParent(logPath);
            smtDumpBasename = logPath.getFileName().toString();
            if (Files.getFileExtension((String)smtDumpBasename).equals("smt2")) {
                smtDumpBasename = Files.getNameWithoutExtension((String)smtDumpBasename);
            }
            smtDumpBasename = (String)smtDumpBasename + "-";
        }
        if (this.logAllQueriesAsScala && this.logAllQueriesAsScalaFile != null) {
            logPath = this.logAllQueriesAsScalaFile.getFreshPath();
            if (directory == null) {
                directory = this.getAbsoluteParent(logPath);
            }
            scalaDumpBasename = logPath.getFileName().toString();
        }
        Debug.enableAllAssertions((boolean)this.enableAssertions);
        SimpleAPI newApi = SimpleAPI.apply((boolean)this.enableAssertions, (boolean)false, (smtDumpBasename != null ? 1 : 0) != 0, (String)smtDumpBasename, (scalaDumpBasename != null ? 1 : 0) != 0, (String)scalaDumpBasename, (File)directory, (boolean)SimpleAPI.apply$default$8(), (boolean)SimpleAPI.apply$default$9(), (Option)new Some((Object)this.randomSeed));
        if (constructProofs) {
            newApi.setConstructProofs(true);
        }
        return newApi;
    }

    private File getAbsoluteParent(Path path) {
        return Optional.ofNullable(path.getParent()).orElse(Path.of(".", new String[0])).toAbsolutePath().toFile();
    }

    int getMinAtomsForAbbreviation() {
        return this.minAtomsForAbbreviation;
    }

    void unregisterStack(PrincessAbstractProver<?, ?> stack) {
        Preconditions.checkState((boolean)this.registeredProvers.contains(stack), (Object)"cannot unregister stack, it is not registered");
        this.registeredProvers.remove(stack);
    }

    void close() {
        for (PrincessAbstractProver prover : ImmutableList.copyOf(this.registeredProvers)) {
            prover.close();
        }
        this.api.shutDown();
        this.api.reset();
        Preconditions.checkState((boolean)this.registeredProvers.isEmpty());
    }

    public List<? extends IExpression> parseStringToTerms(String s, PrincessFormulaCreator creator) {
        Tuple4<scala.collection.immutable.Seq<IFormula>, scala.collection.immutable.Map<IFunction, SMTParser2InputAbsy.SMTFunctionType>, scala.collection.immutable.Map<ConstantTerm, SMTParser2InputAbsy.SMTType>, scala.collection.immutable.Map<Predicate, SMTParser2InputAbsy.SMTFunctionType>> parserResult;
        try {
            parserResult = this.extractFromSTMLIB(s);
        }
        catch (Environment.EnvironmentException | Parser2InputAbsy.TranslationException nested) {
            throw new IllegalArgumentException(nested);
        }
        List formulas = JavaConverters.asJava((Seq)((Seq)parserResult._1()));
        ImmutableSet.Builder declaredFunctions = ImmutableSet.builder();
        for (IExpression f : formulas) {
            declaredFunctions.addAll(creator.extractVariablesAndUFs(f, true).values());
        }
        for (IExpression var : declaredFunctions.build()) {
            if (var instanceof IConstant) {
                this.sortedVariablesCache.put(((IConstant)var).c().name(), (ITerm)var);
                this.addSymbol((ITerm)((IConstant)var));
                continue;
            }
            if (var instanceof IAtom) {
                this.boolVariablesCache.put(((IAtom)var).pred().name(), (IFormula)var);
                this.addSymbol((IFormula)((IAtom)var));
                continue;
            }
            if (!(var instanceof IFunApp)) continue;
            IFunction fun = ((IFunApp)var).fun();
            this.functionsCache.put(fun.name(), fun);
            this.addFunction(fun);
        }
        return formulas;
    }

    private Tuple4<scala.collection.immutable.Seq<IFormula>, scala.collection.immutable.Map<IFunction, SMTParser2InputAbsy.SMTFunctionType>, scala.collection.immutable.Map<ConstantTerm, SMTParser2InputAbsy.SMTType>, scala.collection.immutable.Map<Predicate, SMTParser2InputAbsy.SMTFunctionType>> extractFromSTMLIB(String s) throws Environment.EnvironmentException, Parser2InputAbsy.TranslationException {
        boolean fullyInlineLetsAndFunctions = true;
        return this.api.extractSMTLIBAssertionsSymbols((Reader)new StringReader(s), true);
    }

    @SuppressFBWarnings(value={"THROWS_METHOD_THROWS_CLAUSE_THROWABLE"})
    private static <E extends Throwable> void throwCheckedAsUnchecked(Throwable e) throws E {
        throw e;
    }

    public Appender dumpFormula(IFormula formula, final PrincessFormulaCreator creator) {
        Tuple2 tuple = this.api.abbrevSharedExpressionsWithMap((IExpression)formula, 1);
        final IExpression lettedFormula = (IExpression)tuple._1();
        final java.util.Map abbrevMap = JavaConverters.asJava((Map)((Map)tuple._2()));
        return new Appenders.AbstractAppender(){

            @Override
            public void appendTo(Appendable out) throws IOException {
                try {
                    this.appendTo0(out);
                }
                catch (MatchError e) {
                    if (PrincessEnvironment.this.shutdownNotifier.shouldShutdown()) {
                        InterruptedException interrupt = new InterruptedException();
                        interrupt.addSuppressed(e);
                        PrincessEnvironment.throwCheckedAsUnchecked(interrupt);
                    }
                    throw e;
                }
            }

            private void appendTo0(Appendable out) throws IOException {
                LinkedHashSet<IExpression> allVars = new LinkedHashSet<IExpression>(creator.extractVariablesAndUFs(lettedFormula, true).values());
                TreeMap<String, IExpression> symbols = new TreeMap<String, IExpression>();
                TreeMap<String, IFunApp> ufs = new TreeMap<String, IFunApp>();
                TreeMap<String, IExpression> usedAbbrevs = new TreeMap<String, IExpression>();
                this.collectAllSymbolsAndAbbreviations(allVars, symbols, ufs, usedAbbrevs);
                for (Map.Entry symbol : symbols.entrySet()) {
                    out.append(String.format("(declare-fun %s () %s)%n", SMTLineariser.quoteIdentifier((String)((String)symbol.getKey())), PrincessEnvironment.getFormulaType((IExpression)symbol.getValue()).toSMTLIBString()));
                }
                for (Map.Entry function : ufs.entrySet()) {
                    List argSorts = Lists.transform((List)JavaConverters.asJava((Seq)((IFunApp)function.getValue()).args()), a -> PrincessEnvironment.getFormulaType((IExpression)a).toSMTLIBString());
                    out.append(String.format("(declare-fun %s (%s) %s)%n", SMTLineariser.quoteIdentifier((String)((String)function.getKey())), Joiner.on((String)" ").join((java.lang.Iterable)argSorts), PrincessEnvironment.getFormulaType((IExpression)function.getValue()).toSMTLIBString()));
                }
                for (String abbrev : this.getOrderedAbbreviations(usedAbbrevs)) {
                    IExpression abbrevFormula = (IExpression)usedAbbrevs.get(abbrev);
                    IExpression fullFormula = (IExpression)abbrevMap.get(abbrevFormula);
                    out.append(String.format("(define-fun %s () %s %s)%n", SMTLineariser.quoteIdentifier((String)abbrev), PrincessEnvironment.getFormulaType(fullFormula).toSMTLIBString(), SMTLineariser.asString((IExpression)fullFormula)));
                }
                out.append("(assert ").append(SMTLineariser.asString((IExpression)lettedFormula)).append(')');
            }

            private void collectAllSymbolsAndAbbreviations(Set<IExpression> allVars, java.util.Map<String, IExpression> symbols, java.util.Map<String, IFunApp> ufs, java.util.Map<String, IExpression> abbrevs) {
                ArrayDeque<IExpression> waitlistSymbols = new ArrayDeque<IExpression>(allVars);
                HashSet<String> seenSymbols = new HashSet<String>();
                while (!waitlistSymbols.isEmpty()) {
                    IExpression var = (IExpression)waitlistSymbols.poll();
                    String name = PrincessEnvironment.getName(var);
                    if (!seenSymbols.add(name)) continue;
                    if (this.isAbbreviation(var)) {
                        Preconditions.checkState((!abbrevs.containsKey(name) ? 1 : 0) != 0);
                        abbrevs.put(name, var);
                        Set<IExpression> varsFromAbbrev = this.getVariablesFromAbbreviation(var);
                        Sets.difference(varsFromAbbrev, allVars).forEach(waitlistSymbols::push);
                        allVars.addAll(varsFromAbbrev);
                        continue;
                    }
                    if (var instanceof IFunApp) {
                        Preconditions.checkState((!ufs.containsKey(name) ? 1 : 0) != 0);
                        ufs.put(name, (IFunApp)var);
                        continue;
                    }
                    Preconditions.checkState((!symbols.containsKey(name) ? 1 : 0) != 0);
                    symbols.put(name, var);
                }
            }

            private java.lang.Iterable<String> getOrderedAbbreviations(java.util.Map<String, IExpression> usedAbbrevs) {
                ArrayDeque<String> waitlist = new ArrayDeque<String>(usedAbbrevs.keySet());
                LinkedHashSet<String> orderedAbbreviations = new LinkedHashSet<String>();
                while (!waitlist.isEmpty()) {
                    String abbrev = waitlist.removeFirst();
                    boolean allDependenciesFinished = true;
                    for (IExpression var : this.getVariablesFromAbbreviation(usedAbbrevs.get(abbrev))) {
                        String name = PrincessEnvironment.getName(var);
                        if (!this.isAbbreviation(var) || orderedAbbreviations.contains(name)) continue;
                        allDependenciesFinished = false;
                        waitlist.addLast(name);
                    }
                    if (allDependenciesFinished) {
                        orderedAbbreviations.add(abbrev);
                        continue;
                    }
                    waitlist.addLast(abbrev);
                }
                return orderedAbbreviations;
            }

            private boolean isAbbreviation(IExpression symbol) {
                return abbrevMap.containsKey(symbol);
            }

            private Set<IExpression> getVariablesFromAbbreviation(IExpression var) {
                return ImmutableSet.copyOf(creator.extractVariablesAndUFs((IExpression)abbrevMap.get(var), true).values());
            }
        };
    }

    private static String getName(IExpression var) {
        if (var instanceof IAtom) {
            return ((IAtom)var).pred().name();
        }
        if (var instanceof IConstant) {
            return var.toString();
        }
        if (var instanceof IFunApp) {
            String fullStr = ((IFunApp)var).fun().toString();
            return fullStr.substring(0, fullStr.indexOf(47));
        }
        if (var instanceof IIntFormula) {
            return PrincessEnvironment.getName((IExpression)((IIntFormula)var).t());
        }
        throw new IllegalArgumentException("The given parameter is no variable or function");
    }

    static FormulaType<?> getFormulaType(IExpression pFormula) {
        if (pFormula instanceof IFormula) {
            return FormulaType.BooleanType;
        }
        if (pFormula instanceof ITerm) {
            Sort sort = Sort$.MODULE$.sortOf((ITerm)pFormula);
            try {
                return PrincessEnvironment.getFormulaTypeFromSort(sort);
            }
            catch (IllegalArgumentException e) {
                throw new IllegalArgumentException(String.format("Unknown formula type '%s' for formula '%s'.", pFormula.getClass(), pFormula), e);
            }
        }
        throw new IllegalArgumentException(String.format("Unknown formula type '%s' for formula '%s'.", pFormula.getClass(), pFormula));
    }

    private static FormulaType<?> getFormulaTypeFromSort(Sort sort) {
        if (sort == BOOL_SORT) {
            return FormulaType.BooleanType;
        }
        if (sort == INTEGER_SORT) {
            return FormulaType.IntegerType;
        }
        if (sort instanceof Fractions.FractionSort$) {
            return FormulaType.RationalType;
        }
        if (sort instanceof ExtArray.ArraySort) {
            scala.collection.immutable.Seq indexSorts = ((ExtArray.ArraySort)sort).theory().indexSorts();
            Sort elementSort = ((ExtArray.ArraySort)sort).theory().objSort();
            assert (indexSorts.iterator().size() == 1) : "unexpected index type in Array type:" + sort;
            return new FormulaType.ArrayFormulaType(PrincessEnvironment.getFormulaTypeFromSort((Sort)indexSorts.iterator().next()), PrincessEnvironment.getFormulaTypeFromSort(elementSort));
        }
        if (sort instanceof Sort.MultipleValueBool$) {
            return FormulaType.BooleanType;
        }
        Option<Object> bitWidth = PrincessEnvironment.getBitWidth(sort);
        if (bitWidth.isDefined()) {
            return FormulaType.getBitvectorTypeWithSize((Integer)bitWidth.get());
        }
        throw new IllegalArgumentException(String.format("Unknown formula type '%s' for sort '%s'.", sort.getClass(), sort));
    }

    static Option<Object> getBitWidth(Sort sort) {
        Option bitWidth = ModuloArithmetic.UnsignedBVSort$.MODULE$.unapply(sort);
        if (!bitWidth.isDefined()) {
            bitWidth = ModuloArithmetic.SignedBVSort$.MODULE$.unapply(sort);
        }
        return bitWidth;
    }

    public IExpression makeVariable(Sort type, String varname) {
        if (type == BOOL_SORT) {
            if (this.boolVariablesCache.containsKey(varname)) {
                return (IExpression)this.boolVariablesCache.get(varname);
            }
            IFormula var = this.api.createBooleanVariable(varname);
            this.addSymbol(var);
            this.boolVariablesCache.put(varname, var);
            return var;
        }
        if (this.sortedVariablesCache.containsKey(varname)) {
            return (IExpression)this.sortedVariablesCache.get(varname);
        }
        ITerm var = this.api.createConstant(varname, type);
        this.addSymbol(var);
        this.sortedVariablesCache.put(varname, var);
        return var;
    }

    public IFunction declareFun(String name, Sort returnType, List<Sort> args) {
        if (this.functionsCache.containsKey(name)) {
            return this.functionsCache.get(name);
        }
        IFunction funcDecl = this.api.createFunction(name, PrincessEnvironment.toSeq(args), returnType, false, SimpleAPI.FunctionalityMode$.MODULE$.Full());
        this.addFunction(funcDecl);
        this.functionsCache.put(name, funcDecl);
        return funcDecl;
    }

    public ITerm makeSelect(ITerm array, ITerm index) {
        ImmutableList args = ImmutableList.of((Object)array, (Object)index);
        ExtArray.ArraySort arraySort = (ExtArray.ArraySort)Sort$.MODULE$.sortOf(array);
        return new IFunApp(arraySort.theory().select(), PrincessEnvironment.toSeq(args));
    }

    public ITerm makeStore(ITerm array, ITerm index, ITerm value) {
        ImmutableList args = ImmutableList.of((Object)array, (Object)index, (Object)value);
        ExtArray.ArraySort arraySort = (ExtArray.ArraySort)Sort$.MODULE$.sortOf(array);
        return new IFunApp(arraySort.theory().store(), PrincessEnvironment.toSeq(args));
    }

    public boolean hasArrayType(IExpression exp) {
        if (exp instanceof ITerm) {
            ITerm t = (ITerm)exp;
            return Sort$.MODULE$.sortOf(t) instanceof ExtArray.ArraySort;
        }
        return false;
    }

    public IFormula elimQuantifiers(IFormula formula) {
        return this.api.simplify(formula);
    }

    private void addSymbol(IFormula symbol) {
        for (PrincessAbstractProver<?, ?> prover : this.registeredProvers) {
            prover.addSymbol(symbol);
        }
    }

    private void addSymbol(ITerm symbol) {
        for (PrincessAbstractProver<?, ?> prover : this.registeredProvers) {
            prover.addSymbol(symbol);
        }
    }

    private void addFunction(IFunction funcDecl) {
        for (PrincessAbstractProver<?, ?> prover : this.registeredProvers) {
            prover.addSymbol(funcDecl);
        }
    }

    static <T> scala.collection.immutable.Seq<T> toSeq(List<T> list) {
        return ((Iterable)JavaConverters.collectionAsScalaIterableConverter(list).asScala()).toSeq();
    }

    IExpression simplify(IExpression f) {
        if (f instanceof IFormula) {
            f = BooleanCompactifier.apply((IFormula)((IFormula)f));
        }
        return PartialEvaluator.apply((IExpression)f);
    }
}

