/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.java_smt.solvers.smtinterpol;

import com.google.common.base.Preconditions;
import de.uni_freiburg.informatik.ultimate.smtinterpol.LogProxy;
import java.util.logging.Level;
import org.sosy_lab.common.log.LogManager;

final class LogProxyForwarder
implements LogProxy {
    private static final Level LEVEL_FATAL = Level.SEVERE;
    private static final Level LEVEL_ERROR = Level.WARNING;
    private static final Level LEVEL_WARN = Level.FINE;
    private static final Level LEVEL_INFO = Level.FINER;
    private static final Level LEVEL_DEBUG = Level.FINEST;
    private static final Level LEVEL_TRACE = Level.ALL;
    private final LogManager delegate;

    LogProxyForwarder(LogManager pDelegate) {
        this.delegate = (LogManager)Preconditions.checkNotNull((Object)pDelegate);
    }

    public void outOfMemory(String pArg0) {
        throw new OutOfMemoryError(pArg0);
    }

    public boolean canChangeDestination() {
        return false;
    }

    public void changeDestination(String pArg0) {
        throw new UnsupportedOperationException();
    }

    public String getDestination() {
        return "";
    }

    public int getLoglevel() {
        if (this.delegate.wouldBeLogged(LEVEL_TRACE)) {
            return 6;
        }
        if (this.delegate.wouldBeLogged(LEVEL_DEBUG)) {
            return 5;
        }
        if (this.delegate.wouldBeLogged(LEVEL_INFO)) {
            return 4;
        }
        if (this.delegate.wouldBeLogged(LEVEL_WARN)) {
            return 3;
        }
        if (this.delegate.wouldBeLogged(LEVEL_ERROR)) {
            return 2;
        }
        if (this.delegate.wouldBeLogged(LEVEL_FATAL)) {
            return 1;
        }
        return 0;
    }

    public void setLoglevel(int pArg0) {
    }

    public boolean isFatalEnabled() {
        return this.delegate.wouldBeLogged(LEVEL_FATAL);
    }

    public boolean isErrorEnabled() {
        return this.delegate.wouldBeLogged(LEVEL_ERROR);
    }

    public boolean isWarnEnabled() {
        return this.delegate.wouldBeLogged(LEVEL_WARN);
    }

    public boolean isInfoEnabled() {
        return this.delegate.wouldBeLogged(LEVEL_INFO);
    }

    public boolean isDebugEnabled() {
        return this.delegate.wouldBeLogged(LEVEL_DEBUG);
    }

    public boolean isTraceEnabled() {
        return this.delegate.wouldBeLogged(LEVEL_TRACE);
    }

    public void fatal(Object pArg0) {
        this.delegate.log(LEVEL_FATAL, pArg0);
    }

    public void fatal(String pArg0, Object ... pArg1) {
        this.delegate.logf(LEVEL_FATAL, pArg0, pArg1);
    }

    public void error(Object pArg0) {
        this.delegate.log(LEVEL_ERROR, pArg0);
    }

    public void error(String pArg0, Object ... pArg1) {
        this.delegate.logf(LEVEL_ERROR, pArg0, pArg1);
    }

    public void warn(Object pArg0) {
        this.delegate.log(LEVEL_WARN, pArg0);
    }

    public void warn(String pArg0, Object ... pArg1) {
        this.delegate.logf(LEVEL_WARN, pArg0, pArg1);
    }

    public void info(Object pArg0) {
        this.delegate.log(LEVEL_INFO, pArg0);
    }

    public void info(String pArg0, Object ... pArg1) {
        this.delegate.logf(LEVEL_INFO, pArg0, pArg1);
    }

    public void debug(Object pArg0) {
        this.delegate.log(LEVEL_DEBUG, pArg0);
    }

    public void debug(String pArg0, Object ... pArg1) {
        this.delegate.logf(LEVEL_DEBUG, pArg0, pArg1);
    }

    public void trace(Object pArg0) {
        this.delegate.log(LEVEL_TRACE, pArg0);
    }

    public void trace(String pArg0, Object ... pArg1) {
        this.delegate.logf(LEVEL_TRACE, pArg0, pArg1);
    }
}

