/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.java_smt.solvers.smtinterpol;

import de.uni_freiburg.informatik.ultimate.logic.Sort;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import java.math.BigDecimal;
import java.math.BigInteger;
import org.sosy_lab.java_smt.api.IntegerFormulaManager;
import org.sosy_lab.java_smt.api.NumeralFormula;
import org.sosy_lab.java_smt.basicimpl.AbstractNumeralFormulaManager;
import org.sosy_lab.java_smt.solvers.smtinterpol.SmtInterpolFormulaCreator;
import org.sosy_lab.java_smt.solvers.smtinterpol.SmtInterpolNumeralFormulaManager;

class SmtInterpolIntegerFormulaManager
extends SmtInterpolNumeralFormulaManager<NumeralFormula.IntegerFormula, NumeralFormula.IntegerFormula>
implements IntegerFormulaManager {
    SmtInterpolIntegerFormulaManager(SmtInterpolFormulaCreator pCreator, AbstractNumeralFormulaManager.NonLinearArithmetic pNonLinearArithmetic) {
        super(pCreator, pNonLinearArithmetic);
    }

    @Override
    protected Term makeNumberImpl(long i) {
        return this.env.numeral(BigInteger.valueOf(i));
    }

    @Override
    protected Term makeNumberImpl(BigInteger pI) {
        return this.env.numeral(pI);
    }

    @Override
    protected Term makeNumberImpl(String pI) {
        return this.env.numeral(pI);
    }

    @Override
    protected Term makeNumberImpl(double pNumber) {
        return this.makeNumberImpl((long)pNumber);
    }

    @Override
    protected Term makeNumberImpl(BigDecimal pNumber) {
        return (Term)this.decimalAsInteger(pNumber);
    }

    @Override
    protected Term makeVariableImpl(String varName) {
        Sort t = (Sort)this.getFormulaCreator().getIntegerType();
        return (Term)this.getFormulaCreator().makeVariable(t, varName);
    }

    @Override
    public Term divide(Term pNumber1, Term pNumber2) {
        if (this.consistsOfNumerals(pNumber2)) {
            Sort intSort = pNumber1.getTheory().getNumericSort();
            assert (intSort.equals(pNumber1.getSort()) && intSort.equals(pNumber2.getSort()));
            return this.env.term("div", new Term[]{pNumber1, pNumber2});
        }
        return super.divide(pNumber1, pNumber2);
    }

    @Override
    protected Term modulo(Term pNumber1, Term pNumber2) {
        if (this.consistsOfNumerals(pNumber2)) {
            Sort intSort = pNumber1.getTheory().getNumericSort();
            assert (intSort.equals(pNumber1.getSort()) && intSort.equals(pNumber2.getSort()));
            return this.env.term("mod", new Term[]{pNumber1, pNumber2});
        }
        return super.modulo(pNumber1, pNumber2);
    }

    @Override
    protected Term modularCongruence(Term pNumber1, Term pNumber2, BigInteger pModulo) {
        return this.modularCongruence0(pNumber1, pNumber2, this.env.numeral(pModulo));
    }

    @Override
    protected Term modularCongruence(Term pNumber1, Term pNumber2, long pModulo) {
        return this.modularCongruence0(pNumber1, pNumber2, this.env.numeral(BigInteger.valueOf(pModulo)));
    }

    protected Term modularCongruence0(Term pNumber1, Term pNumber2, Term n) {
        Sort intSort = pNumber1.getTheory().getNumericSort();
        assert (intSort.equals(pNumber1.getSort()) && intSort.equals(pNumber2.getSort()));
        Term x = this.subtract(pNumber1, pNumber2);
        return this.env.term("=", new Term[]{x, this.env.term("*", new Term[]{n, this.env.term("div", new Term[]{x, n})})});
    }
}

