/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.java_smt.solvers.z3;

import com.google.common.primitives.Longs;
import com.microsoft.z3.Native;
import java.math.BigInteger;
import java.util.List;
import org.sosy_lab.java_smt.basicimpl.AbstractBitvectorFormulaManager;
import org.sosy_lab.java_smt.solvers.z3.Z3BooleanFormulaManager;
import org.sosy_lab.java_smt.solvers.z3.Z3FormulaCreator;

class Z3BitvectorFormulaManager
extends AbstractBitvectorFormulaManager<Long, Long, Long, Long> {
    private final long z3context;

    Z3BitvectorFormulaManager(Z3FormulaCreator creator, Z3BooleanFormulaManager pBmgr) {
        super(creator, pBmgr);
        this.z3context = (Long)creator.getEnv();
    }

    @Override
    public Long concat(Long pFirst, Long pSecond) {
        return Native.mkConcat((long)this.z3context, (long)pFirst, (long)pSecond);
    }

    @Override
    public Long extract(Long pNumber, int pMsb, int pLsb) {
        return Native.mkExtract((long)this.z3context, (int)pMsb, (int)pLsb, (long)pNumber);
    }

    @Override
    public Long extend(Long pNumber, int pExtensionBits, boolean pSigned) {
        if (pSigned) {
            return Native.mkSignExt((long)this.z3context, (int)pExtensionBits, (long)pNumber);
        }
        return Native.mkZeroExt((long)this.z3context, (int)pExtensionBits, (long)pNumber);
    }

    @Override
    protected Long makeBitvectorImpl(int pLength, BigInteger pI) {
        pI = this.transformValueToRange(pLength, pI);
        long sort = Native.mkBvSort((long)this.z3context, (int)pLength);
        return Native.mkNumeral((long)this.z3context, (String)pI.toString(), (long)sort);
    }

    @Override
    protected Long makeBitvectorImpl(int pLength, Long pNumeralFormula) {
        return Native.mkInt2bv((long)this.z3context, (int)pLength, (long)pNumeralFormula);
    }

    @Override
    protected Long toIntegerFormulaImpl(Long pBVFormula, boolean pSigned) {
        return Native.mkBv2int((long)this.z3context, (long)pBVFormula, (boolean)pSigned);
    }

    @Override
    public Long makeVariableImpl(int length, String varName) {
        long type = (Long)this.getFormulaCreator().getBitvectorType(length);
        return (Long)this.getFormulaCreator().makeVariable(type, varName);
    }

    @Override
    public Long shiftRight(Long number, Long toShift, boolean signed) {
        if (signed) {
            return Native.mkBvashr((long)this.z3context, (long)number, (long)toShift);
        }
        return Native.mkBvlshr((long)this.z3context, (long)number, (long)toShift);
    }

    @Override
    public Long shiftLeft(Long number, Long toShift) {
        return Native.mkBvshl((long)this.z3context, (long)number, (long)toShift);
    }

    @Override
    public Long not(Long pBits) {
        return Native.mkBvnot((long)this.z3context, (long)pBits);
    }

    @Override
    public Long and(Long pBits1, Long pBits2) {
        return Native.mkBvand((long)this.z3context, (long)pBits1, (long)pBits2);
    }

    @Override
    public Long or(Long pBits1, Long pBits2) {
        return Native.mkBvor((long)this.z3context, (long)pBits1, (long)pBits2);
    }

    @Override
    public Long xor(Long pBits1, Long pBits2) {
        return Native.mkBvxor((long)this.z3context, (long)pBits1, (long)pBits2);
    }

    @Override
    public Long negate(Long pNumber) {
        return Native.mkBvneg((long)this.z3context, (long)pNumber);
    }

    @Override
    public Long add(Long pNumber1, Long pNumber2) {
        return Native.mkBvadd((long)this.z3context, (long)pNumber1, (long)pNumber2);
    }

    @Override
    public Long subtract(Long pNumber1, Long pNumber2) {
        return Native.mkBvsub((long)this.z3context, (long)pNumber1, (long)pNumber2);
    }

    @Override
    public Long divide(Long pNumber1, Long pNumber2, boolean signed) {
        if (signed) {
            return Native.mkBvsdiv((long)this.z3context, (long)pNumber1, (long)pNumber2);
        }
        return Native.mkBvudiv((long)this.z3context, (long)pNumber1, (long)pNumber2);
    }

    @Override
    public Long modulo(Long pNumber1, Long pNumber2, boolean signed) {
        if (signed) {
            return Native.mkBvsrem((long)this.z3context, (long)pNumber1, (long)pNumber2);
        }
        return Native.mkBvurem((long)this.z3context, (long)pNumber1, (long)pNumber2);
    }

    @Override
    public Long multiply(Long pNumber1, Long pNumber2) {
        return Native.mkBvmul((long)this.z3context, (long)pNumber1, (long)pNumber2);
    }

    @Override
    public Long equal(Long pNumber1, Long pNumber2) {
        return Native.mkEq((long)this.z3context, (long)pNumber1, (long)pNumber2);
    }

    @Override
    public Long lessThan(Long pNumber1, Long pNumber2, boolean signed) {
        if (signed) {
            return Native.mkBvslt((long)this.z3context, (long)pNumber1, (long)pNumber2);
        }
        return Native.mkBvult((long)this.z3context, (long)pNumber1, (long)pNumber2);
    }

    @Override
    public Long lessOrEquals(Long pNumber1, Long pNumber2, boolean signed) {
        if (signed) {
            return Native.mkBvsle((long)this.z3context, (long)pNumber1, (long)pNumber2);
        }
        return Native.mkBvule((long)this.z3context, (long)pNumber1, (long)pNumber2);
    }

    @Override
    public Long greaterThan(Long pNumber1, Long pNumber2, boolean signed) {
        return this.lessThan(pNumber2, pNumber1, signed);
    }

    @Override
    public Long greaterOrEquals(Long pNumber1, Long pNumber2, boolean signed) {
        return this.lessOrEquals(pNumber2, pNumber1, signed);
    }

    @Override
    protected Long distinctImpl(List<Long> pBits) {
        return Native.mkDistinct((long)this.z3context, (int)pBits.size(), (long[])Longs.toArray(pBits));
    }
}

