/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.java_smt.solvers.z3;

import com.google.common.base.Preconditions;
import com.google.errorprone.annotations.Immutable;
import com.microsoft.z3.Native;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.sosy_lab.java_smt.api.ArrayFormula;
import org.sosy_lab.java_smt.api.BitvectorFormula;
import org.sosy_lab.java_smt.api.BooleanFormula;
import org.sosy_lab.java_smt.api.FloatingPointFormula;
import org.sosy_lab.java_smt.api.FloatingPointRoundingModeFormula;
import org.sosy_lab.java_smt.api.Formula;
import org.sosy_lab.java_smt.api.FormulaType;
import org.sosy_lab.java_smt.api.NumeralFormula;
import org.sosy_lab.java_smt.api.RegexFormula;
import org.sosy_lab.java_smt.api.StringFormula;

@Immutable
abstract class Z3Formula
implements Formula {
    private final long z3expr;
    private final long z3context;
    private final int hashCache;

    private Z3Formula(long z3context, long z3expr) {
        Preconditions.checkArgument((z3context != 0L ? 1 : 0) != 0, (Object)"Z3 context is null");
        Preconditions.checkArgument((z3expr != 0L ? 1 : 0) != 0, (Object)"Z3 formula is null");
        this.z3expr = z3expr;
        this.z3context = z3context;
        Native.incRef((long)z3context, (long)z3expr);
        this.hashCache = Native.getAstHash((long)z3context, (long)z3expr);
    }

    @Override
    public final String toString() {
        return Native.astToString((long)this.z3context, (long)this.z3expr);
    }

    @Override
    public final boolean equals(@Nullable Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof Z3Formula)) {
            return false;
        }
        Z3Formula other = (Z3Formula)obj;
        return this.z3context == other.z3context && Native.isEqAst((long)this.z3context, (long)this.z3expr, (long)other.z3expr);
    }

    @Override
    public final int hashCode() {
        return this.hashCache;
    }

    final long getFormulaInfo() {
        return this.z3expr;
    }

    @Immutable
    static final class Z3RegexFormula
    extends Z3Formula
    implements RegexFormula {
        Z3RegexFormula(long z3context, long z3expr) {
            super(z3context, z3expr);
        }
    }

    @Immutable
    static final class Z3StringFormula
    extends Z3Formula
    implements StringFormula {
        Z3StringFormula(long z3context, long z3expr) {
            super(z3context, z3expr);
        }
    }

    @Immutable
    static final class Z3BooleanFormula
    extends Z3Formula
    implements BooleanFormula {
        Z3BooleanFormula(long z3context, long z3expr) {
            super(z3context, z3expr);
        }
    }

    @Immutable
    static final class Z3RationalFormula
    extends Z3Formula
    implements NumeralFormula.RationalFormula {
        Z3RationalFormula(long z3context, long z3expr) {
            super(z3context, z3expr);
        }
    }

    @Immutable
    static final class Z3IntegerFormula
    extends Z3Formula
    implements NumeralFormula.IntegerFormula {
        Z3IntegerFormula(long z3context, long z3expr) {
            super(z3context, z3expr);
        }
    }

    @Immutable
    static final class Z3FloatingPointRoundingModeFormula
    extends Z3Formula
    implements FloatingPointRoundingModeFormula {
        Z3FloatingPointRoundingModeFormula(long z3context, long z3expr) {
            super(z3context, z3expr);
        }
    }

    @Immutable
    static final class Z3FloatingPointFormula
    extends Z3Formula
    implements FloatingPointFormula {
        Z3FloatingPointFormula(long z3context, long z3expr) {
            super(z3context, z3expr);
        }
    }

    @Immutable
    static final class Z3BitvectorFormula
    extends Z3Formula
    implements BitvectorFormula {
        Z3BitvectorFormula(long z3context, long z3expr) {
            super(z3context, z3expr);
        }
    }

    static final class Z3ArrayFormula<TI extends Formula, TE extends Formula>
    extends Z3Formula
    implements ArrayFormula<TI, TE> {
        private final FormulaType<TI> indexType;
        private final FormulaType<TE> elementType;

        Z3ArrayFormula(long pZ3context, long pZ3expr, FormulaType<TI> pIndexType, FormulaType<TE> pElementType) {
            super(pZ3context, pZ3expr);
            this.indexType = pIndexType;
            this.elementType = pElementType;
        }

        public FormulaType<TI> getIndexType() {
            return this.indexType;
        }

        public FormulaType<TE> getElementType() {
            return this.elementType;
        }
    }
}

