/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.java_smt.solvers.z3;

import com.google.common.base.Preconditions;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Table;
import com.google.common.primitives.Longs;
import com.microsoft.z3.Native;
import com.microsoft.z3.Z3Exception;
import com.microsoft.z3.enumerations.Z3_ast_kind;
import com.microsoft.z3.enumerations.Z3_decl_kind;
import com.microsoft.z3.enumerations.Z3_sort_kind;
import com.microsoft.z3.enumerations.Z3_symbol_kind;
import java.lang.ref.PhantomReference;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.sosy_lab.common.ShutdownNotifier;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.configuration.Option;
import org.sosy_lab.common.configuration.Options;
import org.sosy_lab.common.rationals.Rational;
import org.sosy_lab.common.time.Timer;
import org.sosy_lab.java_smt.api.ArrayFormula;
import org.sosy_lab.java_smt.api.BitvectorFormula;
import org.sosy_lab.java_smt.api.BooleanFormula;
import org.sosy_lab.java_smt.api.FloatingPointFormula;
import org.sosy_lab.java_smt.api.FloatingPointRoundingMode;
import org.sosy_lab.java_smt.api.Formula;
import org.sosy_lab.java_smt.api.FormulaType;
import org.sosy_lab.java_smt.api.FunctionDeclarationKind;
import org.sosy_lab.java_smt.api.QuantifiedFormulaManager;
import org.sosy_lab.java_smt.api.RegexFormula;
import org.sosy_lab.java_smt.api.SolverException;
import org.sosy_lab.java_smt.api.StringFormula;
import org.sosy_lab.java_smt.api.visitors.FormulaVisitor;
import org.sosy_lab.java_smt.basicimpl.FormulaCreator;
import org.sosy_lab.java_smt.basicimpl.FunctionDeclarationImpl;
import org.sosy_lab.java_smt.solvers.z3.Z3Formula;

@Options(prefix="solver.z3")
class Z3FormulaCreator
extends FormulaCreator<Long, Long, Long, Long> {
    private static final ImmutableMap<Integer, Object> Z3_CONSTANTS = ImmutableMap.builder().put((Object)Z3_decl_kind.Z3_OP_TRUE.toInt(), (Object)true).put((Object)Z3_decl_kind.Z3_OP_FALSE.toInt(), (Object)false).put((Object)Z3_decl_kind.Z3_OP_FPA_PLUS_ZERO.toInt(), (Object)0.0).put((Object)Z3_decl_kind.Z3_OP_FPA_MINUS_ZERO.toInt(), (Object)-0.0).put((Object)Z3_decl_kind.Z3_OP_FPA_PLUS_INF.toInt(), (Object)Double.POSITIVE_INFINITY).put((Object)Z3_decl_kind.Z3_OP_FPA_MINUS_INF.toInt(), (Object)Double.NEGATIVE_INFINITY).put((Object)Z3_decl_kind.Z3_OP_FPA_NAN.toInt(), (Object)Double.NaN).put((Object)Z3_decl_kind.Z3_OP_FPA_RM_NEAREST_TIES_TO_EVEN.toInt(), (Object)FloatingPointRoundingMode.NEAREST_TIES_TO_EVEN).put((Object)Z3_decl_kind.Z3_OP_FPA_RM_NEAREST_TIES_TO_AWAY.toInt(), (Object)FloatingPointRoundingMode.NEAREST_TIES_AWAY).put((Object)Z3_decl_kind.Z3_OP_FPA_RM_TOWARD_POSITIVE.toInt(), (Object)FloatingPointRoundingMode.TOWARD_POSITIVE).put((Object)Z3_decl_kind.Z3_OP_FPA_RM_TOWARD_NEGATIVE.toInt(), (Object)FloatingPointRoundingMode.TOWARD_NEGATIVE).put((Object)Z3_decl_kind.Z3_OP_FPA_RM_TOWARD_ZERO.toInt(), (Object)FloatingPointRoundingMode.TOWARD_ZERO).buildOrThrow();
    private static final ImmutableSet<String> Z3_INTERRUPT_ERRORS = ImmutableSet.of((Object)"canceled", (Object)"Proof error!", (Object)"interrupted", (Object)"maximization suspended");
    @Option(secure=true, description="Whether to use PhantomReferences for discarding Z3 AST")
    private boolean usePhantomReferences = false;
    private final Map<String, Long> symbolsToDeclarations = new LinkedHashMap<String, Long>();
    private final Table<Long, Long, Long> allocatedArraySorts = HashBasedTable.create();
    private final ReferenceQueue<Z3Formula> referenceQueue = new ReferenceQueue();
    private final IdentityHashMap<PhantomReference<? extends Z3Formula>, Long> referenceMap = new IdentityHashMap();
    private final Timer cleanupTimer = new Timer();
    protected final ShutdownNotifier shutdownNotifier;

    Z3FormulaCreator(long pEnv, long pBoolType, long pIntegerType, long pRealType, long pStringType, long pRegexType, Configuration config, ShutdownNotifier pShutdownNotifier) throws InvalidConfigurationException {
        super(pEnv, pBoolType, pIntegerType, pRealType, pStringType, pRegexType);
        this.shutdownNotifier = pShutdownNotifier;
        config.inject(this);
    }

    final Z3Exception handleZ3Exception(Z3Exception e) throws Z3Exception, InterruptedException {
        if (Z3_INTERRUPT_ERRORS.contains((Object)e.getMessage())) {
            this.shutdownNotifier.shutdownIfNecessary();
        }
        throw e;
    }

    @Override
    public Long makeVariable(Long type, String varName) {
        long z3context = (Long)this.getEnv();
        long symbol = Native.mkStringSymbol((long)z3context, (String)varName);
        long var = Native.mkConst((long)z3context, (long)symbol, (long)type);
        this.symbolsToDeclarations.put(varName, Native.getAppDecl((long)z3context, (long)var));
        return var;
    }

    @Override
    public Long extractInfo(Formula pT) {
        if (pT instanceof Z3Formula) {
            return ((Z3Formula)pT).getFormulaInfo();
        }
        throw new IllegalArgumentException("Cannot get the formula info of type " + pT.getClass().getSimpleName() + " in the Solver!");
    }

    @Override
    public <T extends Formula> FormulaType<T> getFormulaType(T pFormula) {
        Long term = this.extractInfo(pFormula);
        return this.getFormulaType(term);
    }

    public FormulaType<?> getFormulaTypeFromSort(Long pSort) {
        long z3context = (Long)this.getEnv();
        Z3_sort_kind sortKind = Z3_sort_kind.fromInt((int)Native.getSortKind((long)z3context, (long)pSort));
        switch (sortKind) {
            case Z3_BOOL_SORT: {
                return FormulaType.BooleanType;
            }
            case Z3_INT_SORT: {
                return FormulaType.IntegerType;
            }
            case Z3_REAL_SORT: {
                return FormulaType.RationalType;
            }
            case Z3_BV_SORT: {
                return FormulaType.getBitvectorTypeWithSize(Native.getBvSortSize((long)z3context, (long)pSort));
            }
            case Z3_ARRAY_SORT: {
                long domainSort = Native.getArraySortDomain((long)z3context, (long)pSort);
                long rangeSort = Native.getArraySortRange((long)z3context, (long)pSort);
                return FormulaType.getArrayType(this.getFormulaTypeFromSort(domainSort), this.getFormulaTypeFromSort(rangeSort));
            }
            case Z3_FLOATING_POINT_SORT: {
                return FormulaType.getFloatingPointType(Native.fpaGetEbits((long)z3context, (long)pSort), Native.fpaGetSbits((long)z3context, (long)pSort) - 1);
            }
            case Z3_ROUNDING_MODE_SORT: {
                return FormulaType.FloatingPointRoundingModeType;
            }
            case Z3_RE_SORT: {
                return FormulaType.RegexType;
            }
            case Z3_DATATYPE_SORT: 
            case Z3_RELATION_SORT: 
            case Z3_FINITE_DOMAIN_SORT: 
            case Z3_SEQ_SORT: 
            case Z3_UNKNOWN_SORT: 
            case Z3_UNINTERPRETED_SORT: {
                if (Native.isStringSort((long)z3context, (long)pSort)) {
                    return FormulaType.StringType;
                }
                throw new IllegalArgumentException("Unknown formula type " + Native.sortToString((long)z3context, (long)pSort) + " with sort " + sortKind);
            }
        }
        throw new UnsupportedOperationException("Unexpected state.");
    }

    @Override
    public FormulaType<?> getFormulaType(Long pFormula) {
        long sort = Native.getSort((long)((Long)this.getEnv()), (long)pFormula);
        return this.getFormulaTypeFromSort(sort);
    }

    @Override
    protected <TD extends Formula, TR extends Formula> FormulaType<TR> getArrayFormulaElementType(ArrayFormula<TD, TR> pArray) {
        return ((Z3Formula.Z3ArrayFormula)pArray).getElementType();
    }

    @Override
    protected <TD extends Formula, TR extends Formula> FormulaType<TD> getArrayFormulaIndexType(ArrayFormula<TD, TR> pArray) {
        return ((Z3Formula.Z3ArrayFormula)pArray).getIndexType();
    }

    @Override
    protected <TD extends Formula, TR extends Formula> ArrayFormula<TD, TR> encapsulateArray(Long pTerm, FormulaType<TD> pIndexType, FormulaType<TR> pElementType) {
        assert (this.getFormulaType(pTerm).equals(FormulaType.getArrayType(pIndexType, pElementType)));
        this.cleanupReferences();
        return this.storePhantomReference(new Z3Formula.Z3ArrayFormula<TD, TR>((Long)this.getEnv(), pTerm, pIndexType, pElementType), pTerm);
    }

    private <T extends Z3Formula> T storePhantomReference(T out, Long pTerm) {
        if (this.usePhantomReferences) {
            PhantomReference<Z3Formula> ref = new PhantomReference<Z3Formula>(out, this.referenceQueue);
            this.referenceMap.put(ref, pTerm);
        }
        return out;
    }

    @Override
    public <T extends Formula> T encapsulate(FormulaType<T> pType, Long pTerm) {
        assert (pType.equals(this.getFormulaType(pTerm)) || pType.equals(FormulaType.RationalType) && this.getFormulaType(pTerm).equals(FormulaType.IntegerType)) : String.format("Trying to encapsulate formula of type %s as %s", this.getFormulaType(pTerm), pType);
        this.cleanupReferences();
        if (pType.isBooleanType()) {
            return (T)this.storePhantomReference(new Z3Formula.Z3BooleanFormula((Long)this.getEnv(), pTerm), pTerm);
        }
        if (pType.isIntegerType()) {
            return (T)this.storePhantomReference(new Z3Formula.Z3IntegerFormula((Long)this.getEnv(), pTerm), pTerm);
        }
        if (pType.isRationalType()) {
            return (T)this.storePhantomReference(new Z3Formula.Z3RationalFormula((Long)this.getEnv(), pTerm), pTerm);
        }
        if (pType.isStringType()) {
            return (T)this.storePhantomReference(new Z3Formula.Z3StringFormula((Long)this.getEnv(), pTerm), pTerm);
        }
        if (pType.isRegexType()) {
            return (T)this.storePhantomReference(new Z3Formula.Z3RegexFormula((Long)this.getEnv(), pTerm), pTerm);
        }
        if (pType.isBitvectorType()) {
            return (T)this.storePhantomReference(new Z3Formula.Z3BitvectorFormula((Long)this.getEnv(), pTerm), pTerm);
        }
        if (pType.isFloatingPointType()) {
            return (T)this.storePhantomReference(new Z3Formula.Z3FloatingPointFormula((Long)this.getEnv(), pTerm), pTerm);
        }
        if (pType.isFloatingPointRoundingModeType()) {
            return (T)this.storePhantomReference(new Z3Formula.Z3FloatingPointRoundingModeFormula((Long)this.getEnv(), pTerm), pTerm);
        }
        if (pType.isArrayType()) {
            FormulaType.ArrayFormulaType arrFt = (FormulaType.ArrayFormulaType)pType;
            return (T)this.storePhantomReference(new Z3Formula.Z3ArrayFormula((Long)this.getEnv(), pTerm, arrFt.getIndexType(), arrFt.getElementType()), pTerm);
        }
        throw new IllegalArgumentException("Cannot create formulas of type " + pType + " in Z3");
    }

    @Override
    public BooleanFormula encapsulateBoolean(Long pTerm) {
        assert (this.getFormulaType(pTerm).isBooleanType());
        this.cleanupReferences();
        return this.storePhantomReference(new Z3Formula.Z3BooleanFormula((Long)this.getEnv(), pTerm), pTerm);
    }

    @Override
    public BitvectorFormula encapsulateBitvector(Long pTerm) {
        assert (this.getFormulaType(pTerm).isBitvectorType());
        this.cleanupReferences();
        return this.storePhantomReference(new Z3Formula.Z3BitvectorFormula((Long)this.getEnv(), pTerm), pTerm);
    }

    @Override
    protected FloatingPointFormula encapsulateFloatingPoint(Long pTerm) {
        assert (this.getFormulaType(pTerm).isFloatingPointType());
        this.cleanupReferences();
        return this.storePhantomReference(new Z3Formula.Z3FloatingPointFormula((Long)this.getEnv(), pTerm), pTerm);
    }

    @Override
    protected StringFormula encapsulateString(Long pTerm) {
        assert (this.getFormulaType(pTerm).isStringType()) : String.format("Term %s has unexpected type %s.", Native.astToString((long)((Long)this.getEnv()), (long)pTerm), Native.sortToString((long)((Long)this.getEnv()), (long)Native.getSort((long)((Long)this.getEnv()), (long)pTerm)));
        this.cleanupReferences();
        return this.storePhantomReference(new Z3Formula.Z3StringFormula((Long)this.getEnv(), pTerm), pTerm);
    }

    @Override
    protected RegexFormula encapsulateRegex(Long pTerm) {
        assert (this.getFormulaType(pTerm).isRegexType()) : String.format("Term %s has unexpected type %s.", Native.astToString((long)((Long)this.getEnv()), (long)pTerm), Native.sortToString((long)((Long)this.getEnv()), (long)Native.getSort((long)((Long)this.getEnv()), (long)pTerm)));
        this.cleanupReferences();
        return this.storePhantomReference(new Z3Formula.Z3RegexFormula((Long)this.getEnv(), pTerm), pTerm);
    }

    @Override
    public Long getArrayType(Long pIndexType, Long pElementType) {
        Long allocatedArraySort = (Long)this.allocatedArraySorts.get((Object)pIndexType, (Object)pElementType);
        if (allocatedArraySort == null) {
            allocatedArraySort = Native.mkArraySort((long)((Long)this.getEnv()), (long)pIndexType, (long)pElementType);
            Native.incRef((long)((Long)this.getEnv()), (long)allocatedArraySort);
            this.allocatedArraySorts.put((Object)pIndexType, (Object)pElementType, (Object)allocatedArraySort);
        }
        return allocatedArraySort;
    }

    @Override
    public Long getBitvectorType(int pBitwidth) {
        Preconditions.checkArgument((pBitwidth > 0 ? 1 : 0) != 0, (String)"Cannot use bitvector type with size %s", (int)pBitwidth);
        long bvSort = Native.mkBvSort((long)((Long)this.getEnv()), (int)pBitwidth);
        Native.incRef((long)((Long)this.getEnv()), (long)Native.sortToAst((long)((Long)this.getEnv()), (long)bvSort));
        return bvSort;
    }

    @Override
    public Long getFloatingPointType(FormulaType.FloatingPointType type) {
        long fpSort = Native.mkFpaSort((long)((Long)this.getEnv()), (int)type.getExponentSize(), (int)(type.getMantissaSize() + 1));
        Native.incRef((long)((Long)this.getEnv()), (long)Native.sortToAst((long)((Long)this.getEnv()), (long)fpSort));
        return fpSort;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cleanupReferences() {
        if (!this.usePhantomReferences) {
            return;
        }
        this.cleanupTimer.start();
        try {
            Reference<Z3Formula> ref;
            while ((ref = this.referenceQueue.poll()) != null) {
                long z3ast = this.referenceMap.remove(ref);
                Native.decRef((long)((Long)this.environment), (long)z3ast);
            }
        }
        finally {
            this.cleanupTimer.stop();
        }
    }

    private String getAppName(long f) {
        long funcDecl = Native.getAppDecl((long)((Long)this.environment), (long)f);
        long symbol = Native.getDeclName((long)((Long)this.environment), (long)funcDecl);
        return this.symbolToString(symbol);
    }

    @Override
    public <R> R visit(FormulaVisitor<R> visitor, Formula formula, Long f) {
        switch (Z3_ast_kind.fromInt((int)Native.getAstKind((long)((Long)this.environment), (long)f))) {
            case Z3_NUMERAL_AST: {
                return visitor.visitConstant(formula, this.convertValue(f));
            }
            case Z3_APP_AST: {
                int arity = Native.getAppNumArgs((long)((Long)this.environment), (long)f);
                int declKind = Native.getDeclKind((long)((Long)this.environment), (long)Native.getAppDecl((long)((Long)this.environment), (long)f));
                if (arity == 0) {
                    Object value = Z3_CONSTANTS.get((Object)declKind);
                    if (value != null) {
                        return visitor.visitConstant(formula, value);
                    }
                    if (declKind == Z3_decl_kind.Z3_OP_FPA_NUM.toInt() || Native.getSortKind((long)((Long)this.environment), (long)Native.getSort((long)((Long)this.environment), (long)f)) == Z3_sort_kind.Z3_ROUNDING_MODE_SORT.toInt()) {
                        return visitor.visitConstant(formula, this.convertValue(f));
                    }
                    if (declKind == Z3_decl_kind.Z3_OP_INTERNAL.toInt() && Native.getSortKind((long)((Long)this.environment), (long)Native.getSort((long)((Long)this.environment), (long)f)) == Z3_sort_kind.Z3_SEQ_SORT.toInt()) {
                        return visitor.visitConstant(formula, this.convertValue(f));
                    }
                    if (declKind == Z3_decl_kind.Z3_OP_UNINTERPRETED.toInt() || declKind == Z3_decl_kind.Z3_OP_INTERNAL.toInt()) {
                        return visitor.visitFreeVariable(formula, this.getAppName(f));
                    }
                }
                ImmutableList.Builder args = ImmutableList.builder();
                ImmutableList.Builder argTypes = ImmutableList.builder();
                for (int i = 0; i < arity; ++i) {
                    long arg = Native.getAppArg((long)((Long)this.environment), (long)f, (int)i);
                    FormulaType<?> argumentType = this.getFormulaType(arg);
                    args.add(this.encapsulate(argumentType, arg));
                    argTypes.add(argumentType);
                }
                return visitor.visitFunction(formula, (List<Formula>)args.build(), FunctionDeclarationImpl.of(this.getAppName(f), this.getDeclarationKind(f), argTypes.build(), this.getFormulaType(f), Native.getAppDecl((long)((Long)this.environment), (long)f)));
            }
            case Z3_VAR_AST: {
                int deBruijnIdx = Native.getIndexValue((long)((Long)this.environment), (long)f);
                return visitor.visitBoundVariable(formula, deBruijnIdx);
            }
            case Z3_QUANTIFIER_AST: {
                BooleanFormula body = this.encapsulateBoolean(Native.getQuantifierBody((long)((Long)this.environment), (long)f));
                QuantifiedFormulaManager.Quantifier q = Native.isQuantifierForall((long)((Long)this.environment), (long)f) ? QuantifiedFormulaManager.Quantifier.FORALL : QuantifiedFormulaManager.Quantifier.EXISTS;
                return visitor.visitQuantifier((BooleanFormula)formula, q, this.getBoundVars(f), body);
            }
        }
        throw new UnsupportedOperationException("Input should be a formula AST, got unexpected type instead");
    }

    protected String symbolToString(long symbol) {
        switch (Z3_symbol_kind.fromInt((int)Native.getSymbolKind((long)((Long)this.environment), (long)symbol))) {
            case Z3_STRING_SYMBOL: {
                return Native.getSymbolString((long)((Long)this.environment), (long)symbol);
            }
            case Z3_INT_SYMBOL: {
                return "#" + Native.getSymbolInt((long)((Long)this.environment), (long)symbol);
            }
        }
        throw new UnsupportedOperationException("Unexpected state");
    }

    private List<Formula> getBoundVars(long f) {
        int numBound = Native.getQuantifierNumBound((long)((Long)this.environment), (long)f);
        ArrayList<Formula> boundVars = new ArrayList<Formula>(numBound);
        for (int i = 0; i < numBound; ++i) {
            long varName = Native.getQuantifierBoundName((long)((Long)this.environment), (long)f, (int)i);
            long varSort = Native.getQuantifierBoundSort((long)((Long)this.environment), (long)f, (int)i);
            boundVars.add((Formula)this.encapsulate(this.getFormulaTypeFromSort(varSort), Native.mkConst((long)((Long)this.environment), (long)varName, (long)varSort)));
        }
        return boundVars;
    }

    private FunctionDeclarationKind getDeclarationKind(long f) {
        assert (Native.getArity((long)((Long)this.environment), (long)Native.getAppDecl((long)((Long)this.environment), (long)f)) > 0) : "Variables should be handled in other branch.";
        if (this.getAppName(f).equals("div0")) {
            return FunctionDeclarationKind.OTHER;
        }
        Z3_decl_kind decl = Z3_decl_kind.fromInt((int)Native.getDeclKind((long)((Long)this.environment), (long)Native.getAppDecl((long)((Long)this.environment), (long)f)));
        switch (decl) {
            case Z3_OP_AND: {
                return FunctionDeclarationKind.AND;
            }
            case Z3_OP_NOT: {
                return FunctionDeclarationKind.NOT;
            }
            case Z3_OP_OR: {
                return FunctionDeclarationKind.OR;
            }
            case Z3_OP_IFF: {
                return FunctionDeclarationKind.IFF;
            }
            case Z3_OP_ITE: {
                return FunctionDeclarationKind.ITE;
            }
            case Z3_OP_XOR: {
                return FunctionDeclarationKind.XOR;
            }
            case Z3_OP_DISTINCT: {
                return FunctionDeclarationKind.DISTINCT;
            }
            case Z3_OP_IMPLIES: {
                return FunctionDeclarationKind.IMPLIES;
            }
            case Z3_OP_SUB: {
                return FunctionDeclarationKind.SUB;
            }
            case Z3_OP_ADD: {
                return FunctionDeclarationKind.ADD;
            }
            case Z3_OP_DIV: {
                return FunctionDeclarationKind.DIV;
            }
            case Z3_OP_MUL: {
                return FunctionDeclarationKind.MUL;
            }
            case Z3_OP_MOD: {
                return FunctionDeclarationKind.MODULO;
            }
            case Z3_OP_TO_INT: {
                return FunctionDeclarationKind.FLOOR;
            }
            case Z3_OP_TO_REAL: {
                return FunctionDeclarationKind.TO_REAL;
            }
            case Z3_OP_UNINTERPRETED: {
                return FunctionDeclarationKind.UF;
            }
            case Z3_OP_LT: {
                return FunctionDeclarationKind.LT;
            }
            case Z3_OP_LE: {
                return FunctionDeclarationKind.LTE;
            }
            case Z3_OP_GT: {
                return FunctionDeclarationKind.GT;
            }
            case Z3_OP_GE: {
                return FunctionDeclarationKind.GTE;
            }
            case Z3_OP_EQ: {
                return FunctionDeclarationKind.EQ;
            }
            case Z3_OP_STORE: {
                return FunctionDeclarationKind.STORE;
            }
            case Z3_OP_SELECT: {
                return FunctionDeclarationKind.SELECT;
            }
            case Z3_OP_TRUE: 
            case Z3_OP_FALSE: 
            case Z3_OP_ANUM: 
            case Z3_OP_AGNUM: {
                throw new UnsupportedOperationException("Unexpected state: constants not expected");
            }
            case Z3_OP_OEQ: {
                throw new UnsupportedOperationException("Unexpected state: not a proof");
            }
            case Z3_OP_UMINUS: {
                return FunctionDeclarationKind.UMINUS;
            }
            case Z3_OP_IDIV: {
                return FunctionDeclarationKind.DIV;
            }
            case Z3_OP_EXTRACT: {
                return FunctionDeclarationKind.BV_EXTRACT;
            }
            case Z3_OP_CONCAT: {
                return FunctionDeclarationKind.BV_CONCAT;
            }
            case Z3_OP_BNOT: {
                return FunctionDeclarationKind.BV_NOT;
            }
            case Z3_OP_BNEG: {
                return FunctionDeclarationKind.BV_NEG;
            }
            case Z3_OP_BAND: {
                return FunctionDeclarationKind.BV_AND;
            }
            case Z3_OP_BOR: {
                return FunctionDeclarationKind.BV_OR;
            }
            case Z3_OP_BXOR: {
                return FunctionDeclarationKind.BV_XOR;
            }
            case Z3_OP_ULT: {
                return FunctionDeclarationKind.BV_ULT;
            }
            case Z3_OP_SLT: {
                return FunctionDeclarationKind.BV_SLT;
            }
            case Z3_OP_ULEQ: {
                return FunctionDeclarationKind.BV_ULE;
            }
            case Z3_OP_SLEQ: {
                return FunctionDeclarationKind.BV_SLE;
            }
            case Z3_OP_UGT: {
                return FunctionDeclarationKind.BV_UGT;
            }
            case Z3_OP_SGT: {
                return FunctionDeclarationKind.BV_SGT;
            }
            case Z3_OP_UGEQ: {
                return FunctionDeclarationKind.BV_UGE;
            }
            case Z3_OP_SGEQ: {
                return FunctionDeclarationKind.BV_SGE;
            }
            case Z3_OP_BADD: {
                return FunctionDeclarationKind.BV_ADD;
            }
            case Z3_OP_BSUB: {
                return FunctionDeclarationKind.BV_SUB;
            }
            case Z3_OP_BMUL: {
                return FunctionDeclarationKind.BV_MUL;
            }
            case Z3_OP_BUDIV: {
                return FunctionDeclarationKind.BV_UDIV;
            }
            case Z3_OP_BSDIV: {
                return FunctionDeclarationKind.BV_SDIV;
            }
            case Z3_OP_BUREM: {
                return FunctionDeclarationKind.BV_UREM;
            }
            case Z3_OP_BSREM: {
                return FunctionDeclarationKind.BV_SREM;
            }
            case Z3_OP_BSHL: {
                return FunctionDeclarationKind.BV_SHL;
            }
            case Z3_OP_BLSHR: {
                return FunctionDeclarationKind.BV_LSHR;
            }
            case Z3_OP_BASHR: {
                return FunctionDeclarationKind.BV_ASHR;
            }
            case Z3_OP_SIGN_EXT: {
                return FunctionDeclarationKind.BV_SIGN_EXTENSION;
            }
            case Z3_OP_ZERO_EXT: {
                return FunctionDeclarationKind.BV_ZERO_EXTENSION;
            }
            case Z3_OP_FPA_NEG: {
                return FunctionDeclarationKind.FP_NEG;
            }
            case Z3_OP_FPA_ABS: {
                return FunctionDeclarationKind.FP_ABS;
            }
            case Z3_OP_FPA_MAX: {
                return FunctionDeclarationKind.FP_MAX;
            }
            case Z3_OP_FPA_MIN: {
                return FunctionDeclarationKind.FP_MIN;
            }
            case Z3_OP_FPA_SQRT: {
                return FunctionDeclarationKind.FP_SQRT;
            }
            case Z3_OP_FPA_SUB: {
                return FunctionDeclarationKind.FP_SUB;
            }
            case Z3_OP_FPA_ADD: {
                return FunctionDeclarationKind.FP_ADD;
            }
            case Z3_OP_FPA_DIV: {
                return FunctionDeclarationKind.FP_DIV;
            }
            case Z3_OP_FPA_MUL: {
                return FunctionDeclarationKind.FP_MUL;
            }
            case Z3_OP_FPA_LT: {
                return FunctionDeclarationKind.FP_LT;
            }
            case Z3_OP_FPA_LE: {
                return FunctionDeclarationKind.FP_LE;
            }
            case Z3_OP_FPA_GE: {
                return FunctionDeclarationKind.FP_GE;
            }
            case Z3_OP_FPA_GT: {
                return FunctionDeclarationKind.FP_GT;
            }
            case Z3_OP_FPA_EQ: {
                return FunctionDeclarationKind.FP_EQ;
            }
            case Z3_OP_FPA_RM_NEAREST_TIES_TO_EVEN: {
                return FunctionDeclarationKind.FP_ROUND_EVEN;
            }
            case Z3_OP_FPA_RM_NEAREST_TIES_TO_AWAY: {
                return FunctionDeclarationKind.FP_ROUND_AWAY;
            }
            case Z3_OP_FPA_RM_TOWARD_POSITIVE: {
                return FunctionDeclarationKind.FP_ROUND_POSITIVE;
            }
            case Z3_OP_FPA_RM_TOWARD_NEGATIVE: {
                return FunctionDeclarationKind.FP_ROUND_NEGATIVE;
            }
            case Z3_OP_FPA_RM_TOWARD_ZERO: {
                return FunctionDeclarationKind.FP_ROUND_ZERO;
            }
            case Z3_OP_FPA_ROUND_TO_INTEGRAL: {
                return FunctionDeclarationKind.FP_ROUND_TO_INTEGRAL;
            }
            case Z3_OP_FPA_TO_FP_UNSIGNED: {
                return FunctionDeclarationKind.BV_UCASTTO_FP;
            }
            case Z3_OP_FPA_TO_SBV: {
                return FunctionDeclarationKind.FP_CASTTO_SBV;
            }
            case Z3_OP_FPA_TO_UBV: {
                return FunctionDeclarationKind.FP_CASTTO_UBV;
            }
            case Z3_OP_FPA_TO_IEEE_BV: {
                return FunctionDeclarationKind.FP_AS_IEEEBV;
            }
            case Z3_OP_FPA_TO_FP: {
                Z3_sort_kind sortKind = Z3_sort_kind.fromInt((int)Native.getSortKind((long)((Long)this.environment), (long)Native.getSort((long)((Long)this.environment), (long)Native.getAppArg((long)((Long)this.environment), (long)f, (int)1))));
                if (Z3_sort_kind.Z3_BV_SORT == sortKind) {
                    return FunctionDeclarationKind.BV_SCASTTO_FP;
                }
                return FunctionDeclarationKind.FP_CASTTO_FP;
            }
            case Z3_OP_FPA_IS_NAN: {
                return FunctionDeclarationKind.FP_IS_NAN;
            }
            case Z3_OP_FPA_IS_INF: {
                return FunctionDeclarationKind.FP_IS_INF;
            }
            case Z3_OP_FPA_IS_ZERO: {
                return FunctionDeclarationKind.FP_IS_ZERO;
            }
            case Z3_OP_FPA_IS_NEGATIVE: {
                return FunctionDeclarationKind.FP_IS_NEGATIVE;
            }
            case Z3_OP_FPA_IS_SUBNORMAL: {
                return FunctionDeclarationKind.FP_IS_SUBNORMAL;
            }
            case Z3_OP_FPA_IS_NORMAL: {
                return FunctionDeclarationKind.FP_IS_NORMAL;
            }
            case Z3_OP_SEQ_CONCAT: {
                return FunctionDeclarationKind.STR_CONCAT;
            }
            case Z3_OP_SEQ_PREFIX: {
                return FunctionDeclarationKind.STR_PREFIX;
            }
            case Z3_OP_SEQ_SUFFIX: {
                return FunctionDeclarationKind.STR_SUFFIX;
            }
            case Z3_OP_SEQ_CONTAINS: {
                return FunctionDeclarationKind.STR_CONTAINS;
            }
            case Z3_OP_SEQ_EXTRACT: {
                return FunctionDeclarationKind.STR_SUBSTRING;
            }
            case Z3_OP_SEQ_REPLACE: {
                return FunctionDeclarationKind.STR_REPLACE;
            }
            case Z3_OP_SEQ_AT: {
                return FunctionDeclarationKind.STR_CHAR_AT;
            }
            case Z3_OP_SEQ_LENGTH: {
                return FunctionDeclarationKind.STR_LENGTH;
            }
            case Z3_OP_SEQ_INDEX: {
                return FunctionDeclarationKind.STR_INDEX_OF;
            }
            case Z3_OP_SEQ_TO_RE: {
                return FunctionDeclarationKind.STR_TO_RE;
            }
            case Z3_OP_SEQ_IN_RE: {
                return FunctionDeclarationKind.STR_IN_RE;
            }
            case Z3_OP_STR_TO_INT: {
                return FunctionDeclarationKind.STR_TO_INT;
            }
            case Z3_OP_INT_TO_STR: {
                return FunctionDeclarationKind.INT_TO_STR;
            }
            case Z3_OP_STRING_LT: {
                return FunctionDeclarationKind.STR_LT;
            }
            case Z3_OP_STRING_LE: {
                return FunctionDeclarationKind.STR_LE;
            }
            case Z3_OP_RE_PLUS: {
                return FunctionDeclarationKind.RE_PLUS;
            }
            case Z3_OP_RE_STAR: {
                return FunctionDeclarationKind.RE_STAR;
            }
            case Z3_OP_RE_OPTION: {
                return FunctionDeclarationKind.RE_OPTIONAL;
            }
            case Z3_OP_RE_CONCAT: {
                return FunctionDeclarationKind.RE_CONCAT;
            }
            case Z3_OP_RE_UNION: {
                return FunctionDeclarationKind.RE_UNION;
            }
            case Z3_OP_RE_RANGE: {
                return FunctionDeclarationKind.RE_RANGE;
            }
            case Z3_OP_RE_INTERSECT: {
                return FunctionDeclarationKind.RE_INTERSECT;
            }
            case Z3_OP_RE_COMPLEMENT: {
                return FunctionDeclarationKind.RE_COMPLEMENT;
            }
        }
        return FunctionDeclarationKind.OTHER;
    }

    public boolean isConstant(long value) {
        return Native.isNumeralAst((long)((Long)this.environment), (long)value) || Native.isAlgebraicNumber((long)((Long)this.environment), (long)value) || Native.isString((long)((Long)this.environment), (long)value) || Z3FormulaCreator.isOP((Long)this.environment, value, Z3_decl_kind.Z3_OP_TRUE.toInt()) || Z3FormulaCreator.isOP((Long)this.environment, value, Z3_decl_kind.Z3_OP_FALSE.toInt());
    }

    @Override
    public Object convertValue(Long value) {
        if (!this.isConstant(value)) {
            return null;
        }
        Native.incRef((long)((Long)this.environment), (long)value);
        Object constantValue = Z3_CONSTANTS.get((Object)Native.getDeclKind((long)((Long)this.environment), (long)Native.getAppDecl((long)((Long)this.environment), (long)value)));
        if (constantValue != null) {
            return constantValue;
        }
        try {
            FormulaType<?> type = this.getFormulaType(value);
            if (type.isBooleanType()) {
                Boolean bl = Z3FormulaCreator.isOP((Long)this.environment, value, Z3_decl_kind.Z3_OP_TRUE.toInt());
                return bl;
            }
            if (type.isIntegerType()) {
                BigInteger bigInteger = new BigInteger(Native.getNumeralString((long)((Long)this.environment), (long)value));
                return bigInteger;
            }
            if (type.isRationalType()) {
                Rational rat = Rational.ofString(Native.getNumeralString((long)((Long)this.environment), (long)value));
                Number number = rat.isIntegral() ? rat.getNum() : rat;
                return number;
            }
            if (type.isStringType()) {
                String string = Native.getString((long)((Long)this.environment), (long)value);
                return string;
            }
            if (type.isBitvectorType()) {
                BigInteger bigInteger = new BigInteger(Native.getNumeralString((long)((Long)this.environment), (long)value));
                return bigInteger;
            }
            if (type.isFloatingPointType()) {
                Object object = this.convertValue(Native.simplify((long)((Long)this.environment), (long)Native.mkFpaToReal((long)((Long)this.environment), (long)value)));
                return object;
            }
            throw new IllegalArgumentException("Unexpected type encountered: " + type);
        }
        finally {
            Native.decRef((long)((Long)this.environment), (long)value);
        }
    }

    @Override
    public Long declareUFImpl(String pName, Long returnType, List<Long> pArgTypes) {
        long symbol = Native.mkStringSymbol((long)((Long)this.environment), (String)pName);
        long[] sorts = Longs.toArray(pArgTypes);
        long func = Native.mkFuncDecl((long)((Long)this.environment), (long)symbol, (int)sorts.length, (long[])sorts, (long)returnType);
        Native.incRef((long)((Long)this.environment), (long)func);
        this.symbolsToDeclarations.put(pName, func);
        return func;
    }

    @Override
    public Long callFunctionImpl(Long declaration, List<Long> args) {
        return Native.mkApp((long)((Long)this.environment), (long)declaration, (int)args.size(), (long[])Longs.toArray(args));
    }

    @Override
    protected Long getBooleanVarDeclarationImpl(Long pLong) {
        return Native.getAppDecl((long)((Long)this.getEnv()), (long)pLong);
    }

    static boolean isOP(long z3context, long expr, int op) {
        if (!Native.isApp((long)z3context, (long)expr)) {
            return false;
        }
        long decl = Native.getAppDecl((long)z3context, (long)expr);
        return Native.getDeclKind((long)z3context, (long)decl) == op;
    }

    public long applyTactics(long z3context, Long pF, String ... pTactics) throws InterruptedException, SolverException {
        long overallResult = pF;
        for (String tactic : pTactics) {
            overallResult = this.applyTactic(z3context, overallResult, tactic);
        }
        return overallResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long applyTactic(long z3context, long pF, String tactic) throws InterruptedException {
        long result;
        long tacticObject = Native.mkTactic((long)z3context, (String)tactic);
        Native.tacticIncRef((long)z3context, (long)tacticObject);
        long goal = Native.mkGoal((long)z3context, (boolean)true, (boolean)false, (boolean)false);
        Native.goalIncRef((long)z3context, (long)goal);
        Native.goalAssert((long)z3context, (long)goal, (long)pF);
        try {
            result = Native.tacticApply((long)z3context, (long)tacticObject, (long)goal);
        }
        catch (Z3Exception exp) {
            throw this.handleZ3Exception(exp);
        }
        try {
            long l = this.applyResultToAST(z3context, result);
            return l;
        }
        finally {
            Native.goalDecRef((long)z3context, (long)goal);
            Native.tacticDecRef((long)z3context, (long)tacticObject);
        }
    }

    private long applyResultToAST(long z3context, long applyResult) {
        int subgoalsCount = Native.applyResultGetNumSubgoals((long)z3context, (long)applyResult);
        long[] goalFormulas = new long[subgoalsCount];
        for (int i = 0; i < subgoalsCount; ++i) {
            long subgoal = Native.applyResultGetSubgoal((long)z3context, (long)applyResult, (int)i);
            goalFormulas[i] = this.goalToAST(z3context, subgoal);
        }
        return goalFormulas.length == 1 ? goalFormulas[0] : Native.mkOr((long)z3context, (int)goalFormulas.length, (long[])goalFormulas);
    }

    private long goalToAST(long z3context, long goal) {
        int subgoalFormulasCount = Native.goalSize((long)z3context, (long)goal);
        long[] subgoalFormulas = new long[subgoalFormulasCount];
        for (int k = 0; k < subgoalFormulasCount; ++k) {
            subgoalFormulas[k] = Native.goalFormula((long)z3context, (long)goal, (int)k);
        }
        return subgoalFormulas.length == 1 ? subgoalFormulas[0] : Native.mkAnd((long)z3context, (int)subgoalFormulas.length, (long[])subgoalFormulas);
    }

    public void forceClose() {
        this.cleanupReferences();
        for (long ast : this.referenceMap.values()) {
            Native.decRef((long)((Long)this.getEnv()), (long)ast);
        }
    }

    @Nullable Long getKnownDeclaration(String symbolName) {
        return this.symbolsToDeclarations.get(symbolName);
    }
}

