/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.java_smt.test;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import org.sosy_lab.java_smt.api.BitvectorFormulaManager;
import org.sosy_lab.java_smt.api.BooleanFormula;
import org.sosy_lab.java_smt.api.BooleanFormulaManager;

class HardBitvectorFormulaGenerator {
    private final BitvectorFormulaManager bvmgr;
    private final BooleanFormulaManager bfmgr;
    private static final String CHOICE_PREFIX = "bool@";
    private static final String COUNTER_PREFIX = "bv@";
    private static final int BITVECTOR_WIDTH = 32;

    HardBitvectorFormulaGenerator(BitvectorFormulaManager pBvmgr, BooleanFormulaManager pBfmgr) {
        this.bvmgr = pBvmgr;
        this.bfmgr = pBfmgr;
    }

    BooleanFormula generate(int n) {
        Preconditions.checkArgument((n >= 2 ? 1 : 0) != 0);
        ArrayList<BooleanFormula> clauses = new ArrayList<BooleanFormula>();
        clauses.add(this.bvmgr.equal(this.bvmgr.makeVariable(32, "bv@0"), this.bvmgr.makeBitvector(32, 0L)));
        int lastIdx = 0;
        int expected = 0;
        for (int i = 1; i < 2 * n; i += 2) {
            BooleanFormula selector = this.bfmgr.makeVariable(CHOICE_PREFIX + i);
            clauses.add(this.bfmgr.or(this.mkConstraint(i, 3, selector), this.mkConstraint(i, 2, this.bfmgr.not(selector))));
            clauses.add(this.bfmgr.or(this.mkConstraint(i + 1, 3, this.bfmgr.not(selector)), this.mkConstraint(i + 1, 2, selector)));
            lastIdx = i + 1;
            expected += 5;
        }
        clauses.add(this.bvmgr.greaterThan(this.bvmgr.makeVariable(32, COUNTER_PREFIX + lastIdx), this.bvmgr.makeBitvector(32, expected), false));
        return this.bfmgr.and(clauses);
    }

    private BooleanFormula mkConstraint(int newIdx, int increment, BooleanFormula selector) {
        return this.bfmgr.and(selector, this.bvmgr.equal(this.bvmgr.makeVariable(32, COUNTER_PREFIX + newIdx), this.bvmgr.add(this.bvmgr.makeVariable(32, COUNTER_PREFIX + (newIdx - 1)), this.bvmgr.makeBitvector(32, increment))));
    }
}

