/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.smtsolver.external;

import com.github.jhoenicke.javacup.runtime.SimpleSymbolFactory;
import com.github.jhoenicke.javacup.runtime.Symbol;
import de.uni_freiburg.informatik.ultimate.core.lib.exceptions.ToolchainCanceledException;
import de.uni_freiburg.informatik.ultimate.core.lib.util.MonitoredProcess;
import de.uni_freiburg.informatik.ultimate.core.model.services.ILogger;
import de.uni_freiburg.informatik.ultimate.core.model.services.IUltimateServiceProvider;
import de.uni_freiburg.informatik.ultimate.logic.Assignments;
import de.uni_freiburg.informatik.ultimate.logic.SMTLIBException;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.smtsolver.external.Lexer;
import de.uni_freiburg.informatik.ultimate.smtsolver.external.Parser;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.output.TeeOutputStream;

class Executor {
    private MonitoredProcess mProcess;
    private Lexer mLexer;
    private BufferedWriter mWriter;
    private InputStream mStdErr;
    private final Script mScript;
    private final Parser mParser;
    private final String mSolverCmd;
    private final ILogger mLogger;
    private final IUltimateServiceProvider mServices;
    private final String mName;
    private final String mFullPathOfDumpedFile;
    private static final String EOF_ERROR_MSG = "Received EOF on stdin.";

    Executor(String solverCommand, Script script, ILogger logger, IUltimateServiceProvider services, String solverName, String fullPathOfDumpedFile) throws IOException {
        this.mServices = services;
        this.mSolverCmd = solverCommand;
        this.mScript = script;
        this.mLogger = logger;
        this.mName = solverName;
        this.mFullPathOfDumpedFile = fullPathOfDumpedFile;
        this.mParser = new Parser();
        this.mParser.setScript(this.mScript);
        this.createProcess();
    }

    private void createProcess() throws IOException {
        OutputStream underlying;
        this.mProcess = MonitoredProcess.exec((String)this.mSolverCmd, (String)"(exit)", (IUltimateServiceProvider)this.mServices);
        if (this.mProcess == null) {
            String errorMsg = String.valueOf(this.getLogStringPrefix()) + " Could not create process, terminating... ";
            this.mLogger.fatal((Object)errorMsg);
            throw new IllegalStateException(errorMsg);
        }
        this.mProcess.setTerminationAfterTimeout(1000L);
        OutputStream stdin = this.mProcess.getOutputStream();
        InputStream stdout = this.mProcess.getInputStream();
        this.mStdErr = this.mProcess.getErrorStream();
        SimpleSymbolFactory symfactory = new SimpleSymbolFactory();
        this.mLexer = new Lexer(new InputStreamReader(stdout));
        this.mLexer.setSymbolFactory(symfactory);
        if (this.mFullPathOfDumpedFile != null) {
            File logFile = new File(this.mFullPathOfDumpedFile);
            FileOutputStream fos = new FileOutputStream(logFile);
            underlying = new TeeOutputStream(stdin, (OutputStream)fos);
        } else {
            underlying = stdin;
        }
        this.mWriter = new BufferedWriter(new OutputStreamWriter(underlying));
        this.input("(set-option :print-success true)");
        this.parseSuccess();
    }

    public void input(String in) {
        if (this.mLogger.isDebugEnabled()) {
            this.mLogger.debug((Object)(String.valueOf(this.getLogStringPrefix()) + " " + in));
        }
        try {
            this.mWriter.write(String.valueOf(in) + System.lineSeparator() + System.lineSeparator());
            this.mWriter.flush();
        }
        catch (IOException e) {
            throw this.convertIOException(e);
        }
    }

    public void exit() {
        if (this.mProcess != null && this.mProcess.isRunning()) {
            this.input("(exit)");
            this.mProcess.forceShutdown();
        }
        this.mProcess = null;
    }

    public static List<Symbol> parseSexpr(Lexer lexer) throws IOException {
        ArrayList<Symbol> result = new ArrayList<Symbol>();
        int parenLevel = 0;
        do {
            Symbol sym = lexer.next_token();
            if (sym.sym == 101) {
                ++parenLevel;
            } else if (sym.sym == 102) {
                --parenLevel;
            } else if (sym.sym == 1) break;
            result.add(sym);
        } while (parenLevel > 0);
        return result;
    }

    private List<Symbol> readAnswer() {
        try {
            List<Symbol> result = Executor.parseSexpr(this.mLexer);
            if (this.mLogger.isDebugEnabled()) {
                for (Symbol s : result) {
                    this.mLogger.debug((Object)s.toString());
                }
            }
            return result;
        }
        catch (IOException e) {
            throw this.convertIOException(e);
        }
    }

    public void reset() throws IOException {
        try {
            this.mWriter.write("(exit)\n");
            this.mWriter.flush();
        }
        catch (IOException iOException) {}
        this.mProcess.forceShutdown();
        this.createProcess();
    }

    public Symbol parse(int what) {
        List<Symbol> answer = this.readAnswer();
        String stderr = "";
        try {
            if (this.mStdErr.available() > 0) {
                StringBuilder sb = new StringBuilder();
                while (this.mStdErr.available() > 0) {
                    int i = this.mStdErr.read();
                    char c = (char)i;
                    sb.append(c);
                }
                stderr = sb.toString();
                this.mLogger.warn((Object)(String.valueOf(this.getLogStringPrefix()) + " " + Executor.generateStderrMessage(stderr)));
            }
        }
        catch (IOException iOException) {}
        answer.add(0, new Symbol(what));
        this.mParser.setAnswer(answer);
        try {
            return this.mParser.parse();
        }
        catch (SMTLIBException ex) {
            if (this.mServices.getProgressMonitorService().continueProcessing()) {
                if (ex.getMessage().equals("EOF")) {
                    throw new SMTLIBException(String.format("%s %s %s", this.getLogStringPrefix(), EOF_ERROR_MSG, Executor.generateStderrMessage(stderr)), (Throwable)ex);
                }
                throw ex;
            }
            throw new ToolchainCanceledException(this.getClass());
        }
        catch (IOException e) {
            throw this.convertIOException(e);
        }
        catch (Exception ex) {
            throw new SMTLIBException(String.format("%s %s %s", this.getLogStringPrefix(), "Unexpected Exception while parsing", Executor.generateStderrMessage(stderr)), (Throwable)ex);
        }
    }

    public void parseSuccess() {
        this.parse(38);
    }

    public Script.LBool parseCheckSatResult() {
        return (Script.LBool)this.parse((int)6).value;
    }

    public Term[] parseGetAssertionsResult() {
        return (Term[])this.parse((int)17).value;
    }

    public Term[] parseGetUnsatCoreResult() {
        return (Term[])this.parse((int)24).value;
    }

    public Map<Term, Term> parseGetValueResult() {
        return (Map)this.parse((int)25).value;
    }

    public Assignments parseGetAssignmentResult() {
        return (Assignments)this.parse((int)18).value;
    }

    public Object[] parseGetInfoResult() {
        return (Object[])this.parse((int)19).value;
    }

    public Object parseGetOptionResult() {
        return this.parse((int)22).value;
    }

    public Term[] parseInterpolants() {
        return (Term[])this.parse((int)20).value;
    }

    public Term parseTerm() {
        return (Term)this.parse((int)57).value;
    }

    private String getLogStringPrefix() {
        if (this.mProcess != null) {
            return String.format("%s (%s)", this.mName, this.mProcess);
        }
        return String.format("%s (dormant, command %s)", this.mName, this.mSolverCmd);
    }

    private static String generateStderrMessage(String stderr) {
        if (stderr.isEmpty()) {
            return "No stderr output.";
        }
        return "stderr output: " + stderr;
    }

    private RuntimeException convertIOException(IOException ex) {
        if (this.mServices.getProgressMonitorService().continueProcessing()) {
            return new SMTLIBException(String.valueOf(this.getLogStringPrefix()) + " Connection to SMT solver broken", (Throwable)ex);
        }
        return new ToolchainCanceledException(this.getClass());
    }
}

