/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.smtsolver.external;

import de.uni_freiburg.informatik.ultimate.core.model.services.ILogger;
import de.uni_freiburg.informatik.ultimate.core.model.services.IUltimateServiceProvider;
import de.uni_freiburg.informatik.ultimate.logic.Assignments;
import de.uni_freiburg.informatik.ultimate.logic.Logics;
import de.uni_freiburg.informatik.ultimate.logic.Model;
import de.uni_freiburg.informatik.ultimate.logic.NoopScript;
import de.uni_freiburg.informatik.ultimate.logic.SMTLIBException;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.Sort;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermVariable;
import de.uni_freiburg.informatik.ultimate.smtsolver.external.Executor;
import de.uni_freiburg.informatik.ultimate.smtsolver.external.SmtCommandUtils;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.Map;

public class NonIncrementalScriptor
extends NoopScript {
    private static final String PRINT_SUCCESS = ":print-success";
    private static final boolean mNewScriptAfterEachReset = false;
    private int mNewScriptCounter = 0;
    protected final LinkedList<ArrayList<SmtCommandUtils.ISmtCommand<?>>> mCommandStack;
    protected Executor mExecutor;
    private Script.LBool mStatus = Script.LBool.UNKNOWN;
    private PrintWriter mPw;
    private final String mPathOfDumpedFakeNonIncrementalScript;
    private final String mBasenameOfDumpedFakeNonIcrementalScript;

    public NonIncrementalScriptor(String command, ILogger logger, IUltimateServiceProvider services, String solverName, boolean dumpFakeNonIncrementalScript, String pathOfDumpedFakeNonIncrementalScript, String basenameOfDumpedFakeNonIcrementalScript, String fullPathOfDumpedFile) throws IOException {
        if (dumpFakeNonIncrementalScript) {
            this.mPathOfDumpedFakeNonIncrementalScript = pathOfDumpedFakeNonIncrementalScript;
            this.mBasenameOfDumpedFakeNonIcrementalScript = basenameOfDumpedFakeNonIcrementalScript;
            String fullFilename = String.valueOf(pathOfDumpedFakeNonIncrementalScript) + File.separator + basenameOfDumpedFakeNonIcrementalScript + "_fakeNonIncremental.smt2";
            this.mPw = this.constructPrintWriter(fullFilename);
        } else {
            this.mPw = null;
            this.mPathOfDumpedFakeNonIncrementalScript = null;
            this.mBasenameOfDumpedFakeNonIcrementalScript = null;
        }
        this.mExecutor = new Executor(command, (Script)this, logger, services, solverName, fullPathOfDumpedFile);
        this.mCommandStack = new LinkedList();
        this.mCommandStack.push(new ArrayList());
    }

    private String constructFullFilenameForNewScript() {
        String result = String.valueOf(this.mPathOfDumpedFakeNonIncrementalScript) + File.separator + this.mBasenameOfDumpedFakeNonIcrementalScript + "_fakeNonIncremental_" + this.mNewScriptCounter + ".smt2";
        ++this.mNewScriptCounter;
        return result;
    }

    private PrintWriter constructPrintWriter(String filename) throws FileNotFoundException {
        return new PrintWriter((Writer)new BufferedWriter(new OutputStreamWriter(new FileOutputStream(filename))), true);
    }

    protected void addToCurrentAssertionStack(SmtCommandUtils.ISmtCommand<?> smtCommand) {
        this.mCommandStack.getLast().add(smtCommand);
    }

    private void resetAssertionStack() {
        this.mCommandStack.clear();
        this.mCommandStack.add(new ArrayList());
    }

    public void setLogic(Logics logic) throws UnsupportedOperationException, SMTLIBException {
        super.setLogic(logic);
        this.addToCurrentAssertionStack(new SmtCommandUtils.SetLogicCommand(logic.name()));
    }

    public void setOption(String opt, Object value) throws UnsupportedOperationException, SMTLIBException {
        if (!opt.equals(PRINT_SUCCESS)) {
            this.addToCurrentAssertionStack(new SmtCommandUtils.SetOptionCommand(opt, value));
        }
    }

    public void setInfo(String info, Object value) {
        this.addToCurrentAssertionStack(new SmtCommandUtils.SetInfoCommand(info, value));
    }

    public void declareSort(String sort, int arity) throws SMTLIBException {
        super.declareSort(sort, arity);
        this.addToCurrentAssertionStack(new SmtCommandUtils.DeclareSortCommand(sort, arity));
    }

    public void defineSort(String sort, Sort[] sortParams, Sort definition) throws SMTLIBException {
        super.defineSort(sort, sortParams, definition);
        this.addToCurrentAssertionStack(new SmtCommandUtils.DefineSortCommand(sort, sortParams, definition));
    }

    public void declareFun(String fun, Sort[] paramSorts, Sort resultSort) throws SMTLIBException {
        super.declareFun(fun, paramSorts, resultSort);
        this.addToCurrentAssertionStack(new SmtCommandUtils.DeclareFunCommand(fun, paramSorts, resultSort));
    }

    public void defineFun(String fun, TermVariable[] params, Sort resultSort, Term definition) throws SMTLIBException {
        super.defineFun(fun, params, resultSort, definition);
        this.addToCurrentAssertionStack(new SmtCommandUtils.DefineFunCommand(fun, params, resultSort, definition));
    }

    public void push(int levels) throws SMTLIBException {
        super.push(levels);
        int i = 0;
        while (i < levels) {
            this.mCommandStack.add(new ArrayList());
            ++i;
        }
    }

    public void pop(int levels) throws SMTLIBException {
        super.pop(levels);
        int i = 0;
        while (i < levels) {
            this.mCommandStack.removeLast();
            ++i;
        }
        this.mStatus = Script.LBool.UNKNOWN;
    }

    public Script.LBool assertTerm(Term term) throws SMTLIBException {
        this.addToCurrentAssertionStack(new SmtCommandUtils.AssertCommand(term));
        this.mStatus = Script.LBool.UNKNOWN;
        return Script.LBool.UNKNOWN;
    }

    public Script.LBool checkSat() throws SMTLIBException {
        new SmtCommandUtils.ResetCommand().executeWithExecutor(this.mExecutor, this.mPw);
        new SmtCommandUtils.SetOptionCommand(PRINT_SUCCESS, true).executeWithExecutor(this.mExecutor, this.mPw);
        for (ArrayList arrayList : this.mCommandStack) {
            for (SmtCommandUtils.ISmtCommand command : arrayList) {
                command.executeWithExecutor(this.mExecutor, this.mPw);
            }
        }
        this.mStatus = new SmtCommandUtils.CheckSatCommand().executeWithExecutor(this.mExecutor, this.mPw);
        if (this.mPw != null) {
            this.mPw.println("; response to preceding check-sat was " + this.mStatus + " when this script was constructed");
        }
        return this.mStatus;
    }

    public Term[] getAssertions() throws SMTLIBException {
        this.mExecutor.input("(get-assertions)");
        return this.mExecutor.parseGetAssertionsResult();
    }

    public Term getProof() throws SMTLIBException, UnsupportedOperationException {
        throw new UnsupportedOperationException("Proofs are not supported");
    }

    public Term[] getUnsatCore() throws SMTLIBException, UnsupportedOperationException {
        this.mExecutor.input(SmtCommandUtils.GetUnsatCoreCommand.buildString());
        return this.mExecutor.parseGetUnsatCoreResult();
    }

    public Map<Term, Term> getValue(Term[] terms) throws SMTLIBException, UnsupportedOperationException {
        Term[] termArray = terms;
        int n = terms.length;
        int n2 = 0;
        while (n2 < n) {
            Term t = termArray[n2];
            if (!(t.getSort().isNumericSort() || t.getSort() == this.getTheory().getBooleanSort() || t.getSort().getRealSort().getName().equals("BitVec") || t.getSort().getRealSort().getName().equals("FloatingPoint"))) {
                throw new UnsupportedOperationException();
            }
            ++n2;
        }
        this.mExecutor.input(SmtCommandUtils.GetValueCommand.buildString(terms));
        return this.mExecutor.parseGetValueResult();
    }

    public Assignments getAssignment() throws SMTLIBException, UnsupportedOperationException {
        this.mExecutor.input("(get-assignment)");
        return this.mExecutor.parseGetAssignmentResult();
    }

    public Object getOption(String opt) throws UnsupportedOperationException {
        this.mExecutor.input("(get-option " + opt + ")");
        return this.mExecutor.parseGetOptionResult();
    }

    public Object getInfo(String info) throws UnsupportedOperationException {
        this.mExecutor.input("(get-info " + info + ")");
        Object[] result = this.mExecutor.parseGetInfoResult();
        if (result.length == 1) {
            return result[0];
        }
        return result;
    }

    public void exit() {
        this.mExecutor.exit();
    }

    public Term simplify(Term term) throws SMTLIBException {
        throw new UnsupportedOperationException();
    }

    public void reset() {
        super.reset();
        new SmtCommandUtils.ResetCommand().executeWithExecutor(this.mExecutor, this.mPw);
        this.resetAssertionStack();
        this.mStatus = Script.LBool.UNKNOWN;
    }

    public Model getModel() throws SMTLIBException, UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    public Script.LBool getStatus() {
        return this.mStatus;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        boolean isFirst = true;
        for (ArrayList arrayList : this.mCommandStack) {
            if (isFirst) {
                isFirst = false;
            } else {
                sb.append("; next level of assertion stack").append(System.lineSeparator());
            }
            for (SmtCommandUtils.ISmtCommand command : arrayList) {
                sb.append(command.toString()).append(System.lineSeparator());
            }
        }
        return sb.toString();
    }
}

