/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.smtsolver.external;

import de.uni_freiburg.informatik.ultimate.core.model.services.ILogger;
import de.uni_freiburg.informatik.ultimate.core.model.services.IUltimateServiceProvider;
import de.uni_freiburg.informatik.ultimate.logic.Assignments;
import de.uni_freiburg.informatik.ultimate.logic.Logics;
import de.uni_freiburg.informatik.ultimate.logic.Model;
import de.uni_freiburg.informatik.ultimate.logic.NoopScript;
import de.uni_freiburg.informatik.ultimate.logic.SMTLIBException;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.Sort;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermVariable;
import de.uni_freiburg.informatik.ultimate.smtsolver.external.Executor;
import de.uni_freiburg.informatik.ultimate.smtsolver.external.SmtCommandUtils;
import java.io.IOException;
import java.util.Map;

public class Scriptor
extends NoopScript {
    protected Executor mExecutor;
    private Script.LBool mStatus = Script.LBool.UNKNOWN;

    public Scriptor(String command, ILogger logger, IUltimateServiceProvider services, String solverName, String fullPathOfDumpedLogFile) throws IOException {
        this.mExecutor = new Executor(command, (Script)this, logger, services, solverName, fullPathOfDumpedLogFile);
        super.setOption(":print-success", (Object)true);
    }

    public void setLogic(Logics logic) throws UnsupportedOperationException, SMTLIBException {
        super.setLogic(logic);
        this.mExecutor.input(SmtCommandUtils.SetLogicCommand.buildString(logic.name()));
        this.mExecutor.parseSuccess();
    }

    public void setOption(String opt, Object value) throws UnsupportedOperationException, SMTLIBException {
        if (!opt.equals(":print-success")) {
            this.mExecutor.input(SmtCommandUtils.SetOptionCommand.buildString(opt, value));
            this.mExecutor.parseSuccess();
        }
    }

    public void setInfo(String info, Object value) {
        this.mExecutor.input(SmtCommandUtils.SetInfoCommand.buildString(info, value));
        this.mExecutor.parseSuccess();
    }

    public void declareSort(String sort, int arity) throws SMTLIBException {
        super.declareSort(sort, arity);
        this.mExecutor.input(SmtCommandUtils.DeclareSortCommand.buildString(sort, arity));
        this.mExecutor.parseSuccess();
    }

    public void defineSort(String sort, Sort[] sortParams, Sort definition) throws SMTLIBException {
        super.defineSort(sort, sortParams, definition);
        this.mExecutor.input(SmtCommandUtils.DefineSortCommand.buildString(sort, sortParams, definition));
        this.mExecutor.parseSuccess();
    }

    public void declareFun(String fun, Sort[] paramSorts, Sort resultSort) throws SMTLIBException {
        super.declareFun(fun, paramSorts, resultSort);
        this.mExecutor.input(SmtCommandUtils.DeclareFunCommand.buildString(fun, paramSorts, resultSort));
        this.mExecutor.parseSuccess();
    }

    public void defineFun(String fun, TermVariable[] params, Sort resultSort, Term definition) throws SMTLIBException {
        super.defineFun(fun, params, resultSort, definition);
        this.mExecutor.input(SmtCommandUtils.DefineFunCommand.buildString(fun, params, resultSort, definition));
        this.mExecutor.parseSuccess();
    }

    public void push(int levels) throws SMTLIBException {
        super.push(levels);
        this.mExecutor.input("(push " + levels + ")");
        this.mExecutor.parseSuccess();
    }

    public void pop(int levels) throws SMTLIBException {
        super.pop(levels);
        this.mExecutor.input("(pop " + levels + ")");
        this.mExecutor.parseSuccess();
        this.mStatus = Script.LBool.UNKNOWN;
    }

    public Script.LBool assertTerm(Term term) throws SMTLIBException {
        this.mExecutor.input(SmtCommandUtils.AssertCommand.buildString(term));
        this.mExecutor.parseSuccess();
        this.mStatus = Script.LBool.UNKNOWN;
        return Script.LBool.UNKNOWN;
    }

    public Script.LBool checkSat() throws SMTLIBException {
        this.mExecutor.input(SmtCommandUtils.CheckSatCommand.buildString());
        this.mStatus = this.mExecutor.parseCheckSatResult();
        return this.mStatus;
    }

    public Term[] getAssertions() throws SMTLIBException {
        this.mExecutor.input("(get-assertions)");
        return this.mExecutor.parseGetAssertionsResult();
    }

    public Term getProof() throws SMTLIBException, UnsupportedOperationException {
        throw new UnsupportedOperationException("Proofs are not supported");
    }

    public Term[] getUnsatCore() throws SMTLIBException, UnsupportedOperationException {
        this.mExecutor.input(SmtCommandUtils.GetUnsatCoreCommand.buildString());
        return this.mExecutor.parseGetUnsatCoreResult();
    }

    public Map<Term, Term> getValue(Term[] terms) throws SMTLIBException, UnsupportedOperationException {
        Term[] termArray = terms;
        int n = terms.length;
        int n2 = 0;
        while (n2 < n) {
            Term t = termArray[n2];
            if (!(t.getSort().isNumericSort() || t.getSort() == this.getTheory().getBooleanSort() || t.getSort().getRealSort().getName().equals("BitVec") || t.getSort().getRealSort().getName().equals("FloatingPoint"))) {
                throw new UnsupportedOperationException("Cannot provide value for term " + t.toStringDirect() + " of sort " + t.getSort().getRealSort());
            }
            ++n2;
        }
        this.mExecutor.input(SmtCommandUtils.GetValueCommand.buildString(terms));
        return this.mExecutor.parseGetValueResult();
    }

    public Assignments getAssignment() throws SMTLIBException, UnsupportedOperationException {
        this.mExecutor.input("(get-assignment)");
        return this.mExecutor.parseGetAssignmentResult();
    }

    public Object getOption(String opt) throws UnsupportedOperationException {
        this.mExecutor.input("(get-option " + opt + ")");
        return this.mExecutor.parseGetOptionResult();
    }

    public Object getInfo(String info) throws UnsupportedOperationException {
        this.mExecutor.input("(get-info " + info + ")");
        Object[] result = this.mExecutor.parseGetInfoResult();
        if (result.length == 1) {
            return result[0];
        }
        return result;
    }

    public void exit() {
        this.mExecutor.exit();
    }

    public Term simplify(Term term) throws SMTLIBException {
        throw new UnsupportedOperationException();
    }

    public void reset() {
        super.reset();
        try {
            this.mExecutor.reset();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.mStatus = Script.LBool.UNKNOWN;
    }

    public Model getModel() throws SMTLIBException, UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    public Script.LBool getStatus() {
        return this.mStatus;
    }
}

