/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.smtsolver.external;

import de.uni_freiburg.informatik.ultimate.core.model.services.ILogger;
import de.uni_freiburg.informatik.ultimate.core.model.services.IUltimateServiceProvider;
import de.uni_freiburg.informatik.ultimate.logic.AnnotatedTerm;
import de.uni_freiburg.informatik.ultimate.logic.Annotation;
import de.uni_freiburg.informatik.ultimate.logic.ApplicationTerm;
import de.uni_freiburg.informatik.ultimate.logic.PrintTerm;
import de.uni_freiburg.informatik.ultimate.logic.SMTLIBException;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.smtsolver.external.Executor;
import de.uni_freiburg.informatik.ultimate.smtsolver.external.Scriptor;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public class ScriptorWithGetInterpolants
extends Scriptor {
    private final IInterpolationAdapter mInterpolationAdapter;

    public ScriptorWithGetInterpolants(String command, ILogger logger, IUltimateServiceProvider services, ExternalInterpolator externalInterpolator, String name, String fullPathOfDumpedFile) throws IOException {
        super(command, logger, services, name, fullPathOfDumpedFile);
        this.mInterpolationAdapter = this.createAdapter(externalInterpolator);
    }

    private IInterpolationAdapter createAdapter(ExternalInterpolator interpolator) {
        switch (interpolator) {
            case IZ3: {
                return new Z3Interpolation();
            }
            case MATHSAT: {
                return new MathsatInterpolation();
            }
            case PRINCESS: 
            case SMTINTERPOL: {
                return new SmtInterpolInterpolation();
            }
        }
        throw new AssertionError((Object)("Unknown ExternalInterpolator: " + (Object)((Object)interpolator)));
    }

    public Term[] getInterpolants(Term[] partition) throws SMTLIBException {
        return this.mInterpolationAdapter.getInterpolants(partition);
    }

    public Term[] getInterpolants(Term[] partition, int[] startOfSubtree) throws SMTLIBException {
        return this.mInterpolationAdapter.getInterpolants(partition, startOfSubtree);
    }

    @Override
    public Script.LBool assertTerm(Term term) throws SMTLIBException {
        return this.mInterpolationAdapter.assertTerm(term);
    }

    private Executor getExecutor() {
        return this.mExecutor;
    }

    private static String buildInterpolationCommand(String initialCommand, Term[] partition) {
        StringBuilder command = new StringBuilder();
        PrintTerm pt = new PrintTerm();
        command.append(initialCommand);
        String sep = "";
        Term[] termArray = partition;
        int n = partition.length;
        int n2 = 0;
        while (n2 < n) {
            Term t = termArray[n2];
            command.append(sep);
            pt.append((Appendable)command, t);
            sep = " ";
            ++n2;
        }
        command.append(")");
        return command.toString();
    }

    private static String buildInterpolationCommand(String initialCommand, Term[] partition, int[] startOfSubtree) {
        StringBuilder command = new StringBuilder();
        PrintTerm pt = new PrintTerm();
        command.append(initialCommand);
        pt.append((Appendable)command, partition[0]);
        int i = 1;
        while (i < partition.length) {
            int prevStart = startOfSubtree[i - 1];
            while (startOfSubtree[i] < prevStart) {
                command.append(')');
                prevStart = startOfSubtree[prevStart - 1];
            }
            command.append(' ');
            if (startOfSubtree[i] == i) {
                command.append('(');
            }
            pt.append((Appendable)command, partition[i]);
            ++i;
        }
        command.append(')');
        return command.toString();
    }

    public static enum ExternalInterpolator {
        IZ3,
        PRINCESS,
        SMTINTERPOL,
        MATHSAT;

    }

    private static interface IInterpolationAdapter {
        public Term[] getInterpolants(Term[] var1) throws SMTLIBException, UnsupportedOperationException;

        public Term[] getInterpolants(Term[] var1, int[] var2) throws SMTLIBException, UnsupportedOperationException;

        public Script.LBool assertTerm(Term var1) throws SMTLIBException;
    }

    private final class MathsatInterpolation
    implements IInterpolationAdapter {
        private static final String CMD = "(get-interpolant (";

        private MathsatInterpolation() {
        }

        @Override
        public Term[] getInterpolants(Term[] partition) throws SMTLIBException {
            ArrayList<Term> currentA = new ArrayList<Term>();
            ArrayList<Term> interpolants = new ArrayList<Term>();
            int i = 0;
            while (i < partition.length) {
                List<Term> current = this.flatten(partition[i]);
                currentA.addAll(current);
                this.sendInterpolationCommand(currentA.toArray(new Term[currentA.size()]));
                interpolants.addAll(Arrays.asList(this.readInterpolants()));
                ++i;
            }
            return interpolants.toArray(new Term[interpolants.size()]);
        }

        @Override
        public Term[] getInterpolants(Term[] partition, int[] startOfSubtree) throws SMTLIBException {
            throw new UnsupportedOperationException("Not yet implemented");
        }

        @Override
        public Script.LBool assertTerm(Term term) throws SMTLIBException {
            Term actualTerm = this.convertAnnotationNamedToInterpolationGroup(term);
            return ScriptorWithGetInterpolants.super.assertTerm(actualTerm);
        }

        private Term convertAnnotationNamedToInterpolationGroup(Term term) {
            if (term instanceof AnnotatedTerm) {
                AnnotatedTerm aterm = (AnnotatedTerm)term;
                Annotation[] annots = aterm.getAnnotations();
                Annotation[] newAnnots = new Annotation[annots.length];
                boolean changed = false;
                int i = 0;
                while (i < annots.length) {
                    Annotation annot = annots[i];
                    if (":named".equals(annot.getKey())) {
                        changed = true;
                        newAnnots[i] = new Annotation(":interpolation-group", annot.getValue());
                    } else {
                        newAnnots[i] = annot;
                    }
                    ++i;
                }
                if (changed) {
                    return ScriptorWithGetInterpolants.this.annotate(aterm.getSubterm(), newAnnots);
                }
            }
            return term;
        }

        private void sendInterpolationCommand(Term[] partition) {
            StringBuilder command = new StringBuilder();
            PrintTerm pt = new PrintTerm();
            command.append(CMD);
            String sep = "";
            Term[] termArray = partition;
            int n = partition.length;
            int n2 = 0;
            while (n2 < n) {
                Term t = termArray[n2];
                command.append(sep);
                pt.append((Appendable)command, t);
                sep = " ";
                ++n2;
            }
            command.append("))");
            ScriptorWithGetInterpolants.this.getExecutor().input(command.toString());
        }

        private void sendInterpolationCommand(Term[] partition, int[] startOfSubtree) {
            String command = ScriptorWithGetInterpolants.buildInterpolationCommand(CMD, partition, startOfSubtree);
            ScriptorWithGetInterpolants.this.getExecutor().input(command);
        }

        private Term readInterpolants() {
            return ScriptorWithGetInterpolants.this.mExecutor.parseTerm();
        }

        private List<Term> flatten(Term t) {
            ApplicationTerm aTerm;
            if (t instanceof ApplicationTerm && "and".equals((aTerm = (ApplicationTerm)t).getFunction().getName())) {
                return Arrays.asList(aTerm.getParameters());
            }
            return Collections.singletonList(t);
        }
    }

    private final class SmtInterpolInterpolation
    implements IInterpolationAdapter {
        private static final String CMD = "(get-interpolants ";

        private SmtInterpolInterpolation() {
        }

        @Override
        public Term[] getInterpolants(Term[] partition) throws SMTLIBException, UnsupportedOperationException {
            this.sendInterpolationCommand(partition);
            return this.readInterpolants();
        }

        @Override
        public Term[] getInterpolants(Term[] partition, int[] startOfSubtree) throws SMTLIBException {
            this.sendInterpolationCommand(partition, startOfSubtree);
            return this.readInterpolants();
        }

        @Override
        public Script.LBool assertTerm(Term term) throws SMTLIBException {
            return ScriptorWithGetInterpolants.super.assertTerm(term);
        }

        private void sendInterpolationCommand(Term[] partition) {
            String command = ScriptorWithGetInterpolants.buildInterpolationCommand(CMD, partition);
            ScriptorWithGetInterpolants.this.getExecutor().input(command);
        }

        private void sendInterpolationCommand(Term[] partition, int[] startOfSubtree) {
            String command = ScriptorWithGetInterpolants.buildInterpolationCommand(CMD, partition, startOfSubtree);
            ScriptorWithGetInterpolants.this.getExecutor().input(command);
        }

        private Term[] readInterpolants() {
            return ScriptorWithGetInterpolants.this.mExecutor.parseGetAssertionsResult();
        }
    }

    private final class Z3Interpolation
    implements IInterpolationAdapter {
        private static final String CMD = "(get-interpolant ";

        private Z3Interpolation() {
        }

        @Override
        public Term[] getInterpolants(Term[] partition) throws SMTLIBException {
            this.sendInterpolationCommand(partition);
            return this.readInterpolants();
        }

        @Override
        public Term[] getInterpolants(Term[] partition, int[] startOfSubtree) throws SMTLIBException {
            this.sendInterpolationCommand(partition, startOfSubtree);
            return this.readInterpolants();
        }

        @Override
        public Script.LBool assertTerm(Term term) throws SMTLIBException {
            return ScriptorWithGetInterpolants.super.assertTerm(term);
        }

        private void sendInterpolationCommand(Term[] partition) {
            String command = ScriptorWithGetInterpolants.buildInterpolationCommand(CMD, partition);
            ScriptorWithGetInterpolants.this.getExecutor().input(command);
        }

        private void sendInterpolationCommand(Term[] partition, int[] startOfSubtree) {
            String command = ScriptorWithGetInterpolants.buildInterpolationCommand(CMD, partition, startOfSubtree);
            ScriptorWithGetInterpolants.this.getExecutor().input(command);
        }

        private Term[] readInterpolants() {
            return ScriptorWithGetInterpolants.this.mExecutor.parseInterpolants();
        }
    }
}

