/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.smtsolver.external;

import de.uni_freiburg.informatik.ultimate.logic.PrintTerm;
import de.uni_freiburg.informatik.ultimate.logic.QuotedObject;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.Sort;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermVariable;
import de.uni_freiburg.informatik.ultimate.smtsolver.external.Executor;
import java.io.PrintWriter;
import java.util.Map;

public class SmtCommandUtils {

    public static class AssertCommand
    implements ISmtCommand<Void> {
        private final Term mTerm;

        public AssertCommand(Term term) {
            this.mTerm = term;
        }

        public Term getTerm() {
            return this.mTerm;
        }

        public static String buildString(Term term) {
            return "(assert " + term.toString() + ")";
        }

        @Override
        public Void executeWithScript(Script script) {
            script.assertTerm(this.mTerm);
            return null;
        }

        @Override
        public String toString() {
            return AssertCommand.buildString(this.mTerm);
        }

        @Override
        public Void executeWithExecutor(Executor executor, PrintWriter pw) {
            String command = this.toString();
            if (pw != null) {
                pw.println(command);
            }
            executor.input(command);
            executor.parseSuccess();
            return null;
        }
    }

    public static class CheckSatCommand
    implements ISmtCommand<Script.LBool> {
        public static String buildString() {
            return "(check-sat)";
        }

        @Override
        public Script.LBool executeWithScript(Script script) {
            return script.checkSat();
        }

        @Override
        public String toString() {
            return CheckSatCommand.buildString();
        }

        @Override
        public Script.LBool executeWithExecutor(Executor executor, PrintWriter pw) {
            String command = this.toString();
            if (pw != null) {
                pw.println(command);
            }
            executor.input(command);
            return executor.parseCheckSatResult();
        }
    }

    public static class DeclareFunCommand
    implements ISmtCommand<Void> {
        final String mFun;
        final Sort[] mParamSorts;
        final Sort mResultSort;

        public DeclareFunCommand(String fun, Sort[] paramSorts, Sort resultSort) {
            this.mFun = fun;
            this.mParamSorts = paramSorts;
            this.mResultSort = resultSort;
        }

        public String getFun() {
            return this.mFun;
        }

        public Sort[] getParamSorts() {
            return this.mParamSorts;
        }

        public Sort getResultSort() {
            return this.mResultSort;
        }

        public static String buildString(String fun, Sort[] paramSorts, Sort resultSort) {
            PrintTerm pt = new PrintTerm();
            StringBuilder sb = new StringBuilder();
            sb.append("(declare-fun ");
            sb.append(PrintTerm.quoteIdentifier((String)fun));
            sb.append(" (");
            String delim = "";
            Sort[] sortArray = paramSorts;
            int n = paramSorts.length;
            int n2 = 0;
            while (n2 < n) {
                Sort s = sortArray[n2];
                sb.append(delim);
                pt.append((Appendable)sb, s);
                delim = " ";
                ++n2;
            }
            sb.append(") ");
            pt.append((Appendable)sb, resultSort);
            sb.append(")");
            return sb.toString();
        }

        @Override
        public Void executeWithScript(Script script) {
            script.declareFun(this.mFun, this.mParamSorts, this.mResultSort);
            return null;
        }

        @Override
        public String toString() {
            return DeclareFunCommand.buildString(this.mFun, this.mParamSorts, this.mResultSort);
        }

        @Override
        public Void executeWithExecutor(Executor executor, PrintWriter pw) {
            String command = this.toString();
            if (pw != null) {
                pw.println(command);
            }
            executor.input(command);
            executor.parseSuccess();
            return null;
        }
    }

    public static class DeclareSortCommand
    implements ISmtCommand<Void> {
        private final String mSort;
        private final int mArity;

        public DeclareSortCommand(String sort, int arity) {
            this.mSort = sort;
            this.mArity = arity;
        }

        public static String buildString(String sort, int arity) {
            StringBuilder sb = new StringBuilder("(declare-sort ").append(PrintTerm.quoteIdentifier((String)sort));
            sb.append(" ").append(arity).append(")");
            return sb.toString();
        }

        @Override
        public Void executeWithScript(Script script) {
            script.declareSort(this.mSort, this.mArity);
            return null;
        }

        @Override
        public String toString() {
            return DeclareSortCommand.buildString(this.mSort, this.mArity);
        }

        @Override
        public Void executeWithExecutor(Executor executor, PrintWriter pw) {
            String command = this.toString();
            if (pw != null) {
                pw.println(command);
            }
            executor.input(command);
            executor.parseSuccess();
            return null;
        }
    }

    public static class DefineFunCommand
    implements ISmtCommand<Void> {
        final String mFun;
        final TermVariable[] mParams;
        final Sort mResultSort;
        final Term mDefinition;

        public DefineFunCommand(String fun, TermVariable[] params, Sort resultSort, Term definition) {
            this.mFun = fun;
            this.mParams = params;
            this.mResultSort = resultSort;
            this.mDefinition = definition;
        }

        public static String buildString(String fun, TermVariable[] params, Sort resultSort, Term definition) {
            PrintTerm pt = new PrintTerm();
            StringBuilder sb = new StringBuilder();
            sb.append("(define-fun ");
            sb.append(PrintTerm.quoteIdentifier((String)fun));
            sb.append(" (");
            String delim = "";
            TermVariable[] termVariableArray = params;
            int n = params.length;
            int n2 = 0;
            while (n2 < n) {
                TermVariable t = termVariableArray[n2];
                sb.append(delim);
                sb.append("(").append(t).append(" ");
                pt.append((Appendable)sb, t.getSort());
                sb.append(")");
                delim = " ";
                ++n2;
            }
            sb.append(") ");
            pt.append((Appendable)sb, resultSort);
            sb.append(" ");
            pt.append((Appendable)sb, definition);
            sb.append(")");
            return sb.toString();
        }

        @Override
        public Void executeWithScript(Script script) {
            script.defineFun(this.mFun, this.mParams, this.mResultSort, this.mDefinition);
            return null;
        }

        @Override
        public String toString() {
            return DefineFunCommand.buildString(this.mFun, this.mParams, this.mResultSort, this.mDefinition);
        }

        @Override
        public Void executeWithExecutor(Executor executor, PrintWriter pw) {
            String command = this.toString();
            if (pw != null) {
                pw.println(command);
            }
            executor.input(command);
            executor.parseSuccess();
            return null;
        }
    }

    public static class DefineSortCommand
    implements ISmtCommand<Void> {
        private final String mSort;
        private final Sort[] mSortParams;
        private final Sort mDefinition;

        public DefineSortCommand(String sort, Sort[] sortParams, Sort definition) {
            this.mSort = sort;
            this.mSortParams = sortParams;
            this.mDefinition = definition;
        }

        public static String buildString(String sort, Sort[] sortParams, Sort definition) {
            PrintTerm pt = new PrintTerm();
            StringBuilder sb = new StringBuilder();
            sb.append("(define-sort ");
            sb.append(PrintTerm.quoteIdentifier((String)sort));
            sb.append(" (");
            String delim = "";
            Sort[] sortArray = sortParams;
            int n = sortParams.length;
            int n2 = 0;
            while (n2 < n) {
                Sort s = sortArray[n2];
                sb.append(delim);
                pt.append((Appendable)sb, s);
                delim = " ";
                ++n2;
            }
            sb.append(") ");
            pt.append((Appendable)sb, definition);
            sb.append(")");
            return sb.toString();
        }

        @Override
        public Void executeWithScript(Script script) {
            script.defineSort(this.mSort, this.mSortParams, this.mDefinition);
            return null;
        }

        @Override
        public String toString() {
            return DefineSortCommand.buildString(this.mSort, this.mSortParams, this.mDefinition);
        }

        @Override
        public Void executeWithExecutor(Executor executor, PrintWriter pw) {
            String command = this.toString();
            if (pw != null) {
                pw.println(command);
            }
            executor.input(command);
            executor.parseSuccess();
            return null;
        }
    }

    public static class EchoCommand
    implements ISmtCommand<Void> {
        final QuotedObject mMsg;

        public EchoCommand(QuotedObject msg) {
            this.mMsg = msg;
        }

        @Override
        public Void executeWithScript(Script script) {
            script.echo(this.mMsg);
            return null;
        }

        public static String buildString(QuotedObject msg) {
            return "(echo " + msg + ")";
        }

        @Override
        public String toString() {
            return EchoCommand.buildString(this.mMsg);
        }

        @Override
        public Void executeWithExecutor(Executor executor, PrintWriter pw) {
            String command = this.toString();
            if (pw != null) {
                pw.println(command);
            }
            executor.input(command);
            executor.parseSuccess();
            return null;
        }
    }

    public static class ExitCommand
    implements ISmtCommand<Void> {
        public static String buildString() {
            return "(exit)";
        }

        @Override
        public Void executeWithScript(Script script) {
            script.reset();
            return null;
        }

        @Override
        public String toString() {
            return ExitCommand.buildString();
        }

        @Override
        public Void executeWithExecutor(Executor executor, PrintWriter pw) {
            String command = this.toString();
            if (pw != null) {
                pw.println(command);
            }
            executor.input(command);
            executor.parseSuccess();
            return null;
        }
    }

    public static class GetUnsatCoreCommand
    implements ISmtCommand<Term[]> {
        public static String buildString() {
            return "(get-unsat-core)";
        }

        @Override
        public Term[] executeWithScript(Script script) {
            return script.getUnsatCore();
        }

        @Override
        public String toString() {
            return GetUnsatCoreCommand.buildString();
        }

        @Override
        public Term[] executeWithExecutor(Executor executor, PrintWriter pw) {
            String command = this.toString();
            if (pw != null) {
                pw.println(command);
            }
            executor.input(command);
            return executor.parseGetUnsatCoreResult();
        }
    }

    public static class GetValueCommand
    implements ISmtCommand<Map<Term, Term>> {
        final Term[] mTerms;

        public GetValueCommand(Term[] terms) {
            this.mTerms = terms;
        }

        public static String buildString(Term[] terms) {
            StringBuilder command = new StringBuilder();
            PrintTerm pt = new PrintTerm();
            command.append("(get-value (");
            String sep = "";
            Term[] termArray = terms;
            int n = terms.length;
            int n2 = 0;
            while (n2 < n) {
                Term t = termArray[n2];
                command.append(sep);
                pt.append((Appendable)command, t);
                sep = " ";
                ++n2;
            }
            command.append("))");
            return command.toString();
        }

        @Override
        public Map<Term, Term> executeWithScript(Script script) {
            return script.getValue(this.mTerms);
        }

        @Override
        public String toString() {
            return GetValueCommand.buildString(this.mTerms);
        }

        @Override
        public Map<Term, Term> executeWithExecutor(Executor executor, PrintWriter pw) {
            return executor.parseGetValueResult();
        }
    }

    public static interface ISmtCommand<RT> {
        public RT executeWithScript(Script var1);

        public RT executeWithExecutor(Executor var1, PrintWriter var2);

        public String toString();
    }

    public static class ResetCommand
    implements ISmtCommand<Void> {
        public static String buildString() {
            return "(reset)";
        }

        @Override
        public Void executeWithScript(Script script) {
            script.reset();
            return null;
        }

        @Override
        public String toString() {
            return ResetCommand.buildString();
        }

        @Override
        public Void executeWithExecutor(Executor executor, PrintWriter pw) {
            String command = this.toString();
            if (pw != null) {
                pw.println(command);
            }
            executor.input(command);
            executor.parseSuccess();
            return null;
        }
    }

    public static class SetInfoCommand
    implements ISmtCommand<Void> {
        private final String mInfo;
        private final Object mValue;

        public SetInfoCommand(String info, Object value) {
            this.mInfo = info;
            this.mValue = value;
        }

        public static String buildString(String info, Object value) {
            StringBuilder sb = new StringBuilder();
            sb.append("(set-info ");
            sb.append(info);
            sb.append(' ');
            sb.append(PrintTerm.quoteObjectIfString((Object)value));
            sb.append(")");
            return sb.toString();
        }

        @Override
        public Void executeWithScript(Script script) {
            script.setInfo(this.mInfo, this.mValue);
            return null;
        }

        @Override
        public String toString() {
            return SetInfoCommand.buildString(this.mInfo, this.mValue);
        }

        @Override
        public Void executeWithExecutor(Executor executor, PrintWriter pw) {
            String command = this.toString();
            if (pw != null) {
                pw.println(command);
            }
            executor.input(command);
            executor.parseSuccess();
            return null;
        }
    }

    public static class SetLogicCommand
    implements ISmtCommand<Void> {
        private final String mLogic;

        public SetLogicCommand(String logic) {
            this.mLogic = logic;
        }

        public static String buildString(String logic) {
            return "(set-logic " + logic + ")";
        }

        @Override
        public Void executeWithScript(Script script) {
            script.setLogic(this.mLogic);
            return null;
        }

        @Override
        public String toString() {
            return SetLogicCommand.buildString(this.mLogic);
        }

        @Override
        public Void executeWithExecutor(Executor executor, PrintWriter pw) {
            String command = this.toString();
            if (pw != null) {
                pw.println(command);
            }
            executor.input(command);
            executor.parseSuccess();
            return null;
        }
    }

    public static class SetOptionCommand
    implements ISmtCommand<Void> {
        private final String mOpt;
        private final Object mValue;

        public SetOptionCommand(String opt, Object value) {
            this.mOpt = opt;
            this.mValue = value;
        }

        public static String buildString(String opt, Object value) {
            StringBuilder sb = new StringBuilder();
            sb.append("(set-option ").append(opt);
            if (value != null) {
                sb.append(" ");
                if (value instanceof String) {
                    sb.append(PrintTerm.quoteIdentifier((String)((String)value)));
                } else if (value instanceof Object[]) {
                    new PrintTerm().append((Appendable)sb, (Object[])value);
                } else {
                    sb.append(value.toString());
                }
            }
            sb.append(")");
            return sb.toString();
        }

        @Override
        public Void executeWithScript(Script script) {
            script.setOption(this.mOpt, this.mValue);
            return null;
        }

        @Override
        public String toString() {
            return SetOptionCommand.buildString(this.mOpt, this.mValue);
        }

        @Override
        public Void executeWithExecutor(Executor executor, PrintWriter pw) {
            String command = this.toString();
            if (pw != null) {
                pw.println(command);
            }
            executor.input(command);
            executor.parseSuccess();
            return null;
        }
    }
}

