/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.smtsolver.external;

import de.uni_freiburg.informatik.ultimate.core.model.services.ILogger;
import de.uni_freiburg.informatik.ultimate.smtinterpol.LogProxy;
import java.io.IOException;
import java.util.Formatter;

public class SmtInterpolLogProxyWrapper
implements LogProxy {
    private final ILogger mLogger;

    public SmtInterpolLogProxyWrapper(ILogger logger) {
        this.mLogger = logger;
    }

    public void setLoglevel(int level) {
    }

    public int getLoglevel() {
        if (this.mLogger.isDebugEnabled()) {
            return 5;
        }
        if (this.mLogger.isInfoEnabled()) {
            return 4;
        }
        if (this.mLogger.isWarnEnabled()) {
            return 3;
        }
        if (this.mLogger.isErrorEnabled()) {
            return 2;
        }
        if (this.mLogger.isFatalEnabled()) {
            return 1;
        }
        return 0;
    }

    public boolean isFatalEnabled() {
        return this.mLogger.isFatalEnabled();
    }

    public boolean isErrorEnabled() {
        return this.mLogger.isErrorEnabled();
    }

    public boolean isWarnEnabled() {
        return this.mLogger.isWarnEnabled();
    }

    public boolean isInfoEnabled() {
        return this.mLogger.isInfoEnabled();
    }

    public boolean isDebugEnabled() {
        return this.mLogger.isDebugEnabled();
    }

    public boolean isTraceEnabled() {
        return false;
    }

    public void outOfMemory(String msg) {
        this.fatal(msg);
    }

    public void fatal(Object msg) {
        if (this.mLogger.isFatalEnabled()) {
            this.log(1, String.valueOf(msg));
        }
    }

    public void error(Object msg) {
        if (this.mLogger.isErrorEnabled()) {
            this.log(2, String.valueOf(msg));
        }
    }

    public void warn(Object msg) {
        if (this.mLogger.isWarnEnabled()) {
            this.log(3, String.valueOf(msg));
        }
    }

    public void info(Object msg) {
        if (this.mLogger.isInfoEnabled()) {
            this.log(4, String.valueOf(msg));
        }
    }

    public void debug(Object msg) {
        if (this.mLogger.isDebugEnabled()) {
            this.log(5, String.valueOf(msg));
        }
    }

    public void trace(Object msg) {
        if (this.mLogger.isDebugEnabled()) {
            this.log(6, String.valueOf(msg));
        }
    }

    public void fatal(String msg, Object ... params) {
        if (this.mLogger.isFatalEnabled()) {
            this.log(1, msg, params);
        }
    }

    public void error(String msg, Object ... params) {
        if (this.mLogger.isErrorEnabled()) {
            this.log(2, msg, params);
        }
    }

    public void warn(String msg, Object ... params) {
        if (this.mLogger.isWarnEnabled()) {
            this.log(3, msg, params);
        }
    }

    public void info(String msg, Object ... params) {
        if (this.mLogger.isInfoEnabled()) {
            this.log(4, msg, params);
        }
    }

    public void debug(String msg, Object ... params) {
        if (this.mLogger.isDebugEnabled()) {
            this.log(5, msg, params);
        }
    }

    public void trace(String msg, Object ... params) {
        if (this.mLogger.isDebugEnabled()) {
            this.log(6, msg, params);
        }
    }

    public boolean canChangeDestination() {
        return false;
    }

    public void changeDestination(String newDest) throws IOException {
    }

    public String getDestination() {
        return "stdout";
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.mLogger == null ? 0 : this.mLogger.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SmtInterpolLogProxyWrapper other = (SmtInterpolLogProxyWrapper)obj;
        return !(this.mLogger == null ? other.mLogger != null : !this.mLogger.equals(other.mLogger));
    }

    private void log(int lvl, String msg) {
        switch (lvl) {
            case 0: {
                return;
            }
            case 5: 
            case 6: {
                this.mLogger.debug((Object)msg);
                return;
            }
            case 4: {
                this.mLogger.info((Object)msg);
                return;
            }
            case 3: {
                this.mLogger.warn((Object)msg);
                return;
            }
            case 2: {
                this.mLogger.error((Object)msg);
                return;
            }
            case 1: {
                this.mLogger.fatal((Object)msg);
                return;
            }
        }
        this.mLogger.fatal((Object)("Unsupported log level: " + msg));
    }

    private void log(int lvl, String msg, Object[] params) {
        if (params.length == 0) {
            this.log(lvl, msg);
        } else {
            this.log(lvl, SmtInterpolLogProxyWrapper.convert(msg, params));
        }
    }

    private static String convert(String msg, Object[] params) {
        StringBuilder sb = new StringBuilder();
        Formatter formatter = new Formatter(sb);
        formatter.format(msg, params);
        formatter.close();
        return sb.toString();
    }
}

