/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.smtsolver.external;

import com.github.jhoenicke.javacup.runtime.SimpleSymbolFactory;
import com.github.jhoenicke.javacup.runtime.Symbol;
import de.uni_freiburg.informatik.ultimate.logic.SMTLIBException;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.smtinterpol.model.ConstantTermNormalizer;
import de.uni_freiburg.informatik.ultimate.smtsolver.external.Executor;
import de.uni_freiburg.informatik.ultimate.smtsolver.external.Lexer;
import de.uni_freiburg.informatik.ultimate.smtsolver.external.Parser;
import java.io.IOException;
import java.io.StringReader;
import java.util.List;

public class TermParseUtils {
    private TermParseUtils() {
    }

    public static Term parseTerm(Script script, String string) {
        List<Symbol> sexpr;
        SimpleSymbolFactory symfactory = new SimpleSymbolFactory();
        Lexer lexer = new Lexer(new StringReader(string));
        lexer.setSymbolFactory(symfactory);
        try {
            sexpr = Executor.parseSexpr(lexer);
        }
        catch (IOException iOException) {
            throw new AssertionError((Object)"IOException but there is neither input nor output");
        }
        Parser parser = new Parser();
        parser.setScript(script);
        sexpr.add(0, new Symbol(57));
        parser.setAnswer(sexpr);
        try {
            Symbol resultSymbol = parser.parse();
            Term resultTerm = (Term)resultSymbol.value;
            return new ConstantTermNormalizer().transform(resultTerm);
        }
        catch (SMTLIBException ex) {
            throw ex;
        }
        catch (UnsupportedOperationException ex) {
            throw ex;
        }
        catch (Exception ex) {
            String msg = String.format("Wrapping exception %s with message %s", ex.getClass(), ex.getMessage());
            throw new SMTLIBException(msg, (Throwable)ex);
        }
    }
}

