/*
 * Decompiled with CFR 0.152.
 */
package jdd.bdd;

import jdd.bdd.BDDNames;
import jdd.bdd.BDDPrinter;
import jdd.bdd.DoubleCache;
import jdd.bdd.NodeTable;
import jdd.bdd.OptimizedCache;
import jdd.bdd.Permutation;
import jdd.bdd.SimpleCache;
import jdd.util.Allocator;
import jdd.util.Array;
import jdd.util.Configuration;
import jdd.util.NodeName;
import jdd.util.Test;
import jdd.util.math.Prime;

public class BDD
extends NodeTable {
    protected static final int CACHE_AND = 0;
    protected static final int CACHE_OR = 1;
    protected static final int CACHE_XOR = 2;
    protected static final int CACHE_BIIMP = 3;
    protected static final int CACHE_IMP = 4;
    protected static final int CACHE_NAND = 5;
    protected static final int CACHE_NOR = 6;
    protected static final int CACHE_RESTRICT = 7;
    protected static final int CACHE_EXISTS = 0;
    protected static final int CACHE_FORALL = 1;
    protected int num_vars;
    protected int last_sat_vars;
    protected SimpleCache op_cache;
    protected SimpleCache relprod_cache;
    protected SimpleCache not_cache;
    protected SimpleCache ite_cache;
    protected SimpleCache quant_cache;
    protected SimpleCache replace_cache;
    protected DoubleCache sat_cache;
    protected boolean[] varset_vec;
    protected boolean[] sign_vec;
    protected int[] oneSat_buffer;
    private boolean[] support_buffer;
    protected int varset_last;
    protected int quant_id;
    protected int quant_cube;
    protected int restrict_careset;
    protected boolean quant_conj;
    protected NodeName nodeNames = new BDDNames();
    private Permutation firstPermutation;
    private int[] perm_vec;
    private int perm_last;
    private int perm_var;
    private int perm_id;
    private int node_count_int;

    public BDD(int n) {
        this(n, 1000);
    }

    public BDD(int n, int n2) {
        super(Prime.prevPrime(n));
        this.op_cache = new OptimizedCache("OP", n2 / Configuration.bddOpcacheDiv, 3, 2);
        this.not_cache = new OptimizedCache("NOT", n2 / Configuration.bddNegcacheDiv, 1, 1);
        this.ite_cache = new OptimizedCache("ITE", n2 / Configuration.bddItecacheDiv, 3, 3);
        this.quant_cache = new OptimizedCache("QUANT", n2 / Configuration.bddQuantcacheDiv, 3, 2);
        this.relprod_cache = new OptimizedCache("REL-PROD", n2 / 2, 3, 3);
        this.replace_cache = new OptimizedCache("REPLACE", n2 / 3, 2, 1);
        this.sat_cache = new DoubleCache("SAT", n2 / 8);
        this.num_vars = 0;
        this.last_sat_vars = -1;
        this.varset_last = -1;
        this.varset_vec = Allocator.allocateBooleanArray(24);
        this.sign_vec = Allocator.allocateBooleanArray(this.varset_vec.length);
        this.support_buffer = new boolean[24];
        this.firstPermutation = null;
        this.enableStackMarking();
    }

    @Override
    public void cleanup() {
        super.cleanup();
        this.varset_vec = null;
        this.sign_vec = null;
        this.oneSat_buffer = null;
        this.quant_cache = null;
        this.ite_cache = null;
        this.not_cache = null;
        this.op_cache = null;
        this.replace_cache = null;
        this.relprod_cache = null;
        this.sat_cache = null;
    }

    public final int getOne() {
        return 1;
    }

    public final int getZero() {
        return 0;
    }

    public int numberOfVariables() {
        return this.num_vars;
    }

    public int createVar() {
        int n = this.mk(this.num_vars, 0, 1);
        this.work_stack[this.work_stack_tos++] = n;
        int n2 = n;
        int n3 = this.mk(this.num_vars, 1, 0);
        --this.work_stack_tos;
        ++this.num_vars;
        this.saturate(n2);
        this.saturate(n3);
        this.not_cache.add(n2, n3);
        this.not_cache.add(n3, n2);
        int n4 = 6 * this.num_vars + 1;
        if (this.work_stack.length < n4) {
            this.work_stack = Array.resize(this.work_stack, this.work_stack_tos, n4);
        }
        if (this.varset_vec.length < this.num_vars) {
            this.varset_vec = Allocator.allocateBooleanArray(this.num_vars * 3);
            this.sign_vec = Allocator.allocateBooleanArray(this.num_vars * 3);
        }
        if (this.support_buffer.length < this.num_vars) {
            this.support_buffer = new boolean[this.num_vars * 3];
        }
        this.tree_depth_changed(this.num_vars);
        this.setAll(0, this.num_vars, 0, 0);
        this.setAll(1, this.num_vars, 1, 1);
        return n2;
    }

    @Override
    protected void post_removal_callbak() {
        this.sat_cache.invalidate_cache();
        this.relprod_cache.free_or_grow(this);
        this.replace_cache.free_or_grow(this);
        this.quant_cache.free_or_grow(this);
        this.ite_cache.free_or_grow(this);
        this.not_cache.free_or_grow(this);
        this.op_cache.free_or_grow(this);
    }

    public int mk(int n, int n2, int n3) {
        if (n2 == n3) {
            return n2;
        }
        return this.add(n, n2, n3);
    }

    public final int cube(boolean[] blArray) {
        int n = 1;
        int n2 = Math.min(blArray.length, this.num_vars);
        for (int i = 0; i < n2; ++i) {
            int n3 = n2 - i - 1;
            this.work_stack[this.work_stack_tos++] = n;
            if (blArray[n3]) {
                n = this.mk(n3, 0, n);
            }
            --this.work_stack_tos;
        }
        return n;
    }

    public final int cube(String string) {
        int n = string.length();
        int n2 = 1;
        for (int i = 0; i < n; ++i) {
            int n3 = n - i - 1;
            this.work_stack[this.work_stack_tos++] = n2;
            if (string.charAt(n3) == '1') {
                n2 = this.mk(n3, 0, n2);
            }
            --this.work_stack_tos;
        }
        return n2;
    }

    public final int minterm(boolean[] blArray) {
        int n = 1;
        int n2 = Math.min(blArray.length, this.num_vars);
        for (int i = 0; i < n2; ++i) {
            int n3 = n2 - i - 1;
            this.work_stack[this.work_stack_tos++] = n;
            n = blArray[n3] ? this.mk(n3, 0, n) : this.mk(n3, n, 0);
            --this.work_stack_tos;
        }
        return n;
    }

    public final int minterm(String string) {
        int n = string.length();
        int n2 = 1;
        for (int i = 0; i < n; ++i) {
            int n3 = n - i - 1;
            this.work_stack[this.work_stack_tos++] = n2;
            n2 = string.charAt(n3) == '1' ? this.mk(n3, 0, n2) : (string.charAt(n3) == '0' ? this.mk(n3, n2, 0) : n2);
            --this.work_stack_tos;
        }
        return n2;
    }

    public int ite(int n, int n2, int n3) {
        if (n == 0) {
            return n3;
        }
        if (n == 1) {
            return n2;
        }
        if (this.getLow(n) < 2 && this.getHigh(n) < 2 && this.getVar(n) < this.getVar(n2) && this.getVar(n) < this.getVar(n3)) {
            if (this.getLow(n) == 0) {
                return this.mk(this.getVar(n), n3, n2);
            }
            if (this.getLow(n) == 1) {
                this.mk(this.getVar(n), n2, n3);
            }
        }
        return this.ite_rec(n, n2, n3);
    }

    private final int ite_rec(int n, int n2, int n3) {
        if (n == 1) {
            return n2;
        }
        if (n == 0) {
            return n3;
        }
        if (n2 == n3) {
            return n2;
        }
        if (n2 == 1 && n3 == 0) {
            return n;
        }
        if (n2 == 0 && n3 == 1) {
            return this.not_rec(n);
        }
        if (n2 == 1) {
            return this.or_rec(n, n3);
        }
        if (n2 == 0) {
            int n4 = this.not_rec(n3);
            this.work_stack[this.work_stack_tos++] = n4;
            int n5 = n4;
            n5 = this.nor_rec(n, n5);
            --this.work_stack_tos;
            return n5;
        }
        if (n3 == 0) {
            return this.and_rec(n, n2);
        }
        if (n3 == 1) {
            int n6 = this.not_rec(n2);
            this.work_stack[this.work_stack_tos++] = n6;
            int n7 = n6;
            n7 = this.nand_rec(n, n7);
            --this.work_stack_tos;
            return n7;
        }
        if (this.ite_cache.lookup(n, n2, n3)) {
            return this.ite_cache.answer;
        }
        int n8 = this.ite_cache.hash_value;
        int n9 = Math.min(this.getVar(n), Math.min(this.getVar(n2), this.getVar(n3)));
        int n10 = this.ite_rec(n9 == this.getVar(n) ? this.getLow(n) : n, n9 == this.getVar(n2) ? this.getLow(n2) : n2, n9 == this.getVar(n3) ? this.getLow(n3) : n3);
        this.work_stack[this.work_stack_tos++] = n10;
        int n11 = n10;
        int n12 = this.ite_rec(n9 == this.getVar(n) ? this.getHigh(n) : n, n9 == this.getVar(n2) ? this.getHigh(n2) : n2, n9 == this.getVar(n3) ? this.getHigh(n3) : n3);
        this.work_stack[this.work_stack_tos++] = n12;
        int n13 = n12;
        n11 = this.mk(n9, n11, n13);
        this.work_stack_tos -= 2;
        this.ite_cache.insert(n8, n, n2, n3, n11);
        return n11;
    }

    public int and(int n, int n2) {
        this.work_stack[this.work_stack_tos++] = n;
        this.work_stack[this.work_stack_tos++] = n2;
        int n3 = this.and_rec(n, n2);
        this.work_stack_tos -= 2;
        return n3;
    }

    private final int and_rec(int n, int n2) {
        int n3;
        int n4;
        if (n == n2 || n2 == 1) {
            return n;
        }
        if (n == 0 || n2 == 0) {
            return 0;
        }
        if (n == 1) {
            return n2;
        }
        int n5 = this.getVar(n);
        if (n5 > this.getVar(n2)) {
            n5 = n;
            n = n2;
            n2 = n5;
            n5 = this.getVar(n);
        }
        if (this.op_cache.lookup(n, n2, 0)) {
            return this.op_cache.answer;
        }
        int n6 = this.op_cache.hash_value;
        if (n5 == this.getVar(n2)) {
            int n7 = this.and_rec(this.getLow(n), this.getLow(n2));
            this.work_stack[this.work_stack_tos++] = n7;
            n4 = n7;
            int n8 = this.and_rec(this.getHigh(n), this.getHigh(n2));
            this.work_stack[this.work_stack_tos++] = n8;
            n3 = n8;
        } else {
            int n9 = this.and_rec(this.getLow(n), n2);
            this.work_stack[this.work_stack_tos++] = n9;
            n4 = n9;
            int n10 = this.and_rec(this.getHigh(n), n2);
            this.work_stack[this.work_stack_tos++] = n10;
            n3 = n10;
        }
        if (n4 != n3) {
            n4 = this.mk(n5, n4, n3);
        }
        this.work_stack_tos -= 2;
        this.op_cache.insert(n6, n, n2, 0, n4);
        return n4;
    }

    private final int and_rec_original(int n, int n2) {
        int n3;
        if (n == n2) {
            return n;
        }
        if (n == 0 || n2 == 0) {
            return 0;
        }
        if (n == 1) {
            return n2;
        }
        if (n2 == 1) {
            return n;
        }
        if (this.op_cache.lookup(n, n2, 0)) {
            return this.op_cache.answer;
        }
        int n4 = this.op_cache.hash_value;
        if (this.getVar(n) == this.getVar(n2)) {
            int n5 = this.and_rec(this.getLow(n), this.getLow(n2));
            this.work_stack[this.work_stack_tos++] = n5;
            int n6 = n5;
            int n7 = this.and_rec(this.getHigh(n), this.getHigh(n2));
            this.work_stack[this.work_stack_tos++] = n7;
            int n8 = n7;
            n3 = this.mk(this.getVar(n), n6, n8);
        } else if (this.getVar(n) < this.getVar(n2)) {
            int n9 = this.and_rec(this.getLow(n), n2);
            this.work_stack[this.work_stack_tos++] = n9;
            int n10 = n9;
            int n11 = this.and_rec(this.getHigh(n), n2);
            this.work_stack[this.work_stack_tos++] = n11;
            int n12 = n11;
            n3 = this.mk(this.getVar(n), n10, n12);
        } else {
            int n13 = this.and_rec(n, this.getLow(n2));
            this.work_stack[this.work_stack_tos++] = n13;
            int n14 = n13;
            int n15 = this.and_rec(n, this.getHigh(n2));
            this.work_stack[this.work_stack_tos++] = n15;
            int n16 = n15;
            n3 = this.mk(this.getVar(n2), n14, n16);
        }
        this.work_stack_tos -= 2;
        this.op_cache.insert(n4, n, n2, 0, n3);
        return n3;
    }

    public int nand(int n, int n2) {
        this.work_stack[this.work_stack_tos++] = n;
        this.work_stack[this.work_stack_tos++] = n2;
        int n3 = this.nand_rec(n, n2);
        this.work_stack_tos -= 2;
        return n3;
    }

    private final int nand_rec(int n, int n2) {
        int n3;
        int n4;
        if (n == 0 || n2 == 0) {
            return 1;
        }
        if (n == 1 || n == n2) {
            return this.not_rec(n2);
        }
        if (n2 == 1) {
            return this.not_rec(n);
        }
        int n5 = this.getVar(n);
        if (n5 > this.getVar(n2)) {
            n5 = n;
            n = n2;
            n2 = n5;
            n5 = this.getVar(n);
        }
        if (this.op_cache.lookup(n, n2, 5)) {
            return this.op_cache.answer;
        }
        int n6 = this.op_cache.hash_value;
        if (n5 == this.getVar(n2)) {
            int n7 = this.nand_rec(this.getLow(n), this.getLow(n2));
            this.work_stack[this.work_stack_tos++] = n7;
            n4 = n7;
            int n8 = this.nand_rec(this.getHigh(n), this.getHigh(n2));
            this.work_stack[this.work_stack_tos++] = n8;
            n3 = n8;
        } else {
            int n9 = this.nand_rec(this.getLow(n), n2);
            this.work_stack[this.work_stack_tos++] = n9;
            n4 = n9;
            int n10 = this.nand_rec(this.getHigh(n), n2);
            this.work_stack[this.work_stack_tos++] = n10;
            n3 = n10;
        }
        if (n4 != n3) {
            n4 = this.mk(n5, n4, n3);
        }
        this.op_cache.insert(n6, n, n2, 5, n4);
        this.work_stack_tos -= 2;
        return n4;
    }

    public int or(int n, int n2) {
        this.work_stack[this.work_stack_tos++] = n;
        this.work_stack[this.work_stack_tos++] = n2;
        int n3 = this.or_rec(n, n2);
        this.work_stack_tos -= 2;
        return n3;
    }

    private final int or_rec(int n, int n2) {
        int n3;
        int n4;
        if (n == 1 || n2 == 1) {
            return 1;
        }
        if (n == 0 || n == n2) {
            return n2;
        }
        if (n2 == 0) {
            return n;
        }
        int n5 = this.getVar(n);
        if (n5 > this.getVar(n2)) {
            n5 = n;
            n = n2;
            n2 = n5;
            n5 = this.getVar(n);
        }
        if (this.op_cache.lookup(n, n2, 1)) {
            return this.op_cache.answer;
        }
        int n6 = this.op_cache.hash_value;
        if (n5 == this.getVar(n2)) {
            int n7 = this.or_rec(this.getLow(n), this.getLow(n2));
            this.work_stack[this.work_stack_tos++] = n7;
            n4 = n7;
            int n8 = this.or_rec(this.getHigh(n), this.getHigh(n2));
            this.work_stack[this.work_stack_tos++] = n8;
            n3 = n8;
        } else {
            int n9 = this.or_rec(this.getLow(n), n2);
            this.work_stack[this.work_stack_tos++] = n9;
            n4 = n9;
            int n10 = this.or_rec(this.getHigh(n), n2);
            this.work_stack[this.work_stack_tos++] = n10;
            n3 = n10;
        }
        if (n4 != n3) {
            n4 = this.mk(n5, n4, n3);
        }
        this.op_cache.insert(n6, n, n2, 1, n4);
        this.work_stack_tos -= 2;
        return n4;
    }

    public int nor(int n, int n2) {
        this.work_stack[this.work_stack_tos++] = n;
        this.work_stack[this.work_stack_tos++] = n2;
        int n3 = this.nor_rec(n, n2);
        this.work_stack_tos -= 2;
        return n3;
    }

    private final int nor_rec(int n, int n2) {
        int n3;
        int n4;
        if (n == 1 || n2 == 1) {
            return 0;
        }
        if (n == 0 || n == n2) {
            return this.not_rec(n2);
        }
        if (n2 == 0) {
            return this.not_rec(n);
        }
        int n5 = this.getVar(n);
        if (n5 > this.getVar(n2)) {
            n5 = n;
            n = n2;
            n2 = n5;
            n5 = this.getVar(n);
        }
        if (this.op_cache.lookup(n, n2, 6)) {
            return this.op_cache.answer;
        }
        int n6 = this.op_cache.hash_value;
        if (n5 == this.getVar(n2)) {
            int n7 = this.nor_rec(this.getLow(n), this.getLow(n2));
            this.work_stack[this.work_stack_tos++] = n7;
            n4 = n7;
            int n8 = this.nor_rec(this.getHigh(n), this.getHigh(n2));
            this.work_stack[this.work_stack_tos++] = n8;
            n3 = n8;
        } else {
            int n9 = this.nor_rec(this.getLow(n), n2);
            this.work_stack[this.work_stack_tos++] = n9;
            n4 = n9;
            int n10 = this.nor_rec(this.getHigh(n), n2);
            this.work_stack[this.work_stack_tos++] = n10;
            n3 = n10;
        }
        if (n4 != n3) {
            n4 = this.mk(n5, n4, n3);
        }
        this.op_cache.insert(n6, n, n2, 6, n4);
        this.work_stack_tos -= 2;
        return n4;
    }

    public int xor(int n, int n2) {
        this.work_stack[this.work_stack_tos++] = n;
        this.work_stack[this.work_stack_tos++] = n2;
        int n3 = this.xor_rec(n, n2);
        this.work_stack_tos -= 2;
        return n3;
    }

    private final int xor_rec(int n, int n2) {
        int n3;
        int n4;
        if (n == n2) {
            return 0;
        }
        if (n == 0) {
            return n2;
        }
        if (n2 == 0) {
            return n;
        }
        if (n == 1) {
            return this.not_rec(n2);
        }
        if (n2 == 1) {
            return this.not_rec(n);
        }
        int n5 = this.getVar(n);
        if (n5 > this.getVar(n2)) {
            n5 = n;
            n = n2;
            n2 = n5;
            n5 = this.getVar(n);
        }
        if (this.op_cache.lookup(n, n2, 2)) {
            return this.op_cache.answer;
        }
        int n6 = this.op_cache.hash_value;
        if (n5 == this.getVar(n2)) {
            int n7 = this.xor_rec(this.getLow(n), this.getLow(n2));
            this.work_stack[this.work_stack_tos++] = n7;
            n4 = n7;
            int n8 = this.xor_rec(this.getHigh(n), this.getHigh(n2));
            this.work_stack[this.work_stack_tos++] = n8;
            n3 = n8;
        } else {
            int n9 = this.xor_rec(this.getLow(n), n2);
            this.work_stack[this.work_stack_tos++] = n9;
            n4 = n9;
            int n10 = this.xor_rec(this.getHigh(n), n2);
            this.work_stack[this.work_stack_tos++] = n10;
            n3 = n10;
        }
        if (n4 != n3) {
            n4 = this.mk(n5, n4, n3);
        }
        this.op_cache.insert(n6, n, n2, 2, n4);
        this.work_stack_tos -= 2;
        return n4;
    }

    public int biimp(int n, int n2) {
        this.work_stack[this.work_stack_tos++] = n;
        this.work_stack[this.work_stack_tos++] = n2;
        int n3 = this.biimp_rec(n, n2);
        this.work_stack_tos -= 2;
        return n3;
    }

    private final int biimp_rec(int n, int n2) {
        int n3;
        int n4;
        if (n == n2) {
            return 1;
        }
        if (n == 0) {
            return this.not_rec(n2);
        }
        if (n == 1) {
            return n2;
        }
        if (n2 == 0) {
            return this.not_rec(n);
        }
        if (n2 == 1) {
            return n;
        }
        int n5 = this.getVar(n);
        if (n5 > this.getVar(n2)) {
            n5 = n;
            n = n2;
            n2 = n5;
            n5 = this.getVar(n);
        }
        if (this.op_cache.lookup(n, n2, 3)) {
            return this.op_cache.answer;
        }
        int n6 = this.op_cache.hash_value;
        if (n5 == this.getVar(n2)) {
            int n7 = this.biimp_rec(this.getLow(n), this.getLow(n2));
            this.work_stack[this.work_stack_tos++] = n7;
            n4 = n7;
            int n8 = this.biimp_rec(this.getHigh(n), this.getHigh(n2));
            this.work_stack[this.work_stack_tos++] = n8;
            n3 = n8;
        } else {
            int n9 = this.biimp_rec(this.getLow(n), n2);
            this.work_stack[this.work_stack_tos++] = n9;
            n4 = n9;
            int n10 = this.biimp_rec(this.getHigh(n), n2);
            this.work_stack[this.work_stack_tos++] = n10;
            n3 = n10;
        }
        if (n4 != n3) {
            n4 = this.mk(n5, n4, n3);
        }
        this.op_cache.insert(n6, n, n2, 3, n4);
        this.work_stack_tos -= 2;
        return n4;
    }

    public int imp(int n, int n2) {
        this.work_stack[this.work_stack_tos++] = n;
        this.work_stack[this.work_stack_tos++] = n2;
        int n3 = this.imp_rec(n, n2);
        this.work_stack_tos -= 2;
        return n3;
    }

    private final int imp_rec(int n, int n2) {
        int n3;
        int n4;
        if (n == 0 || n2 == 1 || n == n2) {
            return 1;
        }
        if (n == 1) {
            return n2;
        }
        if (n2 == 0) {
            return this.not_rec(n);
        }
        if (this.op_cache.lookup(n, n2, 4)) {
            return this.op_cache.answer;
        }
        int n5 = this.op_cache.hash_value;
        int n6 = this.getVar(n);
        if (this.getVar(n) == this.getVar(n2)) {
            int n7 = this.imp_rec(this.getLow(n), this.getLow(n2));
            this.work_stack[this.work_stack_tos++] = n7;
            n4 = n7;
            int n8 = this.imp_rec(this.getHigh(n), this.getHigh(n2));
            this.work_stack[this.work_stack_tos++] = n8;
            n3 = n8;
        } else if (this.getVar(n) < this.getVar(n2)) {
            int n9 = this.imp_rec(this.getLow(n), n2);
            this.work_stack[this.work_stack_tos++] = n9;
            n4 = n9;
            int n10 = this.imp_rec(this.getHigh(n), n2);
            this.work_stack[this.work_stack_tos++] = n10;
            n3 = n10;
        } else {
            int n11 = this.imp_rec(n, this.getLow(n2));
            this.work_stack[this.work_stack_tos++] = n11;
            n4 = n11;
            int n12 = this.imp_rec(n, this.getHigh(n2));
            this.work_stack[this.work_stack_tos++] = n12;
            n3 = n12;
            n6 = this.getVar(n2);
        }
        if (n4 != n3) {
            n4 = this.mk(n6, n4, n3);
        }
        this.op_cache.insert(n5, n, n2, 4, n4);
        this.work_stack_tos -= 2;
        return n4;
    }

    public int not(int n) {
        this.work_stack[this.work_stack_tos++] = n;
        int n2 = this.not_rec(n);
        --this.work_stack_tos;
        return n2;
    }

    private final int not_rec(int n) {
        int n2;
        if (n < 2) {
            return n ^ 1;
        }
        if (this.not_cache.lookup(n)) {
            return this.not_cache.answer;
        }
        int n3 = this.not_cache.hash_value;
        this.work_stack[this.work_stack_tos++] = this.not_rec(this.getLow(n));
        int n4 = this.work_stack[this.work_stack_tos++];
        if (n4 != (n2 = (this.work_stack[this.work_stack_tos++] = this.not_rec(this.getHigh(n))))) {
            n4 = this.mk(this.getVar(n), n4, n2);
        }
        this.work_stack_tos -= 2;
        this.not_cache.insert(n3, n, n4);
        return n4;
    }

    private void varset(int n) {
        Test.check(n > 1, "BAD varset");
        int n2 = this.num_vars;
        while (n2 != 0) {
            this.varset_vec[--n2] = false;
        }
        while (n > 1) {
            this.varset_last = this.getVar(n);
            this.varset_vec[this.varset_last] = true;
            n = this.getHigh(n);
        }
    }

    private void varset_signed(int n) {
        Test.check(n > 1, "BAD varset");
        for (int i = 0; i < this.num_vars; ++i) {
            this.varset_vec[i] = false;
        }
        while (n > 1) {
            this.varset_last = this.getVar(n);
            this.varset_vec[this.varset_last] = true;
            this.sign_vec[this.varset_last] = this.getLow(n) == 0;
            n = this.getHigh(n);
        }
    }

    public int exists(int n, int n2) {
        if (n2 == 1) {
            return n;
        }
        Test.check(n2 != 0, "Empty cube");
        this.quant_conj = false;
        this.quant_id = 0;
        this.quant_cube = n2;
        this.varset(n2);
        return this.quant_rec(n);
    }

    public int forall(int n, int n2) {
        if (n2 == 1) {
            return n;
        }
        Test.check(n2 != 0, "Empty cube");
        this.quant_conj = true;
        this.quant_id = 1;
        this.quant_cube = n2;
        this.varset(n2);
        return this.quant_rec(n);
    }

    private final int quant_rec_JAVABDD(int n) {
        if (n < 2 || this.getVar(n) > this.varset_last) {
            return n;
        }
        if (this.quant_cache.lookup(n, this.quant_cube, this.quant_id)) {
            return this.quant_cache.answer;
        }
        int n2 = this.quant_cache.hash_value;
        int n3 = this.quant_rec(this.getLow(n));
        this.work_stack[this.work_stack_tos++] = n3;
        int n4 = n3;
        int n5 = this.quant_rec(this.getHigh(n));
        this.work_stack[this.work_stack_tos++] = n5;
        int n6 = n5;
        int n7 = this.varset_vec[this.getVar(n)] ? (this.quant_conj ? this.and_rec(n4, n6) : this.or_rec(n4, n6)) : this.mk(this.getVar(n), n4, n6);
        this.work_stack_tos -= 2;
        this.quant_cache.insert(n2, n, this.quant_cube, this.quant_id, n7);
        return n7;
    }

    private final int quant_rec(int n) {
        int n2 = this.getVar(n);
        if (n < 2 || n2 > this.varset_last) {
            return n;
        }
        if (this.quant_cache.lookup(n, this.quant_cube, this.quant_id)) {
            return this.quant_cache.answer;
        }
        int n3 = this.quant_cache.hash_value;
        int n4 = 0;
        if (this.varset_vec[n2]) {
            n4 = this.getLow(n);
            int n5 = this.getHigh(n);
            if (this.getVar(n5) > this.getVar(n4)) {
                n4 = n5;
                n5 = this.getLow(n);
            }
            n4 = this.quant_rec(n4);
            if (!(this.quant_conj && n4 == 0 || !this.quant_conj && n4 == 1)) {
                this.work_stack[this.work_stack_tos++] = n4;
                int n6 = this.quant_rec(n5);
                this.work_stack[this.work_stack_tos++] = n6;
                n5 = n6;
                n4 = this.quant_conj ? this.and_rec(n4, n5) : this.or_rec(n4, n5);
                this.work_stack_tos -= 2;
            }
        } else {
            int n7 = this.quant_rec(this.getLow(n));
            this.work_stack[this.work_stack_tos++] = n7;
            n4 = n7;
            int n8 = this.quant_rec(this.getHigh(n));
            this.work_stack[this.work_stack_tos++] = n8;
            int n9 = n8;
            n4 = this.mk(n2, n4, n9);
            this.work_stack_tos -= 2;
        }
        this.quant_cache.insert(n3, n, this.quant_cube, this.quant_id, n4);
        return n4;
    }

    public int relProd(int n, int n2, int n3) {
        if (n3 < 2) {
            return this.and_rec(n, n2);
        }
        this.varset(n3);
        this.quant_conj = false;
        this.quant_id = 0;
        this.quant_cube = n3;
        return this.relProd_rec(n, n2);
    }

    private final int relProd_rec_ORG(int n, int n2) {
        int n3;
        if (n == 0 || n2 == 0) {
            return 0;
        }
        if (n == n2 || n2 == 1) {
            return this.quant_rec(n);
        }
        if (n == 1) {
            return this.quant_rec(n2);
        }
        if (this.getVar(n) > this.varset_last && this.getVar(n2) > this.varset_last) {
            return this.and_rec(n, n2);
        }
        if (this.relprod_cache.lookup(n, n2, this.quant_cube)) {
            return this.relprod_cache.answer;
        }
        int n4 = this.relprod_cache.hash_value;
        if (this.getVar(n) == this.getVar(n2)) {
            int n5 = this.relProd_rec(this.getLow(n), this.getLow(n2));
            this.work_stack[this.work_stack_tos++] = n5;
            n3 = n5;
            int n6 = this.relProd_rec(this.getHigh(n), this.getHigh(n2));
            this.work_stack[this.work_stack_tos++] = n6;
            int n7 = n6;
            n3 = this.varset_vec[this.getVar(n2)] ? this.or_rec(n3, n7) : this.mk(this.getVar(n2), n3, n7);
        } else if (this.getVar(n) > this.getVar(n2)) {
            int n8 = this.relProd_rec(n, this.getLow(n2));
            this.work_stack[this.work_stack_tos++] = n8;
            n3 = n8;
            int n9 = this.relProd_rec(n, this.getHigh(n2));
            this.work_stack[this.work_stack_tos++] = n9;
            int n10 = n9;
            n3 = this.varset_vec[this.getVar(n2)] ? this.or_rec(n3, n10) : this.mk(this.getVar(n2), n3, n10);
        } else {
            int n11 = this.relProd_rec(this.getLow(n), n2);
            this.work_stack[this.work_stack_tos++] = n11;
            n3 = n11;
            int n12 = this.relProd_rec(this.getHigh(n), n2);
            this.work_stack[this.work_stack_tos++] = n12;
            int n13 = n12;
            n3 = this.varset_vec[this.getVar(n)] ? this.or_rec(n3, n13) : this.mk(this.getVar(n), n3, n13);
        }
        this.relprod_cache.insert(n4, n, n2, this.quant_cube, n3);
        this.work_stack_tos -= 2;
        return n3;
    }

    private final int relProd_rec_OPT(int n, int n2) {
        int n3;
        int n4;
        int n5;
        if (n == 0 || n2 == 0) {
            return 0;
        }
        if (n == n2 || n2 == 1) {
            return this.quant_rec(n);
        }
        if (n == 1) {
            return this.quant_rec(n2);
        }
        if (this.getVar(n) > this.varset_last && this.getVar(n2) > this.varset_last) {
            return this.and_rec(n, n2);
        }
        if (this.getVar(n) < this.getVar(n2)) {
            n5 = n;
            n = n2;
            n2 = n5;
        }
        if (this.relprod_cache.lookup(n, n2, this.quant_cube)) {
            return this.relprod_cache.answer;
        }
        n5 = this.relprod_cache.hash_value;
        if (this.getVar(n) == this.getVar(n2)) {
            int n6 = this.relProd_rec(this.getLow(n), this.getLow(n2));
            this.work_stack[this.work_stack_tos++] = n6;
            n4 = n6;
            int n7 = this.relProd_rec(this.getHigh(n), this.getHigh(n2));
            this.work_stack[this.work_stack_tos++] = n7;
            n3 = n7;
        } else {
            int n8 = this.relProd_rec(n, this.getLow(n2));
            this.work_stack[this.work_stack_tos++] = n8;
            n4 = n8;
            int n9 = this.relProd_rec(n, this.getHigh(n2));
            this.work_stack[this.work_stack_tos++] = n9;
            n3 = n9;
        }
        n4 = this.varset_vec[this.getVar(n2)] ? this.or_rec(n4, n3) : this.mk(this.getVar(n2), n4, n3);
        this.relprod_cache.insert(n5, n, n2, this.quant_cube, n4);
        this.work_stack_tos -= 2;
        return n4;
    }

    private final int relProd_rec(int n, int n2) {
        int n3;
        if (n == 0 || n2 == 0) {
            return 0;
        }
        if (n == n2 || n2 == 1) {
            return this.quant_rec(n);
        }
        if (n == 1) {
            return this.quant_rec(n2);
        }
        if (this.getVar(n) > this.varset_last && this.getVar(n2) > this.varset_last) {
            return this.and_rec(n, n2);
        }
        if (this.getVar(n2) < this.getVar(n)) {
            n3 = n;
            n = n2;
            n2 = n3;
        }
        if (this.relprod_cache.lookup(n, n2, this.quant_cube)) {
            return this.relprod_cache.answer;
        }
        n3 = this.relprod_cache.hash_value;
        int n4 = this.getVar(n);
        int n5 = this.relProd_rec(this.getLow(n), n4 == this.getVar(n2) ? this.getLow(n2) : n2);
        if (this.varset_vec[n4]) {
            if (n5 == 1) {
                return n5;
            }
            if (n5 == this.getHigh(n)) {
                return n5;
            }
            if (n5 == this.getHigh(n2) && this.getVar(n2) == n4) {
                return n5;
            }
        }
        this.work_stack[this.work_stack_tos++] = n5;
        this.work_stack[this.work_stack_tos++] = this.relProd_rec(this.getHigh(n), n4 == this.getVar(n2) ? this.getHigh(n2) : n2);
        int n6 = this.work_stack[this.work_stack_tos++];
        if (n5 != n6) {
            n5 = this.varset_vec[n4] ? this.or_rec(n5, n6) : this.mk(n4, n5, n6);
        }
        this.relprod_cache.insert(n3, n, n2, this.quant_cube, n5);
        this.work_stack_tos -= 2;
        return n5;
    }

    public Permutation createPermutation(int[] nArray, int[] nArray2) {
        Permutation permutation = Permutation.findPermutation(this.firstPermutation, nArray, nArray2);
        if (permutation == null) {
            permutation = new Permutation(nArray, nArray2, this);
            permutation.next = this.firstPermutation;
            this.firstPermutation = permutation;
        }
        return permutation;
    }

    public int replace(int n, Permutation permutation) {
        this.perm_vec = permutation.perm;
        this.perm_last = permutation.last;
        this.perm_id = permutation.id;
        int n2 = this.replace_rec(n);
        this.perm_vec = null;
        return n2;
    }

    private final int replace_rec(int n) {
        if (n < 2 || this.getVar(n) > this.perm_last) {
            return n;
        }
        if (this.replace_cache.lookup(n, this.perm_id)) {
            return this.replace_cache.answer;
        }
        int n2 = this.replace_cache.hash_value;
        int n3 = this.replace_rec(this.getLow(n));
        this.work_stack[this.work_stack_tos++] = n3;
        int n4 = n3;
        int n5 = this.replace_rec(this.getHigh(n));
        this.work_stack[this.work_stack_tos++] = n5;
        int n6 = n5;
        this.perm_var = this.perm_vec[this.getVar(n)];
        n4 = this.mkAndOrder(n4, n6);
        this.work_stack_tos -= 2;
        this.replace_cache.insert(n2, n, this.perm_id, n4);
        return n4;
    }

    private final int mkAndOrder(int n, int n2) {
        int n3;
        int n4;
        int n5 = this.getVar(n);
        int n6 = this.getVar(n2);
        if (this.perm_var < n5 && this.perm_var < n6) {
            return this.mk(this.perm_var, n, n2);
        }
        Test.check(this.perm_var != n5 && this.perm_var != n6, "Replacing to a variable already in the BDD");
        int n7 = n5;
        if (n5 == n6) {
            int n8 = this.mkAndOrder(this.getLow(n), this.getLow(n2));
            this.work_stack[this.work_stack_tos++] = n8;
            n4 = n8;
            int n9 = this.mkAndOrder(this.getHigh(n), this.getHigh(n2));
            this.work_stack[this.work_stack_tos++] = n9;
            n3 = n9;
        } else if (n5 < n6) {
            int n10 = this.mkAndOrder(this.getLow(n), n2);
            this.work_stack[this.work_stack_tos++] = n10;
            n4 = n10;
            int n11 = this.mkAndOrder(this.getHigh(n), n2);
            this.work_stack[this.work_stack_tos++] = n11;
            n3 = n11;
        } else {
            int n12 = this.mkAndOrder(n, this.getLow(n2));
            this.work_stack[this.work_stack_tos++] = n12;
            n4 = n12;
            int n13 = this.mkAndOrder(n, this.getHigh(n2));
            this.work_stack[this.work_stack_tos++] = n13;
            n3 = n13;
            n7 = n6;
        }
        n4 = this.mk(n7, n4, n3);
        this.work_stack_tos -= 2;
        return n4;
    }

    public int restrict(int n, int n2) {
        if (n2 == 1) {
            return n;
        }
        this.varset_signed(n2);
        this.restrict_careset = n2;
        return this.restrict_rec(n);
    }

    private int restrict_rec(int n) {
        if (n < 2 || this.getVar(n) > this.varset_last) {
            return n;
        }
        if (this.op_cache.lookup(n, this.restrict_careset, 7)) {
            return this.op_cache.answer;
        }
        int n2 = this.op_cache.hash_value;
        int n3 = 0;
        if (this.varset_vec[this.getVar(n)]) {
            n3 = this.restrict_rec(this.sign_vec[this.getVar(n)] ? this.getHigh(n) : this.getLow(n));
        } else {
            int n4 = this.restrict_rec(this.getLow(n));
            this.work_stack[this.work_stack_tos++] = n4;
            int n5 = n4;
            int n6 = this.restrict_rec(this.getHigh(n));
            this.work_stack[this.work_stack_tos++] = n6;
            int n7 = n6;
            n3 = this.mk(this.getVar(n), n5, n7);
            this.work_stack_tos -= 2;
        }
        this.op_cache.insert(n2, n, this.restrict_careset, 7, n3);
        return n3;
    }

    public int simplify(int n, int n2) {
        if (n == 0) {
            return 0;
        }
        if (n2 < 2) {
            return n2;
        }
        if (n == 1) {
            int n3 = this.simplify(n, this.getLow(n2));
            this.work_stack[this.work_stack_tos++] = n3;
            int n4 = n3;
            int n5 = this.simplify(n, this.getHigh(n2));
            this.work_stack[this.work_stack_tos++] = n5;
            int n6 = n5;
            n6 = this.mk(this.getVar(n2), n4, n6);
            this.work_stack_tos -= 2;
            return n6;
        }
        if (this.getVar(n) == this.getVar(n2)) {
            if (this.getLow(n) == 0) {
                return this.simplify(this.getHigh(n), this.getHigh(n2));
            }
            if (this.getHigh(n) == 0) {
                return this.simplify(this.getLow(n), this.getLow(n2));
            }
            int n7 = this.simplify(this.getLow(n), this.getLow(n2));
            this.work_stack[this.work_stack_tos++] = n7;
            int n8 = n7;
            int n9 = this.simplify(this.getHigh(n), this.getHigh(n2));
            this.work_stack[this.work_stack_tos++] = n9;
            int n10 = n9;
            n10 = this.mk(this.getVar(n2), n8, n10);
            this.work_stack_tos -= 2;
            return n10;
        }
        if (this.getVar(n) < this.getVar(n2)) {
            int n11 = this.simplify(this.getLow(n), n2);
            this.work_stack[this.work_stack_tos++] = n11;
            int n12 = n11;
            int n13 = this.simplify(this.getHigh(n), n2);
            this.work_stack[this.work_stack_tos++] = n13;
            int n14 = n13;
            n14 = this.mk(this.getVar(n), n12, n14);
            this.work_stack_tos -= 2;
            return n14;
        }
        int n15 = this.simplify(n, this.getLow(n2));
        this.work_stack[this.work_stack_tos++] = n15;
        int n16 = n15;
        int n17 = this.simplify(n, this.getHigh(n2));
        this.work_stack[this.work_stack_tos++] = n17;
        int n18 = n17;
        n18 = this.mk(this.getVar(n2), n16, n18);
        this.work_stack_tos -= 2;
        return n18;
    }

    public boolean isVariable(int n) {
        if (n < 2 || n > this.table_size || !this.isValid(n)) {
            return false;
        }
        return this.getLow(n) == 0 && this.getHigh(n) == 1;
    }

    public double satCount(int n) {
        if (this.last_sat_vars != -1 && this.last_sat_vars != this.num_vars) {
            this.sat_cache.invalidate_cache();
        }
        this.last_sat_vars = this.num_vars;
        return Math.pow(2.0, this.getVar(n)) * this.satCount_rec(n);
    }

    protected double satCount_rec(int n) {
        if (n < 2) {
            return n;
        }
        if (this.sat_cache.lookup(n)) {
            return this.sat_cache.answer;
        }
        int n2 = this.sat_cache.hash_value;
        int n3 = this.getLow(n);
        int n4 = this.getHigh(n);
        double d = this.satCount_rec(n3) * Math.pow(2.0, this.getVar(n3) - this.getVar(n) - 1) + this.satCount_rec(n4) * Math.pow(2.0, this.getVar(n4) - this.getVar(n) - 1);
        this.sat_cache.insert(n2, n, d);
        return d;
    }

    public int nodeCount(int n) {
        this.node_count_int = 0;
        this.nodeCount_mark(n);
        this.unmark_tree(n);
        return this.node_count_int;
    }

    private final void nodeCount_mark(int n) {
        if (n < 2) {
            return;
        }
        if (this.isNodeMarked(n)) {
            return;
        }
        this.mark_node(n);
        ++this.node_count_int;
        this.nodeCount_mark(this.getLow(n));
        this.nodeCount_mark(this.getHigh(n));
    }

    public final int quasiReducedNodeCount(int n) {
        if (n < 2) {
            return 0;
        }
        return 1 + this.quasiReducedNodeCount(this.getLow(n)) + this.quasiReducedNodeCount(this.getHigh(n));
    }

    public int oneSat(int n) {
        if (n < 2) {
            return n;
        }
        if (this.getLow(n) == 0) {
            int n2 = this.oneSat(this.getHigh(n));
            this.work_stack[this.work_stack_tos++] = n2;
            int n3 = n2;
            int n4 = this.mk(this.getVar(n), 0, n3);
            --this.work_stack_tos;
            return n4;
        }
        int n5 = this.oneSat(this.getLow(n));
        this.work_stack[this.work_stack_tos++] = n5;
        int n6 = n5;
        int n7 = this.mk(this.getVar(n), n6, 0);
        --this.work_stack_tos;
        return n7;
    }

    public int[] oneSat(int n, int[] nArray) {
        if (nArray == null) {
            nArray = new int[this.num_vars];
        }
        this.oneSat_buffer = nArray;
        Array.set(nArray, -1);
        this.oneSat_rec(n);
        this.oneSat_buffer = null;
        return nArray;
    }

    protected void oneSat_rec(int n) {
        if (n < 2) {
            return;
        }
        if (this.getLow(n) == 0) {
            this.oneSat_buffer[this.getVar((int)n)] = 1;
            this.oneSat_rec(this.getHigh(n));
        } else {
            this.oneSat_buffer[this.getVar((int)n)] = 0;
            this.oneSat_rec(this.getLow(n));
        }
    }

    public int support(int n) {
        Array.set(this.support_buffer, false);
        this.support_rec(n);
        this.unmark_tree(n);
        int n2 = this.cube(this.support_buffer);
        return n2;
    }

    private final void support_rec(int n) {
        if (n < 2) {
            return;
        }
        if (this.isNodeMarked(n)) {
            return;
        }
        this.support_buffer[this.getVar((int)n)] = true;
        this.mark_node(n);
        this.support_rec(this.getLow(n));
        this.support_rec(this.getHigh(n));
    }

    public boolean member(int n, boolean[] blArray) {
        while (n >= 2) {
            n = blArray[this.getVar(n)] ? this.getHigh(n) : this.getLow(n);
        }
        return n != 0;
    }

    public int orTo(int n, int n2) {
        int n3 = this.ref(this.or(n, n2));
        this.deref(n);
        return n3;
    }

    public int andTo(int n, int n2) {
        int n3 = this.ref(this.and(n, n2));
        this.deref(n);
        return n3;
    }

    @Override
    public void showStats() {
        super.showStats();
        this.op_cache.showStats();
        this.not_cache.showStats();
        this.quant_cache.showStats();
        this.replace_cache.showStats();
        this.ite_cache.showStats();
        this.relprod_cache.showStats();
        this.sat_cache.showStats();
    }

    @Override
    public long getMemoryUsage() {
        long l = super.getMemoryUsage();
        if (this.varset_vec != null) {
            l += (long)(this.varset_vec.length * 4);
        }
        if (this.oneSat_buffer != null) {
            l += (long)(this.oneSat_buffer.length * 4);
        }
        if (this.support_buffer != null) {
            l += (long)(this.support_buffer.length * 1);
        }
        if (this.op_cache != null) {
            l += this.op_cache.getMemoryUsage();
        }
        if (this.relprod_cache != null) {
            l += this.relprod_cache.getMemoryUsage();
        }
        if (this.not_cache != null) {
            l += this.not_cache.getMemoryUsage();
        }
        if (this.ite_cache != null) {
            l += this.ite_cache.getMemoryUsage();
        }
        if (this.quant_cache != null) {
            l += this.quant_cache.getMemoryUsage();
        }
        if (this.sat_cache != null) {
            l += this.sat_cache.getMemoryUsage();
        }
        if (this.replace_cache != null) {
            l += this.replace_cache.getMemoryUsage();
        }
        Permutation permutation = this.firstPermutation;
        while (permutation != null) {
            l += permutation.getMemoryUsage();
            permutation = permutation.next;
        }
        return l;
    }

    public void print(int n) {
        BDDPrinter.print(n, this);
    }

    public void printDot(String string, int n) {
        BDDPrinter.printDot(string, n, this, this.nodeNames);
    }

    public void printSet(int n) {
        BDDPrinter.printSet(n, this.num_vars, this, null);
    }

    public void printCubes(int n) {
        BDDPrinter.printSet(n, this.num_vars, this, this.nodeNames);
    }

    public void setNodeNames(NodeName nodeName) {
        this.nodeNames = nodeName;
    }

    public static void internal_test() {
        Test.start("BDD");
        BDD bDD = new BDD(2);
        int n = bDD.createVar();
        int n2 = bDD.createVar();
        int n3 = bDD.createVar();
        int n4 = bDD.createVar();
        int n5 = bDD.and(n3, n2);
        Test.check(bDD.dead_nodes == 0, " no dead nodes at start");
        bDD.ref(n5);
        Test.check(bDD.dead_nodes == 0, " still no dead nodes");
        bDD.deref(n5);
        Test.check(bDD.dead_nodes == 1, " one dead node");
        bDD.deref(n5);
        Test.check(bDD.dead_nodes == 1, " still one dead node");
        bDD.grow();
        int n6 = bDD.and(n3, n2);
        int n7 = bDD.ref(bDD.or(n6, n));
        Test.check(bDD.gc() == 0, "should not free g1 (recusrive dep)");
        bDD.deref(n7);
        Test.check(bDD.gc() == 2, "should free g2 thus also g1 (recusrive dep)");
        bDD.gc();
        int n8 = bDD.ref(bDD.not(n));
        int n9 = bDD.ref(bDD.not(n2));
        int n10 = bDD.ref(bDD.not(n3));
        int n11 = bDD.ref(bDD.and(n, n10));
        int n12 = bDD.ref(bDD.xor(n, n2));
        int n13 = bDD.ref(bDD.not(n12));
        Test.checkEquality(bDD.restrict(n, n11), 1, "restrict 1");
        Test.checkEquality(bDD.restrict(n2, n11), n2, "restrict 2");
        Test.checkEquality(bDD.restrict(n3, n11), 0, "restrict 3");
        Test.checkEquality(bDD.restrict(n12, n11), n9, "restrict 4");
        Test.checkEquality(bDD.restrict(n13, n11), n2, "restrict 5");
        bDD.deref(n13);
        bDD.deref(n12);
        bDD.deref(n11);
        int n14 = bDD.ref(bDD.and(n, n2));
        int n15 = bDD.ref(bDD.or(n8, n9));
        int n16 = bDD.ref(bDD.not(n15));
        Test.check(n14 == n16, "BDD canonicity (and/or/not)");
        int n17 = bDD.ref(bDD.and(n, n9));
        int n18 = bDD.ref(bDD.and(n2, n8));
        int n19 = bDD.ref(bDD.or(n17, n18));
        bDD.deref(n17);
        bDD.deref(n18);
        int n20 = bDD.ref(bDD.xor(n, n2));
        Test.checkEquality(n19, n20, "BDD canonicity (XOR)");
        bDD.deref(n19);
        bDD.deref(n20);
        int n21 = bDD.ref(bDD.or(n14, bDD.and(bDD.not(n), bDD.not(n2))));
        int n22 = bDD.biimp(n, n2);
        Test.check(n21 == n22, "BDD canonicity (biimp)");
        int n23 = bDD.ref(bDD.and(n, n2));
        int n24 = bDD.ref(bDD.not(n23));
        bDD.deref(n23);
        int n25 = bDD.ref(bDD.nand(n, n2));
        int n26 = bDD.ref(bDD.biimp(n24, n25));
        Test.check(n24 == n25, "NAND consitency");
        bDD.deref(n24);
        bDD.deref(n25);
        bDD.deref(n26);
        int n27 = bDD.ref(bDD.or(n, n2));
        int n28 = bDD.ref(bDD.not(n27));
        bDD.deref(n27);
        int n29 = bDD.ref(bDD.nor(n, n2));
        int n30 = bDD.ref(bDD.biimp(n28, n29));
        Test.check(n29 == n28, "NOR consitency");
        bDD.deref(n28);
        bDD.deref(n29);
        bDD.deref(n30);
        Test.check(bDD.work_stack_tos == 0, "workset stack should be empty");
        Test.checkEquality(bDD.nodeCount(0), 0, "nodeCount (1)");
        Test.checkEquality(bDD.nodeCount(1), 0, "nodeCount (2)");
        Test.checkEquality(bDD.nodeCount(n), 1, "nodeCount (3)");
        Test.checkEquality(bDD.nodeCount(n9), 1, "nodeCount (4)");
        Test.checkEquality(bDD.nodeCount(bDD.and(n, n2)), 2, "nodeCount (5)");
        Test.checkEquality(bDD.nodeCount(bDD.xor(n, n2)), 3, "nodeCount (6)");
        Test.checkEquality(bDD.quasiReducedNodeCount(0), 0, "quasiReducedNodeCount (1)");
        Test.checkEquality(bDD.quasiReducedNodeCount(1), 0, "quasiReducedNodeCount (2)");
        Test.checkEquality(bDD.quasiReducedNodeCount(n), 1, "quasiReducedNodeCount (3)");
        Test.checkEquality(bDD.quasiReducedNodeCount(n9), 1, "quasiReducedNodeCount (4)");
        Test.checkEquality(bDD.quasiReducedNodeCount(bDD.and(n, n2)), 2, "quasiReducedNodeCount (5)");
        Test.checkEquality(bDD.quasiReducedNodeCount(bDD.xor(n, n2)), 3, "quasiReducedNodeCount (6)");
        int n31 = bDD.ref(bDD.xor(n, n2));
        int n32 = bDD.ref(bDD.xor(n3, n4));
        int n33 = bDD.ref(bDD.xor(n31, n32));
        Test.checkEquality(bDD.quasiReducedNodeCount(n31), 3, "quasiReducedNodeCount (7)");
        Test.checkEquality(bDD.quasiReducedNodeCount(n32), 3, "quasiReducedNodeCount (8)");
        Test.checkEquality(bDD.quasiReducedNodeCount(n33), 15, "quasiReducedNodeCount (9)");
        Test.checkEquality(bDD.nodeCount(n33), 7, "nodeCount (7)");
        bDD.deref(n31);
        bDD.deref(n32);
        bDD.deref(n33);
        Test.checkEquality(bDD.satCount(0), 0.0, "satCount(0)");
        Test.checkEquality(bDD.satCount(1), 16.0, "satCount(1)");
        Test.checkEquality(bDD.satCount(n), 8.0, "satCount(v1)");
        Test.checkEquality(bDD.satCount(n14), 4.0, "satCount(n1)");
        Test.checkEquality(bDD.satCount(n21), 8.0, "satCount(b1)");
        int n34 = bDD.ref(bDD.and(n2, n3));
        int n35 = bDD.ref(bDD.and(n, n3));
        int n36 = bDD.ref(bDD.or(n, n2));
        Test.check(bDD.exists(n35, n34) == n, "Exist failed (1)");
        Test.check(bDD.exists(n8, n34) == n8, "Exist failed (2)");
        Test.check(bDD.forall(n35, n34) == 0, "Forall failed (1)");
        Test.check(bDD.forall(n36, n2) == n, "Forall failed (2)");
        Test.check(bDD.forall(n36, n) == n2, "Forall failed (3)");
        Test.check(bDD.forall(n36, n3) == n36, "Forall failed (4)");
        int n37 = bDD.ref(bDD.xor(n, n2));
        int n38 = bDD.ref(bDD.relProd(n37, n, n));
        int n39 = bDD.ref(bDD.relProd(n37, n8, n));
        int n40 = bDD.ref(bDD.and(n37, n));
        int n41 = bDD.ref(bDD.exists(n40, n));
        bDD.deref(n40);
        n40 = bDD.ref(bDD.and(n37, n8));
        int n42 = bDD.ref(bDD.exists(n40, n));
        bDD.deref(n40);
        Test.checkEquality(n38, n41, "relProd (1)");
        Test.checkEquality(n39, n42, "relProd (2)");
        bDD.deref(n41);
        bDD.deref(n42);
        bDD.deref(n37);
        bDD.deref(n38);
        bDD.deref(n39);
        int[] nArray = new int[]{n, n2};
        int[] nArray2 = new int[]{n3, n4};
        int[] nArray3 = new int[]{n, n3};
        int[] nArray4 = new int[]{n2, n4};
        Permutation permutation = bDD.createPermutation(nArray, nArray2);
        Permutation permutation2 = bDD.createPermutation(nArray2, nArray);
        Permutation permutation3 = bDD.createPermutation(nArray3, nArray4);
        Permutation permutation4 = bDD.createPermutation(nArray4, nArray3);
        int n43 = bDD.ref(bDD.and(n, n2));
        int n44 = bDD.ref(bDD.and(n4, n3));
        int n45 = bDD.ref(bDD.and(n, n3));
        int n46 = bDD.ref(bDD.and(n2, n4));
        int n47 = bDD.replace(n43, permutation);
        int n48 = bDD.replace(n44, permutation2);
        int n49 = bDD.replace(n45, permutation3);
        int n50 = bDD.replace(n46, permutation4);
        Test.check(n47 == n44, "replace() test (1)");
        Test.check(n48 == n43, "replace() test (2)");
        Test.check(n49 == n46, "replace() test (2)");
        Test.check(n50 == n45, "replace() test (2)");
        int n51 = bDD.xor(n2, n3);
        int n52 = bDD.imp(n, n3);
        int n53 = bDD.biimp(n2, n4);
        int n54 = bDD.ref(bDD.cube("1100"));
        int n55 = bDD.ref(bDD.cube("1010"));
        int n56 = bDD.ref(bDD.cube("0101"));
        int n57 = bDD.ref(bDD.cube("0110"));
        int n58 = bDD.ref(bDD.cube("0011"));
        Test.checkEquality(n54, bDD.support(n43), "Support (1)");
        Test.checkEquality(n55, bDD.support(n45), "Support (2)");
        Test.checkEquality(n56, bDD.support(n46), "Support (4)");
        Test.checkEquality(n58, bDD.support(n44), "Support (5)");
        Test.checkEquality(n57, bDD.support(n51), "Support (6)");
        Test.checkEquality(n55, bDD.support(n52), "Support (7)");
        Test.checkEquality(n56, bDD.support(n53), "Support (8)");
        bDD.deref(n54);
        bDD.deref(n55);
        bDD.deref(n56);
        bDD.deref(n58);
        bDD.deref(n57);
        bDD.deref(n47);
        bDD.deref(n48);
        bDD.deref(n49);
        bDD.deref(n50);
        bDD.deref(n43);
        bDD.deref(n45);
        bDD.deref(n46);
        bDD.deref(n44);
        bDD = new BDD(7);
        n = bDD.createVar();
        n2 = bDD.createVar();
        int n59 = bDD.and(n, n2);
        bDD.work_stack[bDD.work_stack_tos++] = n59;
        int n60 = n59;
        bDD.gc();
        Test.check(bDD.isValid(n60), "intermediate node not garbage collected");
        --bDD.work_stack_tos;
        bDD.gc();
        Test.check(!bDD.isValid(n60), "previously intermediate node garbage collected");
        bDD = new BDD(100000);
        n = bDD.createVar();
        n2 = bDD.createVar();
        Test.checkEquality(bDD.and(n, n2), bDD.ite(n, n2, 0), "ITE 1");
        Test.checkEquality(bDD.or(n, n2), bDD.ite(n, 1, n2), "ITE 2");
        Test.checkEquality(bDD.xor(n, n2), bDD.ite(n, bDD.not(n2), n2), "ITE 3");
        Test.checkEquality(bDD.not(n), bDD.ite(n, 0, 1), "ITE 4");
        Test.checkEquality(bDD.nor(n, n2), bDD.ite(n, 0, bDD.not(n2)), "ITE 5");
        Test.checkEquality(bDD.biimp(n, n2), bDD.ite(n, n2, bDD.not(n2)), "ITE 6");
        Test.checkEquality(bDD.nand(n, n2), bDD.ite(n, bDD.not(n2), 1), "ITE 7");
        bDD = new BDD(200);
        n = bDD.createVar();
        n2 = bDD.createVar();
        n3 = bDD.createVar();
        n5 = bDD.ref(bDD.not(n2));
        n47 = bDD.ref(bDD.and(n, n5));
        n48 = bDD.ref(bDD.and(n, n3));
        int[] nArray5 = bDD.oneSat(n47, null);
        Test.checkEquality(nArray5[0], 1, "onesat_v1 (1)");
        Test.checkEquality(nArray5[1], 0, "onesat_v2 (1)");
        Test.checkEquality(nArray5[2], -1, "onesat_v3 (1)");
        nArray5 = bDD.oneSat(n48, null);
        Test.checkEquality(nArray5[0], 1, "onesat_v1 (2)");
        Test.checkEquality(nArray5[1], -1, "onesat_v2 (2)");
        Test.checkEquality(nArray5[2], 1, "onesat_v3 (2)");
        bDD = new BDD(200);
        n = bDD.createVar();
        n2 = bDD.createVar();
        n3 = bDD.createVar();
        n47 = bDD.ref(bDD.and(n, n2));
        n48 = bDD.ref(bDD.or(n, n2));
        n49 = bDD.ref(bDD.and(bDD.not(n), n2));
        n50 = bDD.ref(bDD.and(bDD.not(n2), n));
        boolean[] blArray = new boolean[]{false, true};
        Test.checkEquality(bDD.member(n47, blArray), false, "member (1)");
        Test.checkEquality(bDD.member(n48, blArray), true, "member (2)");
        Test.checkEquality(bDD.member(n49, blArray), true, "member (3)");
        Test.checkEquality(bDD.member(n50, blArray), false, "member (4)");
        Test.end();
    }
}

