/*
 * Decompiled with CFR 0.152.
 */
package jdd.util.jre;

import java.util.Date;
import java.util.Properties;
import jdd.util.JDDConsole;
import jdd.util.math.Digits;

public class JREInfo {
    public static Runtime rt = Runtime.getRuntime();

    public static long usedMemory() {
        return rt.totalMemory() - rt.freeMemory();
    }

    public static long totalMemory() {
        return rt.totalMemory();
    }

    public static long freeMemory() {
        return rt.freeMemory();
    }

    public static long maxMemory() {
        return rt.maxMemory();
    }

    public static void show() {
        Properties properties = System.getProperties();
        JDDConsole.out.println("Using JDD build 108 on " + new Date().toString() + "\n");
        JDDConsole.out.print("Using " + properties.getProperty("java.vendor") + " JRE " + properties.getProperty("java.version"));
        String string = properties.getProperty("java.compiler");
        if (string != null) {
            JDDConsole.out.print(", " + string + " JIT in");
        }
        JDDConsole.out.println(" " + properties.getProperty("java.vm.name"));
        JDDConsole.out.println("OS " + properties.getProperty("os.name") + " on " + rt.availableProcessors() + " " + properties.getProperty("os.arch") + " CPU(s)");
        JDDConsole.out.print("Total JRE memory: ");
        Digits.printNumber1024(rt.maxMemory());
        JDDConsole.out.print(", memory currently reserved by the JRE: ");
        Digits.printNumber1024(JREInfo.usedMemory());
        JDDConsole.out.println("\n");
    }

    public static void main(String[] stringArray) {
        JREInfo.show();
    }
}

