/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cfa;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.TreeMultimap;
import com.google.common.graph.EndpointPair;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.TreeMap;
import java.util.function.BiFunction;
import java.util.logging.Level;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.cpachecker.cfa.CFA;
import org.sosy_lab.cpachecker.cfa.CFAReversePostorder;
import org.sosy_lab.cpachecker.cfa.CfaMutableNetwork;
import org.sosy_lab.cpachecker.cfa.MutableCFA;
import org.sosy_lab.cpachecker.cfa.ast.FileLocation;
import org.sosy_lab.cpachecker.cfa.ast.c.CAstNode;
import org.sosy_lab.cpachecker.cfa.ast.c.CDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.c.CExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CFunctionCall;
import org.sosy_lab.cpachecker.cfa.ast.c.CFunctionDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.c.CReturnStatement;
import org.sosy_lab.cpachecker.cfa.ast.c.CStatement;
import org.sosy_lab.cpachecker.cfa.ast.c.CVariableDeclaration;
import org.sosy_lab.cpachecker.cfa.model.BlankEdge;
import org.sosy_lab.cpachecker.cfa.model.CFAEdge;
import org.sosy_lab.cpachecker.cfa.model.CFALabelNode;
import org.sosy_lab.cpachecker.cfa.model.CFANode;
import org.sosy_lab.cpachecker.cfa.model.CFATerminationNode;
import org.sosy_lab.cpachecker.cfa.model.FunctionEntryNode;
import org.sosy_lab.cpachecker.cfa.model.FunctionExitNode;
import org.sosy_lab.cpachecker.cfa.model.c.CAssumeEdge;
import org.sosy_lab.cpachecker.cfa.model.c.CCfaEdge;
import org.sosy_lab.cpachecker.cfa.model.c.CCfaEdgeVisitor;
import org.sosy_lab.cpachecker.cfa.model.c.CDeclarationEdge;
import org.sosy_lab.cpachecker.cfa.model.c.CFunctionCallEdge;
import org.sosy_lab.cpachecker.cfa.model.c.CFunctionEntryNode;
import org.sosy_lab.cpachecker.cfa.model.c.CFunctionReturnEdge;
import org.sosy_lab.cpachecker.cfa.model.c.CFunctionSummaryEdge;
import org.sosy_lab.cpachecker.cfa.model.c.CFunctionSummaryStatementEdge;
import org.sosy_lab.cpachecker.cfa.model.c.CReturnStatementEdge;
import org.sosy_lab.cpachecker.cfa.model.c.CStatementEdge;
import org.sosy_lab.cpachecker.exceptions.NoException;
import org.sosy_lab.cpachecker.exceptions.ParserException;
import org.sosy_lab.cpachecker.exceptions.UnrecognizedCodeException;
import org.sosy_lab.cpachecker.util.CFAUtils;
import org.sosy_lab.cpachecker.util.LoopStructure;
import org.sosy_lab.cpachecker.util.variableclassification.VariableClassification;
import org.sosy_lab.cpachecker.util.variableclassification.VariableClassificationBuilder;

public final class CCfaTransformer {
    private CCfaTransformer() {
    }

    public static CFA createCfa(Configuration pConfiguration, LogManager pLogger, CFA pOriginalCfa, CfaMutableNetwork pCfaMutableNetwork, BiFunction<CFAEdge, CAstNode, CAstNode> pCfaEdgeAstNodeSubstitution, BiFunction<CFANode, CAstNode, CAstNode> pCfaNodeAstNodeSubstitution) {
        Preconditions.checkNotNull((Object)pConfiguration);
        Preconditions.checkNotNull((Object)pLogger);
        Preconditions.checkNotNull((Object)pOriginalCfa);
        Preconditions.checkNotNull((Object)pCfaMutableNetwork);
        Preconditions.checkNotNull(pCfaEdgeAstNodeSubstitution);
        Preconditions.checkNotNull(pCfaNodeAstNodeSubstitution);
        CfaBuilder cfaBuilder = new CfaBuilder(pCfaMutableNetwork, pCfaEdgeAstNodeSubstitution, pCfaNodeAstNodeSubstitution);
        return cfaBuilder.createCfa(pConfiguration, pLogger, pOriginalCfa);
    }

    public static CFA createCfa(Configuration pConfiguration, LogManager pLogger, CFA pOriginalCfa, CfaMutableNetwork pCfaMutableNetwork, BiFunction<CFAEdge, CAstNode, CAstNode> pCfaEdgeAstNodeSubstitution) {
        return CCfaTransformer.createCfa(pConfiguration, pLogger, pOriginalCfa, pCfaMutableNetwork, pCfaEdgeAstNodeSubstitution, (cfaNode, astNode) -> astNode);
    }

    public static CFA substituteAstNodes(Configuration pConfiguration, LogManager pLogger, CFA pCfa, BiFunction<CFAEdge, CAstNode, CAstNode> pSubstitutionFunction) {
        Preconditions.checkNotNull((Object)pConfiguration);
        Preconditions.checkNotNull((Object)pLogger);
        Preconditions.checkNotNull((Object)pCfa);
        Preconditions.checkNotNull(pSubstitutionFunction);
        CfaMutableNetwork mutableGraph = CfaMutableNetwork.of(pCfa);
        return CCfaTransformer.createCfa(pConfiguration, pLogger, pCfa, mutableGraph, pSubstitutionFunction);
    }

    private static final class CfaBuilder {
        private final CfaMutableNetwork graph;
        private final BiFunction<CFAEdge, CAstNode, CAstNode> cfaEdgeAstNodeSubstitution;
        private final BiFunction<CFANode, CAstNode, CAstNode> cfaNodeAstNodeSubstitution;
        private final Map<CFANode, CFANode> oldNodeToNewNode;
        private final Map<CFAEdge, CFAEdge> oldEdgeToNewEdge;

        private CfaBuilder(CfaMutableNetwork pCfaMutableNetwork, BiFunction<CFAEdge, CAstNode, CAstNode> pCfaEdgeAstNodeSubstitution, BiFunction<CFANode, CAstNode, CAstNode> pCfaNodeAstNodeSubstitution) {
            this.graph = pCfaMutableNetwork;
            this.cfaEdgeAstNodeSubstitution = pCfaEdgeAstNodeSubstitution;
            this.cfaNodeAstNodeSubstitution = pCfaNodeAstNodeSubstitution;
            this.oldNodeToNewNode = new HashMap<CFANode, CFANode>();
            this.oldEdgeToNewEdge = new HashMap<CFAEdge, CFAEdge>();
        }

        private CFunctionDeclaration newFunctionDeclaration(CFANode pOldNode) {
            return (CFunctionDeclaration)this.cfaNodeAstNodeSubstitution.apply(pOldNode, (CFunctionDeclaration)pOldNode.getFunction());
        }

        private CFALabelNode newCfaLabelNode(CFALabelNode pOldNode) {
            return new CFALabelNode(this.newFunctionDeclaration(pOldNode), pOldNode.getLabel());
        }

        private CFunctionEntryNode newCFunctionEntryNode(CFunctionEntryNode pOldNode) {
            FunctionExitNode oldExitNode = pOldNode.getExitNode();
            FunctionExitNode newExitNode = (FunctionExitNode)this.toNew(oldExitNode);
            Optional<CVariableDeclaration> oldReturnVariable = pOldNode.getReturnVariable();
            Optional<CVariableDeclaration> newReturnVariable = oldReturnVariable.isPresent() ? Optional.ofNullable((CVariableDeclaration)this.cfaNodeAstNodeSubstitution.apply(pOldNode, oldReturnVariable.orElseThrow())) : Optional.empty();
            CFunctionEntryNode newEntryNode = new CFunctionEntryNode(pOldNode.getFileLocation(), this.newFunctionDeclaration(pOldNode), newExitNode, newReturnVariable);
            newExitNode.setEntryNode(newEntryNode);
            return newEntryNode;
        }

        private FunctionExitNode newFunctionExitNode(FunctionExitNode pOldNode) {
            return new FunctionExitNode(this.newFunctionDeclaration(pOldNode));
        }

        private CFATerminationNode newCfaTerminationNode(CFATerminationNode pOldNode) {
            return new CFATerminationNode(this.newFunctionDeclaration(pOldNode));
        }

        private CFANode newCfaNode(CFANode pOldNode) {
            return new CFANode(this.newFunctionDeclaration(pOldNode));
        }

        private CFANode toNew(CFANode pOldNode) {
            CFANode newNode = this.oldNodeToNewNode.get(pOldNode);
            if (newNode != null) {
                return newNode;
            }
            newNode = pOldNode instanceof CFALabelNode ? this.newCfaLabelNode((CFALabelNode)pOldNode) : (pOldNode instanceof CFunctionEntryNode ? this.newCFunctionEntryNode((CFunctionEntryNode)pOldNode) : (pOldNode instanceof FunctionExitNode ? this.newFunctionExitNode((FunctionExitNode)pOldNode) : (pOldNode instanceof CFATerminationNode ? this.newCfaTerminationNode((CFATerminationNode)pOldNode) : this.newCfaNode(pOldNode))));
            this.oldNodeToNewNode.put(pOldNode, newNode);
            return newNode;
        }

        private CAstNode substituteAst(CFAEdge pCfaEdge, CAstNode pCAstNode) {
            return this.cfaEdgeAstNodeSubstitution.apply(pCfaEdge, pCAstNode);
        }

        private CFunctionSummaryEdge newCFunctionSummaryEdge(CFunctionSummaryEdge pOldSummaryEdge, CFANode pNewNodeU, CFANode pNewNodeV) {
            CFANode oldSummaryEdgeNodeU = (CFANode)this.graph.incidentNodes(pOldSummaryEdge).nodeU();
            for (CFAEdge outEdge : this.graph.outEdges(oldSummaryEdgeNodeU)) {
                if (!(outEdge instanceof CFunctionCallEdge)) continue;
                CFANode oldEntryNode = (CFANode)this.graph.incidentNodes(outEdge).nodeV();
                CFunctionEntryNode newEntryNode = (CFunctionEntryNode)this.toNew(oldEntryNode);
                CFunctionCall newFunctionCall = (CFunctionCall)this.substituteAst(pOldSummaryEdge, pOldSummaryEdge.getExpression());
                return new CFunctionSummaryEdge(pOldSummaryEdge.getRawStatement(), pOldSummaryEdge.getFileLocation(), pNewNodeU, pNewNodeV, newFunctionCall, newEntryNode);
            }
            throw new IllegalStateException("Missing function call edge for summary edge: " + pOldSummaryEdge);
        }

        private CFunctionCallEdge newCFunctionCallEdge(CFunctionCallEdge pOldCallEdge, CFANode pNewNodeU, CFANode pNewNodeV) {
            CFANode oldCallEdgeNodeU = (CFANode)this.graph.incidentNodes(pOldCallEdge).nodeU();
            for (CFAEdge outEdge : this.graph.outEdges(oldCallEdgeNodeU)) {
                if (!(outEdge instanceof CFunctionSummaryEdge)) continue;
                CFunctionSummaryEdge newSummaryEdge = (CFunctionSummaryEdge)this.toNew(outEdge, true);
                return new CFunctionCallEdge(pOldCallEdge.getRawStatement(), pOldCallEdge.getFileLocation(), pNewNodeU, (CFunctionEntryNode)pNewNodeV, newSummaryEdge.getExpression(), newSummaryEdge);
            }
            throw new IllegalStateException("Missing summary edge for function call edge: " + pOldCallEdge);
        }

        private CFunctionReturnEdge newCFunctionReturnEdge(CFunctionReturnEdge pOldReturnEdge, CFANode pNewNodeU, CFANode pNewNodeV) {
            CFANode oldReturnEdgeNodeV = (CFANode)this.graph.incidentNodes(pOldReturnEdge).nodeV();
            for (CFAEdge inEdge : this.graph.inEdges(oldReturnEdgeNodeV)) {
                if (!(inEdge instanceof CFunctionSummaryEdge)) continue;
                CFunctionSummaryEdge newSummaryEdge = (CFunctionSummaryEdge)this.toNew(inEdge, true);
                return new CFunctionReturnEdge(pOldReturnEdge.getFileLocation(), (FunctionExitNode)pNewNodeU, pNewNodeV, newSummaryEdge);
            }
            throw new IllegalStateException("Missing summary edge for function return edge: " + pOldReturnEdge);
        }

        private CFAEdge toNew(CFAEdge pOldEdge, boolean pBuildSupergraph) {
            CFANode newNodeV;
            @Nullable CFAEdge newEdge = this.oldEdgeToNewEdge.get(pOldEdge);
            if (newEdge != null) {
                return newEdge;
            }
            EndpointPair oldEndpoints = this.graph.incidentNodes(pOldEdge);
            final CFANode newNodeU = this.toNew((CFANode)oldEndpoints.nodeU());
            CCfaEdgeVisitor<@Nullable CFAEdge, NoException> transformingEdgeVisitor = new CCfaEdgeVisitor<CFAEdge, NoException>(newNodeV = this.toNew((CFANode)oldEndpoints.nodeV()), pBuildSupergraph){
                final /* synthetic */ CFANode val$newNodeV;
                final /* synthetic */ boolean val$pBuildSupergraph;
                {
                    this.val$newNodeV = cFANode2;
                    this.val$pBuildSupergraph = bl;
                }

                @Override
                public CFAEdge visit(BlankEdge pBlankEdge) {
                    return new BlankEdge(pBlankEdge.getRawStatement(), pBlankEdge.getFileLocation(), newNodeU, this.val$newNodeV, pBlankEdge.getDescription());
                }

                @Override
                public CFAEdge visit(CAssumeEdge pCAssumeEdge) {
                    CExpression newExpression = (CExpression)this.substituteAst(pCAssumeEdge, pCAssumeEdge.getExpression());
                    return new CAssumeEdge(pCAssumeEdge.getRawStatement(), pCAssumeEdge.getFileLocation(), newNodeU, this.val$newNodeV, newExpression, pCAssumeEdge.getTruthAssumption(), pCAssumeEdge.isSwapped(), pCAssumeEdge.isArtificialIntermediate());
                }

                @Override
                public CFAEdge visit(CDeclarationEdge pCDeclarationEdge) {
                    CDeclaration newDeclaration = (CDeclaration)this.substituteAst(pCDeclarationEdge, pCDeclarationEdge.getDeclaration());
                    return new CDeclarationEdge(pCDeclarationEdge.getRawStatement(), pCDeclarationEdge.getFileLocation(), newNodeU, this.val$newNodeV, newDeclaration);
                }

                @Override
                public CFAEdge visit(CStatementEdge pCStatementEdge) {
                    CStatement newStatement = (CStatement)this.substituteAst(pCStatementEdge, pCStatementEdge.getStatement());
                    return new CStatementEdge(pCStatementEdge.getRawStatement(), newStatement, pCStatementEdge.getFileLocation(), newNodeU, this.val$newNodeV);
                }

                @Override
                public @Nullable CFAEdge visit(CFunctionCallEdge pCFunctionCallEdge) {
                    if (this.val$pBuildSupergraph) {
                        return this.newCFunctionCallEdge(pCFunctionCallEdge, newNodeU, this.val$newNodeV);
                    }
                    return null;
                }

                @Override
                public @Nullable CFAEdge visit(CFunctionReturnEdge pCFunctionReturnEdge) {
                    if (this.val$pBuildSupergraph) {
                        return this.newCFunctionReturnEdge(pCFunctionReturnEdge, newNodeU, this.val$newNodeV);
                    }
                    return null;
                }

                @Override
                public CFAEdge visit(CFunctionSummaryEdge pCFunctionSummaryEdge) {
                    if (this.val$pBuildSupergraph) {
                        return this.newCFunctionSummaryEdge(pCFunctionSummaryEdge, newNodeU, this.val$newNodeV);
                    }
                    return new SummaryPlaceholderEdge("", pCFunctionSummaryEdge.getFileLocation(), newNodeU, this.val$newNodeV, "summary-placeholder-edge");
                }

                @Override
                public CFAEdge visit(CReturnStatementEdge pCReturnStatementEdge) {
                    CReturnStatement newReturnStatement = (CReturnStatement)this.substituteAst(pCReturnStatementEdge, pCReturnStatementEdge.getReturnStatement());
                    return new CReturnStatementEdge(pCReturnStatementEdge.getRawStatement(), newReturnStatement, pCReturnStatementEdge.getFileLocation(), newNodeU, (FunctionExitNode)this.val$newNodeV);
                }

                @Override
                public CFAEdge visit(CFunctionSummaryStatementEdge pCFunctionSummaryStatementEdge) {
                    if (this.val$pBuildSupergraph) {
                        CStatement newStatement = (CStatement)this.substituteAst(pCFunctionSummaryStatementEdge, pCFunctionSummaryStatementEdge.getStatement());
                        CFunctionCall newFunctionCall = (CFunctionCall)this.substituteAst(pCFunctionSummaryStatementEdge, pCFunctionSummaryStatementEdge.getFunctionCall());
                        return new CFunctionSummaryStatementEdge(pCFunctionSummaryStatementEdge.getRawStatement(), newStatement, pCFunctionSummaryStatementEdge.getFileLocation(), newNodeU, this.val$newNodeV, newFunctionCall, pCFunctionSummaryStatementEdge.getFunctionName());
                    }
                    return new SummaryPlaceholderEdge("", pCFunctionSummaryStatementEdge.getFileLocation(), newNodeU, this.val$newNodeV, "summary-placeholder-edge");
                }
            };
            newEdge = ((CCfaEdge)((Object)pOldEdge)).accept(transformingEdgeVisitor);
            if (newEdge != null) {
                if (!(newEdge instanceof SummaryPlaceholderEdge)) {
                    this.oldEdgeToNewEdge.put(pOldEdge, newEdge);
                }
                if (newEdge instanceof CFunctionSummaryEdge) {
                    CFunctionSummaryEdge cfaSummaryEdge = (CFunctionSummaryEdge)newEdge;
                    newNodeU.addLeavingSummaryEdge(cfaSummaryEdge);
                    newNodeV.addEnteringSummaryEdge(cfaSummaryEdge);
                } else {
                    newNodeU.addLeavingEdge(newEdge);
                    newNodeV.addEnteringEdge(newEdge);
                }
            }
            return newEdge;
        }

        private Optional<VariableClassification> createVariableClassification(Configuration pConfiguration, LogManager pLogger, CFA pCfa) {
            try {
                VariableClassificationBuilder builder = new VariableClassificationBuilder(pConfiguration, pLogger);
                return Optional.of(builder.build(pCfa));
            }
            catch (InvalidConfigurationException | UnrecognizedCodeException ex) {
                pLogger.log(Level.WARNING, new Object[]{ex});
                return Optional.empty();
            }
        }

        private void removeSummaryPlaceholderEdges() {
            ArrayList<SummaryPlaceholderEdge> summaryPlaceholderEdges = new ArrayList<SummaryPlaceholderEdge>();
            for (CFANode newCfaNode : this.oldNodeToNewNode.values()) {
                for (CFAEdge newCfaEdge : CFAUtils.allLeavingEdges(newCfaNode)) {
                    if (!(newCfaEdge instanceof SummaryPlaceholderEdge)) continue;
                    summaryPlaceholderEdges.add((SummaryPlaceholderEdge)newCfaEdge);
                }
            }
            for (SummaryPlaceholderEdge summaryPlaceholderEdge : summaryPlaceholderEdges) {
                summaryPlaceholderEdge.getPredecessor().removeLeavingEdge(summaryPlaceholderEdge);
                summaryPlaceholderEdge.getSuccessor().removeEnteringEdge(summaryPlaceholderEdge);
            }
        }

        private FunctionEntryNode determineMainFunctionEntryNode() {
            HashSet<CFANode> waitlisted = new HashSet<CFANode>();
            ArrayDeque<CFANode> waitlist = new ArrayDeque<CFANode>();
            for (CFANode node : this.graph.nodes()) {
                if (this.graph.inDegree(node) != 0) continue;
                waitlisted.add(node);
                waitlist.add(node);
            }
            while (!waitlist.isEmpty()) {
                CFANode node = (CFANode)waitlist.remove();
                if (node instanceof FunctionEntryNode) {
                    return (FunctionEntryNode)node;
                }
                for (CFANode adjacentNode : this.graph.adjacentNodes(node)) {
                    if (!waitlisted.add(adjacentNode)) continue;
                    waitlist.add(adjacentNode);
                }
            }
            throw new AssertionError((Object)"Unable to determine main function node");
        }

        private MutableCFA createUnconnectedFunctionCfa(CFA pOriginalCfa) {
            FunctionEntryNode oldMainEntryNode = this.determineMainFunctionEntryNode();
            TreeMap<String, FunctionEntryNode> newFunctions = new TreeMap<String, FunctionEntryNode>();
            TreeMultimap newNodes = TreeMultimap.create();
            HashSet<CFANode> waitlisted = new HashSet<CFANode>((Collection<CFANode>)ImmutableList.of((Object)oldMainEntryNode));
            ArrayDeque<CFANode> waitlist = new ArrayDeque<CFANode>((Collection<CFANode>)ImmutableList.of((Object)oldMainEntryNode));
            while (!waitlist.isEmpty()) {
                CFANode oldNode = (CFANode)waitlist.remove();
                CFANode newNode = this.toNew(oldNode);
                String functionName = newNode.getFunction().getQualifiedName();
                if (newNode instanceof FunctionEntryNode) {
                    newFunctions.put(functionName, (FunctionEntryNode)newNode);
                }
                newNodes.put((Object)functionName, (Object)newNode);
                for (CFANode adjacentNode : this.graph.adjacentNodes(oldNode)) {
                    if (!waitlisted.add(adjacentNode)) continue;
                    waitlist.add(adjacentNode);
                }
            }
            for (CFANode oldNode : this.oldNodeToNewNode.keySet()) {
                for (CFAEdge outEdge : this.graph.outEdges(oldNode)) {
                    this.toNew(outEdge, false);
                }
            }
            return new MutableCFA(pOriginalCfa.getMachineModel(), newFunctions, (TreeMultimap<String, CFANode>)newNodes, (FunctionEntryNode)this.oldNodeToNewNode.get(oldMainEntryNode), pOriginalCfa.getFileNames(), pOriginalCfa.getLanguage());
        }

        private CFA createCfa(Configuration pConfiguration, LogManager pLogger, CFA pOriginalCfa) {
            MutableCFA newMutableCfa = this.createUnconnectedFunctionCfa(pOriginalCfa);
            newMutableCfa.getAllFunctionHeads().forEach(CFAReversePostorder::assignIds);
            if (pOriginalCfa.getLoopStructure().isPresent()) {
                try {
                    newMutableCfa.setLoopStructure(LoopStructure.getLoopStructure(newMutableCfa));
                }
                catch (ParserException ex) {
                    pLogger.log(Level.WARNING, new Object[]{ex});
                }
            }
            this.removeSummaryPlaceholderEdges();
            for (CFANode oldNode : this.oldNodeToNewNode.keySet()) {
                for (CFAEdge outEdge : this.graph.outEdges(oldNode)) {
                    this.toNew(outEdge, true);
                }
            }
            Optional<VariableClassification> variableClassification = pOriginalCfa.getVarClassification().isPresent() ? this.createVariableClassification(pConfiguration, pLogger, newMutableCfa) : Optional.empty();
            return newMutableCfa.makeImmutableCFA(variableClassification);
        }

        private static final class SummaryPlaceholderEdge
        extends BlankEdge {
            private static final long serialVersionUID = -4605071143372536460L;

            public SummaryPlaceholderEdge(String pRawStatement, FileLocation pFileLocation, CFANode pPredecessor, CFANode pSuccessor, String pDescription) {
                super(pRawStatement, pFileLocation, pPredecessor, pSuccessor, pDescription);
            }
        }
    }
}

