/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cfa;

import com.google.common.base.Verify;
import com.google.common.base.VerifyException;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import java.math.BigInteger;
import java.util.ArrayDeque;
import java.util.HashSet;
import java.util.Set;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.sosy_lab.cpachecker.cfa.ast.ADeclaration;
import org.sosy_lab.cpachecker.cfa.ast.AStatement;
import org.sosy_lab.cpachecker.cfa.ast.FileLocation;
import org.sosy_lab.cpachecker.cfa.ast.c.CArraySubscriptExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CBinaryExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CCastExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CCharLiteralExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CComplexCastExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CExpressionStatement;
import org.sosy_lab.cpachecker.cfa.ast.c.CFieldReference;
import org.sosy_lab.cpachecker.cfa.ast.c.CImaginaryLiteralExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CInitializer;
import org.sosy_lab.cpachecker.cfa.ast.c.CInitializerExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CIntegerLiteralExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CPointerExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CUnaryExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CVariableDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.c.DefaultCExpressionVisitor;
import org.sosy_lab.cpachecker.cfa.model.ADeclarationEdge;
import org.sosy_lab.cpachecker.cfa.model.AStatementEdge;
import org.sosy_lab.cpachecker.cfa.model.AssumeEdge;
import org.sosy_lab.cpachecker.cfa.model.CFAEdge;
import org.sosy_lab.cpachecker.cfa.model.CFANode;
import org.sosy_lab.cpachecker.cfa.model.CFATerminationNode;
import org.sosy_lab.cpachecker.cfa.model.FunctionEntryNode;
import org.sosy_lab.cpachecker.cfa.model.FunctionExitNode;
import org.sosy_lab.cpachecker.cfa.model.c.CAssumeEdge;
import org.sosy_lab.cpachecker.cfa.model.c.CFunctionCallEdge;
import org.sosy_lab.cpachecker.cfa.model.c.CFunctionSummaryStatementEdge;
import org.sosy_lab.cpachecker.cfa.types.MachineModel;
import org.sosy_lab.cpachecker.cfa.types.c.CSimpleType;
import org.sosy_lab.cpachecker.cfa.types.c.CType;
import org.sosy_lab.cpachecker.util.CFAUtils;

public class CFACheck {
    public static boolean check(FunctionEntryNode cfa, @Nullable Set<CFANode> nodes, MachineModel machineModel) throws VerifyException {
        HashSet<CFANode> visitedNodes = new HashSet<CFANode>();
        ArrayDeque<FunctionEntryNode> waitingNodeList = new ArrayDeque<FunctionEntryNode>();
        waitingNodeList.add(cfa);
        while (!waitingNodeList.isEmpty()) {
            CFANode node = (CFANode)waitingNodeList.poll();
            if (!visitedNodes.add(node)) continue;
            Iterables.addAll(waitingNodeList, CFAUtils.successorsOf(node));
            Iterables.addAll(waitingNodeList, CFAUtils.predecessorsOf(node));
            CFACheck.isConsistent(node, machineModel);
            CFACheck.checkEdgeCount(node);
        }
        if (nodes != null) {
            Verify.verify((boolean)visitedNodes.equals(nodes), (String)"\nNodes in CFA but not reachable through traversal: %s\nNodes reached that are not in CFA: %s", (Object)Iterables.transform((Iterable)Sets.difference(nodes, visitedNodes), CFACheck::debugFormat), (Object)Iterables.transform((Iterable)Sets.difference(visitedNodes, nodes), CFACheck::debugFormat));
        }
        return true;
    }

    private static Object debugFormat(final CFANode node) {
        return new Object(){

            public String toString() {
                FileLocation location = FileLocation.DUMMY;
                if (node.getNumEnteringEdges() > 0) {
                    location = node.getEnteringEdge(0).getFileLocation();
                } else if (node.getNumLeavingEdges() > 0) {
                    location = node.getLeavingEdge(0).getFileLocation();
                }
                return node.getFunctionName() + ":" + node + " (" + location + ")";
            }
        };
    }

    private static void checkEdgeCount(CFANode pNode) {
        int entering = pNode.getNumEnteringEdges();
        if (entering == 0) {
            Verify.verify((boolean)(pNode instanceof FunctionEntryNode), (String)"Dead code: node %s has no incoming edges (successors are %s)", (Object)CFACheck.debugFormat(pNode), (Object)CFAUtils.successorsOf(pNode).transform(CFACheck::debugFormat));
        }
        if (!(pNode instanceof FunctionExitNode)) {
            switch (pNode.getNumLeavingEdges()) {
                case 0: {
                    Verify.verify((boolean)(pNode instanceof CFATerminationNode), (String)"Dead end at node %s", (Object)CFACheck.debugFormat(pNode));
                    break;
                }
                case 1: {
                    CFAEdge edge = pNode.getLeavingEdge(0);
                    Verify.verify((!(edge instanceof AssumeEdge) ? 1 : 0) != 0, (String)"AssumeEdge does not appear in pair at node %s", (Object)CFACheck.debugFormat(pNode));
                    Verify.verify((!(edge instanceof CFunctionSummaryStatementEdge) ? 1 : 0) != 0, (String)"CFunctionSummaryStatementEdge is not paired with CFunctionCallEdge at node %s", (Object)CFACheck.debugFormat(pNode));
                    break;
                }
                case 2: {
                    CFAEdge edge1 = pNode.getLeavingEdge(0);
                    CFAEdge edge2 = pNode.getLeavingEdge(1);
                    if (edge1 instanceof CFunctionSummaryStatementEdge) {
                        Verify.verify((boolean)(edge2 instanceof CFunctionCallEdge), (String)"CFunctionSummaryStatementEdge is not paired with CFunctionCallEdge at node %s", (Object)CFACheck.debugFormat(pNode));
                        break;
                    }
                    if (edge2 instanceof CFunctionSummaryStatementEdge) {
                        Verify.verify((boolean)(edge1 instanceof CFunctionCallEdge), (String)"CFunctionSummaryStatementEdge is not paired with CFunctionCallEdge at node %s", (Object)CFACheck.debugFormat(pNode));
                        break;
                    }
                    Verify.verify((edge1 instanceof AssumeEdge && edge2 instanceof AssumeEdge ? 1 : 0) != 0, (String)"Branching without conditions at node %s", (Object)CFACheck.debugFormat(pNode));
                    AssumeEdge ae1 = (AssumeEdge)edge1;
                    AssumeEdge ae2 = (AssumeEdge)edge2;
                    Verify.verify((ae1.getTruthAssumption() != ae2.getTruthAssumption() ? 1 : 0) != 0, (String)"Inconsistent branching at node %s", (Object)CFACheck.debugFormat(pNode));
                    break;
                }
                default: {
                    throw new VerifyException("Too much branching at node " + CFACheck.debugFormat(pNode));
                }
            }
        }
    }

    private static void isConsistent(CFANode pNode, MachineModel machineModel) {
        HashSet<CFAEdge> seenEdges = new HashSet<CFAEdge>();
        HashSet<CFANode> seenNodes = new HashSet<CFANode>();
        for (CFAEdge edge : CFAUtils.leavingEdges(pNode)) {
            Verify.verify((boolean)seenEdges.add(edge), (String)"Duplicate leaving edge %s on node %s", (Object)edge, (Object)CFACheck.debugFormat(pNode));
            CFACheck.checkEdge(edge, machineModel);
            CFANode successor = edge.getSuccessor();
            Verify.verify((boolean)seenNodes.add(successor), (String)"Duplicate successor %s for node %s", (Object)successor, (Object)CFACheck.debugFormat(pNode));
            Verify.verify((boolean)CFAUtils.enteringEdges(successor).contains((Object)edge), (String)"Node %s has leaving edge %s, but node %s does not have this edge as entering edge!", (Object)CFACheck.debugFormat(pNode), (Object)edge, (Object)CFACheck.debugFormat(successor));
        }
        seenEdges.clear();
        seenNodes.clear();
        for (CFAEdge edge : CFAUtils.enteringEdges(pNode)) {
            Verify.verify((boolean)seenEdges.add(edge), (String)"Duplicate entering edge %s on node %s", (Object)edge, (Object)CFACheck.debugFormat(pNode));
            CFANode predecessor = edge.getPredecessor();
            Verify.verify((boolean)seenNodes.add(predecessor), (String)"Duplicate predecessor %s for node %s", (Object)predecessor, (Object)CFACheck.debugFormat(pNode));
            Verify.verify((boolean)CFAUtils.leavingEdges(predecessor).contains((Object)edge), (String)"Node %s has entering edge %s, but node %s does not have this edge as leaving edge!", (Object)CFACheck.debugFormat(pNode), (Object)edge, (Object)CFACheck.debugFormat(predecessor));
        }
    }

    private static void checkEdge(CFAEdge edge, MachineModel machineModel) {
        switch (edge.getEdgeType()) {
            case AssumeEdge: {
                if (!(edge instanceof CAssumeEdge)) break;
                CFACheck.checkTypes(((CAssumeEdge)edge).getExpression(), machineModel);
                break;
            }
            case DeclarationEdge: {
                CInitializer init;
                ADeclaration decl = ((ADeclarationEdge)edge).getDeclaration();
                if (!(decl instanceof CVariableDeclaration) || !((init = ((CVariableDeclaration)decl).getInitializer()) instanceof CInitializerExpression)) break;
                CFACheck.checkTypes(((CInitializerExpression)init).getExpression(), machineModel);
                break;
            }
            case StatementEdge: {
                AStatement stat = ((AStatementEdge)edge).getStatement();
                if (!(stat instanceof CExpressionStatement)) break;
                CFACheck.checkTypes(((CExpressionStatement)stat).getExpression(), machineModel);
                break;
            }
        }
    }

    private static void checkTypes(CExpression exp, MachineModel machineModel) {
        exp.accept(new ExpressionValidator(machineModel, exp));
    }

    private static final class ExpressionValidator
    extends DefaultCExpressionVisitor<Void, RuntimeException> {
        private final MachineModel machineModel;
        private final CExpression expressionForLogging;

        public ExpressionValidator(MachineModel pMachineModel, CExpression pExp) {
            this.machineModel = pMachineModel;
            this.expressionForLogging = pExp;
        }

        private void checkValueRange(CType pType, BigInteger value) {
            CSimpleType type = (CSimpleType)pType.getCanonicalType();
            Verify.verify((this.machineModel.getMinimalIntegerValue(type).compareTo(value) <= 0 ? 1 : 0) != 0, (String)"value '%s' is too small for type '%s' in expression '%s' at %s", (Object)value, (Object)type, (Object)this.expressionForLogging.toASTString(), (Object)this.expressionForLogging.getFileLocation());
            Verify.verify((this.machineModel.getMaximalIntegerValue(type).compareTo(value) >= 0 ? 1 : 0) != 0, (String)"value '%s' is too large for type '%s' in expression '%s' at %s", (Object)value, (Object)type, (Object)this.expressionForLogging.toASTString(), (Object)this.expressionForLogging.getFileLocation());
        }

        @Override
        public Void visit(CArraySubscriptExpression pArraySubscriptExpression) {
            pArraySubscriptExpression.getSubscriptExpression().accept(this);
            return null;
        }

        @Override
        public Void visit(CFieldReference pFieldReference) {
            pFieldReference.getFieldOwner().accept(this);
            return null;
        }

        @Override
        public Void visit(CPointerExpression pPointerExpression) {
            pPointerExpression.getOperand().accept(this);
            return null;
        }

        @Override
        public Void visit(CComplexCastExpression pComplexCastExpression) {
            pComplexCastExpression.getOperand().accept(this);
            return null;
        }

        @Override
        public Void visit(CBinaryExpression pBinaryExpression) {
            pBinaryExpression.getOperand1().accept(this);
            pBinaryExpression.getOperand2().accept(this);
            return null;
        }

        @Override
        public Void visit(CCastExpression pCastExpression) {
            pCastExpression.getOperand().accept(this);
            return null;
        }

        @Override
        public Void visit(CCharLiteralExpression pLiteral) {
            this.checkValueRange(pLiteral.getExpressionType(), BigInteger.valueOf(pLiteral.getCharacter()));
            return null;
        }

        @Override
        public Void visit(CIntegerLiteralExpression pLiteral) {
            this.checkValueRange(pLiteral.getExpressionType(), pLiteral.getValue());
            return null;
        }

        @Override
        public Void visit(CUnaryExpression pUnaryExpression) {
            pUnaryExpression.getOperand().accept(this);
            return null;
        }

        @Override
        public Void visit(CImaginaryLiteralExpression pLiteralExpression) {
            pLiteralExpression.getValue().accept(this);
            return null;
        }

        @Override
        protected Void visitDefault(CExpression pExp) throws RuntimeException {
            return null;
        }
    }
}

