/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cfa;

import java.util.logging.Level;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.cpachecker.cfa.model.CFAEdge;
import org.sosy_lab.cpachecker.cfa.model.CFAEdgeType;
import org.sosy_lab.cpachecker.cfa.model.CFALabelNode;
import org.sosy_lab.cpachecker.cfa.model.CFANode;
import org.sosy_lab.cpachecker.cfa.model.FunctionEntryNode;

public class CFACreationUtils {
    private static int lastDetectedDeadCode = -1;

    public static void addEdgeToCFA(CFAEdge edge, LogManager logger) {
        CFACreationUtils.addEdgeToCFA(edge, logger, true);
    }

    public static void addEdgeToCFA(CFAEdge edge, LogManager logger, boolean warnForDeadCode) {
        CFANode predecessor = edge.getPredecessor();
        if (edge.getEdgeType() == CFAEdgeType.AssumeEdge) {
            assert (predecessor.getNumLeavingEdges() <= 1);
            if (predecessor.getNumLeavingEdges() > 0) assert (predecessor.getLeavingEdge(0).getEdgeType() == CFAEdgeType.AssumeEdge);
        } else assert (predecessor.getNumLeavingEdges() == 0);
        if (CFACreationUtils.isReachableNode(predecessor)) {
            CFACreationUtils.addEdgeUnconditionallyToCFA(edge);
        } else {
            if (!edge.getDescription().isEmpty()) {
                Level level = Level.INFO;
                if (!warnForDeadCode) {
                    level = Level.FINER;
                } else if (edge.getDescription().matches("^Goto: (switch|while|ldv)_\\d+(_[a-z0-9]+)?$")) {
                    level = Level.FINER;
                } else if (edge.getPredecessor().getNodeNumber() == lastDetectedDeadCode) {
                    level = Level.FINER;
                }
                logger.logf(level, "%s: Dead code detected: %s", new Object[]{edge.getFileLocation(), edge.getRawStatement()});
            }
            lastDetectedDeadCode = edge.getSuccessor().getNodeNumber();
        }
    }

    public static void addEdgeUnconditionallyToCFA(CFAEdge edge) {
        edge.getPredecessor().addLeavingEdge(edge);
        edge.getSuccessor().addEnteringEdge(edge);
    }

    public static boolean isReachableNode(CFANode node) {
        return node.getNumEnteringEdges() > 0 || node instanceof FunctionEntryNode || node.isLoopStart() || node instanceof CFALabelNode;
    }

    public static void removeChainOfNodesFromCFA(CFANode n) {
        if (n.getNumEnteringEdges() > 0) {
            return;
        }
        for (int i = n.getNumLeavingEdges() - 1; i >= 0; --i) {
            CFAEdge e = n.getLeavingEdge(i);
            CFANode succ = e.getSuccessor();
            CFACreationUtils.removeEdgeFromNodes(e);
            CFACreationUtils.removeChainOfNodesFromCFA(succ);
        }
    }

    public static void removeEdgeFromNodes(CFAEdge e) {
        e.getPredecessor().removeLeavingEdge(e);
        e.getSuccessor().removeEnteringEdge(e);
    }
}

