/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cfa;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.io.MoreFiles;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.logging.Level;
import java.util.stream.Collectors;
import java.util.zip.GZIPOutputStream;
import org.sosy_lab.common.Concurrency;
import org.sosy_lab.common.ShutdownNotifier;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.FileOption;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.configuration.Option;
import org.sosy_lab.common.configuration.Options;
import org.sosy_lab.common.io.IO;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.common.time.Timer;
import org.sosy_lab.cpachecker.cfa.CFA;
import org.sosy_lab.cpachecker.cfa.CFACheck;
import org.sosy_lab.cpachecker.cfa.CFACreationUtils;
import org.sosy_lab.cpachecker.cfa.CFAReversePostorder;
import org.sosy_lab.cpachecker.cfa.CFASecondPassBuilder;
import org.sosy_lab.cpachecker.cfa.CParser;
import org.sosy_lab.cpachecker.cfa.CParserWithLocationMapper;
import org.sosy_lab.cpachecker.cfa.CParserWithPreprocessor;
import org.sosy_lab.cpachecker.cfa.CPreprocessor;
import org.sosy_lab.cpachecker.cfa.ClangPreprocessor;
import org.sosy_lab.cpachecker.cfa.ImmutableCFA;
import org.sosy_lab.cpachecker.cfa.Language;
import org.sosy_lab.cpachecker.cfa.LlvmParserWithClang;
import org.sosy_lab.cpachecker.cfa.MutableCFA;
import org.sosy_lab.cpachecker.cfa.ParseResult;
import org.sosy_lab.cpachecker.cfa.ParseResultWithCommentLocations;
import org.sosy_lab.cpachecker.cfa.Parser;
import org.sosy_lab.cpachecker.cfa.ast.ADeclaration;
import org.sosy_lab.cpachecker.cfa.ast.AExpression;
import org.sosy_lab.cpachecker.cfa.ast.AFunctionCall;
import org.sosy_lab.cpachecker.cfa.ast.AIdExpression;
import org.sosy_lab.cpachecker.cfa.ast.AStatement;
import org.sosy_lab.cpachecker.cfa.ast.AVariableDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.FileLocation;
import org.sosy_lab.cpachecker.cfa.ast.acsl.ACSLParser;
import org.sosy_lab.cpachecker.cfa.ast.acsl.util.SyntacticBlock;
import org.sosy_lab.cpachecker.cfa.ast.acsl.util.SyntacticBlockStructureBuilder;
import org.sosy_lab.cpachecker.cfa.ast.c.CDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.c.CInitializer;
import org.sosy_lab.cpachecker.cfa.ast.c.CVariableDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.java.JDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.java.JMethodDeclaration;
import org.sosy_lab.cpachecker.cfa.export.CFAToPixelsWriter;
import org.sosy_lab.cpachecker.cfa.export.DOTBuilder;
import org.sosy_lab.cpachecker.cfa.export.DOTBuilder2;
import org.sosy_lab.cpachecker.cfa.export.FunctionCallDumper;
import org.sosy_lab.cpachecker.cfa.model.ADeclarationEdge;
import org.sosy_lab.cpachecker.cfa.model.AStatementEdge;
import org.sosy_lab.cpachecker.cfa.model.BlankEdge;
import org.sosy_lab.cpachecker.cfa.model.CFAEdge;
import org.sosy_lab.cpachecker.cfa.model.CFAEdgeType;
import org.sosy_lab.cpachecker.cfa.model.CFANode;
import org.sosy_lab.cpachecker.cfa.model.FunctionEntryNode;
import org.sosy_lab.cpachecker.cfa.model.c.CDeclarationEdge;
import org.sosy_lab.cpachecker.cfa.model.java.JDeclarationEdge;
import org.sosy_lab.cpachecker.cfa.parser.Parsers;
import org.sosy_lab.cpachecker.cfa.postprocessing.function.CFADeclarationMover;
import org.sosy_lab.cpachecker.cfa.postprocessing.function.CFASimplifier;
import org.sosy_lab.cpachecker.cfa.postprocessing.function.CFunctionPointerResolver;
import org.sosy_lab.cpachecker.cfa.postprocessing.function.ExpandFunctionPointerArrayAssignments;
import org.sosy_lab.cpachecker.cfa.postprocessing.function.NullPointerChecks;
import org.sosy_lab.cpachecker.cfa.postprocessing.function.ThreadCreateTransformer;
import org.sosy_lab.cpachecker.cfa.postprocessing.global.CFACloner;
import org.sosy_lab.cpachecker.cfa.postprocessing.global.FunctionCallUnwinder;
import org.sosy_lab.cpachecker.cfa.types.MachineModel;
import org.sosy_lab.cpachecker.cfa.types.c.CComplexType;
import org.sosy_lab.cpachecker.cfa.types.c.CDefaults;
import org.sosy_lab.cpachecker.cfa.types.c.CElaboratedType;
import org.sosy_lab.cpachecker.cfa.types.c.CStorageClass;
import org.sosy_lab.cpachecker.cfa.types.c.CType;
import org.sosy_lab.cpachecker.core.CPAcheckerResult;
import org.sosy_lab.cpachecker.core.interfaces.Statistics;
import org.sosy_lab.cpachecker.core.reachedset.UnmodifiableReachedSet;
import org.sosy_lab.cpachecker.exceptions.CPAException;
import org.sosy_lab.cpachecker.exceptions.CParserException;
import org.sosy_lab.cpachecker.exceptions.JParserException;
import org.sosy_lab.cpachecker.exceptions.ParserException;
import org.sosy_lab.cpachecker.exceptions.UnrecognizedCodeException;
import org.sosy_lab.cpachecker.util.CFAUtils;
import org.sosy_lab.cpachecker.util.LiveVariables;
import org.sosy_lab.cpachecker.util.LoopStructure;
import org.sosy_lab.cpachecker.util.Pair;
import org.sosy_lab.cpachecker.util.cwriter.CFAToCTranslator;
import org.sosy_lab.cpachecker.util.cwriter.CfaToCExporter;
import org.sosy_lab.cpachecker.util.statistics.StatisticsUtils;
import org.sosy_lab.cpachecker.util.variableclassification.VariableClassification;
import org.sosy_lab.cpachecker.util.variableclassification.VariableClassificationBuilder;

@Options
public class CFACreator {
    public static final String VALID_C_FUNCTION_NAME_PATTERN = "[_a-zA-Z][_a-zA-Z0-9]*";
    public static final String VALID_JAVA_FUNCTION_NAME_PATTERN = ".*";
    @Option(secure=true, name="parser.usePreprocessor", description="For C files, run the preprocessor on them before parsing. Note that all line numbers printed by CPAchecker will refer to the pre-processed file, not the original input file.")
    private boolean usePreprocessor = false;
    @Option(secure=true, name="parser.useClang", description="For C files, convert to LLVM IR with clang first and then use the LLVM parser.")
    private boolean useClang = false;
    @Option(secure=true, name="parser.readLineDirectives", description="For C files, read #line preprocessor directives and use their information for outputting line numbers. (Always enabled when pre-processing is used.)")
    private boolean readLineDirectives = false;
    @Option(secure=true, name="analysis.entryFunction", description="entry function")
    private String mainFunctionName = "main";
    @Option(secure=true, name="analysis.machineModel", description="the machine model, which determines the sizes of types like int")
    private MachineModel machineModel = MachineModel.LINUX32;
    @Option(secure=true, name="analysis.interprocedural", description="run interprocedural analysis")
    private boolean interprocedural = true;
    @Option(secure=true, name="analysis.functionPointerCalls", description="create all potential function pointer call edges")
    private boolean fptrCallEdges = true;
    @Option(secure=true, name="analysis.threadOperationsTransform", description="Replace thread creation operations with a special function callsso, any analysis can go through the function")
    private boolean enableThreadOperationsInstrumentation = false;
    @Option(secure=true, name="analysis.useGlobalVars", description="add declarations for global variables before entry function")
    private boolean useGlobalVars = true;
    @Option(secure=true, name="analysis.useLoopStructure", description="add loop-structure information to CFA.")
    private boolean useLoopStructure = true;
    @Option(secure=true, name="cfa.export", description="export CFA as .dot file")
    private boolean exportCfa = true;
    @Option(secure=true, name="cfa.exportPerFunction", description="export individual CFAs for function as .dot files")
    private boolean exportCfaPerFunction = true;
    @Option(secure=true, name="cfa.exportToC", description="export CFA as C file")
    private boolean exportCfaToC = false;
    @Option(secure=true, name="cfa.exportToC.file", description="export CFA as C file")
    @FileOption(value=FileOption.Type.OUTPUT_FILE)
    private Path exportCfaToCFile = Path.of("cfa.c", new String[0]);
    @Option(secure=true, name="cfa.exportToC.stayCloserToInput", description="produce C programs more similar to the input program\n(only possible for a single input file)")
    private boolean exportCfaToCStayingCloserToInput = false;
    @Option(secure=true, name="cfa.callgraph.export", description="dump a simple call graph")
    private boolean exportFunctionCalls = true;
    @Option(secure=true, name="cfa.callgraph.file", description="file name for call graph as .dot file")
    @FileOption(value=FileOption.Type.OUTPUT_FILE)
    private Path exportFunctionCallsFile = Path.of("functionCalls.dot", new String[0]);
    @Option(secure=true, name="cfa.callgraph.fileUsed", description="file name for call graph as .dot file")
    @FileOption(value=FileOption.Type.OUTPUT_FILE)
    private Path exportFunctionCallsUsedFile = Path.of("functionCallsUsed.dot", new String[0]);
    @Option(secure=true, name="cfa.file", description="export CFA as .dot file")
    @FileOption(value=FileOption.Type.OUTPUT_FILE)
    private Path exportCfaFile = Path.of("cfa.dot", new String[0]);
    @Option(secure=true, name="cfa.serialize", description="export CFA as .ser file (dump Java objects)")
    private boolean serializeCfa = false;
    @Option(secure=true, name="cfa.serializeFile", description="export CFA as .ser file (dump Java objects)")
    @FileOption(value=FileOption.Type.OUTPUT_FILE)
    private Path serializeCfaFile = Path.of("cfa.ser.gz", new String[0]);
    @Option(secure=true, name="cfa.pixelGraphicFile", description="Export CFA as pixel graphic to the given file name. The suffix is added corresponding to the value of option pixelgraphic.export.formatIf set to 'null', no pixel graphic is exported.")
    @FileOption(value=FileOption.Type.OUTPUT_FILE)
    private Path exportCfaPixelFile = Path.of("cfaPixel", new String[0]);
    @Option(secure=true, name="cfa.checkNullPointers", description="while this option is activated, before each use of a PointerExpression, or a dereferenced field access the expression is checked if it is 0")
    private boolean checkNullPointers = false;
    @Option(secure=true, name="cfa.expandFunctionPointerArrayAssignments", description="When a function pointer array element is written with a variable as index, create a series of if-else edges with explicit indizes instead.")
    private boolean expandFunctionPointerArrayAssignments = false;
    @Option(secure=true, name="cfa.simplifyCfa", description="Remove all edges which don't have any effect on the program")
    private boolean simplifyCfa = true;
    @Option(secure=true, name="cfa.moveDeclarationsToFunctionStart", description="With this option, all declarations in each function will be movedto the beginning of each function. Do only use this option if you arenot able to handle initializer lists and designated initializers (like they can be used for arrays and structs) in your analysis anyway. this option will otherwise create c code which is not the same as the original one")
    private boolean moveDeclarationsToFunctionStart = false;
    @Option(secure=true, name="cfa.useFunctionCallUnwinding", description="unwind recursive functioncalls (bounded to max call stack size)")
    private boolean useFunctionCallUnwinding = false;
    @Option(secure=true, name="cfa.useCFACloningForMultiThreadedPrograms", description="clone functions of the CFA, such that there are several identical CFAs for each function, only with different names.")
    private boolean useCFACloningForMultiThreadedPrograms = false;
    @Option(secure=true, name="cfa.findLiveVariables", description="By enabling this option the variables that are live are computed for each edge of the cfa. Live means that their value is read later on.")
    private boolean findLiveVariables = false;
    @Option(secure=true, description="Programming language of the input program. If not given explicitly, auto-detection will occur")
    private Language language = Language.C;
    private final List<FileLocation> commentPositions = new ArrayList<FileLocation>();
    private final List<SyntacticBlock> blocks = new ArrayList<SyntacticBlock>();
    private final LogManager logger;
    private final Parser parser;
    private final ShutdownNotifier shutdownNotifier;
    private static final String EXAMPLE_JAVA_METHOD_NAME = "Please note that a method has to be given in the following notation:\n <ClassName>_<MethodName>_<ParameterTypes>.\nExample: pack1.Car_drive_int_Car\nfor the method drive(int speed, Car car) in the class Car.";
    private final CFACreatorStatistics stats;
    private final Configuration config;

    public CFACreator(Configuration config, LogManager logger, ShutdownNotifier pShutdownNotifier) throws InvalidConfigurationException {
        config.inject((Object)this);
        this.config = config;
        this.logger = logger;
        this.shutdownNotifier = pShutdownNotifier;
        this.stats = new CFACreatorStatistics(logger);
        this.stats.parserInstantiationTime.start();
        switch (this.language) {
            case JAVA: {
                String regExPattern = "^.*$";
                if (!this.mainFunctionName.matches(regExPattern)) {
                    throw new InvalidConfigurationException("Entry function for java programs must match pattern " + regExPattern);
                }
                this.parser = Parsers.getJavaParser(logger, config, this.mainFunctionName);
                break;
            }
            case C: {
                String regExPattern = "^[_a-zA-Z][_a-zA-Z0-9]*$";
                if (!this.mainFunctionName.matches(regExPattern)) {
                    throw new InvalidConfigurationException("Entry function for c programs must match pattern " + regExPattern);
                }
                CParser outerParser = CParser.Factory.getParser(logger, CParser.Factory.getOptions(config), this.machineModel, this.shutdownNotifier);
                outerParser = new CParserWithLocationMapper(config, logger, outerParser, this.readLineDirectives || this.usePreprocessor || this.useClang);
                if (this.usePreprocessor) {
                    CPreprocessor preprocessor = new CPreprocessor(config, logger);
                    outerParser = new CParserWithPreprocessor(outerParser, preprocessor);
                }
                if (this.useClang) {
                    if (this.usePreprocessor) {
                        logger.log(Level.WARNING, new Object[]{"Option -preprocess is ignored when used with option -clang"});
                    }
                    ClangPreprocessor clang = new ClangPreprocessor(config, logger);
                    this.parser = LlvmParserWithClang.Factory.getParser(clang, logger, this.machineModel);
                    break;
                }
                this.parser = outerParser;
                break;
            }
            case LLVM: {
                this.parser = Parsers.getLlvmParser(logger, this.machineModel);
                this.language = Language.C;
                break;
            }
            default: {
                throw new AssertionError();
            }
        }
        this.stats.parsingTime = this.parser.getParseTime();
        this.stats.conversionTime = this.parser.getCFAConstructionTime();
        this.stats.parserInstantiationTime.stop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CFA parseSourceAndCreateCFA(String program) throws InvalidConfigurationException, ParserException, InterruptedException {
        this.stats.totalTime.start();
        try {
            CFA cfa;
            ParseResult parseResult = this.parseToCFAs(program);
            FunctionEntryNode mainFunction = (FunctionEntryNode)parseResult.getFunctions().get(this.mainFunctionName);
            assert (mainFunction != null) : "program lacks main function.";
            CFA cFA = cfa = this.createCFA(parseResult, mainFunction);
            return cFA;
        }
        finally {
            this.stats.totalTime.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CFA parseFileAndCreateCFA(List<String> sourceFiles) throws InvalidConfigurationException, IOException, ParserException, InterruptedException {
        Preconditions.checkArgument((!sourceFiles.isEmpty() ? 1 : 0) != 0, (Object)"At least one source file must be provided!");
        this.stats.totalTime.start();
        try {
            FunctionEntryNode mainFunction;
            this.logger.log(Level.FINE, new Object[]{"Starting parsing of file(s)"});
            ParseResult c = this.parseToCFAs(sourceFiles);
            this.logger.log(Level.FINE, new Object[]{"Parser Finished"});
            switch (this.language) {
                case JAVA: {
                    mainFunction = CFACreator.getJavaMainMethod(sourceFiles, this.mainFunctionName, c.getFunctions());
                    this.checkForAmbiguousMethod(mainFunction, this.mainFunctionName, c.getFunctions());
                    break;
                }
                case C: {
                    mainFunction = this.getCMainFunction(sourceFiles, c.getFunctions());
                    break;
                }
                default: {
                    throw new AssertionError();
                }
            }
            CFA cfa = this.createCFA(c, mainFunction);
            if (!this.commentPositions.isEmpty()) {
                SyntacticBlockStructureBuilder blockStructureBuilder = new SyntacticBlockStructureBuilder(cfa);
                blockStructureBuilder.addAll(this.blocks);
                cfa = ACSLParser.parseACSLAnnotations(sourceFiles, cfa, this.logger, this.commentPositions, blockStructureBuilder.build());
            }
            CFA cFA = cfa;
            return cFA;
        }
        finally {
            this.stats.totalTime.stop();
        }
    }

    @VisibleForTesting
    static FunctionEntryNode getJavaMainMethod(List<String> sourceFiles, String mainFunction, Map<String, FunctionEntryNode> cfas) throws InvalidConfigurationException {
        Optional<Object> mainMethodKey = Optional.empty();
        for (String sourceFile : sourceFiles) {
            int indexOfLastSlash;
            String classPath = sourceFile.replace("\\/", ".");
            mainMethodKey = CFACreator.findJavaFunctionInCfa(cfas, classPath, mainFunction).stream().findFirst();
            if (mainMethodKey.isEmpty() && (indexOfLastSlash = mainFunction.lastIndexOf(46)) >= 0) {
                classPath = mainFunction.substring(0, indexOfLastSlash);
                String mainFunctionExtracted = mainFunction.substring(indexOfLastSlash + 1);
                mainMethodKey = CFACreator.findJavaFunctionInCfa(cfas, classPath, mainFunctionExtracted).stream().findFirst();
            }
            if (mainMethodKey.isEmpty()) {
                classPath = mainFunction;
                mainMethodKey = CFACreator.findJavaFunctionInCfa(cfas, classPath, "main").stream().findFirst();
            }
            if (!mainMethodKey.isPresent()) continue;
            break;
        }
        return (FunctionEntryNode)mainMethodKey.orElseThrow(() -> new InvalidConfigurationException("Method " + mainFunction + " not found.\nPlease note that a method has to be given in the following notation:\n <ClassName>_<MethodName>_<ParameterTypes>.\nExample: pack1.Car_drive_int_Car\nfor the method drive(int speed, Car car) in the class Car."));
    }

    private CFA createCFA(ParseResult pParseResult, FunctionEntryNode pMainFunction) throws InvalidConfigurationException, InterruptedException, ParserException {
        Optional<VariableClassification> varClassification;
        FunctionEntryNode mainFunction = pMainFunction;
        assert (mainFunction != null);
        MutableCFA cfa = new MutableCFA(this.machineModel, pParseResult.getFunctions(), pParseResult.getCFANodes(), mainFunction, pParseResult.getFileNames(), this.language);
        this.stats.checkTime.start();
        for (String functionName : cfa.getAllFunctionNames()) {
            assert (CFACheck.check(cfa.getFunctionHead(functionName), cfa.getFunctionNodes(functionName), this.machineModel));
        }
        this.stats.checkTime.stop();
        this.stats.processingTime.start();
        cfa = this.postProcessingOnMutableCFAs(cfa, pParseResult.getGlobalDeclarations());
        this.stats.checkTime.start();
        for (String functionName : cfa.getAllFunctionNames()) {
            assert (CFACheck.check(cfa.getFunctionHead(functionName), cfa.getFunctionNodes(functionName), this.machineModel));
        }
        this.stats.checkTime.stop();
        cfa.getAllFunctionHeads().forEach(CFAReversePostorder::assignIds);
        if (this.useLoopStructure) {
            this.addLoopStructure(cfa);
        }
        if (this.interprocedural) {
            this.logger.log(Level.FINE, new Object[]{"Analysis is interprocedural, adding super edges."});
            CFASecondPassBuilder spbuilder = new CFASecondPassBuilder(cfa, this.language, this.logger, this.config);
            spbuilder.insertCallEdgesRecursively();
        }
        if (this.language == Language.C) {
            try {
                VariableClassificationBuilder builder = new VariableClassificationBuilder(this.config, this.logger);
                varClassification = Optional.of(builder.build(cfa));
                builder.collectStatistics(this.stats.statisticsCollection);
            }
            catch (UnrecognizedCodeException e) {
                throw new CParserException(e);
            }
        } else {
            varClassification = Optional.empty();
        }
        if (this.findLiveVariables && (varClassification.isPresent() || cfa.getLanguage() != Language.C)) {
            cfa.setLiveVariables(LiveVariables.create(varClassification, pParseResult.getGlobalDeclarations(), cfa, this.logger, this.shutdownNotifier, this.config));
        }
        this.stats.processingTime.stop();
        ImmutableCFA immutableCFA = cfa.makeImmutableCFA(varClassification);
        if (pParseResult instanceof ParseResultWithCommentLocations) {
            ParseResultWithCommentLocations withCommentLocations = (ParseResultWithCommentLocations)pParseResult;
            this.commentPositions.addAll(withCommentLocations.getCommentLocations());
            this.blocks.addAll(withCommentLocations.getBlocks());
        }
        this.stats.checkTime.start();
        assert (CFACheck.check(mainFunction, null, this.machineModel));
        this.stats.checkTime.stop();
        if (this.exportCfaFile != null && (this.exportCfa || this.exportCfaPerFunction) || this.exportFunctionCallsFile != null && this.exportFunctionCalls || this.exportFunctionCallsUsedFile != null && this.exportFunctionCalls || this.serializeCfaFile != null && this.serializeCfa || this.exportCfaPixelFile != null || this.exportCfaToCFile != null && this.exportCfaToC) {
            this.exportCFAAsync(immutableCFA);
        }
        this.logger.log(Level.FINE, new Object[]{"DONE, CFA for", immutableCFA.getNumberOfFunctions(), "functions created."});
        return immutableCFA;
    }

    private ParseResult parseToCFAs(String program) throws ParserException, InterruptedException {
        ParseResult parseResult = this.parser.parseString(Path.of("test", new String[0]), program);
        if (parseResult.isEmpty()) {
            switch (this.language) {
                case JAVA: {
                    throw new JParserException("No methods found in program");
                }
                case C: {
                    throw new CParserException("No functions found in program");
                }
            }
            throw new AssertionError();
        }
        return parseResult;
    }

    private ParseResult parseToCFAs(List<String> sourceFiles) throws InvalidConfigurationException, IOException, ParserException, InterruptedException {
        if (this.language == Language.C) {
            this.checkIfValidFiles(sourceFiles);
        } else if (this.language == Language.JAVA) {
            // empty if block
        }
        ParseResult parseResult = this.parser.parseFiles(sourceFiles);
        if (parseResult.isEmpty()) {
            switch (this.language) {
                case JAVA: {
                    throw new JParserException("No methods found in program");
                }
                case C: {
                    throw new CParserException("No functions found in program");
                }
            }
            throw new AssertionError();
        }
        return parseResult;
    }

    private MutableCFA postProcessingOnMutableCFAs(MutableCFA cfa, List<Pair<ADeclaration, String>> globalDeclarations) throws InvalidConfigurationException, CParserException {
        if (this.simplifyCfa) {
            CFASimplifier.simplifyCFA(cfa);
        }
        if (this.moveDeclarationsToFunctionStart) {
            CFADeclarationMover declarationMover = new CFADeclarationMover(this.logger);
            declarationMover.moveDeclarationsToFunctionStart(cfa);
        }
        if (this.checkNullPointers) {
            NullPointerChecks nullPointerCheck = new NullPointerChecks(this.logger, this.config);
            nullPointerCheck.addNullPointerChecks(cfa);
        }
        if (this.expandFunctionPointerArrayAssignments) {
            ExpandFunctionPointerArrayAssignments transformer = new ExpandFunctionPointerArrayAssignments(this.logger);
            transformer.replaceFunctionPointerArrayAssignments(cfa);
        }
        if (this.language == Language.C && this.fptrCallEdges) {
            CFunctionPointerResolver fptrResolver = new CFunctionPointerResolver(cfa, globalDeclarations, this.config, this.logger);
            fptrResolver.resolveFunctionPointers();
            fptrResolver.collectStatistics(this.stats.statisticsCollection);
        }
        if (this.enableThreadOperationsInstrumentation) {
            ThreadCreateTransformer TCtransformer = new ThreadCreateTransformer(this.logger, this.config);
            TCtransformer.transform(cfa);
        }
        if (this.useFunctionCallUnwinding) {
            FunctionCallUnwinder fca = new FunctionCallUnwinder(cfa, this.config);
            cfa = fca.unwindRecursion();
        }
        if (this.useCFACloningForMultiThreadedPrograms && this.isMultiThreadedProgram(cfa)) {
            this.logger.log(Level.INFO, new Object[]{"program contains concurrency, cloning functions..."});
            CFACloner cloner = new CFACloner(cfa, this.config);
            cfa = cloner.execute();
        }
        if (this.useGlobalVars) {
            this.insertGlobalDeclarations(cfa, globalDeclarations);
        }
        return cfa;
    }

    private boolean isMultiThreadedProgram(MutableCFA pCfa) {
        for (CFANode node : pCfa.getAllNodes()) {
            for (CFAEdge edge : CFAUtils.allLeavingEdges(node)) {
                AExpression functionNameExp;
                AStatement statement;
                if (!(edge instanceof AStatementEdge) || !((statement = ((AStatementEdge)edge).getStatement()) instanceof AFunctionCall) || !((functionNameExp = ((AFunctionCall)statement).getFunctionCallExpression().getFunctionNameExpression()) instanceof AIdExpression) || !"pthread_create".equals(((AIdExpression)functionNameExp).getName())) continue;
                return true;
            }
        }
        return false;
    }

    private static Set<FunctionEntryNode> findJavaFunctionInCfa(Map<String, FunctionEntryNode> cfas, String classPath, String mainMethodName) throws InvalidConfigurationException {
        Set<FunctionEntryNode> nodesWithCorrectClassPath = CFACreator.getCfaNodesOfClass(cfas, classPath);
        String fullName = classPath + "_" + mainMethodName;
        Set mainMethodValues = (Set)nodesWithCorrectClassPath.stream().filter(v -> v.getFunctionDefinition().getName().equals(fullName)).collect(ImmutableSet.toImmutableSet());
        if (mainMethodValues.isEmpty()) {
            mainMethodValues = (Set)nodesWithCorrectClassPath.stream().filter(v -> ((JMethodDeclaration)v.getFunctionDefinition()).getSimpleName().equals(mainMethodName)).collect(ImmutableSet.toImmutableSet());
        }
        if (mainMethodValues.size() >= 2) {
            StringBuilder exceptionMessage = new StringBuilder();
            mainMethodValues.forEach(k -> exceptionMessage.append(((JMethodDeclaration)k.getFunctionDefinition()).getSimpleName()).append("\n"));
            throw new InvalidConfigurationException("Two or more matching functions for \"" + mainMethodName + "\" found:\n" + exceptionMessage + EXAMPLE_JAVA_METHOD_NAME);
        }
        return mainMethodValues;
    }

    private static Set<FunctionEntryNode> getCfaNodesOfClass(Map<String, FunctionEntryNode> cfas, String classPath) {
        return (Set)cfas.values().stream().filter(v -> ((JMethodDeclaration)v.getFunctionDefinition()).getDeclaringClass().getName().equals(classPath)).collect(ImmutableSet.toImmutableSet());
    }

    private void checkForAmbiguousMethod(FunctionEntryNode mainFunction, String mainMethodName, Map<String, FunctionEntryNode> cfas) {
        Set<FunctionEntryNode> pNodesWithCorrectClassPath;
        Set methodsWithSameName;
        if (!mainFunction.getFunctionDefinition().getName().equals(this.mainFunctionName) && (methodsWithSameName = (Set)(pNodesWithCorrectClassPath = CFACreator.getCfaNodesOfClass(cfas, ((JMethodDeclaration)mainFunction.getFunctionDefinition()).getDeclaringClass().getName())).stream().filter(v -> CFACreator.hasMethodName(v, mainMethodName)).collect(ImmutableSet.toImmutableSet())).size() > 1) {
            String foundMethods = methodsWithSameName.stream().map(m -> m.getFunctionDefinition().getName()).collect(Collectors.joining("\n"));
            this.logger.log(Level.WARNING, new Object[]{"Multiple methods with same name but different parameters found. Make sure you picked the right one.\nMethods found:\n\n" + foundMethods + "\n\nPlease note that a method has to be given in the following notation:\n <ClassName>_<MethodName>_<ParameterTypes>.\nExample: pack1.Car_drive_int_Car\nfor the method drive(int speed, Car car) in the class Car."});
        }
    }

    private static boolean hasMethodName(FunctionEntryNode entryNode, String methodName) {
        JMethodDeclaration functionDefinition = (JMethodDeclaration)entryNode.getFunctionDefinition();
        return (functionDefinition.getDeclaringClass().getName() + "." + functionDefinition.getSimpleName()).equals(methodName) || functionDefinition.getSimpleName().equals(methodName);
    }

    private void checkIfValidFiles(List<String> sourceFiles) throws InvalidConfigurationException {
        for (String file : sourceFiles) {
            this.checkIfValidFile(Path.of(file, new String[0]));
        }
    }

    private void checkIfValidFile(Path file) throws InvalidConfigurationException {
        try {
            IO.checkReadableFile((Path)file);
        }
        catch (FileNotFoundException e) {
            throw new InvalidConfigurationException(e.getMessage());
        }
    }

    private FunctionEntryNode getCMainFunction(List<String> sourceFiles, Map<String, FunctionEntryNode> cfas) throws InvalidConfigurationException {
        Path path;
        FunctionEntryNode mainFunction = cfas.get(this.mainFunctionName);
        if (mainFunction != null) {
            return mainFunction;
        }
        if (!this.mainFunctionName.equals("main")) {
            throw new InvalidConfigurationException("Function " + this.mainFunctionName + " not found.");
        }
        if (cfas.size() == 1) {
            return (FunctionEntryNode)Iterables.getOnlyElement(cfas.values());
        }
        if (sourceFiles.size() == 1 && (path = Path.of(sourceFiles.get(0), new String[0]).getFileName()) != null) {
            String filename = path.toString();
            int indexOfDot = filename.indexOf(46);
            String baseFilename = indexOfDot >= 1 ? filename.substring(0, indexOfDot) : filename;
            mainFunction = cfas.get(baseFilename);
        }
        if (mainFunction == null) {
            throw new InvalidConfigurationException("No entry function found, please specify one.");
        }
        return mainFunction;
    }

    private void addLoopStructure(MutableCFA cfa) {
        try {
            cfa.setLoopStructure(LoopStructure.getLoopStructure(cfa));
        }
        catch (ParserException e) {
            this.logger.logUserException(Level.WARNING, (Throwable)e, "Could not analyze loop structure of program.");
        }
        catch (OutOfMemoryError e) {
            this.logger.logUserException(Level.WARNING, (Throwable)e, "Could not analyze loop structure of program due to memory problems");
        }
    }

    private void insertGlobalDeclarations(MutableCFA cfa, List<Pair<ADeclaration, String>> globalVars) {
        if (globalVars.isEmpty()) {
            return;
        }
        if (cfa.getLanguage() == Language.C) {
            CFACreator.addDefaultInitializers(globalVars);
        }
        FunctionEntryNode firstNode = cfa.getMainFunction();
        assert (firstNode.getNumLeavingEdges() == 1);
        CFAEdge firstEdge = firstNode.getLeavingEdge(0);
        assert (firstEdge.getEdgeType() == CFAEdgeType.BlankEdge);
        CFANode secondNode = firstEdge.getSuccessor();
        CFACreationUtils.removeEdgeFromNodes(firstEdge);
        CFANode cur = new CFANode(firstNode.getFunction());
        cfa.addNode(cur);
        BlankEdge newFirstEdge = new BlankEdge("", FileLocation.DUMMY, firstNode, cur, "INIT GLOBAL VARS");
        CFACreationUtils.addEdgeUnconditionallyToCFA(newFirstEdge);
        for (Pair<ADeclaration, String> p : globalVars) {
            ADeclarationEdge newEdge;
            ADeclaration d = p.getFirst();
            String rawSignature = p.getSecond();
            assert (d.isGlobal());
            CFANode n = new CFANode(cur.getFunction());
            cfa.addNode(n);
            switch (cfa.getLanguage()) {
                case C: {
                    newEdge = new CDeclarationEdge(rawSignature, d.getFileLocation(), cur, n, (CDeclaration)d);
                    break;
                }
                case JAVA: {
                    newEdge = new JDeclarationEdge(rawSignature, d.getFileLocation(), cur, n, (JDeclaration)d);
                    break;
                }
                default: {
                    throw new AssertionError((Object)"unknown language");
                }
            }
            CFACreationUtils.addEdgeUnconditionallyToCFA(newEdge);
            cur = n;
        }
        BlankEdge newLastEdge = new BlankEdge(firstEdge.getRawStatement(), firstEdge.getFileLocation(), cur, secondNode, firstEdge.getDescription());
        CFACreationUtils.addEdgeUnconditionallyToCFA(newLastEdge);
    }

    private static void addDefaultInitializers(List<Pair<ADeclaration, String>> globalVars) {
        HashSet<String> initializedVariables = new HashSet<String>();
        for (Pair<ADeclaration, String> p : globalVars) {
            AVariableDeclaration v;
            if (!(p.getFirst() instanceof AVariableDeclaration) || (v = (AVariableDeclaration)p.getFirst()).getInitializer() == null) continue;
            initializedVariables.add(v.getName());
        }
        HashSet<String> previouslyInitializedVariables = new HashSet<String>();
        ListIterator<Pair<ADeclaration, String>> iterator = globalVars.listIterator();
        while (iterator.hasNext()) {
            CType type;
            Pair<ADeclaration, String> p = iterator.next();
            if (!(p.getFirst() instanceof AVariableDeclaration)) continue;
            CVariableDeclaration v = (CVariableDeclaration)p.getFirst();
            assert (v.isGlobal());
            String name = v.getName();
            if (previouslyInitializedVariables.contains(name)) {
                iterator.remove();
                continue;
            }
            if (v.getInitializer() != null) {
                previouslyInitializedVariables.add(name);
                continue;
            }
            if (initializedVariables.contains(name) || v.getCStorageClass() != CStorageClass.AUTO || (type = v.getType().getCanonicalType()) instanceof CElaboratedType && ((CElaboratedType)type).getKind() != CComplexType.ComplexTypeKind.ENUM) continue;
            CInitializer initializer = CDefaults.forType(type, v.getFileLocation());
            v.addInitializer(initializer);
            v = new CVariableDeclaration(v.getFileLocation(), v.isGlobal(), v.getCStorageClass(), v.getType(), v.getName(), v.getOrigName(), v.getQualifiedName(), initializer);
            previouslyInitializedVariables.add(name);
            iterator.set(Pair.of(v, p.getSecond()));
        }
    }

    private void exportCFAAsync(CFA cfa) {
        Concurrency.newThread((String)"CFA export thread", () -> this.exportCFA(cfa)).start();
    }

    private void exportCFA(CFA cfa) {
        Writer w;
        this.stats.exportTime.start();
        if (this.exportCfa && this.exportCfaFile != null) {
            try {
                w = IO.openOutputFile((Path)this.exportCfaFile, (Charset)Charset.defaultCharset(), (OpenOption[])new OpenOption[0]);
                try {
                    DOTBuilder.generateDOT(w, cfa);
                }
                finally {
                    if (w != null) {
                        w.close();
                    }
                }
            }
            catch (IOException e) {
                this.logger.logUserException(Level.WARNING, (Throwable)e, "Could not write CFA to dot file");
            }
        }
        if (this.exportCfaPerFunction && this.exportCfaFile != null) {
            try {
                Path outdir = this.exportCfaFile.getParent().resolve("cfa");
                new DOTBuilder2(cfa).writeGraphs(outdir);
            }
            catch (IOException e) {
                this.logger.logUserException(Level.WARNING, (Throwable)e, "Could not write CFA to dot files");
            }
        }
        if (this.exportFunctionCalls && this.exportFunctionCallsFile != null) {
            try {
                w = IO.openOutputFile((Path)this.exportFunctionCallsFile, (Charset)Charset.defaultCharset(), (OpenOption[])new OpenOption[0]);
                try {
                    FunctionCallDumper.dump(w, cfa, false);
                }
                finally {
                    if (w != null) {
                        w.close();
                    }
                }
            }
            catch (IOException e) {
                this.logger.logUserException(Level.WARNING, (Throwable)e, "Could not write functionCalls to dot file");
            }
        }
        if (this.exportFunctionCalls && this.exportFunctionCallsUsedFile != null) {
            try {
                w = IO.openOutputFile((Path)this.exportFunctionCallsUsedFile, (Charset)Charset.defaultCharset(), (OpenOption[])new OpenOption[0]);
                try {
                    FunctionCallDumper.dump(w, cfa, true);
                }
                finally {
                    if (w != null) {
                        w.close();
                    }
                }
            }
            catch (IOException e) {
                this.logger.logUserException(Level.WARNING, (Throwable)e, "Could not write functionCalls to dot file");
            }
        }
        if (this.exportCfaPixelFile != null) {
            try {
                new CFAToPixelsWriter(this.config).write(cfa.getMainFunction(), this.exportCfaPixelFile);
            }
            catch (IOException | InvalidConfigurationException e) {
                this.logger.logUserException(Level.WARNING, e, "Could not write CFA as pixel graphic.");
            }
        }
        if (this.serializeCfa && this.serializeCfaFile != null) {
            try {
                MoreFiles.createParentDirectories((Path)this.serializeCfaFile, (FileAttribute[])new FileAttribute[0]);
                try (OutputStream outputStream = Files.newOutputStream(this.serializeCfaFile, new OpenOption[0]);
                     GZIPOutputStream gzipOutputStream = new GZIPOutputStream(outputStream);
                     ObjectOutputStream oos = new ObjectOutputStream(gzipOutputStream);){
                    oos.writeObject(cfa);
                }
            }
            catch (IOException e) {
                this.logger.logUserException(Level.WARNING, (Throwable)e, "Could not serialize CFA to file.");
            }
        }
        if (this.exportCfaToC && this.exportCfaToCFile != null) {
            try {
                String code;
                if (this.exportCfaToCStayingCloserToInput && cfa.getFileNames().size() == 1) {
                    code = new CfaToCExporter(this.logger, this.config, this.shutdownNotifier).exportCfa(cfa);
                } else {
                    if (this.exportCfaToCStayingCloserToInput) {
                        this.logger.log(Level.INFO, new Object[]{"Using the regular CFA-to-C exporter (staying closer to the input program is only possible for a single input file)"});
                    }
                    code = new CFAToCTranslator(this.config).translateCfa(cfa);
                }
                try (Writer writer = IO.openOutputFile((Path)this.exportCfaToCFile, (Charset)Charset.defaultCharset(), (OpenOption[])new OpenOption[0]);){
                    writer.write(code);
                }
            }
            catch (IOException | InterruptedException | InvalidConfigurationException | CPAException e) {
                this.logger.logUserException(Level.WARNING, e, "Could not write CFA to C file.");
            }
        }
        this.stats.exportTime.stop();
    }

    public CFACreatorStatistics getStatistics() {
        return this.stats;
    }

    private static class CFACreatorStatistics
    implements Statistics {
        private final Timer parserInstantiationTime = new Timer();
        private final Timer totalTime = new Timer();
        private Timer parsingTime;
        private Timer conversionTime;
        private final Timer checkTime = new Timer();
        private final Timer processingTime = new Timer();
        private final Timer exportTime = new Timer();
        private final List<Statistics> statisticsCollection;
        private final LogManager logger;

        private CFACreatorStatistics(LogManager pLogger) {
            this.logger = pLogger;
            this.statisticsCollection = new ArrayList<Statistics>();
        }

        @Override
        public String getName() {
            return "";
        }

        @Override
        public void printStatistics(PrintStream out, CPAcheckerResult.Result pResult, UnmodifiableReachedSet pReached) {
            out.println("  Time for loading parser:    " + this.parserInstantiationTime);
            out.println("  Time for CFA construction:  " + this.totalTime);
            out.println("    Time for parsing file(s): " + this.parsingTime);
            out.println("    Time for AST to CFA:      " + this.conversionTime);
            out.println("    Time for CFA sanity check:" + this.checkTime);
            out.println("    Time for post-processing: " + this.processingTime);
            if (this.exportTime.getNumberOfIntervals() > 0) {
                out.println("    Time for CFA export:      " + this.exportTime);
            }
            for (Statistics st : this.statisticsCollection) {
                StatisticsUtils.printStatistics(st, out, this.logger, pResult, pReached);
            }
        }

        @Override
        public void writeOutputFiles(CPAcheckerResult.Result pResult, UnmodifiableReachedSet pReached) {
            for (Statistics st : this.statisticsCollection) {
                StatisticsUtils.writeOutputFiles(st, this.logger, pResult, pReached);
            }
        }
    }
}

