/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cfa;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.base.Splitter;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import com.google.common.truth.Truth;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.sosy_lab.common.ShutdownNotifier;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.cpachecker.cfa.CFA;
import org.sosy_lab.cpachecker.cfa.CFACreator;
import org.sosy_lab.cpachecker.cfa.ast.AExpression;
import org.sosy_lab.cpachecker.cfa.ast.AFunctionCall;
import org.sosy_lab.cpachecker.cfa.ast.AIdExpression;
import org.sosy_lab.cpachecker.cfa.ast.AStatement;
import org.sosy_lab.cpachecker.cfa.ast.FileLocation;
import org.sosy_lab.cpachecker.cfa.ast.java.JConstructorDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.java.JMethodDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.java.JParameterDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.java.VisibilityModifier;
import org.sosy_lab.cpachecker.cfa.model.AStatementEdge;
import org.sosy_lab.cpachecker.cfa.model.CFAEdge;
import org.sosy_lab.cpachecker.cfa.model.CFAEdgeType;
import org.sosy_lab.cpachecker.cfa.model.CFATerminationNode;
import org.sosy_lab.cpachecker.cfa.model.FunctionEntryNode;
import org.sosy_lab.cpachecker.cfa.model.java.JMethodEntryNode;
import org.sosy_lab.cpachecker.cfa.types.java.JClassType;
import org.sosy_lab.cpachecker.cfa.types.java.JType;
import org.sosy_lab.cpachecker.exceptions.ParserException;
import org.sosy_lab.cpachecker.util.CFATraversal;
import org.sosy_lab.cpachecker.util.test.TestDataTools;

public class CFACreatorTest {
    @Mock
    JMethodEntryNode N1;
    @Mock
    JMethodEntryNode N2;
    @Mock
    JMethodEntryNode N3;
    @Mock
    JMethodEntryNode N4;
    @Mock
    JMethodEntryNode N5;
    private Map<String, FunctionEntryNode> cfa;

    @Before
    public void init() {
        MockitoAnnotations.openMocks((Object)this);
        JMethodDeclaration functionDefinition1 = this.createFunctionDefinition("pack5.CallTests_true_assert", "main", "String[]");
        Mockito.when((Object)this.N1.getFunctionDefinition()).thenReturn((Object)functionDefinition1);
        JMethodDeclaration functionDefinition2 = this.createFunctionDefinition("pack5.CallTests_true_assert", "main2", "String[]");
        Mockito.when((Object)this.N2.getFunctionDefinition()).thenReturn((Object)functionDefinition2);
        JMethodDeclaration functionDefinition3 = this.createFunctionDefinition("pack5.CallTests_true_assert", "callTests_true_assert", "");
        Mockito.when((Object)this.N3.getFunctionDefinition()).thenReturn((Object)functionDefinition3);
        JMethodDeclaration functionDefinition4 = this.createFunctionDefinition("pack5.CallTests_true_assert", "callTests_true_assert", "int");
        Mockito.when((Object)this.N4.getFunctionDefinition()).thenReturn((Object)functionDefinition4);
        JMethodDeclaration functionDefinition5 = this.createFunctionDefinition("pack5.CallTests_true_assert", "callTests_true_assert", "int_int");
        Mockito.when((Object)this.N5.getFunctionDefinition()).thenReturn((Object)functionDefinition5);
        this.cfa = Maps.uniqueIndex((Iterable)ImmutableList.of((Object)this.N1, (Object)this.N2, (Object)this.N3, (Object)this.N4, (Object)this.N5), node -> node.getFunctionDefinition().getName());
    }

    @Test
    public void testGetJavaMainMethodSourceFileIsClasspathAndMainFunctionWithParameters() throws InvalidConfigurationException {
        String sourceFile = "test/programs/java/CallTests";
        String mainFunction = "pack5.CallTests_true_assert.main_String[]";
        FunctionEntryNode result = CFACreator.getJavaMainMethod((List<String>)ImmutableList.of((Object)sourceFile), mainFunction, this.cfa);
        Truth.assertThat((Comparable)result).isEqualTo((Object)this.N1);
    }

    @Test
    public void testGetJavaMainMethodForSameNameMethodsWithDifferentParameters() throws InvalidConfigurationException {
        String sourceFile = "pack5.CallTests_true_assert";
        String mainFunction = "callTests_true_assert";
        Truth.assertThat((Comparable)CFACreator.getJavaMainMethod((List<String>)ImmutableList.of((Object)sourceFile), mainFunction, this.cfa)).isEqualTo((Object)this.N3);
        mainFunction = "callTests_true_assert_int";
        Truth.assertThat((Comparable)CFACreator.getJavaMainMethod((List<String>)ImmutableList.of((Object)sourceFile), mainFunction, this.cfa)).isEqualTo((Object)this.N4);
        mainFunction = "callTests_true_assert_int_int";
        Truth.assertThat((Comparable)CFACreator.getJavaMainMethod((List<String>)ImmutableList.of((Object)sourceFile), mainFunction, this.cfa)).isEqualTo((Object)this.N5);
    }

    @Test
    public void testGetJavaMainMethodWithTwoSimilarNamedMethods() throws InvalidConfigurationException {
        String sourceFile = "pack5.CallTests_true_assert";
        String mainFunction = "main";
        FunctionEntryNode result = CFACreator.getJavaMainMethod((List<String>)ImmutableList.of((Object)sourceFile), mainFunction, this.cfa);
        Truth.assertThat((Comparable)result).isEqualTo((Object)this.N1);
    }

    @Test
    public void testParseSourceAndCreateCfaWithNoReturnAbort() throws InvalidConfigurationException, ParserException, InterruptedException {
        Configuration config = TestDataTools.configurationForTest().setOption("language", "C").build();
        CFACreator creator = this.createCfaCreatorForTesting(config);
        String programSource = "extern void abort() __attribute__((__noreturn__));int main() { abort(); }";
        CFA created = creator.parseSourceAndCreateCFA("extern void abort() __attribute__((__noreturn__));int main() { abort(); }");
        Predicate isNoReturnFunctionCall = Predicates.and(CFACreatorTest::isTerminatingStatement, pCFAEdge -> CFACreatorTest.isFunctionCall(pCFAEdge, "abort"));
        FluentIterable<CFAEdge> cfaEdges = this.getAllEdges(created);
        Truth.assertWithMessage((String)"Expected function call to abort() with a succeeding CFATerminationNode in the CFA, but none found.").that(Boolean.valueOf(cfaEdges.anyMatch(isNoReturnFunctionCall))).isTrue();
    }

    @Test
    public void testParseSourceAndCreateCfaWithNoReturnFunctionAttribute() throws InvalidConfigurationException, ParserException, InterruptedException {
        Configuration config = TestDataTools.configurationForTest().setOption("language", "C").build();
        CFACreator creator = this.createCfaCreatorForTesting(config);
        String programSource = "extern void myfunc() __attribute__((__noreturn__));int main() { myfunc(); }";
        CFA created = creator.parseSourceAndCreateCFA("extern void myfunc() __attribute__((__noreturn__));int main() { myfunc(); }");
        Predicate isNoReturnFunctionCall = Predicates.and(CFACreatorTest::isTerminatingStatement, pCFAEdge -> CFACreatorTest.isFunctionCall(pCFAEdge, "myfunc"));
        FluentIterable<CFAEdge> cfaEdges = this.getAllEdges(created);
        Truth.assertWithMessage((String)"Expected function call to myfunc() with a succeeding CFATerminationNode in the CFA, but none found.").that(Boolean.valueOf(cfaEdges.anyMatch(isNoReturnFunctionCall))).isTrue();
    }

    @Test
    public void testParseSourceAndCreateCfaWithReturningAbort() throws InvalidConfigurationException, ParserException, InterruptedException {
        Configuration config = TestDataTools.configurationForTest().setOption("language", "C").setOption("cfa.nonReturningFunctions", "[]").build();
        CFACreator creator = this.createCfaCreatorForTesting(config);
        String programSource = "extern void abort();int main() { abort(); }";
        CFA created = creator.parseSourceAndCreateCFA("extern void abort();int main() { abort(); }");
        Predicate isNoReturnFunctionCall = Predicates.and(CFACreatorTest::isTerminatingStatement, pCFAEdge -> CFACreatorTest.isFunctionCall(pCFAEdge, "abort"));
        FluentIterable<CFAEdge> cfaEdges = this.getAllEdges(created);
        Truth.assertWithMessage((String)"Found function call to abort() with CFATerminationNode in the CFA, but CFA should continue after function call.").that(Boolean.valueOf(cfaEdges.anyMatch(isNoReturnFunctionCall))).isFalse();
    }

    @Test
    public void testParseSourceAndCreateCfaWithReturningAbortButExplicitTermination() throws InvalidConfigurationException, ParserException, InterruptedException {
        Configuration config = TestDataTools.configurationForTest().setOption("language", "C").setOption("cfa.nonReturningFunctions", "abort").build();
        CFACreator creator = this.createCfaCreatorForTesting(config);
        String programSource = "extern void abort();int main() { abort(); }";
        CFA created = creator.parseSourceAndCreateCFA("extern void abort();int main() { abort(); }");
        Predicate isNoReturnFunctionCall = Predicates.and(CFACreatorTest::isTerminatingStatement, pCFAEdge -> CFACreatorTest.isFunctionCall(pCFAEdge, "abort"));
        FluentIterable<CFAEdge> cfaEdges = this.getAllEdges(created);
        Truth.assertWithMessage((String)"Expected function call to abort() with a succeeding CFATerminationNode in the CFA, but none found.").that(Boolean.valueOf(cfaEdges.anyMatch(isNoReturnFunctionCall))).isTrue();
    }

    private CFACreator createCfaCreatorForTesting(Configuration config) throws InvalidConfigurationException {
        LogManager logger = LogManager.createTestLogManager();
        ShutdownNotifier shutdownNotifier = ShutdownNotifier.createDummy();
        return new CFACreator(config, logger, shutdownNotifier);
    }

    private static boolean isTerminatingStatement(CFAEdge pCfaEdge) {
        return pCfaEdge.getEdgeType().equals((Object)CFAEdgeType.StatementEdge) && pCfaEdge.getSuccessor() instanceof CFATerminationNode;
    }

    private static boolean isFunctionCall(CFAEdge pCfaEdge, String pExpectedFunctionName) {
        if (!(pCfaEdge instanceof AStatementEdge)) {
            return false;
        }
        AStatement statement = ((AStatementEdge)pCfaEdge).getStatement();
        if (!(statement instanceof AFunctionCall)) {
            return false;
        }
        AExpression callee = ((AFunctionCall)statement).getFunctionCallExpression().getFunctionNameExpression();
        if (!(callee instanceof AIdExpression)) {
            return false;
        }
        String functionName = ((AIdExpression)callee).getName();
        return functionName.equals(pExpectedFunctionName);
    }

    private FluentIterable<CFAEdge> getAllEdges(CFA pCfa) {
        CFATraversal.EdgeCollectingCFAVisitor edgeCollector = new CFATraversal.EdgeCollectingCFAVisitor();
        CFATraversal.dfs().traverse(pCfa.getMainFunction(), edgeCollector);
        return FluentIterable.from(edgeCollector.getVisitedEdges());
    }

    private JMethodDeclaration createFunctionDefinition(String classPath, String methodName, String parametersSubString) {
        String name = classPath + "_" + methodName;
        List parameters = Splitter.on((char)'_').splitToList((CharSequence)parametersSubString);
        ArrayList<JParameterDeclaration> jParameterDeclarations = new ArrayList<JParameterDeclaration>(parameters.size());
        for (String parameter : parameters) {
            jParameterDeclarations.add(new JParameterDeclaration(FileLocation.DUMMY, (JType)Mockito.mock(JType.class), parameter, "stub", false));
        }
        if (!parametersSubString.isEmpty()) {
            name = name + "_" + parametersSubString;
        }
        return new JConstructorDeclaration(FileLocation.DUMMY, null, name, methodName, jParameterDeclarations, VisibilityModifier.PUBLIC, false, this.createDeclaringClassMock(classPath));
    }

    private JClassType createDeclaringClassMock(String classPath) {
        int indexOfLastDot = classPath.lastIndexOf(".");
        String simpleClassName = indexOfLastDot >= 0 ? classPath.substring(indexOfLastDot) : classPath;
        JClassType declaringClass = (JClassType)Mockito.mock(JClassType.class);
        Mockito.when((Object)declaringClass.getName()).thenReturn((Object)classPath);
        Mockito.when((Object)declaringClass.getSimpleName()).thenReturn((Object)simpleClassName);
        return declaringClass;
    }
}

