/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cfa;

import com.google.common.graph.Traverser;
import java.util.ArrayDeque;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import org.sosy_lab.cpachecker.cfa.model.CFANode;
import org.sosy_lab.cpachecker.util.CFAUtils;

public class CFAReversePostorder {
    private CFAReversePostorder() {
    }

    private static boolean checkIds(CFANode pStartNode) {
        HashSet<CFANode> finished = new HashSet<CFANode>();
        int reversePostorderId = 0;
        ArrayDeque<CFANode> nodeStack = new ArrayDeque<CFANode>();
        LinkedList<Iterator> iteratorStack = new LinkedList<Iterator>();
        nodeStack.push(pStartNode);
        iteratorStack.push(null);
        while (!nodeStack.isEmpty()) {
            assert (nodeStack.size() == iteratorStack.size());
            CFANode node = (CFANode)nodeStack.peek();
            Iterator successors = (Iterator)iteratorStack.peek();
            if (successors == null) {
                if (!finished.add(node)) {
                    nodeStack.pop();
                    iteratorStack.pop();
                    continue;
                }
                successors = CFAUtils.successorsOf(node).iterator();
                iteratorStack.pop();
                iteratorStack.push(successors);
            }
            if (successors.hasNext()) {
                CFANode successor = (CFANode)successors.next();
                nodeStack.push(successor);
                iteratorStack.push(null);
                continue;
            }
            if (node.getReversePostorderId() != reversePostorderId++) {
                return false;
            }
            nodeStack.pop();
            iteratorStack.pop();
        }
        return true;
    }

    public static void assignIds(CFANode pStartNode) {
        int reversePostOrderId = 0;
        Iterable nodesInPostOrder = Traverser.forGraph(CFAUtils::successorsOf).depthFirstPostOrder((Object)pStartNode);
        for (CFANode node : nodesInPostOrder) {
            node.setReversePostorderId(reversePostOrderId++);
        }
        assert (CFAReversePostorder.checkIds(pStartNode));
    }
}

